/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.context;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.catalina.tribes.tipis.ReplicatedMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ReplicatedContext
extends StandardContext
implements AbstractReplicatedMap.MapOwner {
    private int mapSendOptions = 2;
    private static final Log log = LogFactory.getLog(ReplicatedContext.class);
    protected static long DEFAULT_REPL_TIMEOUT = 15000L;

    protected synchronized void startInternal() throws LifecycleException {
        try {
            CatalinaCluster catclust = (CatalinaCluster)this.getCluster();
            if (this.context == null) {
                this.context = new ReplApplContext(this);
            }
            if (catclust != null) {
                ReplicatedMap map = new ReplicatedMap((AbstractReplicatedMap.MapOwner)this, catclust.getChannel(), DEFAULT_REPL_TIMEOUT, this.getName(), this.getClassLoaders());
                map.setChannelSendOptions(this.mapSendOptions);
                ((ReplApplContext)this.context).setAttributeMap((Map<String, Object>)map);
                if (this.getAltDDName() != null) {
                    this.context.setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.getAltDDName());
                }
            }
            super.startInternal();
        }
        catch (Exception x) {
            log.error((Object)"Unable to start ReplicatedContext", (Throwable)x);
            throw new LifecycleException("Failed to start ReplicatedContext", (Throwable)x);
        }
    }

    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        Map<String, Object> map = ((ReplApplContext)this.context).getAttributeMap();
        if (map != null && map instanceof ReplicatedMap) {
            ((ReplicatedMap)map).breakdown();
        }
    }

    public void setMapSendOptions(int mapSendOptions) {
        this.mapSendOptions = mapSendOptions;
    }

    public int getMapSendOptions() {
        return this.mapSendOptions;
    }

    public ClassLoader[] getClassLoaders() {
        Loader loader = null;
        ClassLoader classLoader = null;
        loader = this.getLoader();
        if (loader != null) {
            classLoader = loader.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == Thread.currentThread().getContextClassLoader()) {
            return new ClassLoader[]{classLoader};
        }
        return new ClassLoader[]{classLoader, Thread.currentThread().getContextClassLoader()};
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ReplApplContext(this);
            if (this.getAltDDName() != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.getAltDDName());
            }
        }
        return ((ReplApplContext)this.context).getFacade();
    }

    public void objectMadePrimay(Object key, Object value) {
    }

    protected static class MultiEnumeration<T>
    implements Enumeration<T> {
        Enumeration<T>[] e = null;

        public MultiEnumeration(Enumeration<T>[] lists) {
            this.e = lists;
        }

        @Override
        public boolean hasMoreElements() {
            for (int i = 0; i < this.e.length; ++i) {
                if (!this.e[i].hasMoreElements()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T nextElement() {
            for (int i = 0; i < this.e.length; ++i) {
                if (!this.e[i].hasMoreElements()) continue;
                return this.e[i].nextElement();
            }
            return null;
        }
    }

    protected static class ReplApplContext
    extends ApplicationContext {
        protected ConcurrentHashMap<String, Object> tomcatAttributes = new ConcurrentHashMap();

        public ReplApplContext(ReplicatedContext context) {
            super((StandardContext)context);
        }

        protected ReplicatedContext getParent() {
            return (ReplicatedContext)this.getContext();
        }

        protected ServletContext getFacade() {
            return super.getFacade();
        }

        public Map<String, Object> getAttributeMap() {
            return this.attributes;
        }

        public void setAttributeMap(Map<String, Object> map) {
            this.attributes = map;
        }

        public void removeAttribute(String name) {
            this.tomcatAttributes.remove(name);
            super.removeAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            if (!this.getParent().getState().isAvailable() || "org.apache.jasper.runtime.JspApplicationContextImpl".equals(name)) {
                this.tomcatAttributes.put(name, value);
            } else {
                super.setAttribute(name, value);
            }
        }

        public Object getAttribute(String name) {
            Object obj = this.tomcatAttributes.get(name);
            if (obj == null) {
                return super.getAttribute(name);
            }
            return obj;
        }

        public Enumeration<String> getAttributeNames() {
            HashSet names = new HashSet();
            names.addAll(this.attributes.keySet());
            return new MultiEnumeration<String>(new Enumeration[]{super.getAttributeNames(), Collections.enumeration(names)});
        }
    }
}

