/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.MonitorFactory;
import cc.arduino.packages.uploaders.SerialUploader;
import com.jcraft.jsch.JSchException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import jssc.SerialPortException;
import processing.app.AbstractMonitor;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.CaretAwareUndoableEdit;
import processing.app.EditorConsole;
import processing.app.EditorHeader;
import processing.app.EditorLineStatus;
import processing.app.EditorListener;
import processing.app.EditorStatus;
import processing.app.EditorToolbar;
import processing.app.FindReplace;
import processing.app.I18n;
import processing.app.LastUndoableEditAwareUndoManager;
import processing.app.PreferencesData;
import processing.app.SerialException;
import processing.app.SerialNotFoundException;
import processing.app.Sketch;
import processing.app.SketchCodeDocument;
import processing.app.SketchData;
import processing.app.Theme;
import processing.app.debug.RunnerException;
import processing.app.debug.RunnerListener;
import processing.app.forms.PasswordAuthorizationDialog;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.PreferencesMapException;
import processing.app.legacy.PApplet;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeKeywords;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.TextAreaPainter;
import processing.app.tools.DiscourseFormat;
import processing.app.tools.MenuScroller;
import processing.app.tools.Tool;

public class Editor
extends JFrame
implements RunnerListener {
    private static final List<String> BOARD_PROTOCOLS_ORDER = Arrays.asList("serial", "network");
    private static final List<String> BOARD_PROTOCOLS_ORDER_TRANSLATIONS = Arrays.asList(I18n._((String)"Serial ports"), I18n._((String)"Network ports"));
    Base base;
    protected static final String EMPTY = "                                                                                                                                                                                                               ";
    static final int SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    static final KeyStroke WINDOW_CLOSE_KEYSTROKE = KeyStroke.getKeyStroke(87, SHORTCUT_KEY_MASK);
    static final int SHORTCUT_ALT_KEY_MASK = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    boolean untitled;
    PageFormat pageFormat;
    PrinterJob printerJob;
    JMenu fileMenu;
    JMenu sketchMenu;
    JMenu toolsMenu;
    int numTools = 0;
    EditorToolbar toolbar;
    static JMenu toolbarMenu;
    static JMenu sketchbookMenu;
    static JMenu examplesMenu;
    static JMenu importMenu;
    static JMenu serialMenu;
    static AbstractMonitor serialMonitor;
    EditorHeader header;
    EditorStatus status;
    EditorConsole console;
    JSplitPane splitPane;
    JPanel consolePanel;
    JLabel lineNumberComponent;
    Sketch sketch;
    EditorLineStatus lineStatus;
    JEditTextArea textarea;
    EditorListener listener;
    Point sketchWindowLocation;
    JMenuItem exportAppItem;
    JMenuItem saveMenuItem;
    JMenuItem saveAsMenuItem;
    boolean running;
    boolean uploading;
    JMenuItem undoItem;
    JMenuItem redoItem;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    LastUndoableEditAwareUndoManager undo;
    CompoundEdit compoundEdit;
    FindReplace find;
    Runnable runHandler;
    Runnable presentHandler;
    Runnable stopHandler;
    Runnable exportHandler;
    Runnable exportAppHandler;

    public Editor(Base ibase, File file, int[] location) throws Exception {
        super("Arduino");
        this.base = ibase;
        Base.setIcon(this);
        this.resetHandlers();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Editor.this.base.handleClose(Editor.this);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Editor.this.base.handleActivated(Editor.this);
                Editor.this.fileMenu.insert(sketchbookMenu, 2);
                Editor.this.fileMenu.insert(examplesMenu, 3);
                Editor.this.buildSketchMenu();
                int offset = 0;
                for (JMenu menu : Editor.this.base.getBoardsCustomMenus()) {
                    Editor.this.toolsMenu.insert(menu, Editor.this.numTools + offset);
                    ++offset;
                }
                Editor.this.toolsMenu.insert(serialMenu, Editor.this.numTools + offset);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                Editor.this.fileMenu.remove(sketchbookMenu);
                Editor.this.fileMenu.remove(examplesMenu);
                Editor.this.buildSketchMenu();
                LinkedList<Component> toolsMenuItemsToRemove = new LinkedList<Component>();
                for (Component menuItem : Editor.this.toolsMenu.getMenuComponents()) {
                    Object removeOnWindowDeactivation;
                    if (!(menuItem instanceof JComponent) || (removeOnWindowDeactivation = ((JComponent)menuItem).getClientProperty("removeOnWindowDeactivation")) == null || !Boolean.valueOf(removeOnWindowDeactivation.toString()).booleanValue()) continue;
                    toolsMenuItemsToRemove.add(menuItem);
                }
                for (Component menuItem : toolsMenuItemsToRemove) {
                    Editor.this.toolsMenu.remove(menuItem);
                }
                Editor.this.toolsMenu.remove(serialMenu);
            }
        });
        this.buildMenuBar();
        Container contentPain = this.getContentPane();
        contentPain.setLayout(new BorderLayout());
        JPanel pain = new JPanel();
        pain.setLayout(new BorderLayout());
        contentPain.add((Component)pain, "Center");
        Box box = Box.createVerticalBox();
        Box upper = Box.createVerticalBox();
        if (toolbarMenu == null) {
            toolbarMenu = new JMenu();
            this.base.rebuildToolbarMenu(toolbarMenu);
        }
        this.toolbar = new EditorToolbar(this, toolbarMenu);
        upper.add(this.toolbar);
        this.header = new EditorHeader(this);
        upper.add(this.header);
        this.textarea = new JEditTextArea(new PdeTextAreaDefaults());
        this.textarea.setName("editor");
        this.textarea.setRightClickPopup(new TextAreaPopup());
        this.textarea.setHorizontalOffset(6);
        this.consolePanel = new JPanel();
        this.consolePanel.setLayout(new BorderLayout());
        this.status = new EditorStatus(this);
        this.consolePanel.add((Component)this.status, "North");
        this.console = new EditorConsole(this);
        this.console.setName("console");
        this.console.setBorder(null);
        this.consolePanel.add((Component)this.console, "Center");
        this.lineStatus = new EditorLineStatus(this.textarea);
        this.consolePanel.add((Component)this.lineStatus, "South");
        upper.add(this.textarea);
        this.splitPane = new JSplitPane(0, upper, this.consolePanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setBorder(null);
        int dividerSize = PreferencesData.getInteger((String)"editor.divider.size");
        if (dividerSize != 0) {
            this.splitPane.setDividerSize(dividerSize);
        }
        this.splitPane.setMinimumSize(new Dimension(600, 100));
        box.add(this.splitPane);
        this.listener = new EditorListener(this, this.textarea);
        pain.add(box);
        this.textarea.addKeyListener(this.toolbar);
        pain.setTransferHandler(new FileDropHandler());
        this.pack();
        this.setPlacement(location);
        this.setMinimumSize(new Dimension(PreferencesData.getInteger((String)"editor.window.width.min"), PreferencesData.getInteger((String)"editor.window.height.min")));
        this.applyPreferences();
        boolean loaded = this.handleOpenInternal(file);
        if (!loaded) {
            this.sketch = null;
        }
    }

    protected void setPlacement(int[] location) {
        this.setBounds(location[0], location[1], location[2], location[3]);
        if (location[4] != 0) {
            this.splitPane.setDividerLocation(location[4]);
        }
    }

    protected int[] getPlacement() {
        int[] location = new int[5];
        Rectangle bounds = this.getBounds();
        location[0] = bounds.x;
        location[1] = bounds.y;
        location[2] = bounds.width;
        location[3] = bounds.height;
        location[4] = this.splitPane.getDividerLocation();
        return location;
    }

    protected void applyPreferences() {
        boolean external = PreferencesData.getBoolean((String)"editor.external");
        this.textarea.setEditable(!external);
        this.saveMenuItem.setEnabled(!external);
        this.saveAsMenuItem.setEnabled(!external);
        this.textarea.setDisplayLineNumbers(PreferencesData.getBoolean((String)"editor.linenumbers"));
        TextAreaPainter painter = this.textarea.getPainter();
        if (external) {
            Color color = Theme.getColor("editor.external.bgcolor");
            painter.setBackground(color);
            painter.setLineHighlightEnabled(false);
            this.textarea.setCaretVisible(false);
        } else {
            Color color = Theme.getColor("editor.bgcolor");
            painter.setBackground(color);
            boolean highlight = PreferencesData.getBoolean((String)"editor.linehighlight");
            painter.setLineHighlightEnabled(highlight);
            this.textarea.setCaretVisible(true);
        }
        painter.setFont(PreferencesData.getFont((String)"editor.font"));
        this.listener.applyPreferences();
    }

    protected void buildMenuBar() throws Exception {
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.buildFileMenu());
        menubar.add(this.buildEditMenu());
        menubar.add(this.buildSketchMenu());
        menubar.add(this.buildToolsMenu());
        menubar.add(this.buildHelpMenu());
        this.setJMenuBar(menubar);
    }

    protected JMenu buildFileMenu() {
        this.fileMenu = new JMenu(I18n._((String)"File"));
        JMenuItem item = Editor.newJMenuItem(I18n._((String)"New"), 78);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Editor.this.base.handleNew();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.fileMenu.add(item);
        item = Editor.newJMenuItem(I18n._((String)"Open..."), 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Editor.this.base.handleOpenPrompt();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.fileMenu.add(item);
        if (sketchbookMenu == null) {
            sketchbookMenu = new JMenu(I18n._((String)"Sketchbook"));
            MenuScroller.setScrollerFor(sketchbookMenu);
            this.base.rebuildSketchbookMenu(sketchbookMenu);
        }
        this.fileMenu.add(sketchbookMenu);
        if (examplesMenu == null) {
            examplesMenu = new JMenu(I18n._((String)"Examples"));
            MenuScroller.setScrollerFor(examplesMenu);
            this.base.rebuildExamplesMenu(examplesMenu);
        }
        this.fileMenu.add(examplesMenu);
        item = Editor.newJMenuItem(I18n._((String)"Close"), 87);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleClose(Editor.this);
            }
        });
        this.fileMenu.add(item);
        this.saveMenuItem = Editor.newJMenuItem(I18n._((String)"Save"), 83);
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSave(false);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem = Editor.newJMenuItemShift(I18n._((String)"Save As..."), 83);
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSaveAs();
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        item = Editor.newJMenuItem(I18n._((String)"Upload"), 85);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleExport(false);
            }
        });
        this.fileMenu.add(item);
        item = Editor.newJMenuItemShift(I18n._((String)"Upload Using Programmer"), 85);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleExport(true);
            }
        });
        this.fileMenu.add(item);
        this.fileMenu.addSeparator();
        item = Editor.newJMenuItemShift(I18n._((String)"Page Setup"), 80);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handlePageSetup();
            }
        });
        this.fileMenu.add(item);
        item = Editor.newJMenuItem(I18n._((String)"Print"), 80);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handlePrint();
            }
        });
        this.fileMenu.add(item);
        if (!OSUtils.isMacOS()) {
            this.fileMenu.addSeparator();
            item = Editor.newJMenuItem(I18n._((String)"Preferences"), 44);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handlePrefs();
                }
            });
            this.fileMenu.add(item);
            this.fileMenu.addSeparator();
            item = Editor.newJMenuItem(I18n._((String)"Quit"), 81);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handleQuit();
                }
            });
            this.fileMenu.add(item);
        }
        return this.fileMenu;
    }

    protected JMenu buildSketchMenu() {
        if (this.sketchMenu == null) {
            this.sketchMenu = new JMenu(I18n._((String)"Sketch"));
        } else {
            this.sketchMenu.removeAll();
        }
        JMenuItem item = Editor.newJMenuItem(I18n._((String)"Verify / Compile"), 82);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleRun(false);
            }
        });
        this.sketchMenu.add(item);
        this.sketchMenu.addSeparator();
        item = Editor.newJMenuItem(I18n._((String)"Show Sketch Folder"), 75);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.openFolder(Editor.this.sketch.getFolder());
            }
        });
        this.sketchMenu.add(item);
        item.setEnabled(Base.openFolderAvailable());
        if (importMenu == null) {
            importMenu = new JMenu(I18n._((String)"Include Library"));
            MenuScroller.setScrollerFor(importMenu);
            this.base.rebuildImportMenu(importMenu);
        }
        this.sketchMenu.add(importMenu);
        item = new JMenuItem(I18n._((String)"Add File..."));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.sketch.handleAddFile();
            }
        });
        this.sketchMenu.add(item);
        return this.sketchMenu;
    }

    protected JMenu buildToolsMenu() throws Exception {
        this.toolsMenu = new JMenu(I18n._((String)"Tools"));
        this.addInternalTools(this.toolsMenu);
        JMenuItem item = Editor.newJMenuItemShift(I18n._((String)"Serial Monitor"), 77);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSerial();
            }
        });
        this.toolsMenu.add(item);
        this.addTools(this.toolsMenu, Base.getToolsFolder());
        File sketchbookTools = new File(Base.getSketchbookFolder(), "tools");
        this.addTools(this.toolsMenu, sketchbookTools);
        this.toolsMenu.addSeparator();
        this.numTools = this.toolsMenu.getItemCount();
        for (JMenu menu : this.base.getBoardsCustomMenus()) {
            this.toolsMenu.add(menu);
        }
        if (serialMenu == null) {
            serialMenu = new JMenu(I18n._((String)"Port"));
        }
        this.populatePortMenu();
        this.toolsMenu.add(serialMenu);
        this.toolsMenu.addSeparator();
        JMenu programmerMenu = new JMenu(I18n._((String)"Programmer"));
        this.base.rebuildProgrammerMenu(programmerMenu);
        this.toolsMenu.add(programmerMenu);
        item = new JMenuItem(I18n._((String)"Burn Bootloader"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleBurnBootloader();
            }
        });
        this.toolsMenu.add(item);
        this.toolsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                Editor.this.populatePortMenu();
                for (Component c : Editor.this.toolsMenu.getMenuComponents()) {
                    String newname;
                    JMenuItem item;
                    JMenu menu;
                    String name;
                    if (!(c instanceof JMenu) || !c.isVisible() || (name = (menu = (JMenu)c).getText()) == null) continue;
                    String basename = name;
                    int index = name.indexOf(58);
                    if (index > 0) {
                        basename = name.substring(0, index);
                    }
                    String sel = null;
                    int count = menu.getItemCount();
                    for (int i = 0; !(i >= count || (item = menu.getItem(i)) != null && item.isSelected() && (sel = item.getText()) != null); ++i) {
                    }
                    if (sel == null) {
                        if (name.equals(basename)) continue;
                        menu.setText(basename);
                        continue;
                    }
                    if (sel.length() > 17) {
                        sel = sel.substring(0, 16) + "...";
                    }
                    if (name.equals(newname = basename + ": \"" + sel + "\"")) continue;
                    menu.setText(newname);
                }
            }
        });
        return this.toolsMenu;
    }

    protected void addTools(JMenu menu, File sourceFolder) {
        if (sourceFolder == null) {
            return;
        }
        HashMap<String, JMenuItem> toolItems = new HashMap<String, JMenuItem>();
        File[] folders = sourceFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File folder) {
                if (folder.isDirectory()) {
                    File subfolder = new File(folder, "tool");
                    return subfolder.exists();
                }
                return false;
            }
        });
        if (folders == null || folders.length == 0) {
            return;
        }
        for (int i = 0; i < folders.length; ++i) {
            File toolDirectory = new File(folders[i], "tool");
            try {
                File[] archives = toolDirectory.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".jar") || name.toLowerCase().endsWith(".zip");
                    }
                });
                URL[] urlList = new URL[archives.length];
                for (int j = 0; j < urlList.length; ++j) {
                    urlList[j] = archives[j].toURI().toURL();
                }
                URLClassLoader loader = new URLClassLoader(urlList);
                String className = null;
                for (int j = 0; j < archives.length && (className = this.findClassInZipFile(folders[i].getName(), archives[j])) == null; ++j) {
                }
                if (className == null) continue;
                Class<?> toolClass = Class.forName(className, true, loader);
                final Tool tool = (Tool)toolClass.newInstance();
                tool.init(this);
                String title = tool.getMenuTitle();
                JMenuItem item = new JMenuItem(title);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(tool);
                    }
                });
                toolItems.put(title, item);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList toolList = new ArrayList(toolItems.keySet());
        if (toolList.size() == 0) {
            return;
        }
        menu.addSeparator();
        Collections.sort(toolList);
        for (String title : toolList) {
            menu.add((JMenuItem)toolItems.get(title));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String findClassInZipFile(String base, File file) {
        String classFileName = "/" + base + ".class";
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (true) {
                if (entries.hasMoreElements()) {
                    String name;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !(name = entry.getName()).endsWith(classFileName)) continue;
                    String string = name.substring(0, name.length() - 6).replace('/', '.');
                    return string;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    protected JMenuItem createToolMenuItem(String className) {
        try {
            Class<?> toolClass = Class.forName(className);
            final Tool tool = (Tool)toolClass.newInstance();
            JMenuItem item = new JMenuItem(tool.getMenuTitle());
            tool.init(this);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(tool);
                }
            });
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected JMenu addInternalTools(JMenu menu) {
        JMenuItem item = this.createToolMenuItem("cc.arduino.packages.formatter.AStyle");
        item.setName("menuToolsAutoFormat");
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        item.setAccelerator(KeyStroke.getKeyStroke(84, modifiers));
        menu.add(item);
        menu.add(this.createToolMenuItem("processing.app.tools.Archiver"));
        menu.add(this.createToolMenuItem("processing.app.tools.FixEncoding"));
        return menu;
    }

    protected void selectSerialPort(String name) {
        if (serialMenu == null) {
            System.out.println(I18n._((String)"serialMenu is null"));
            return;
        }
        if (name == null) {
            System.out.println(I18n._((String)"name is null"));
            return;
        }
        JCheckBoxMenuItem selection = null;
        for (int i = 0; i < serialMenu.getItemCount(); ++i) {
            JMenuItem menuItem = serialMenu.getItem(i);
            if (!(menuItem instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem checkBoxMenuItem = (JCheckBoxMenuItem)menuItem;
            if (checkBoxMenuItem == null) {
                System.out.println(I18n._((String)"name is null"));
                continue;
            }
            checkBoxMenuItem.setState(false);
            if (!name.equals(checkBoxMenuItem.getText())) continue;
            selection = checkBoxMenuItem;
        }
        if (selection != null) {
            selection.setState(true);
        }
        Base.selectSerialPort(name);
        if (serialMonitor != null) {
            try {
                serialMonitor.close();
                serialMonitor.setVisible(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.onBoardOrPortChange();
    }

    protected void populatePortMenu() {
        serialMenu.removeAll();
        String selectedPort = PreferencesData.get((String)"serial.port");
        List ports = Base.getDiscoveryManager().discovery();
        ports = Base.getPlatform().filterPorts(ports, PreferencesData.getBoolean((String)"serial.ports.showall"));
        Collections.sort(ports, new Comparator<BoardPort>(){

            @Override
            public int compare(BoardPort o1, BoardPort o2) {
                return BOARD_PROTOCOLS_ORDER.indexOf(o1.getProtocol()) - BOARD_PROTOCOLS_ORDER.indexOf(o2.getProtocol());
            }
        });
        String lastProtocol = null;
        for (BoardPort port : ports) {
            if (lastProtocol == null || !port.getProtocol().equals(lastProtocol)) {
                if (lastProtocol != null) {
                    serialMenu.addSeparator();
                }
                lastProtocol = port.getProtocol();
                String lastProtocolTranslated = BOARD_PROTOCOLS_ORDER.indexOf(port.getProtocol()) != -1 ? BOARD_PROTOCOLS_ORDER_TRANSLATIONS.get(BOARD_PROTOCOLS_ORDER.indexOf(port.getProtocol())) : port.getProtocol();
                serialMenu.add(new JMenuItem(I18n._((String)lastProtocolTranslated)));
            }
            String address = port.getAddress();
            String label = port.getLabel();
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(label, address.equals(selectedPort));
            item.addActionListener(new SerialMenuListener(address));
            serialMenu.add(item);
        }
        serialMenu.setEnabled(serialMenu.getMenuComponentCount() > 0);
    }

    protected JMenu buildHelpMenu() {
        JMenu menu = new JMenu(I18n._((String)"Help"));
        JMenuItem item = new JMenuItem(I18n._((String)"Getting Started"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.showArduinoGettingStarted();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._((String)"Environment"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.showEnvironment();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._((String)"Troubleshooting"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.showTroubleshooting();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._((String)"Reference"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.showReference();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(I18n._((String)"Galileo Help"));
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem(I18n._((String)"Getting Started"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.showReference("reference/Galileo_help_files", "ArduinoIDE_guide_galileo");
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._((String)"Troubleshooting"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.showReference("reference/Galileo_help_files", "Guide_Troubleshooting_Galileo");
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(I18n._((String)"Edison Help"));
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem(I18n._((String)"Getting Started"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.showReference("reference/Edison_help_files", "ArduinoIDE_guide_edison");
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._((String)"Troubleshooting"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.showReference("reference/Edison_help_files", "Guide_Troubleshooting_Edison");
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = Editor.newJMenuItemShift(I18n._((String)"Find in Reference"), 70);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleFindReference();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._((String)"Frequently Asked Questions"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.showFAQ();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._((String)"Visit Arduino.cc"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.openURL(I18n._((String)"http://arduino.cc/"));
            }
        });
        menu.add(item);
        if (!OSUtils.isMacOS()) {
            menu.addSeparator();
            item = new JMenuItem(I18n._((String)"About Arduino"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handleAbout();
                }
            });
            menu.add(item);
        }
        return menu;
    }

    protected JMenu buildEditMenu() {
        JMenu menu = new JMenu(I18n._((String)"Edit"));
        menu.setName("menuEdit");
        this.undoItem = Editor.newJMenuItem(I18n._((String)"Undo"), 90);
        this.undoItem.setName("menuEditUndo");
        this.undoAction = new UndoAction();
        this.undoItem.addActionListener(this.undoAction);
        menu.add(this.undoItem);
        this.redoItem = !OSUtils.isMacOS() ? Editor.newJMenuItem(I18n._((String)"Redo"), 89) : Editor.newJMenuItemShift(I18n._((String)"Redo"), 90);
        this.redoItem.setName("menuEditRedo");
        this.redoAction = new RedoAction();
        this.redoItem.addActionListener(this.redoAction);
        menu.add(this.redoItem);
        menu.addSeparator();
        JMenuItem item = Editor.newJMenuItem(I18n._((String)"Cut"), 88);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCut();
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._((String)"Copy"), 67);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.copy();
            }
        });
        menu.add(item);
        item = Editor.newJMenuItemShift(I18n._((String)"Copy for Forum"), 67);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DiscourseFormat(Editor.this, false).show();
            }
        });
        menu.add(item);
        item = Editor.newJMenuItemAlt(I18n._((String)"Copy as HTML"), 67);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DiscourseFormat(Editor.this, true).show();
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._((String)"Paste"), 86);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.paste();
                Editor.this.sketch.setModified(true);
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._((String)"Select All"), 65);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.selectAll();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = Editor.newJMenuItem(I18n._((String)"Comment/Uncomment"), 47);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCommentUncomment();
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._((String)"Increase Indent"), 93);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleIndentOutdent(true);
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._((String)"Decrease Indent"), 91);
        item.setName("menuDecreaseIndent");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleIndentOutdent(false);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = Editor.newJMenuItem(I18n._((String)"Find..."), 70);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find == null) {
                    Editor.this.find = new FindReplace(Editor.this);
                }
                if (Editor.this.getSelectedText() != null) {
                    Editor.this.find.setFindText(Editor.this.getSelectedText());
                }
                Editor.this.find.setLocationRelativeTo(Editor.this);
                Editor.this.find.setVisible(true);
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._((String)"Find Next"), 71);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find != null) {
                    Editor.this.find.findNext();
                }
            }
        });
        menu.add(item);
        item = Editor.newJMenuItemShift(I18n._((String)"Find Previous"), 71);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find != null) {
                    Editor.this.find.findPrevious();
                }
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._((String)"Use Selection For Find"), 69);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find == null) {
                    Editor.this.find = new FindReplace(Editor.this);
                }
                Editor.this.find.setLocationRelativeTo(Editor.this);
                Editor.this.find.setFindText(Editor.this.getSelectedText());
            }
        });
        menu.add(item);
        return menu;
    }

    public static JMenuItem newJMenuItem(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_KEY_MASK));
        return menuItem;
    }

    public static JMenuItem newJMenuItemShift(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_KEY_MASK | 1));
        return menuItem;
    }

    public static JMenuItem newJMenuItemAlt(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_ALT_KEY_MASK));
        return menuItem;
    }

    public void setHandlers(Runnable runHandler, Runnable presentHandler, Runnable stopHandler, Runnable exportHandler, Runnable exportAppHandler) {
        this.runHandler = runHandler;
        this.presentHandler = presentHandler;
        this.stopHandler = stopHandler;
        this.exportHandler = exportHandler;
        this.exportAppHandler = exportAppHandler;
    }

    public void resetHandlers() {
        this.runHandler = new BuildHandler();
        this.presentHandler = new BuildHandler(true);
        this.stopHandler = new DefaultStopHandler();
        this.exportHandler = new DefaultExportHandler();
        this.exportAppHandler = new DefaultExportAppHandler();
    }

    public Sketch getSketch() {
        return this.sketch;
    }

    public JEditTextArea getTextArea() {
        return this.textarea;
    }

    public String getText() {
        return this.textarea.getText();
    }

    public String getText(int start, int stop) {
        return this.textarea.getText(start, stop - start);
    }

    public void setText(String what) {
        this.startCompoundEdit();
        this.textarea.setText(what);
        this.stopCompoundEdit();
    }

    public void insertText(String what) {
        this.startCompoundEdit();
        int caret = this.getCaretOffset();
        this.setSelection(caret, caret);
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public String getSelectedText() {
        return this.textarea.getSelectedText();
    }

    public void setSelectedText(String what) {
        this.textarea.setSelectedText(what);
    }

    public void setSelection(int start, int stop) {
        start = PApplet.constrain((int)start, (int)0, (int)this.textarea.getDocumentLength());
        stop = PApplet.constrain((int)stop, (int)0, (int)this.textarea.getDocumentLength());
        this.textarea.select(start, stop);
    }

    public int getCaretOffset() {
        return this.textarea.getCaretPosition();
    }

    public boolean isSelectionActive() {
        return this.textarea.isSelectionActive();
    }

    public int getSelectionStart() {
        return this.textarea.getSelectionStart();
    }

    public int getSelectionStop() {
        return this.textarea.getSelectionStop();
    }

    public String getLineText(int line) {
        return this.textarea.getLineText(line);
    }

    public void setLineText(int line, String what) {
        this.startCompoundEdit();
        this.textarea.select(this.getLineStartOffset(line), this.getLineStopOffset(line));
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public int getLineStartOffset(int line) {
        return this.textarea.getLineStartOffset(line);
    }

    public int getLineStopOffset(int line) {
        return this.textarea.getLineStopOffset(line);
    }

    public int getLineCount() {
        return this.textarea.getLineCount();
    }

    public void startCompoundEdit() {
        this.compoundEdit = new CompoundEdit();
    }

    public void stopCompoundEdit() {
        this.compoundEdit.end();
        this.undo.addEdit(this.compoundEdit);
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
        this.compoundEdit = null;
    }

    public int getScrollPosition() {
        return this.textarea.getScrollPosition();
    }

    protected void setCode(SketchCodeDocument codeDoc) {
        SyntaxDocument document = (SyntaxDocument)codeDoc.getDocument();
        if (document == null) {
            document = new SyntaxDocument();
            codeDoc.setDocument(document);
            document.setTokenMarker(new PdeKeywords());
            try {
                document.insertString(0, codeDoc.getCode().getProgram(), null);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
            document.addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent e) {
                    if (Editor.this.compoundEdit != null) {
                        Editor.this.compoundEdit.addEdit(new CaretAwareUndoableEdit(e.getEdit(), Editor.this.textarea));
                    } else if (Editor.this.undo != null) {
                        Editor.this.undo.addEdit(new CaretAwareUndoableEdit(e.getEdit(), Editor.this.textarea));
                    }
                    if (Editor.this.compoundEdit != null || Editor.this.undo != null) {
                        Editor.this.sketch.setModified(true);
                        Editor.this.undoAction.updateUndoState();
                        Editor.this.redoAction.updateRedoState();
                    }
                }
            });
        }
        this.textarea.setDocument(document, codeDoc.getSelectionStart(), codeDoc.getSelectionStop(), codeDoc.getScrollPosition());
        this.textarea.requestFocus();
        this.undo = codeDoc.getUndo();
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    public void handleCut() {
        this.textarea.cut();
        this.sketch.setModified(true);
    }

    public void handleCopy() {
        this.textarea.copy();
    }

    protected void handleDiscourseCopy() {
        new DiscourseFormat(this, false).show();
    }

    protected void handleHTMLCopy() {
        new DiscourseFormat(this, true).show();
    }

    public void handlePaste() {
        this.textarea.paste();
        this.sketch.setModified(true);
    }

    public void handleSelectAll() {
        this.textarea.selectAll();
    }

    protected void handleCommentUncomment() {
        this.startCompoundEdit();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        int length = this.textarea.getDocumentLength();
        boolean commented = true;
        for (int i = startLine; commented && i <= stopLine; ++i) {
            int pos = this.textarea.getLineStartOffset(i);
            if (pos + 2 > length) {
                commented = false;
                continue;
            }
            String begin = this.textarea.getText(pos, 2);
            commented = begin.equals("//");
        }
        for (int line = startLine; line <= stopLine; ++line) {
            int location = this.textarea.getLineStartOffset(line);
            if (commented) {
                this.textarea.select(location, location + 2);
                if (!this.textarea.getSelectedText().equals("//")) continue;
                this.textarea.setSelectedText("");
                continue;
            }
            this.textarea.select(location, location);
            this.textarea.setSelectedText("//");
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
    }

    protected void handleIndentOutdent(boolean indent) {
        int tabSize = PreferencesData.getInteger((String)"editor.tabs.size");
        String tabString = EMPTY.substring(0, tabSize);
        this.startCompoundEdit();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        for (int line = startLine; line <= stopLine; ++line) {
            int location = this.textarea.getLineStartOffset(line);
            if (indent) {
                this.textarea.select(location, location);
                this.textarea.setSelectedText(tabString);
                continue;
            }
            this.textarea.select(location, location + tabSize);
            if (!this.textarea.getSelectedText().equals(tabString)) continue;
            this.textarea.setSelectedText("");
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
    }

    protected String getCurrentKeyword() {
        String text = "";
        if (this.textarea.getSelectedText() != null) {
            text = this.textarea.getSelectedText().trim();
        }
        try {
            int current = this.textarea.getCaretPosition();
            int startOffset = 0;
            int endIndex = current;
            String tmp = this.textarea.getDocument().getText(current, 1);
            String regexp = "[\\s\\n();\\\\.!='\\[\\]{}]";
            while (!tmp.matches(regexp)) {
                tmp = this.textarea.getDocument().getText(++endIndex, 1);
            }
            tmp = "";
            while (!tmp.matches(regexp)) {
                if (current - ++startOffset < 0) {
                    tmp = this.textarea.getDocument().getText(0, 1);
                    break;
                }
                tmp = this.textarea.getDocument().getText(current - startOffset, 1);
            }
            int length = endIndex - current + --startOffset;
            text = this.textarea.getDocument().getText(current - startOffset, length);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        return text;
    }

    protected void handleFindReference() {
        String text = this.getCurrentKeyword();
        String referenceFile = PdeKeywords.getReference(text);
        if (referenceFile == null) {
            this.statusNotice(I18n.format((String)I18n._((String)"No reference available for \"{0}\""), (Object[])new Object[]{text}));
        } else {
            Base.showReference("Reference/" + referenceFile);
        }
    }

    public void handleRun(boolean verbose) {
        this.internalCloseRunner();
        if (PreferencesData.getBoolean((String)"editor.save_on_verify") && this.sketch.isModified() && !this.sketch.isReadOnly()) {
            this.handleSave(true);
        }
        this.running = true;
        this.toolbar.activate(0);
        this.status.progress(I18n._((String)"Compiling sketch..."));
        for (int i = 0; i < 10; ++i) {
            System.out.println();
        }
        if (PreferencesData.getBoolean((String)"console.auto_clear")) {
            this.console.clear();
        }
        new Thread(verbose ? this.presentHandler : this.runHandler).start();
    }

    public void setSketchLocation(Point p) {
        this.sketchWindowLocation = p;
    }

    public Point getSketchLocation() {
        return this.sketchWindowLocation;
    }

    public void handleStop() {
        this.internalCloseRunner();
        this.toolbar.deactivate(0);
        this.toFront();
    }

    public void internalRunnerClosed() {
        this.running = false;
        this.toolbar.deactivate(0);
    }

    public void internalCloseRunner() {
        this.running = false;
        if (this.stopHandler != null) {
            try {
                this.stopHandler.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean checkModified() {
        if (!this.sketch.isModified()) {
            return true;
        }
        this.toFront();
        String prompt = I18n.format((String)I18n._((String)"Save changes to \"{0}\"?  "), (Object[])new Object[]{this.sketch.getName()});
        if (!OSUtils.isMacOS()) {
            int result = JOptionPane.showConfirmDialog(this, prompt, I18n._((String)"Close"), 1, 3);
            switch (result) {
                case 0: {
                    return this.handleSave(true);
                }
                case 1: {
                    return true;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
            throw new IllegalStateException();
        }
        JOptionPane pane = new JOptionPane(I18n._((String)"<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost."), 3);
        Object[] options = new String[]{I18n._((String)"Save"), I18n._((String)"Cancel"), I18n._((String)"Don't Save")};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog dialog = pane.createDialog(this, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return this.handleSave(true);
        }
        return result == options[2];
    }

    protected void handleOpenUnchecked(File file, int codeIndex, int selStart, int selStop, int scrollPos) {
        this.internalCloseRunner();
        this.handleOpenInternal(file);
        this.untitled = false;
        this.sketch.setCurrentCode(codeIndex);
        this.textarea.select(selStart, selStop);
        this.textarea.setScrollPosition(scrollPos);
    }

    protected boolean handleOpenInternal(File sketchFile) {
        String fileName = sketchFile.getName();
        File file = SketchData.checkSketchFile((File)sketchFile);
        if (file == null) {
            if (!fileName.endsWith(".ino") && !fileName.endsWith(".pde")) {
                Base.showWarning(I18n._((String)"Bad file selected"), I18n._((String)"Arduino can only open its own sketches\nand other files ending in .ino or .pde"), null);
                return false;
            }
            String properParent = fileName.substring(0, fileName.length() - 4);
            Object[] options = new Object[]{I18n._((String)"OK"), I18n._((String)"Cancel")};
            String prompt = I18n.format((String)I18n._((String)"The file \"{0}\" needs to be inside\na sketch folder named \"{1}\".\nCreate this folder, move the file, and continue?"), (Object[])new Object[]{fileName, properParent});
            int result = JOptionPane.showOptionDialog(this, prompt, I18n._((String)"Moving"), 0, 3, null, options, options[0]);
            if (result == 0) {
                File properFolder = new File(sketchFile.getParent(), properParent);
                if (properFolder.exists()) {
                    Base.showWarning(I18n._((String)"Error"), I18n.format((String)I18n._((String)"A folder named \"{0}\" already exists. Can't open sketch."), (Object[])new Object[]{properParent}), null);
                    return false;
                }
                if (!properFolder.mkdirs()) {
                    Base.showWarning(I18n._((String)"Error"), I18n._((String)"Could not create the sketch folder."), null);
                    return false;
                }
                File properPdeFile = new File(properFolder, sketchFile.getName());
                try {
                    Base.copyFile(sketchFile, properPdeFile);
                }
                catch (IOException e) {
                    Base.showWarning(I18n._((String)"Error"), I18n._((String)"Could not copy to a proper location."), e);
                    return false;
                }
                sketchFile.delete();
                file = properPdeFile;
            } else if (result == 1) {
                return false;
            }
        }
        try {
            this.sketch = new Sketch(this, file);
        }
        catch (IOException e) {
            Base.showWarning(I18n._((String)"Error"), I18n._((String)"Could not create the sketch."), e);
            return false;
        }
        this.header.rebuild();
        this.setTitle(I18n.format((String)I18n._((String)"{0} | Arduino {1}"), (Object[])new Object[]{this.sketch.getName(), BaseNoGui.VERSION_NAME}));
        this.untitled = false;
        this.base.storeSketches();
        PreferencesData.save();
        return true;
    }

    public boolean handleSave(boolean immediately) {
        this.handleStop();
        if (this.untitled) {
            return this.handleSaveAs();
        }
        if (immediately) {
            return this.handleSave2();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Editor.this.handleSave2();
            }
        });
        return true;
    }

    protected boolean handleSave2() {
        this.toolbar.activate(4);
        this.statusNotice(I18n._((String)"Saving..."));
        boolean saved = false;
        try {
            saved = this.sketch.save();
            if (saved) {
                this.statusNotice(I18n._((String)"Done Saving."));
            } else {
                this.statusEmpty();
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
        this.toolbar.deactivate(4);
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSaveAs() {
        block6: {
            this.handleStop();
            this.toolbar.activate(4);
            this.statusNotice(I18n._((String)"Saving..."));
            try {
                if (this.sketch.saveAs()) {
                    this.statusNotice(I18n._((String)"Done Saving."));
                    break block6;
                }
                this.statusNotice(I18n._((String)"Save Canceled."));
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                this.statusError(e);
            }
            finally {
                this.toolbar.deactivate(4);
            }
        }
        return true;
    }

    public boolean serialPrompt() {
        int count = serialMenu.getItemCount();
        Object[] names = new Object[count];
        for (int i = 0; i < count; ++i) {
            names[i] = ((JCheckBoxMenuItem)serialMenu.getItem(i)).getText();
        }
        String result = (String)JOptionPane.showInputDialog(this, I18n.format((String)I18n._((String)"Serial port {0} not found.\nRetry the upload with another serial port?"), (Object[])new Object[]{PreferencesData.get((String)"serial.port")}), "Serial port not found", -1, null, names, 0);
        if (result == null) {
            return false;
        }
        this.selectSerialPort(result);
        this.base.onBoardOrPortChange();
        return true;
    }

    public synchronized void handleExport(boolean usingProgrammer) {
        if (PreferencesData.getBoolean((String)"editor.save_on_verify") && this.sketch.isModified() && !this.sketch.isReadOnly()) {
            this.handleSave(true);
        }
        this.toolbar.activate(1);
        this.console.clear();
        this.status.progress(I18n._((String)"Uploading to I/O Board..."));
        new Thread(usingProgrammer ? this.exportAppHandler : this.exportHandler).start();
    }

    protected boolean handleExportCheckModified() {
        if (!this.sketch.isModified()) {
            return true;
        }
        Object[] options = new Object[]{I18n._((String)"OK"), I18n._((String)"Cancel")};
        int result = JOptionPane.showOptionDialog(this, I18n._((String)"Save changes before export?"), I18n._((String)"Save"), 2, 3, null, options, options[0]);
        if (result != 0) {
            this.statusNotice(I18n._((String)"Export canceled, changes must first be saved."));
            return false;
        }
        this.handleSave(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSerial() {
        BoardPort port;
        if (this.uploading) {
            return;
        }
        if (serialMonitor != null) {
            try {
                serialMonitor.close();
                serialMonitor.setVisible(false);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((port = Base.getDiscoveryManager().find(PreferencesData.get((String)"serial.port"))) == null) {
            this.statusError(I18n.format((String)"Board at {0} is not available", (Object[])new Object[]{PreferencesData.get((String)"serial.port")}));
            return;
        }
        serialMonitor = new MonitorFactory().newMonitor(port);
        serialMonitor.setIconImage(this.getIconImage());
        boolean success = false;
        do {
            if (serialMonitor.requiresAuthorization() && !PreferencesData.has((String)serialMonitor.getAuthorizationKey())) {
                PasswordAuthorizationDialog dialog = new PasswordAuthorizationDialog((Frame)this, I18n._((String)"Type board password to access its console"));
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isCancelled()) {
                    this.statusNotice(I18n._((String)"Unable to open serial monitor"));
                    return;
                }
                PreferencesData.set((String)serialMonitor.getAuthorizationKey(), (String)dialog.getPassword());
            }
            try {
                serialMonitor.open();
                serialMonitor.setVisible(true);
                success = true;
            }
            catch (ConnectException e) {
                this.statusError(I18n._((String)"Unable to connect: is the sketch using the bridge?"));
            }
            catch (JSchException e) {
                this.statusError(I18n._((String)"Unable to connect: wrong password?"));
            }
            catch (SerialException e) {
                String errorMessage = e.getMessage();
                if (e.getCause() != null && e.getCause() instanceof SerialPortException) {
                    errorMessage = errorMessage + " (" + ((SerialPortException)e.getCause()).getExceptionType() + ")";
                }
                this.statusError(errorMessage);
            }
            catch (Exception e) {
                this.statusError(e);
            }
            finally {
                if (serialMonitor.requiresAuthorization() && !success) {
                    PreferencesData.remove((String)serialMonitor.getAuthorizationKey());
                }
            }
        } while (serialMonitor.requiresAuthorization() && !success);
    }

    protected void handleBurnBootloader() {
        this.console.clear();
        this.statusNotice(I18n._((String)"Burning bootloader to I/O Board (this may take a minute)..."));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SerialUploader uploader = new SerialUploader();
                    if (uploader.burnBootloader()) {
                        Editor.this.statusNotice(I18n._((String)"Done burning bootloader."));
                    } else {
                        Editor.this.statusError(I18n._((String)"Error while burning bootloader."));
                    }
                }
                catch (PreferencesMapException e) {
                    Editor.this.statusError(I18n.format((String)I18n._((String)"Error while burning bootloader: missing '{0}' configuration parameter"), (Object[])new Object[]{e.getMessage()}));
                }
                catch (RunnerException e) {
                    Editor.this.statusError(e.getMessage());
                }
                catch (Exception e) {
                    Editor.this.statusError(I18n._((String)"Error while burning bootloader."));
                    e.printStackTrace();
                }
            }
        });
    }

    public void handlePageSetup() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
        }
        this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
    }

    public void handlePrint() {
        this.statusNotice(I18n._((String)"Printing..."));
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat != null) {
            this.printerJob.setPrintable(this.textarea.getPainter(), this.pageFormat);
        } else {
            this.printerJob.setPrintable(this.textarea.getPainter());
        }
        this.printerJob.setJobName(this.sketch.getCurrentCode().getPrettyName());
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
                this.statusNotice(I18n._((String)"Done printing."));
            }
            catch (PrinterException pe) {
                this.statusError(I18n._((String)"Error while printing."));
                pe.printStackTrace();
            }
        } else {
            this.statusNotice(I18n._((String)"Printing canceled."));
        }
    }

    @Override
    public void statusError(String what) {
        System.err.println(what);
        this.status.error(what);
        this.toolbar.deactivate(0);
    }

    @Override
    public void statusError(Exception e) {
        String mess;
        e.printStackTrace();
        if (e instanceof RunnerException) {
            RunnerException re = (RunnerException)((Object)e);
            if (re.hasCodeIndex()) {
                this.sketch.setCurrentCode(re.getCodeIndex());
            }
            if (re.hasCodeLine()) {
                int line = re.getCodeLine();
                if (line >= this.textarea.getLineCount() && this.textarea.getLineText(line = this.textarea.getLineCount() - 1).length() == 0) {
                    --line;
                }
                if (line < 0 || line >= this.textarea.getLineCount()) {
                    System.err.println(I18n.format((String)I18n._((String)"Bad error line: {0}"), (Object[])new Object[]{line}));
                } else {
                    this.textarea.select(this.textarea.getLineStartOffset(line), this.textarea.getLineStopOffset(line) - 1);
                }
            }
        }
        if ((mess = e.getMessage()) != null) {
            String rxString;
            String javaLang = "java.lang.";
            if (mess.indexOf(javaLang) == 0) {
                mess = mess.substring(javaLang.length());
            }
            if (mess.indexOf(rxString = "RuntimeException: ") == 0) {
                mess = mess.substring(rxString.length());
            }
            this.statusError(mess);
        }
    }

    @Override
    public void statusNotice(String msg) {
        this.status.notice(msg);
    }

    public void statusEmpty() {
        this.statusNotice(EMPTY);
    }

    protected void onBoardOrPortChange() {
        PreferencesMap boardPreferences = Base.getBoardPreferences();
        if (boardPreferences != null) {
            this.lineStatus.setBoardName((String)boardPreferences.get("name"));
        } else {
            this.lineStatus.setBoardName("-");
        }
        this.lineStatus.setSerialPort(PreferencesData.get((String)"serial.port"));
        this.lineStatus.repaint();
    }

    class TextAreaPopup
    extends JPopupMenu {
        private String referenceFile = null;
        private JMenuItem cutItem;
        private JMenuItem copyItem;
        private JMenuItem discourseItem;
        private JMenuItem referenceItem;
        private JMenuItem openURLItem = new JMenuItem(I18n._((String)"Open URL"));
        private JSeparator openURLItemSeparator;
        private String clickedURL;

        public TextAreaPopup() {
            this.openURLItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Base.openURL(TextAreaPopup.this.clickedURL);
                }
            });
            this.add(this.openURLItem);
            this.openURLItemSeparator = new JSeparator();
            this.add(this.openURLItemSeparator);
            this.cutItem = new JMenuItem(I18n._((String)"Cut"));
            this.cutItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCut();
                }
            });
            this.add(this.cutItem);
            this.copyItem = new JMenuItem(I18n._((String)"Copy"));
            this.copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCopy();
                }
            });
            this.add(this.copyItem);
            this.discourseItem = new JMenuItem(I18n._((String)"Copy for Forum"));
            this.discourseItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleDiscourseCopy();
                }
            });
            this.add(this.discourseItem);
            this.discourseItem = new JMenuItem(I18n._((String)"Copy as HTML"));
            this.discourseItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleHTMLCopy();
                }
            });
            this.add(this.discourseItem);
            JMenuItem item = new JMenuItem(I18n._((String)"Paste"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handlePaste();
                }
            });
            this.add(item);
            item = new JMenuItem(I18n._((String)"Select All"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleSelectAll();
                }
            });
            this.add(item);
            this.addSeparator();
            item = new JMenuItem(I18n._((String)"Comment/Uncomment"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCommentUncomment();
                }
            });
            this.add(item);
            item = new JMenuItem(I18n._((String)"Increase Indent"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleIndentOutdent(true);
                }
            });
            this.add(item);
            item = new JMenuItem(I18n._((String)"Decrease Indent"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleIndentOutdent(false);
                }
            });
            this.add(item);
            this.addSeparator();
            this.referenceItem = new JMenuItem(I18n._((String)"Find in Reference"));
            this.referenceItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleFindReference();
                }
            });
            this.add(this.referenceItem);
        }

        @Override
        public void show(Component component, int x, int y) {
            int lineNo = Editor.this.textarea.getLineOfOffset(Editor.this.textarea.xyToOffset(x, y));
            int offset = Editor.this.textarea.xToOffset(lineNo, x);
            String line = Editor.this.textarea.getLineText(lineNo);
            this.clickedURL = Editor.this.textarea.checkClickedURL(line, offset);
            if (this.clickedURL != null) {
                this.openURLItem.setVisible(true);
                this.openURLItemSeparator.setVisible(true);
            } else {
                this.openURLItem.setVisible(false);
                this.openURLItemSeparator.setVisible(false);
            }
            if (Editor.this.textarea.isSelectionActive()) {
                this.cutItem.setEnabled(true);
                this.copyItem.setEnabled(true);
                this.discourseItem.setEnabled(true);
            } else {
                this.cutItem.setEnabled(false);
                this.copyItem.setEnabled(false);
                this.discourseItem.setEnabled(false);
            }
            this.referenceFile = PdeKeywords.getReference(Editor.this.getCurrentKeyword());
            this.referenceItem.setEnabled(this.referenceFile != null);
            super.show(component, x, y);
        }
    }

    class DefaultExportAppHandler
    implements Runnable {
        DefaultExportAppHandler() {
        }

        @Override
        public void run() {
            try {
                if (serialMonitor != null) {
                    serialMonitor.close();
                    serialMonitor.setVisible(false);
                }
                Editor.this.uploading = true;
                boolean success = Editor.this.sketch.exportApplet(true);
                if (success) {
                    Editor.this.statusNotice(I18n._((String)"Done uploading."));
                }
            }
            catch (SerialNotFoundException e) {
                Editor.this.populatePortMenu();
                if (serialMenu.getItemCount() == 0) {
                    Editor.this.statusError((Exception)((Object)e));
                } else if (Editor.this.serialPrompt()) {
                    this.run();
                } else {
                    Editor.this.statusNotice(I18n._((String)"Upload canceled."));
                }
            }
            catch (PreferencesMapException e) {
                Editor.this.statusError(I18n.format((String)I18n._((String)"Error while uploading: missing '{0}' configuration parameter"), (Object[])new Object[]{e.getMessage()}));
            }
            catch (RunnerException e) {
                Editor.this.status.unprogress();
                Editor.this.statusError((Exception)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Editor.this.status.unprogress();
            Editor.this.uploading = false;
            Editor.this.toolbar.deactivate(1);
        }
    }

    class DefaultExportHandler
    implements Runnable {
        DefaultExportHandler() {
        }

        @Override
        public void run() {
            try {
                if (serialMonitor != null) {
                    serialMonitor.close();
                    serialMonitor.setVisible(false);
                }
                Editor.this.uploading = true;
                boolean success = Editor.this.sketch.exportApplet(false);
                if (success) {
                    Editor.this.statusNotice(I18n._((String)"Done uploading."));
                }
            }
            catch (SerialNotFoundException e) {
                Editor.this.populatePortMenu();
                if (serialMenu.getItemCount() == 0) {
                    Editor.this.statusError((Exception)((Object)e));
                } else if (Editor.this.serialPrompt()) {
                    this.run();
                } else {
                    Editor.this.statusNotice(I18n._((String)"Upload canceled."));
                }
            }
            catch (PreferencesMapException e) {
                Editor.this.statusError(I18n.format((String)I18n._((String)"Error while uploading: missing '{0}' configuration parameter"), (Object[])new Object[]{e.getMessage()}));
            }
            catch (RunnerException e) {
                Editor.this.status.unprogress();
                Editor.this.statusError((Exception)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Editor.this.status.unprogress();
            Editor.this.uploading = false;
            Editor.this.toolbar.deactivate(1);
        }
    }

    class DefaultStopHandler
    implements Runnable {
        DefaultStopHandler() {
        }

        @Override
        public void run() {
        }
    }

    class BuildHandler
    implements Runnable {
        private final boolean verbose;

        public BuildHandler() {
            this(false);
        }

        public BuildHandler(boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        public void run() {
            try {
                Editor.this.sketch.prepare();
                Editor.this.sketch.build(this.verbose);
                Editor.this.statusNotice(I18n._((String)"Done compiling."));
            }
            catch (PreferencesMapException e) {
                Editor.this.statusError(I18n.format((String)I18n._((String)"Error while compiling: missing '{0}' configuration parameter"), (Object[])new Object[]{e.getMessage()}));
            }
            catch (Exception e) {
                Editor.this.status.unprogress();
                Editor.this.statusError(e);
            }
            Editor.this.status.unprogress();
            Editor.this.toolbar.deactivate(0);
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Editor.this.undo.redo();
                Editor.this.sketch.setModified(true);
            }
            catch (CannotRedoException ex) {
                // empty catch block
            }
            if (Editor.this.undo.getLastUndoableEdit() != null && Editor.this.undo.getLastUndoableEdit() instanceof CaretAwareUndoableEdit) {
                CaretAwareUndoableEdit undoableEdit = (CaretAwareUndoableEdit)Editor.this.undo.getLastUndoableEdit();
                Editor.this.textarea.setCaretPosition(undoableEdit.getCaretPosition());
            }
            this.updateRedoState();
            Editor.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (Editor.this.undo.canRedo()) {
                Editor.this.redoItem.setEnabled(true);
                Editor.this.redoItem.setText(Editor.this.undo.getRedoPresentationName());
                this.putValue("Name", Editor.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                Editor.this.redoItem.setEnabled(false);
                Editor.this.redoItem.setText(I18n._((String)"Redo"));
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CaretAwareUndoableEdit undoableEdit;
            int nextCaretPosition;
            try {
                Editor.this.undo.undo();
                Editor.this.sketch.setModified(true);
            }
            catch (CannotUndoException ex) {
                // empty catch block
            }
            if (Editor.this.undo.getLastUndoableEdit() != null && Editor.this.undo.getLastUndoableEdit() instanceof CaretAwareUndoableEdit && (nextCaretPosition = (undoableEdit = (CaretAwareUndoableEdit)Editor.this.undo.getLastUndoableEdit()).getCaretPosition() - 1) >= 0 && Editor.this.textarea.getDocumentLength() > nextCaretPosition) {
                Editor.this.textarea.setCaretPosition(nextCaretPosition);
            }
            this.updateUndoState();
            Editor.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (Editor.this.undo.canUndo()) {
                this.setEnabled(true);
                Editor.this.undoItem.setEnabled(true);
                Editor.this.undoItem.setText(Editor.this.undo.getUndoPresentationName());
                this.putValue("Name", Editor.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                Editor.this.undoItem.setEnabled(false);
                Editor.this.undoItem.setText(I18n._((String)"Undo"));
                this.putValue("Name", "Undo");
            }
        }
    }

    class SerialMenuListener
    implements ActionListener {
        private final String serialPort;

        public SerialMenuListener(String serialPort) {
            this.serialPort = serialPort;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.selectSerialPort(this.serialPort);
            Editor.this.base.onBoardOrPortChange();
        }
    }

    class FileDropHandler
    extends TransferHandler {
        FileDropHandler() {
        }

        @Override
        public boolean canImport(JComponent dest, DataFlavor[] flavors) {
            return true;
        }

        @Override
        public boolean importData(JComponent src, Transferable transferable) {
            int successful = 0;
            try {
                DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : list) {
                        if (!Editor.this.sketch.addFile(file)) continue;
                        ++successful;
                    }
                } else if (transferable.isDataFlavorSupported(uriListFlavor)) {
                    String data = (String)transferable.getTransferData(uriListFlavor);
                    String[] pieces = PApplet.splitTokens((String)data, (String)"\r\n");
                    for (int i = 0; i < pieces.length; ++i) {
                        if (pieces[i].startsWith("#")) continue;
                        String path = null;
                        if (pieces[i].startsWith("file:///")) {
                            path = pieces[i].substring(7);
                        } else if (pieces[i].startsWith("file:/")) {
                            path = pieces[i].substring(5);
                        }
                        if (!Editor.this.sketch.addFile(new File(path))) continue;
                        ++successful;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (successful == 0) {
                Editor.this.statusError(I18n._((String)"No files were added to the sketch."));
            } else if (successful == 1) {
                Editor.this.statusNotice(I18n._((String)"One file added to the sketch."));
            } else {
                Editor.this.statusNotice(I18n.format((String)I18n._((String)"{0} files added to the sketch."), (Object[])new Object[]{successful}));
            }
            return true;
        }
    }
}

