/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;

public class FileUtils {
    private static final List<String> SOURCE_CONTROL_FOLDERS = Arrays.asList("CVS", "RCS", ".git", ".svn", ".hg", ".bzr");
    private static final Pattern BACKSLASH = Pattern.compile("\\\\");

    public static boolean isSubDirectory(File base, File child) {
        try {
            base = base.getCanonicalFile();
            child = child.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        for (File parentFile = child; parentFile != null; parentFile = parentFile.getParentFile()) {
            if (!base.equals(parentFile)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(dest);
            byte[] buf = new byte[4096];
            int readBytes = -1;
            while ((readBytes = fis.read(buf, 0, buf.length)) != -1) {
                fos.write(buf, 0, readBytes);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void copy(File sourceFolder, File destFolder) throws IOException {
        for (File file : sourceFolder.listFiles()) {
            File destFile = new File(destFolder, file.getName());
            if (file.isDirectory()) {
                if (!destFile.mkdir()) {
                    throw new IOException("Unable to create folder: " + destFile);
                }
                FileUtils.copy(file, destFile);
                continue;
            }
            FileUtils.copyFile(file, destFile);
        }
    }

    public static void recursiveDelete(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File current : files) {
                FileUtils.recursiveDelete(current);
            }
        }
        FileUtils.deleteIfExists(file);
    }

    public static File createTempFolder() throws IOException {
        return FileUtils.createTempFolderIn(new File(System.getProperty("java.io.tmpdir")));
    }

    public static File createTempFolderIn(File parent) throws IOException {
        File tmpFolder = new File(parent, "arduino_" + new Random().nextInt(1000000));
        if (!tmpFolder.mkdir()) {
            throw new IOException("Unable to create temp folder " + tmpFolder);
        }
        return tmpFolder;
    }

    public static String relativePath(String origin, String target) {
        try {
            origin = new File(origin).getCanonicalPath();
            File targetFile = new File(target);
            target = targetFile.isAbsolute() ? targetFile.getCanonicalPath() : new File(origin, target).getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        if (origin.equals(target)) {
            return ".";
        }
        if (origin.equals(File.separator)) {
            return "." + target;
        }
        String prefix = "";
        String root = File.separator;
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            if (origin.startsWith("\\\\") || target.startsWith("\\\\")) {
                return null;
            }
            char originLetter = origin.charAt(0);
            char targetLetter = target.charAt(0);
            if (Character.isLetter(originLetter) && Character.isLetter(targetLetter) && originLetter != targetLetter) {
                return null;
            }
            prefix = "" + originLetter + ':';
            root = prefix + File.separator;
        }
        String relative = "";
        while (!target.startsWith(origin + File.separator)) {
            if ((origin = new File(origin).getParent()).equals(root)) {
                origin = prefix;
            }
            relative = relative + "..";
            relative = relative + File.separator;
        }
        return relative + target.substring(origin.length() + 1);
    }

    public static String getLinuxPathFrom(File file) {
        return BACKSLASH.matcher(file.getAbsolutePath()).replaceAll("/");
    }

    public static boolean isSCCSOrHiddenFile(File file) {
        return file.isHidden() || file.getName().charAt(0) == '.' || file.isDirectory() && SOURCE_CONTROL_FOLDERS.contains(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static boolean hasExtension(File file, String ... extensions) {
        return FileUtils.hasExtension(file, Arrays.asList(extensions));
    }

    public static boolean hasExtension(File file, List<String> extensions) {
        String[] pieces = file.getName().split("\\.");
        if (pieces.length < 2) {
            return false;
        }
        String extension = pieces[pieces.length - 1];
        return extensions.contains(extension.toLowerCase());
    }

    public static List<File> listFiles(File folder, boolean recursive, String ... extensions) {
        return FileUtils.listFiles(folder, recursive, Arrays.asList(extensions));
    }

    public static List<File> listFiles(File folder, boolean recursive, List<String> extensions) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : folder.listFiles()) {
            if (FileUtils.isSCCSOrHiddenFile(file)) continue;
            if (file.isDirectory()) {
                if (!recursive) continue;
                result.addAll(FileUtils.listFiles(file, true, extensions));
                continue;
            }
            if (!extensions.isEmpty() && !FileUtils.hasExtension(file, extensions)) continue;
            result.add(file);
        }
        return result;
    }

    public static File newFile(File parent, String ... parts) {
        File result = parent;
        for (String part : parts) {
            result = new File(result, part);
        }
        return result;
    }

    public static boolean deleteIfExists(File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }
}

