/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.MissingResourceException;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.helpers.PreferencesHelper;
import processing.app.helpers.PreferencesMap;
import processing.app.legacy.PApplet;
import processing.app.legacy.PConstants;

public class PreferencesData {
    private static final String PREFS_FILE = "preferences.txt";
    static PreferencesMap defaults;
    static PreferencesMap prefs;
    static File preferencesFile;
    static boolean doSave;

    public static void init(File file) {
        preferencesFile = file != null ? file : BaseNoGui.getSettingsFile(PREFS_FILE);
        try {
            BaseNoGui.getPlatform().fixPrefsFilePermissions(preferencesFile);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            prefs.load(new File(BaseNoGui.getContentFile("lib"), PREFS_FILE));
        }
        catch (IOException e) {
            BaseNoGui.showError(null, I18n._("Could not read default settings.\nYou'll need to reinstall Arduino."), e);
        }
        File hardwareFolder = BaseNoGui.getHardwareFolder();
        prefs.put("runtime.ide.path", hardwareFolder.getParentFile().getAbsolutePath());
        prefs.put("runtime.ide.version", "10604");
        defaults = new PreferencesMap(prefs);
        if (preferencesFile.exists()) {
            try {
                prefs.load(preferencesFile);
            }
            catch (IOException ex) {
                BaseNoGui.showError(I18n._("Error reading preferences"), I18n.format(I18n._("Error reading the preferences file. Please delete (or move)\n{0} and restart Arduino."), preferencesFile.getAbsolutePath()), ex);
            }
        }
        try {
            I18n.init(PreferencesData.get("editor.languages.current"));
        }
        catch (MissingResourceException e) {
            I18n.init("en");
            PreferencesData.set("editor.languages.current", "en");
        }
        PreferencesData.set("runtime.os", PConstants.platformNames[PApplet.platform]);
        PreferencesData.fixPreferences();
    }

    private static void fixPreferences() {
        String baud = PreferencesData.get("serial.debug_rate");
        if ("14400".equals(baud) || "28800".equals(baud)) {
            PreferencesData.set("serial.debug_rate", "9600");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void save() {
        if (!doSave) {
            return;
        }
        if (preferencesFile == null) {
            return;
        }
        PrintWriter writer = null;
        try {
            writer = PApplet.createWriter(preferencesFile);
            Object[] keys = prefs.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                if (((String)key).startsWith("runtime.")) continue;
                writer.println((String)key + "=" + (String)prefs.get(key));
            }
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            BaseNoGui.getPlatform().fixPrefsFilePermissions(preferencesFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String get(String attribute) {
        return (String)prefs.get(attribute);
    }

    public static String get(String attribute, String defaultValue) {
        String value = PreferencesData.get(attribute);
        return value == null ? defaultValue : value;
    }

    public static boolean has(String key) {
        return prefs.containsKey(key);
    }

    public static void remove(String key) {
        prefs.remove(key);
    }

    public static String getDefault(String attribute) {
        return (String)defaults.get(attribute);
    }

    public static void set(String attribute, String value) {
        prefs.put(attribute, value);
    }

    public static void unset(String attribute) {
        prefs.remove(attribute);
    }

    public static boolean getBoolean(String attribute) {
        return prefs.getBoolean(attribute);
    }

    public static void setBoolean(String attribute, boolean value) {
        prefs.putBoolean(attribute, value);
    }

    public static int getInteger(String attribute) {
        return Integer.parseInt(PreferencesData.get(attribute));
    }

    public static int getInteger(String attribute, int defaultValue) {
        if (PreferencesData.has(attribute)) {
            return PreferencesData.getInteger(attribute);
        }
        return defaultValue;
    }

    public static void setInteger(String key, int value) {
        PreferencesData.set(key, String.valueOf(value));
    }

    public static PreferencesMap getMap() {
        return new PreferencesMap(prefs);
    }

    public static void removeAllKeysWithPrefix(String prefix) {
        Iterator keys = prefs.keySet().iterator();
        while (keys.hasNext()) {
            if (!((String)keys.next()).startsWith(prefix)) continue;
            keys.remove();
        }
    }

    public static void setDoSave(boolean value) {
        doSave = value;
    }

    public static Font getFont(String attr) {
        Font font = PreferencesHelper.getFont(prefs, attr);
        if (font == null) {
            String value = (String)defaults.get(attr);
            prefs.put(attr, value);
            font = PreferencesHelper.getFont(prefs, attr);
        }
        return font;
    }

    static {
        prefs = new PreferencesMap();
        doSave = true;
    }
}

