/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers.serial;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.discoverers.SerialDiscovery;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import processing.app.BaseNoGui;
import processing.app.Platform;
import processing.app.Serial;
import processing.app.debug.TargetBoard;
import processing.app.helpers.PreferencesMap;

public class SerialBoardsLister
extends TimerTask {
    private static final int MAX_TIME_AWAITING_FOR_PACKAGES = 5000;
    private final SerialDiscovery serialDiscovery;

    public SerialBoardsLister(SerialDiscovery serialDiscovery) {
        this.serialDiscovery = serialDiscovery;
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 0L, 3000L);
    }

    @Override
    public void run() {
        int sleptFor = 0;
        while (BaseNoGui.packages == null && sleptFor <= 5000) {
            try {
                Thread.sleep(1000L);
                sleptFor += 1000;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Platform platform = BaseNoGui.getPlatform();
        if (platform == null) {
            return;
        }
        LinkedList<BoardPort> boardPorts = new LinkedList<BoardPort>();
        List<String> ports = Serial.list();
        String devicesListOutput = null;
        if (!ports.isEmpty()) {
            devicesListOutput = platform.preListAllCandidateDevices();
        }
        for (String port : ports) {
            Map<String, Object> boardData = platform.resolveDeviceAttachedTo(port, BaseNoGui.packages, devicesListOutput);
            BoardPort boardPort = new BoardPort();
            boardPort.setAddress(port);
            boardPort.setProtocol("serial");
            String label = port;
            PreferencesMap prefs = new PreferencesMap();
            if (boardData != null) {
                prefs.put("vid", boardData.get("vid").toString());
                prefs.put("pid", boardData.get("pid").toString());
                TargetBoard board = (TargetBoard)boardData.get("board");
                if (board != null) {
                    String boardName = board.getName();
                    if (boardName != null) {
                        label = label + " (" + boardName + ")";
                    }
                    boardPort.setBoardName(boardName);
                }
            }
            boardPort.setLabel(label);
            boardPort.setPrefs(prefs);
            boardPorts.add(boardPort);
        }
        this.serialDiscovery.setSerialBoardPorts(boardPorts);
    }
}

