/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.uploaders;

import cc.arduino.packages.Uploader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Serial;
import processing.app.SerialException;
import processing.app.debug.RunnerException;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.StringReplacer;

public class SerialUploader
extends Uploader {
    public SerialUploader() {
    }

    public SerialUploader(boolean noUploadPort) {
        super(noUploadPort);
    }

    @Override
    public boolean uploadUsingPreferences(File sourcePath, String buildPath, String className, boolean usingProgrammer, List<String> warningsAccumulator) throws Exception {
        boolean uploadResult;
        boolean waitForUploadPort;
        String tool;
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        PreferencesMap prefs = PreferencesData.getMap();
        PreferencesMap boardPreferences = BaseNoGui.getBoardPreferences();
        if (boardPreferences != null) {
            prefs.putAll(boardPreferences);
        }
        if ((tool = prefs.getOrExcept("upload.tool")).contains(":")) {
            String[] split = tool.split(":", 2);
            targetPlatform = BaseNoGui.getCurrentTargetPlatformFromPackage(split[0]);
            tool = split[1];
        }
        prefs.putAll(targetPlatform.getTool(tool));
        if (usingProgrammer || prefs.get("upload.protocol") == null) {
            return this.uploadUsingProgrammer(buildPath, className);
        }
        if (this.noUploadPort) {
            boolean uploadResult2;
            prefs.put("build.path", buildPath);
            prefs.put("build.project_name", className);
            if (this.verbose) {
                prefs.put("upload.verbose", prefs.getOrExcept("upload.params.verbose"));
            } else {
                prefs.put("upload.verbose", prefs.getOrExcept("upload.params.quiet"));
            }
            try {
                String pattern = prefs.getOrExcept("upload.pattern");
                String[] cmd = StringReplacer.formatAndSplit(pattern, prefs, true);
                uploadResult2 = this.executeUploadCommand(cmd);
            }
            catch (Exception e) {
                throw new RunnerException(e);
            }
            return uploadResult2;
        }
        String t = (String)prefs.get("upload.use_1200bps_touch");
        boolean doTouch = t != null && t.equals("true");
        t = (String)prefs.get("upload.wait_for_upload_port");
        boolean bl = waitForUploadPort = t != null && t.equals("true");
        if (doTouch) {
            String uploadPort = prefs.getOrExcept("serial.port");
            try {
                List<String> before = Serial.list();
                if (before.contains(uploadPort)) {
                    if (this.verbose) {
                        System.out.println(I18n.format(I18n._("Forcing reset using 1200bps open/close on port {0}"), uploadPort));
                    }
                    Serial.touchForCDCReset(uploadPort);
                }
                Thread.sleep(400L);
                if (waitForUploadPort) {
                    uploadPort = this.waitForUploadPort(uploadPort, before);
                }
            }
            catch (SerialException e) {
                throw new RunnerException(e);
            }
            catch (InterruptedException e) {
                throw new RunnerException(e.getMessage());
            }
            prefs.put("serial.port", uploadPort);
            if (uploadPort.startsWith("/dev/")) {
                prefs.put("serial.port.file", uploadPort.substring(5));
            } else {
                prefs.put("serial.port.file", uploadPort);
            }
        }
        prefs.put("build.path", buildPath);
        prefs.put("build.project_name", className);
        if (this.verbose) {
            prefs.put("upload.verbose", prefs.getOrExcept("upload.params.verbose"));
        } else {
            prefs.put("upload.verbose", prefs.getOrExcept("upload.params.quiet"));
        }
        try {
            String pattern = prefs.getOrExcept("upload.pattern");
            String[] cmd = StringReplacer.formatAndSplit(pattern, prefs, true);
            uploadResult = this.executeUploadCommand(cmd);
        }
        catch (RunnerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        try {
            if (uploadResult && doTouch) {
                String uploadPort = PreferencesData.get("serial.port");
                if (waitForUploadPort) {
                    List<String> portList;
                    Thread.sleep(1000L);
                    long started = System.currentTimeMillis();
                    while (System.currentTimeMillis() - started < 2000L && !(portList = Serial.list()).contains(uploadPort)) {
                        Thread.sleep(250L);
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return uploadResult;
    }

    private String waitForUploadPort(String uploadPort, List<String> before) throws InterruptedException, RunnerException {
        int elapsed = 0;
        while (elapsed < 10000) {
            List<String> now = Serial.list();
            ArrayList<String> diff = new ArrayList<String>(now);
            diff.removeAll(before);
            if (this.verbose) {
                System.out.print("PORTS {");
                for (String p : before) {
                    System.out.print(p + ", ");
                }
                System.out.print("} / {");
                for (String p : now) {
                    System.out.print(p + ", ");
                }
                System.out.print("} => {");
                for (String p : diff) {
                    System.out.print(p + ", ");
                }
                System.out.println("}");
            }
            if (diff.size() > 0) {
                String newPort = (String)diff.get(0);
                if (this.verbose) {
                    System.out.println("Found upload port: " + newPort);
                }
                return newPort;
            }
            before = now;
            Thread.sleep(250L);
            if ((OSUtils.isWindows() || (elapsed += 250) < 500) && elapsed < 5000 || !now.contains(uploadPort)) continue;
            if (this.verbose) {
                System.out.println("Uploading using selected port: " + uploadPort);
            }
            return uploadPort;
        }
        throw new RunnerException(I18n._("Couldn't find a Board on the selected port. Check that you have the correct port selected.  If it is correct, try pressing the board's reset button after initiating the upload."));
    }

    public boolean uploadUsingProgrammer(String buildPath, String className) throws Exception {
        PreferencesMap programmerPrefs;
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        String programmer = PreferencesData.get("programmer");
        if (programmer.contains(":")) {
            String[] split = programmer.split(":", 2);
            targetPlatform = BaseNoGui.getCurrentTargetPlatformFromPackage(split[0]);
            programmer = split[1];
        }
        PreferencesMap prefs = PreferencesData.getMap();
        PreferencesMap boardPreferences = BaseNoGui.getBoardPreferences();
        if (boardPreferences != null) {
            prefs.putAll(boardPreferences);
        }
        if ((programmerPrefs = targetPlatform.getProgrammer(programmer)) == null) {
            throw new RunnerException(I18n._("Please select a programmer from Tools->Programmer menu"));
        }
        prefs.putAll(targetPlatform.getTool(programmerPrefs.getOrExcept("program.tool")));
        prefs.putAll(programmerPrefs);
        prefs.put("build.path", buildPath);
        prefs.put("build.project_name", className);
        if (this.verbose) {
            prefs.put("program.verbose", prefs.getOrExcept("program.params.verbose"));
        } else {
            prefs.put("program.verbose", prefs.getOrExcept("program.params.quiet"));
        }
        try {
            String pattern = prefs.getOrExcept("program.pattern");
            String[] cmd = StringReplacer.formatAndSplit(pattern, prefs, true);
            return this.executeUploadCommand(cmd);
        }
        catch (RunnerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
    }

    @Override
    public boolean burnBootloader() throws Exception {
        PreferencesMap programmerPrefs;
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        String programmer = PreferencesData.get("programmer");
        if (programmer.contains(":")) {
            String[] split = programmer.split(":", 2);
            TargetPlatform platform = BaseNoGui.getCurrentTargetPlatformFromPackage(split[0]);
            programmer = split[1];
            programmerPrefs = platform.getProgrammer(programmer);
        } else {
            programmerPrefs = targetPlatform.getProgrammer(programmer);
        }
        if (programmerPrefs == null) {
            throw new RunnerException(I18n._("Please select a programmer from Tools->Programmer menu"));
        }
        PreferencesMap prefs = PreferencesData.getMap();
        PreferencesMap boardPreferences = BaseNoGui.getBoardPreferences();
        if (boardPreferences != null) {
            prefs.putAll(boardPreferences);
        }
        prefs.putAll(programmerPrefs);
        PreferencesMap toolPrefs = new PreferencesMap();
        String tool = prefs.getOrExcept("bootloader.tool");
        if (tool.contains(":")) {
            String[] split = tool.split(":", 2);
            TargetPlatform platform = BaseNoGui.getCurrentTargetPlatformFromPackage(split[0]);
            tool = split[1];
            toolPrefs.putAll(platform.getTool(tool));
            if (toolPrefs.size() == 0) {
                throw new RunnerException(I18n.format(I18n._("Could not find tool {0} from package {1}"), tool, split[0]));
            }
        }
        toolPrefs.putAll(targetPlatform.getTool(tool));
        if (toolPrefs.size() == 0) {
            throw new RunnerException(I18n.format(I18n._("Could not find tool {0}"), tool));
        }
        prefs.putAll(toolPrefs);
        if (this.verbose) {
            prefs.put("erase.verbose", prefs.getOrExcept("erase.params.verbose"));
            prefs.put("bootloader.verbose", prefs.getOrExcept("bootloader.params.verbose"));
        } else {
            prefs.put("erase.verbose", prefs.getOrExcept("erase.params.quiet"));
            prefs.put("bootloader.verbose", prefs.getOrExcept("bootloader.params.quiet"));
        }
        String pattern = prefs.getOrExcept("erase.pattern");
        String[] cmd = StringReplacer.formatAndSplit(pattern, prefs, true);
        if (!this.executeUploadCommand(cmd)) {
            return false;
        }
        pattern = prefs.getOrExcept("bootloader.pattern");
        cmd = StringReplacer.formatAndSplit(pattern, prefs, true);
        return this.executeUploadCommand(cmd);
    }
}

