/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.view;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.util.Map;

public class SplashScreenHelper {
    private final Map desktopHints;
    private final SplashScreen splash;
    private Rectangle2D.Double splashTextArea;
    private Graphics2D splashGraphics;

    public SplashScreenHelper(SplashScreen splash) {
        this.splash = splash;
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.desktopHints = (Map)tk.getDesktopProperty("awt.font.desktophints");
    }

    public void splashText(String str) {
        if (this.splash == null) {
            this.printText(str);
            return;
        }
        if (!this.splash.isVisible()) {
            return;
        }
        if (this.splashTextArea == null) {
            this.splashTextArea = new Rectangle2D.Double(0.0, 300.0, 520.0, 30.0);
            this.splashGraphics = this.splash.createGraphics();
            if (this.desktopHints != null) {
                this.splashGraphics.addRenderingHints(this.desktopHints);
            }
        }
        this.splashGraphics.setPaint(new Color(245, 245, 245));
        this.splashGraphics.fill(this.splashTextArea);
        this.splashGraphics.setPaint(Color.BLACK);
        FontMetrics metrics = this.splashGraphics.getFontMetrics();
        this.splashGraphics.drawString(str, (int)this.splashTextArea.getX() + 10, (int)this.splashTextArea.getY() + (30 - metrics.getHeight()) + 4);
        this.splash.update();
    }

    public void close() {
        if (this.splash == null) {
            return;
        }
        this.splash.close();
    }

    public void printText(String str) {
        System.out.println(str);
    }
}

