/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.panel.JreLocator;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class JreTableModel
extends AbstractTableModel {
    private ArrayList _jres;
    private ArrayList _validPaths;
    private String[] _columnNames;
    private boolean _system;
    private HashSet _hidden;
    private boolean dirty = false;

    public JreTableModel(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ResourceManager.getMessage("controlpanel.jre.platformTableColumnTitle"));
        arrayList.add(ResourceManager.getMessage("controlpanel.jre.productTableColumnTitle"));
        arrayList.add(ResourceManager.getMessage("controlpanel.jre.locationTableColumnTitle"));
        arrayList.add(ResourceManager.getMessage("controlpanel.jre.pathTableColumnTitle"));
        arrayList.add(ResourceManager.getMessage("controlpanel.jre.vmargsTableColumnTitle"));
        if (Platform.get().canUseAlternateJREs()) {
            arrayList.add(ResourceManager.getMessage("controlpanel.jre.enabledTableColumnTitle"));
        }
        this._jres = new ArrayList();
        this._validPaths = new ArrayList();
        this._columnNames = arrayList.toArray(new String[arrayList.size()]);
        this._system = bl;
        this._hidden = new HashSet();
        this.refresh();
        if (!bl) {
            this.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    JreTableModel.this.dirty = true;
                }
            });
        }
    }

    private void refresh() {
        Config.get().refreshIfNeeded();
        JREInfo[] jREInfoArray = JREInfo.getAll();
        this._jres.clear();
        this._validPaths.clear();
        this._hidden.clear();
        Trace.println("refresh for " + (this._system ? "system" : "user") + " JREs", TraceLevel.BASIC);
        for (int i = 0; i < jREInfoArray.length; ++i) {
            JREInfo jREInfo = jREInfoArray[i];
            if (jREInfo.isSystemJRE() != this._system) continue;
            if (jREInfo.getOSName() == null || jREInfo.getOSArch() == null || jREInfo.isOsInfoMatch()) {
                if (jREInfo.getPath() != null && JREInfo.isValidJREPath(jREInfo.getPath())) {
                    this.add(new JREInfo(jREInfo), true, false);
                    continue;
                }
                this._hidden.add(new JREInfo(jREInfo));
                continue;
            }
            this._hidden.add(new JREInfo(jREInfo));
        }
        this.fireTableDataChanged();
    }

    HashSet getHiddenJREs() {
        return this._hidden;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.getJRE(n).getPlatform();
            }
            case 1: {
                return this.getJRE(n).getProduct();
            }
            case 2: {
                return this.getJRE(n).getLocation();
            }
            case 3: {
                return this.getJRE(n).getPath();
            }
            case 4: {
                return this.getJRE(n).getVmArgs();
            }
        }
        return this.getJRE(n).isEnabled();
    }

    public boolean isCellEditable(int n, int n2) {
        JREInfo jREInfo = this.getJRE(n);
        if (jREInfo.isSystemJRE()) {
            return false;
        }
        if (n2 == 5 && this.getRowCount() == 1) {
            return !jREInfo.isEnabled();
        }
        return true;
    }

    public Class getColumnClass(int n) {
        if (n < 5) {
            return String.class;
        }
        return Boolean.class;
    }

    void add(JREInfo jREInfo, boolean bl, boolean bl2) {
        if (jREInfo.isSystemJRE() == this._system) {
            if (Trace.isEnabled(TraceLevel.TEMP)) {
                Trace.println("Table model adding jre: " + jREInfo, TraceLevel.TEMP);
            }
            this._jres.add(jREInfo);
            if (bl) {
                this._validPaths.add(Boolean.TRUE);
            } else {
                this._validPaths.add(null);
            }
            if (bl2) {
                this.fireTableRowsInserted(this._jres.size() - 1, this._jres.size() - 1);
            }
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n >= this._jres.size()) {
            return;
        }
        JREInfo jREInfo = this.getJRE(n);
        switch (n2) {
            case 0: {
                String string = (String)object;
                if (string == null || string.equals("")) break;
                this._jres.set(n, new JREInfo((String)object, jREInfo.getProduct(), jREInfo.getLocation(), jREInfo.getPath(), jREInfo.getVmArgs(), jREInfo.getOSName(), jREInfo.getOSArch(), jREInfo.isEnabled(), jREInfo.isRegistered()));
                break;
            }
            case 1: {
                this._jres.set(n, new JREInfo(jREInfo.getPlatform(), (String)object, jREInfo.getLocation(), jREInfo.getPath(), jREInfo.getVmArgs(), jREInfo.getOSName(), jREInfo.getOSArch(), jREInfo.isEnabled(), jREInfo.isRegistered()));
                break;
            }
            case 2: {
                this._jres.set(n, new JREInfo(jREInfo.getPlatform(), jREInfo.getProduct(), (String)object, jREInfo.getPath(), jREInfo.getVmArgs(), jREInfo.getOSName(), jREInfo.getOSArch(), jREInfo.isEnabled(), jREInfo.isRegistered()));
                break;
            }
            case 3: {
                this._jres.set(n, new JREInfo(jREInfo.getPlatform(), jREInfo.getProduct(), jREInfo.getLocation(), (String)object, jREInfo.getVmArgs(), jREInfo.getOSName(), jREInfo.getOSArch(), jREInfo.isEnabled(), jREInfo.isRegistered()));
                this._validPaths.set(n, null);
                break;
            }
            case 4: {
                this._jres.set(n, new JREInfo(jREInfo.getPlatform(), jREInfo.getProduct(), jREInfo.getLocation(), jREInfo.getPath(), (String)object, jREInfo.getOSName(), jREInfo.getOSArch(), jREInfo.isEnabled(), jREInfo.isRegistered()));
                break;
            }
            default: {
                this._jres.set(n, new JREInfo(jREInfo.getPlatform(), jREInfo.getProduct(), jREInfo.getLocation(), jREInfo.getPath(), jREInfo.getVmArgs(), jREInfo.getOSName(), jREInfo.getOSArch(), (Boolean)object, jREInfo.isRegistered()));
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public int getColumnCount() {
        return this._columnNames.length;
    }

    public int getRowCount() {
        return this._jres.size();
    }

    JREInfo getJRE(int n) {
        return (JREInfo)this._jres.get(n);
    }

    public String getColumnName(int n) {
        return this._columnNames[n];
    }

    void validateAndSave() {
        block7: {
            block6: {
                if (this._system || !this.dirty) break block6;
                if (this.getRowCount() <= 0) break block7;
                JREInfo.clear();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (!this.isPathValid(i)) continue;
                    JREInfo.addJRE(this.validatePlatform(i));
                }
                for (JREInfo jREInfo : this.getHiddenJREs()) {
                    JREInfo.addJRE(jREInfo);
                }
                break block7;
            }
            if (this._system) {
                if (this.getRowCount() > 0) {
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        JREInfo.addJRE(this.getJRE(i));
                    }
                }
                for (JREInfo jREInfo : this.getHiddenJREs()) {
                    JREInfo.addJRE(jREInfo);
                }
            }
        }
    }

    boolean isPathValid(int n) {
        Boolean bl = (Boolean)this._validPaths.get(n);
        if (bl == null) {
            bl = JREInfo.isValidJREPath(this.getJRE(n).getPath()) ? Boolean.TRUE : Boolean.FALSE;
            this._validPaths.set(n, bl);
        }
        return Boolean.TRUE.equals(bl);
    }

    private JREInfo validatePlatform(int n) {
        JREInfo jREInfo = this.getJRE(n);
        if (jREInfo.getPlatform() == null) {
            String string = JREInfo.getPlatformByProduct(jREInfo.getProduct());
            if (string != null) {
                jREInfo.setPlatform(string);
            } else {
                JREInfo jREInfo2 = null;
                try {
                    jREInfo2 = JreLocator.getVersion(new File(jREInfo.getPath()));
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
                if (jREInfo2 != null) {
                    jREInfo.setProduct(jREInfo2.getProduct());
                    jREInfo.setPlatform(jREInfo2.getPlatform());
                }
            }
        }
        return jREInfo;
    }

    void remove(int[] nArray) {
        if (nArray != null) {
            int n = this.getRowCount();
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] == -1 || nArray[i] >= n) continue;
                this._jres.remove(nArray[i]);
                this._validPaths.remove(nArray[i]);
            }
        }
        this.fireTableDataChanged();
    }

    boolean isSystem() {
        return this._system;
    }
}

