/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Uploader;
import cc.arduino.packages.UploaderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.SketchCode;
import processing.app.SketchData;
import processing.app.debug.MessageConsumer;
import processing.app.debug.RunnerException;
import processing.app.debug.Sizer;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.FileUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.PreferencesMapException;
import processing.app.helpers.StringReplacer;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.legacy.PApplet;
import processing.app.packages.LegacyUserLibrary;
import processing.app.packages.LibraryList;
import processing.app.packages.UserLibrary;
import processing.app.preproc.PdePreprocessor;
import processing.app.tools.DoubleQuotedArgumentsOnWindowsCommandLine;

public class Compiler
implements MessageConsumer {
    public static final String BUILD_PREFS_FILE = "buildprefs.txt";
    private SketchData sketch;
    private PreferencesMap prefs;
    private boolean verbose;
    private List<File> objectFiles;
    private boolean sketchIsCompiled;
    private RunnerException exception;
    private ProgressListener progressListener;
    private LibraryList importedLibraries;
    private List<String> importedDuplicateHeaders;
    private List<LibraryList> importedDuplicateLibraries;

    public static String build(SketchData data, String buildPath, File tempBuildFolder, ProgressListener progListener, boolean verbose) throws RunnerException, PreferencesMapException {
        if (SketchData.checkSketchFile(data.getPrimaryFile()) == null) {
            BaseNoGui.showError(I18n._("Bad file selected"), I18n._("Bad sketch primary file or bad sketch directory structure"), null);
        }
        String primaryClassName = data.getName() + ".cpp";
        Compiler compiler = new Compiler(data, buildPath, primaryClassName);
        File buildPrefsFile = new File(buildPath, BUILD_PREFS_FILE);
        String newBuildPrefs = compiler.buildPrefsString();
        boolean prefsChanged = compiler.buildPreferencesChanged(buildPrefsFile, newBuildPrefs);
        compiler.cleanup(prefsChanged, tempBuildFolder);
        if (prefsChanged) {
            try {
                PrintWriter out = new PrintWriter(buildPrefsFile);
                out.print(newBuildPrefs);
                out.close();
            }
            catch (IOException e) {
                System.err.println(I18n._("Could not write build preferences file"));
            }
        }
        compiler.setProgressListener(progListener);
        try {
            if (compiler.compile(verbose)) {
                compiler.size(compiler.getBuildPreferences());
                return primaryClassName;
            }
        }
        catch (RunnerException e) {
            compiler.adviseDuplicateLibraries();
            throw e;
        }
        return null;
    }

    public static Uploader getUploaderByPreferences(boolean noUploadPort) {
        TargetPlatform target = BaseNoGui.getTargetPlatform();
        String board = PreferencesData.get("board");
        if (noUploadPort) {
            return new UploaderFactory().newUploader(target.getBoards().get(board), null, noUploadPort);
        }
        BoardPort boardPort = BaseNoGui.getDiscoveryManager().find(PreferencesData.get("serial.port"));
        return new UploaderFactory().newUploader(target.getBoards().get(board), boardPort, noUploadPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean upload(SketchData data, Uploader uploader, String buildPath, String suggestedClassName, boolean usingProgrammer, boolean noUploadPort, List<String> warningsAccumulator) throws Exception {
        if (uploader == null) {
            uploader = Compiler.getUploaderByPreferences(noUploadPort);
        }
        boolean success = false;
        if (uploader.requiresAuthorization() && !PreferencesData.has(uploader.getAuthorizationKey())) {
            BaseNoGui.showError(I18n._("Authorization required"), I18n._("No athorization data found"), null);
        }
        boolean useNewWarningsAccumulator = false;
        if (warningsAccumulator == null) {
            warningsAccumulator = new LinkedList<String>();
            useNewWarningsAccumulator = true;
        }
        try {
            success = uploader.uploadUsingPreferences(data.getFolder(), buildPath, suggestedClassName, usingProgrammer, warningsAccumulator);
        }
        finally {
            if (uploader.requiresAuthorization() && !success) {
                PreferencesData.remove(uploader.getAuthorizationKey());
            }
        }
        if (useNewWarningsAccumulator) {
            for (String warning : warningsAccumulator) {
                System.out.print(I18n._("Warning"));
                System.out.print(": ");
                System.out.println(warning);
            }
        }
        return success;
    }

    public Compiler(SketchData _sketch, String _buildPath, String _primaryClassName) throws RunnerException {
        this.sketch = _sketch;
        this.prefs = this.createBuildPreferences(_buildPath, _primaryClassName);
        this.prefs.put("build.source.path", _sketch.getFolder().getAbsolutePath());
        this.progressListener = new ProgressListener(){

            @Override
            public void progress(int percent) {
            }
        };
    }

    protected boolean buildPreferencesChanged(File buildPrefsFile, String newBuildPrefs) {
        String previousPrefs;
        if (!buildPrefsFile.exists()) {
            return true;
        }
        try {
            previousPrefs = FileUtils.readFileToString(buildPrefsFile);
        }
        catch (IOException e) {
            System.err.println(I18n._("Could not read prevous build preferences file, rebuilding all"));
            return true;
        }
        if (!previousPrefs.equals(newBuildPrefs)) {
            System.out.println(I18n._("Build options changed, rebuilding all"));
            return true;
        }
        return false;
    }

    protected String buildPrefsString() {
        PreferencesMap buildPrefs = this.getBuildPreferences();
        String res = "";
        TreeSet treeSet = new TreeSet(buildPrefs.keySet());
        for (String k : treeSet) {
            if (!k.startsWith("build.") && !k.startsWith("compiler.") && !k.startsWith("recipes.")) continue;
            res = res + k + " = " + (String)buildPrefs.get(k) + "\n";
        }
        return res;
    }

    protected void setProgressListener(ProgressListener _progressListener) {
        this.progressListener = _progressListener == null ? new ProgressListener(){

            @Override
            public void progress(int percent) {
            }
        } : _progressListener;
    }

    protected void cleanup(boolean force, File tempBuildFolder) {
        System.gc();
        if (force) {
            BaseNoGui.removeDescendants(tempBuildFolder);
        } else if (tempBuildFolder.exists()) {
            String[] files;
            for (String file : files = tempBuildFolder.list()) {
                File deleteMe;
                if (!file.endsWith(".c") && !file.endsWith(".cpp") && !file.endsWith(".s") || (deleteMe = new File(tempBuildFolder, file)).delete()) continue;
                System.err.println("Could not delete " + deleteMe);
            }
        }
    }

    protected void size(PreferencesMap prefs) throws RunnerException {
        long[] sizes;
        String maxTextSizeString = (String)prefs.get("upload.maximum_size");
        String maxDataSizeString = (String)prefs.get("upload.maximum_data_size");
        if (maxTextSizeString == null) {
            return;
        }
        long maxTextSize = Integer.parseInt(maxTextSizeString);
        long maxDataSize = -1L;
        if (maxDataSizeString != null) {
            maxDataSize = Integer.parseInt(maxDataSizeString);
        }
        Sizer sizer = new Sizer(prefs);
        try {
            sizes = sizer.computeSize();
        }
        catch (RunnerException e) {
            System.err.println(I18n.format(I18n._("Couldn't determine program size: {0}"), e.getMessage()));
            return;
        }
        long textSize = sizes[0];
        long dataSize = sizes[1];
        System.out.println();
        System.out.println(I18n.format(I18n._("Sketch uses {0} bytes ({2}%%) of program storage space. Maximum is {1} bytes."), textSize, maxTextSize, textSize * 100L / maxTextSize));
        if (dataSize >= 0L) {
            if (maxDataSize > 0L) {
                System.out.println(I18n.format(I18n._("Global variables use {0} bytes ({2}%%) of dynamic memory, leaving {3} bytes for local variables. Maximum is {1} bytes."), dataSize, maxDataSize, dataSize * 100L / maxDataSize, maxDataSize - dataSize));
            } else {
                System.out.println(I18n.format(I18n._("Global variables use {0} bytes of dynamic memory."), dataSize));
            }
        }
        if (textSize > maxTextSize) {
            throw new RunnerException(I18n._("Sketch too big; see http://www.arduino.cc/en/Guide/Troubleshooting#size for tips on reducing it."));
        }
        if (maxDataSize > 0L && dataSize > maxDataSize) {
            throw new RunnerException(I18n._("Not enough memory; see http://www.arduino.cc/en/Guide/Troubleshooting#size for tips on reducing your footprint."));
        }
        int warnDataPercentage = Integer.parseInt((String)prefs.get("build.warn_data_percentage"));
        if (maxDataSize > 0L && dataSize > maxDataSize * (long)warnDataPercentage / 100L) {
            System.err.println(I18n._("Low memory available, stability problems may occur."));
        }
    }

    public boolean compile(boolean _verbose) throws RunnerException, PreferencesMapException {
        this.preprocess((String)this.prefs.get("build.path"));
        this.verbose = _verbose || PreferencesData.getBoolean("build.verbose");
        this.sketchIsCompiled = false;
        this.runActions("hooks.prebuild", this.prefs);
        this.objectFiles = new ArrayList<File>();
        this.progressListener.progress(20);
        ArrayList<File> includeFolders = new ArrayList<File>();
        includeFolders.add(this.prefs.getFile("build.core.path"));
        if (this.prefs.getFile("build.variant.path") != null) {
            includeFolders.add(this.prefs.getFile("build.variant.path"));
        }
        for (UserLibrary lib : this.importedLibraries) {
            if (this.verbose) {
                String legacy = "";
                if (lib instanceof LegacyUserLibrary) {
                    legacy = "(legacy)";
                }
                System.out.println(I18n.format(I18n._("Using library {0} in folder: {1} {2}"), lib.getName(), lib.getInstalledFolder(), legacy));
            }
            includeFolders.add(lib.getSrcFolder());
        }
        if (this.verbose) {
            System.out.println();
        }
        ArrayList<String> archs = new ArrayList<String>();
        archs.add(BaseNoGui.getTargetPlatform().getId());
        if (this.prefs.containsKey("architecture.override_check")) {
            String[] overrides = ((String)this.prefs.get("architecture.override_check")).split(",");
            archs.addAll(Arrays.asList(overrides));
        }
        for (UserLibrary lib : this.importedLibraries) {
            if (lib.supportsArchitecture(archs)) continue;
            System.err.println(I18n.format(I18n._("WARNING: library {0} claims to run on {1} architecture(s) and may be incompatible with your current board which runs on {2} architecture(s)."), lib.getName(), lib.getArchitectures(), archs));
            System.err.println();
        }
        this.progressListener.progress(30);
        this.compileSketch(includeFolders);
        this.sketchIsCompiled = true;
        this.progressListener.progress(40);
        this.compileLibraries(includeFolders);
        this.progressListener.progress(50);
        this.compileCore();
        this.progressListener.progress(60);
        this.compileLink();
        this.progressListener.progress(75);
        ArrayList<String> objcopyPatterns = new ArrayList<String>();
        for (String key : this.prefs.keySet()) {
            if (!key.startsWith("recipe.objcopy.") || !key.endsWith(".pattern")) continue;
            objcopyPatterns.add(key);
        }
        Collections.sort(objcopyPatterns);
        for (String recipe : objcopyPatterns) {
            this.runRecipe(recipe);
        }
        this.progressListener.progress(90);
        this.runActions("hooks.postbuild", this.prefs);
        this.adviseDuplicateLibraries();
        return true;
    }

    private void adviseDuplicateLibraries() {
        for (int i = 0; i < this.importedDuplicateHeaders.size(); ++i) {
            System.out.println(I18n.format(I18n._("Multiple libraries were found for \"{0}\""), this.importedDuplicateHeaders.get(i)));
            boolean first = true;
            for (UserLibrary lib : this.importedDuplicateLibraries.get(i)) {
                if (first) {
                    System.out.println(I18n.format(I18n._(" Used: {0}"), lib.getInstalledFolder().getPath()));
                    first = false;
                    continue;
                }
                System.out.println(I18n.format(I18n._(" Not used: {0}"), lib.getInstalledFolder().getPath()));
            }
        }
    }

    private PreferencesMap createBuildPreferences(String _buildPath, String _primaryClassName) throws RunnerException {
        TargetPlatform tp;
        if (BaseNoGui.getBoardPreferences() == null) {
            RunnerException re = new RunnerException(I18n._("No board selected; please choose a board from the Tools > Board menu."));
            re.hideStackTrace();
            throw re;
        }
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        TargetPlatform corePlatform = null;
        PreferencesMap boardPreferences = BaseNoGui.getBoardPreferences();
        String core = boardPreferences.get("build.core", "arduino");
        if (core.contains(":")) {
            String[] split = core.split(":");
            core = split[1];
            corePlatform = BaseNoGui.getTargetPlatform(split[0], targetPlatform.getId());
            if (corePlatform == null) {
                RunnerException re = new RunnerException(I18n.format(I18n._("Selected board depends on '{0}' core (not installed)."), split[0]));
                re.hideStackTrace();
                throw re;
            }
        }
        PreferencesMap p = new PreferencesMap();
        p.putAll(PreferencesData.getMap());
        if (corePlatform != null) {
            p.putAll(corePlatform.getPreferences());
        }
        p.putAll(targetPlatform.getPreferences());
        p.putAll(BaseNoGui.getBoardPreferences());
        for (String k : p.keySet()) {
            if (p.get(k) != null) continue;
            p.put(k, "");
        }
        p.put("build.path", _buildPath);
        p.put("build.project_name", _primaryClassName);
        p.put("build.arch", targetPlatform.getId().toUpperCase());
        if (!p.containsKey("compiler.path")) {
            System.err.println(I18n._("Third-party platform.txt does not define compiler.path. Please report this to the third-party hardware maintainer."));
            p.put("compiler.path", BaseNoGui.getAvrBasePath());
        }
        if ((tp = corePlatform) == null) {
            tp = targetPlatform;
        }
        File coreFolder = new File(tp.getFolder(), "cores");
        coreFolder = new File(coreFolder, core);
        p.put("build.core", core);
        p.put("build.core.path", coreFolder.getAbsolutePath());
        File systemFolder = tp.getFolder();
        systemFolder = new File(systemFolder, "system");
        p.put("build.system.path", systemFolder.getAbsolutePath());
        String variant = (String)p.get("build.variant");
        if (variant != null) {
            TargetPlatform t;
            if (!variant.contains(":")) {
                t = targetPlatform;
            } else {
                String[] split = variant.split(":", 2);
                t = BaseNoGui.getTargetPlatform(split[0], targetPlatform.getId());
                variant = split[1];
            }
            File variantFolder = new File(t.getFolder(), "variants");
            variantFolder = new File(variantFolder, variant);
            p.put("build.variant.path", variantFolder.getAbsolutePath());
        } else {
            p.put("build.variant.path", "");
        }
        return p;
    }

    private List<File> compileFiles(File outputPath, File sourcePath, boolean recurse, List<File> includeFolders) throws RunnerException, PreferencesMapException {
        String[] cmd;
        File dependFile;
        File objectFile;
        List<File> sSources = Compiler.findFilesInFolder(sourcePath, "S", recurse);
        List<File> cSources = Compiler.findFilesInFolder(sourcePath, "c", recurse);
        List<File> cppSources = Compiler.findFilesInFolder(sourcePath, "cpp", recurse);
        ArrayList<File> objectPaths = new ArrayList<File>();
        for (File file : sSources) {
            objectFile = new File(outputPath, file.getName() + ".o");
            objectPaths.add(objectFile);
            String[] cmd2 = this.getCommandCompilerByRecipe(includeFolders, file, objectFile, "recipe.S.o.pattern");
            this.execAsynchronously(cmd2);
        }
        for (File file : cSources) {
            objectFile = new File(outputPath, file.getName() + ".o");
            dependFile = new File(outputPath, file.getName() + ".d");
            objectPaths.add(objectFile);
            if (this.isAlreadyCompiled(file, objectFile, dependFile, this.prefs)) continue;
            cmd = this.getCommandCompilerByRecipe(includeFolders, file, objectFile, "recipe.c.o.pattern");
            this.execAsynchronously(cmd);
        }
        for (File file : cppSources) {
            objectFile = new File(outputPath, file.getName() + ".o");
            dependFile = new File(outputPath, file.getName() + ".d");
            objectPaths.add(objectFile);
            if (this.isAlreadyCompiled(file, objectFile, dependFile, this.prefs)) continue;
            cmd = this.getCommandCompilerByRecipe(includeFolders, file, objectFile, "recipe.cpp.o.pattern");
            this.execAsynchronously(cmd);
        }
        return objectPaths;
    }

    protected static String unescapeDepFile(String line) {
        line = line.replaceAll("\\\\([ #\\\\])", "$1");
        line = line.replace("$$", "$");
        return line;
    }

    private boolean isAlreadyCompiled(File src, File obj, File dep, Map<String, String> prefs) {
        boolean ret = true;
        try {
            String line;
            long obj_modified;
            if (!obj.exists()) {
                return false;
            }
            if (!dep.exists()) {
                return false;
            }
            long src_modified = src.lastModified();
            if (src_modified >= (obj_modified = obj.lastModified())) {
                return false;
            }
            if (src_modified >= dep.lastModified()) {
                return false;
            }
            BufferedReader reader = new BufferedReader(new FileReader(dep.getPath()));
            boolean need_obj_parse = true;
            while ((line = reader.readLine()) != null) {
                if (line.endsWith("\\")) {
                    line = line.substring(0, line.length() - 1);
                }
                line = line.trim();
                if ((line = Compiler.unescapeDepFile(line)).length() == 0) continue;
                if (need_obj_parse) {
                    if (line.endsWith(":")) {
                        File linefile;
                        String linepath;
                        line = line.substring(0, line.length() - 1);
                        String objpath = obj.getCanonicalPath();
                        if (objpath.compareTo(linepath = (linefile = new File(line)).getCanonicalPath()) == 0) {
                            need_obj_parse = false;
                            continue;
                        }
                        ret = false;
                        break;
                    }
                    ret = false;
                    break;
                }
                File prereq = new File(line);
                if (!prereq.exists()) {
                    ret = false;
                    break;
                }
                if (prereq.lastModified() < obj_modified) continue;
                ret = false;
                break;
            }
            reader.close();
        }
        catch (Exception e) {
            return false;
        }
        if (ret && this.verbose) {
            System.out.println(I18n.format(I18n._("Using previously compiled file: {0}"), obj.getPath()));
        }
        return ret;
    }

    private void execAsynchronously(String[] command) throws RunnerException {
        int result;
        ArrayList<String> stringList = new ArrayList<String>();
        for (String string : command) {
            if ((string = string.trim()).length() == 0) continue;
            stringList.add(string);
        }
        command = stringList.toArray(new String[stringList.size()]);
        if (command.length == 0) {
            return;
        }
        if (this.verbose) {
            for (String c : command) {
                System.out.print(c + " ");
            }
            System.out.println();
        }
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler(new ExecuteStreamHandler(){

            public void setProcessInputStream(OutputStream os) throws IOException {
            }

            public void setProcessErrorStream(InputStream is) throws IOException {
                this.forwardToMessage(is);
            }

            public void setProcessOutputStream(InputStream is) throws IOException {
                this.forwardToMessage(is);
            }

            private void forwardToMessage(InputStream is) throws IOException {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                while ((line = reader.readLine()) != null) {
                    Compiler.this.message(line + "\n");
                }
            }

            public void start() throws IOException {
            }

            public void stop() {
            }
        });
        DoubleQuotedArgumentsOnWindowsCommandLine commandLine = new DoubleQuotedArgumentsOnWindowsCommandLine(command[0]);
        for (int i = 1; i < command.length; ++i) {
            commandLine.addArgument(command[i], false);
        }
        executor.setExitValues(null);
        try {
            result = executor.execute((CommandLine)commandLine);
        }
        catch (IOException e) {
            RunnerException re = new RunnerException(e.getMessage());
            re.hideStackTrace();
            throw re;
        }
        executor.setExitValues(new int[0]);
        if (this.exception != null) {
            throw this.exception;
        }
        if (result > 1) {
            System.err.println(I18n.format(I18n._("{0} returned {1}"), command[0], result));
        }
        if (result != 0) {
            RunnerException re = new RunnerException(I18n._("Error compiling."));
            re.hideStackTrace();
            throw re;
        }
    }

    @Override
    public void message(String s) {
        String error;
        String errorFormat;
        String[] pieces;
        if (!this.verbose) {
            int i;
            String buildPath = (String)this.prefs.get("build.path");
            while ((i = s.indexOf(buildPath + File.separator)) != -1) {
                s = s.substring(0, i) + s.substring(i + (buildPath + File.separator).length());
            }
        }
        if ((pieces = PApplet.match(s, errorFormat = "(.+\\.\\w+):(\\d+)(:\\d+)*:\\s*error:\\s*(.*)\\s*")) != null) {
            error = pieces[pieces.length - 1];
            String msg = "";
            if (error.trim().equals("SPI.h: No such file or directory")) {
                error = I18n._("Please import the SPI library from the Sketch > Import Library menu.");
                msg = I18n._("\nAs of Arduino 0019, the Ethernet library depends on the SPI library.\nYou appear to be using it or another library that depends on the SPI library.\n\n");
            }
            if (error.trim().equals("'BYTE' was not declared in this scope")) {
                error = I18n._("The 'BYTE' keyword is no longer supported.");
                msg = I18n._("\nAs of Arduino 1.0, the 'BYTE' keyword is no longer supported.\nPlease use Serial.write() instead.\n\n");
            }
            if (error.trim().equals("no matching function for call to 'Server::Server(int)'")) {
                error = I18n._("The Server class has been renamed EthernetServer.");
                msg = I18n._("\nAs of Arduino 1.0, the Server class in the Ethernet library has been renamed to EthernetServer.\n\n");
            }
            if (error.trim().equals("no matching function for call to 'Client::Client(byte [4], int)'")) {
                error = I18n._("The Client class has been renamed EthernetClient.");
                msg = I18n._("\nAs of Arduino 1.0, the Client class in the Ethernet library has been renamed to EthernetClient.\n\n");
            }
            if (error.trim().equals("'Udp' was not declared in this scope")) {
                error = I18n._("The Udp class has been renamed EthernetUdp.");
                msg = I18n._("\nAs of Arduino 1.0, the Udp class in the Ethernet library has been renamed to EthernetUdp.\n\n");
            }
            if (error.trim().equals("'class TwoWire' has no member named 'send'")) {
                error = I18n._("Wire.send() has been renamed Wire.write().");
                msg = I18n._("\nAs of Arduino 1.0, the Wire.send() function was renamed to Wire.write() for consistency with other libraries.\n\n");
            }
            if (error.trim().equals("'class TwoWire' has no member named 'receive'")) {
                error = I18n._("Wire.receive() has been renamed Wire.read().");
                msg = I18n._("\nAs of Arduino 1.0, the Wire.receive() function was renamed to Wire.read() for consistency with other libraries.\n\n");
            }
            if (error.trim().equals("'Mouse' was not declared in this scope")) {
                error = I18n._("'Mouse' only supported on the Arduino Leonardo");
            }
            if (error.trim().equals("'Keyboard' was not declared in this scope")) {
                error = I18n._("'Keyboard' only supported on the Arduino Leonardo");
            }
            RunnerException e = null;
            if (!this.sketchIsCompiled) {
                e = this.placeException(error, pieces[1], PApplet.parseInt(pieces[2]) - 1);
            }
            if (e != null && !this.verbose) {
                SketchCode code = this.sketch.getCode(e.getCodeIndex());
                String fileName = code.isExtension("ino") || code.isExtension("pde") ? code.getPrettyName() : code.getFileName();
                int lineNum = e.getCodeLine() + 1;
                s = fileName + ":" + lineNum + ": error: " + error + msg;
            }
            if (e != null && (this.exception == null || this.exception.getMessage().equals(e.getMessage()))) {
                this.exception = e;
                this.exception.hideStackTrace();
            }
        }
        if (s.contains("undefined reference to `SPIClass::begin()'") && s.contains("libraries/Robot_Control")) {
            error = I18n._("Please import the SPI library from the Sketch > Import Library menu.");
            this.exception = new RunnerException(error);
        }
        if (s.contains("undefined reference to `Wire'") && s.contains("libraries/Robot_Control")) {
            error = I18n._("Please import the Wire library from the Sketch > Import Library menu.");
            this.exception = new RunnerException(error);
        }
        System.err.print(s);
    }

    private String[] getCommandCompilerByRecipe(List<File> includeFolders, File sourceFile, File objectFile, String recipe) throws PreferencesMapException, RunnerException {
        String includes = Compiler.prepareIncludes(includeFolders);
        PreferencesMap dict = new PreferencesMap(this.prefs);
        dict.put("ide_version", "10604");
        dict.put("includes", includes);
        dict.put("source_file", sourceFile.getAbsolutePath());
        dict.put("object_file", objectFile.getAbsolutePath());
        this.setupWarningFlags(dict);
        String cmd = this.prefs.getOrExcept(recipe);
        try {
            return StringReplacer.formatAndSplit(cmd, dict, true);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
    }

    private void setupWarningFlags(PreferencesMap dict) {
        if (dict.containsKey("compiler.warning_level")) {
            String key = "compiler.warning_flags." + (String)dict.get("compiler.warning_level");
            dict.put("compiler.warning_flags", dict.get(key));
        } else {
            dict.put("compiler.warning_flags", dict.get("compiler.warning_flags.none"));
        }
        if (dict.get("compiler.warning_flags") == null) {
            dict.remove("compiler.warning_flags");
        }
    }

    private void createFolder(File folder) throws RunnerException {
        if (folder.isDirectory()) {
            return;
        }
        if (!folder.mkdir()) {
            throw new RunnerException("Couldn't create: " + folder);
        }
    }

    public static List<File> findFilesInFolder(File folder, String extension, boolean recurse) {
        ArrayList<File> files = new ArrayList<File>();
        if (FileUtils.isSCCSOrHiddenFile(folder)) {
            return files;
        }
        File[] listFiles = folder.listFiles();
        if (listFiles == null) {
            return files;
        }
        for (File file : listFiles) {
            if (FileUtils.isSCCSOrHiddenFile(file)) continue;
            if (file.getName().endsWith("." + extension)) {
                files.add(file);
            }
            if (!recurse || !file.isDirectory()) continue;
            files.addAll(Compiler.findFilesInFolder(file, extension, true));
        }
        return files;
    }

    void compileSketch(List<File> includeFolders) throws RunnerException, PreferencesMapException {
        File buildPath = this.prefs.getFile("build.path");
        this.objectFiles.addAll(this.compileFiles(buildPath, buildPath, false, includeFolders));
    }

    void compileLibraries(List<File> includeFolders) throws RunnerException, PreferencesMapException {
        for (UserLibrary lib : this.importedLibraries) {
            this.compileLibrary(lib, includeFolders);
        }
    }

    private void compileLibrary(UserLibrary lib, List<File> includeFolders) throws RunnerException, PreferencesMapException {
        File libFolder = lib.getSrcFolder();
        File libBuildFolder = this.prefs.getFile("build.path", lib.getName());
        if (lib.useRecursion()) {
            this.recursiveCompileFilesInFolder(libBuildFolder, libFolder, includeFolders);
        } else {
            File utilityFolder = new File(libFolder, "utility");
            File utilityBuildFolder = new File(libBuildFolder, "utility");
            includeFolders.add(utilityFolder);
            this.compileFilesInFolder(libBuildFolder, libFolder, includeFolders);
            this.compileFilesInFolder(utilityBuildFolder, utilityFolder, includeFolders);
            includeFolders.remove(utilityFolder);
        }
    }

    private void recursiveCompileFilesInFolder(File srcBuildFolder, File srcFolder, List<File> includeFolders) throws RunnerException, PreferencesMapException {
        this.compileFilesInFolder(srcBuildFolder, srcFolder, includeFolders);
        for (File subFolder : srcFolder.listFiles(new OnlyDirs())) {
            File subBuildFolder = new File(srcBuildFolder, subFolder.getName());
            this.recursiveCompileFilesInFolder(subBuildFolder, subFolder, includeFolders);
        }
    }

    private void compileFilesInFolder(File buildFolder, File srcFolder, List<File> includeFolders) throws RunnerException, PreferencesMapException {
        this.createFolder(buildFolder);
        List<File> objects = this.compileFiles(buildFolder, srcFolder, false, includeFolders);
        this.objectFiles.addAll(objects);
    }

    void compileCore() throws RunnerException, PreferencesMapException {
        File coreFolder = this.prefs.getFile("build.core.path");
        File variantFolder = this.prefs.getFile("build.variant.path");
        File buildFolder = this.prefs.getFile("build.path");
        ArrayList<File> includeFolders = new ArrayList<File>();
        includeFolders.add(coreFolder);
        if (variantFolder != null) {
            includeFolders.add(variantFolder);
        }
        if (variantFolder != null) {
            this.objectFiles.addAll(this.compileFiles(buildFolder, variantFolder, true, includeFolders));
        }
        File afile = new File(buildFolder, "core.a");
        List<File> coreObjectFiles = this.compileFiles(buildFolder, coreFolder, true, includeFolders);
        if (afile.exists()) {
            boolean changed = false;
            for (File file : coreObjectFiles) {
                if (file.lastModified() <= afile.lastModified()) continue;
                changed = true;
                break;
            }
            if (!changed) {
                if (this.verbose) {
                    System.out.println(I18n.format(I18n._("Using previously compiled file: {0}"), afile.getPath()));
                }
                return;
            }
        }
        afile.delete();
        try {
            for (File file : coreObjectFiles) {
                String[] cmdArray;
                PreferencesMap dict = new PreferencesMap(this.prefs);
                dict.put("ide_version", "10604");
                dict.put("archive_file", afile.getName());
                dict.put("object_file", file.getAbsolutePath());
                String cmd = this.prefs.getOrExcept("recipe.ar.pattern");
                try {
                    cmdArray = StringReplacer.formatAndSplit(cmd, dict, true);
                }
                catch (Exception e) {
                    throw new RunnerException(e);
                }
                this.execAsynchronously(cmdArray);
            }
        }
        catch (RunnerException e) {
            afile.delete();
            throw e;
        }
    }

    void compileLink() throws RunnerException, PreferencesMapException {
        String[] cmdArray;
        String optRelax = "";
        if (((String)this.prefs.get("build.mcu")).equals("atmega2560")) {
            optRelax = ",--relax";
        }
        String objectFileList = "";
        for (File file : this.objectFiles) {
            objectFileList = objectFileList + " \"" + file.getAbsolutePath() + '\"';
        }
        objectFileList = objectFileList.substring(1);
        PreferencesMap dict = new PreferencesMap(this.prefs);
        String flags = (String)dict.get("compiler.c.elf.flags") + optRelax;
        dict.put("compiler.c.elf.flags", flags);
        dict.put("archive_file", "core.a");
        dict.put("object_files", objectFileList);
        dict.put("ide_version", "10604");
        this.setupWarningFlags(dict);
        String cmd = this.prefs.getOrExcept("recipe.c.combine.pattern");
        try {
            cmdArray = StringReplacer.formatAndSplit(cmd, dict, true);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        this.execAsynchronously(cmdArray);
    }

    void runActions(String recipeClass, PreferencesMap prefs) throws RunnerException, PreferencesMapException {
        ArrayList<String> patterns = new ArrayList<String>();
        for (String key : prefs.keySet()) {
            if (!key.startsWith("recipe." + recipeClass) || !key.endsWith(".pattern")) continue;
            patterns.add(key);
        }
        Collections.sort(patterns);
        for (String recipe : patterns) {
            this.runRecipe(recipe);
        }
    }

    void runRecipe(String recipe) throws RunnerException, PreferencesMapException {
        String[] cmdArray;
        PreferencesMap dict = new PreferencesMap(this.prefs);
        dict.put("ide_version", "10604");
        String cmd = this.prefs.getOrExcept(recipe);
        try {
            cmdArray = StringReplacer.formatAndSplit(cmd, dict, true);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        this.execAsynchronously(cmdArray);
    }

    private static String prepareIncludes(List<File> includeFolders) {
        String res = "";
        for (File p : includeFolders) {
            res = res + " \"-I" + p.getAbsolutePath() + '\"';
        }
        return res.substring(1);
    }

    public PreferencesMap getBuildPreferences() {
        return this.prefs;
    }

    public void preprocess(String buildPath) throws RunnerException {
        this.preprocess(buildPath, new PdePreprocessor());
    }

    public void preprocess(String buildPath, PdePreprocessor preprocessor) throws RunnerException {
        StringBuffer bigCode = new StringBuffer();
        int bigCount = 0;
        for (SketchCode sc : this.sketch.getCodes()) {
            if (!sc.isExtension("ino") && !sc.isExtension("pde")) continue;
            sc.setPreprocOffset(bigCount);
            bigCode.append("#line 1 \"" + sc.getFileName() + "\"\n");
            bigCode.append(sc.getProgram());
            bigCode.append('\n');
            bigCount += sc.getLineCount();
        }
        int headerOffset = 0;
        try {
            headerOffset = preprocessor.writePrefix(bigCode.toString());
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            String msg = I18n._("Build folder disappeared or could not be written");
            throw new RunnerException(msg);
        }
        FileOutputStream outputStream = null;
        try {
            File streamFile = new File(buildPath, this.sketch.getName() + ".cpp");
            outputStream = new FileOutputStream(streamFile);
            preprocessor.write(outputStream);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            String msg = I18n._("Build folder disappeared or could not be written");
            throw new RunnerException(msg);
        }
        catch (RunnerException pe) {
            throw pe;
        }
        catch (Exception ex) {
            System.err.println(I18n.format(I18n._("Uncaught exception type: {0}"), ex.getClass()));
            ex.printStackTrace();
            throw new RunnerException(ex.toString());
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
        }
        this.importedLibraries = new LibraryList();
        this.importedDuplicateHeaders = new ArrayList<String>();
        this.importedDuplicateLibraries = new ArrayList<LibraryList>();
        for (String item : preprocessor.getExtraImports()) {
            UserLibrary lib;
            LibraryList list = BaseNoGui.importToLibraryTable.get(item);
            if (list == null || (lib = (UserLibrary)list.peekFirst()) == null || this.importedLibraries.contains(lib)) continue;
            this.importedLibraries.add(lib);
            if (list.size() <= 1) continue;
            this.importedDuplicateHeaders.add(item);
            this.importedDuplicateLibraries.add(list);
        }
        for (SketchCode sc : this.sketch.getCodes()) {
            if (sc.isExtension("c") || sc.isExtension("cpp") || sc.isExtension("h")) {
                String filename = sc.getFileName();
                try {
                    BaseNoGui.saveFile(sc.getProgram(), new File(buildPath, filename));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RunnerException(I18n.format(I18n._("Problem moving {0} to the build folder"), filename));
                }
            }
            if (!sc.isExtension("ino") && !sc.isExtension("pde")) continue;
            sc.addPreprocOffset(headerOffset);
        }
    }

    public RunnerException placeException(String message, String dotJavaFilename, int dotJavaLine) {
        for (SketchCode code : this.sketch.getCodes()) {
            if (!dotJavaFilename.equals(code.getFileName())) continue;
            return new RunnerException(message, this.sketch.indexOfCode(code), dotJavaLine);
        }
        return null;
    }

    public static interface ProgressListener {
        public void progress(int var1);
    }
}

