/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import processing.app.I18n;
import processing.app.debug.LegacyTargetPlatform;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.filefilters.OnlyDirs;

public class LegacyTargetPackage
implements TargetPackage {
    private String id;
    private Map<String, TargetPlatform> platforms;

    public LegacyTargetPackage(String _id, File _folder) throws TargetPlatformException {
        this.id = _id;
        this.platforms = new LinkedHashMap<String, TargetPlatform>();
        File[] folders = _folder.listFiles(OnlyDirs.ONLY_DIRS);
        if (folders == null) {
            return;
        }
        for (File subFolder : folders) {
            if (!subFolder.exists() || !subFolder.canRead()) continue;
            String arch = subFolder.getName();
            try {
                LegacyTargetPlatform platform = new LegacyTargetPlatform(arch, subFolder, this);
                this.platforms.put(arch, platform);
            }
            catch (TargetPlatformException e) {
                System.out.println(e.getMessage());
            }
        }
        if (this.platforms.size() == 0) {
            throw new TargetPlatformException(I18n.format(I18n._("No valid hardware definitions found in folder {0}."), _folder.getName()));
        }
    }

    @Override
    public Map<String, TargetPlatform> getPlatforms() {
        return this.platforms;
    }

    @Override
    public Collection<TargetPlatform> platforms() {
        return this.platforms.values();
    }

    @Override
    public TargetPlatform get(String platform) {
        return this.platforms.get(platform);
    }

    @Override
    public boolean hasPlatform(TargetPlatform platform) {
        return this.platforms.containsKey(platform.getId());
    }

    @Override
    public String getId() {
        return this.id;
    }
}

