/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import sun.awt.SunToolkit;
import sun.font.CharToGlyphMapper;
import sun.font.FileFont;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.font.FontScaler;
import sun.font.FontScalerException;
import sun.font.FontUtilities;
import sun.font.NativeFont;
import sun.font.SunFontManager;
import sun.font.TrueTypeGlyphMapper;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.security.action.GetPropertyAction;

public class TrueTypeFont
extends FileFont {
    public static final int cmapTag = 1668112752;
    public static final int glyfTag = 1735162214;
    public static final int headTag = 1751474532;
    public static final int hheaTag = 1751672161;
    public static final int hmtxTag = 1752003704;
    public static final int locaTag = 1819239265;
    public static final int maxpTag = 1835104368;
    public static final int nameTag = 1851878757;
    public static final int postTag = 1886352244;
    public static final int os_2Tag = 1330851634;
    public static final int GDEFTag = 1195656518;
    public static final int GPOSTag = 1196445523;
    public static final int GSUBTag = 1196643650;
    public static final int mortTag = 1836020340;
    public static final int fdscTag = 1717859171;
    public static final int fvarTag = 1719034226;
    public static final int featTag = 1717920116;
    public static final int EBLCTag = 1161972803;
    public static final int gaspTag = 1734439792;
    public static final int ttcfTag = 1953784678;
    public static final int v1ttTag = 65536;
    public static final int trueTag = 1953658213;
    public static final int ottoTag = 0x4F54544F;
    public static final int MS_PLATFORM_ID = 3;
    public static final short ENGLISH_LOCALE_ID = 1033;
    public static final int FAMILY_NAME_ID = 1;
    public static final int FULL_NAME_ID = 4;
    public static final int POSTSCRIPT_NAME_ID = 6;
    private static final short US_LCID = 1033;
    private static Map<String, Short> lcidMap;
    TTDisposerRecord disposerRecord = new TTDisposerRecord();
    int fontIndex = 0;
    int directoryCount = 1;
    int directoryOffset;
    int numTables;
    DirectoryEntry[] tableDirectory;
    private boolean supportsJA;
    private boolean supportsCJK;
    private Locale nameLocale;
    private String localeFamilyName;
    private String localeFullName;
    private static final int TTCHEADERSIZE = 12;
    private static final int DIRECTORYHEADERSIZE = 12;
    private static final int DIRECTORYENTRYSIZE = 16;
    static final String[] encoding_mapping;
    private static final String[][] languages;
    private static final String[] codePages;
    private static String defaultCodePage;
    public static final int reserved_bits1 = Integer.MIN_VALUE;
    public static final int reserved_bits2 = 65535;
    private static final int fsSelectionItalicBit = 1;
    private static final int fsSelectionBoldBit = 32;
    private static final int fsSelectionRegularBit = 64;
    private float stSize;
    private float stPos;
    private float ulSize;
    private float ulPos;
    private char[] gaspTable;

    public TrueTypeFont(String string, Object object, int n, boolean bl) throws FontFormatException {
        super(string, object);
        this.useJavaRasterizer = bl;
        this.fontRank = 3;
        try {
            this.verify();
            this.init(n);
        }
        catch (Throwable throwable) {
            this.close();
            if (throwable instanceof FontFormatException) {
                throw (FontFormatException)throwable;
            }
            throw new FontFormatException("Unexpected runtime exception.");
        }
        Disposer.addObjectRecord(this, this.disposerRecord);
    }

    @Override
    protected boolean checkUseNatives() {
        if (this.checkedNatives) {
            return this.useNatives;
        }
        if (!FontUtilities.isSolaris || this.useJavaRasterizer || FontUtilities.useT2K || this.nativeNames == null || this.getDirectoryEntry(1161972803) != null || GraphicsEnvironment.isHeadless()) {
            this.checkedNatives = true;
            return false;
        }
        if (this.nativeNames instanceof String) {
            String string = (String)this.nativeNames;
            if (string.indexOf("8859") > 0) {
                this.checkedNatives = true;
                return false;
            }
            if (NativeFont.hasExternalBitmaps(string)) {
                this.nativeFonts = new NativeFont[1];
                try {
                    this.nativeFonts[0] = new NativeFont(string, true);
                    this.useNatives = true;
                }
                catch (FontFormatException fontFormatException) {
                    this.nativeFonts = null;
                }
            }
        } else if (this.nativeNames instanceof String[]) {
            int n;
            String[] stringArray = (String[])this.nativeNames;
            int n2 = stringArray.length;
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                if (stringArray[n].indexOf("8859") > 0) {
                    this.checkedNatives = true;
                    return false;
                }
                if (!NativeFont.hasExternalBitmaps(stringArray[n])) continue;
                bl = true;
            }
            if (!bl) {
                this.checkedNatives = true;
                return false;
            }
            this.useNatives = true;
            this.nativeFonts = new NativeFont[n2];
            for (n = 0; n < n2; ++n) {
                try {
                    this.nativeFonts[n] = new NativeFont(stringArray[n], true);
                    continue;
                }
                catch (FontFormatException fontFormatException) {
                    this.useNatives = false;
                    this.nativeFonts = null;
                }
            }
        }
        if (this.useNatives) {
            this.glyphToCharMap = new char[this.getMapper().getNumGlyphs()];
        }
        this.checkedNatives = true;
        return this.useNatives;
    }

    private synchronized FileChannel open() throws FontFormatException {
        if (this.disposerRecord.channel == null) {
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().info("open TTF: " + this.platName);
            }
            try {
                RandomAccessFile randomAccessFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return new RandomAccessFile(TrueTypeFont.this.platName, "r");
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return null;
                        }
                    }
                });
                this.disposerRecord.channel = randomAccessFile.getChannel();
                this.fileSize = (int)this.disposerRecord.channel.size();
                FontManager fontManager = FontManagerFactory.getInstance();
                if (fontManager instanceof SunFontManager) {
                    ((SunFontManager)fontManager).addToPool(this);
                }
            }
            catch (NullPointerException nullPointerException) {
                this.close();
                throw new FontFormatException(nullPointerException.toString());
            }
            catch (ClosedChannelException closedChannelException) {
                Thread.interrupted();
                this.close();
                this.open();
            }
            catch (IOException iOException) {
                this.close();
                throw new FontFormatException(iOException.toString());
            }
        }
        return this.disposerRecord.channel;
    }

    @Override
    protected synchronized void close() {
        this.disposerRecord.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readBlock(ByteBuffer byteBuffer, int n, int n2) {
        int n3;
        block21: {
            n3 = 0;
            try {
                TrueTypeFont trueTypeFont = this;
                synchronized (trueTypeFont) {
                    if (this.disposerRecord.channel == null) {
                        this.open();
                    }
                    if (n + n2 > this.fileSize) {
                        if (n >= this.fileSize) {
                            if (FontUtilities.isLogging()) {
                                String string = "Read offset is " + n + " file size is " + this.fileSize + " file is " + this.platName;
                                FontUtilities.getLogger().severe(string);
                            }
                            return -1;
                        }
                        n2 = this.fileSize - n;
                    }
                    byteBuffer.clear();
                    this.disposerRecord.channel.position(n);
                    while (n3 < n2) {
                        int n4 = this.disposerRecord.channel.read(byteBuffer);
                        if (n4 == -1) {
                            String string = "Unexpected EOF " + this;
                            int n5 = (int)this.disposerRecord.channel.size();
                            if (n5 != this.fileSize) {
                                string = string + " File size was " + this.fileSize + " and now is " + n5;
                            }
                            if (FontUtilities.isLogging()) {
                                FontUtilities.getLogger().severe(string);
                            }
                            if (n3 > n2 / 2 || n3 > 16384) {
                                byteBuffer.flip();
                                if (FontUtilities.isLogging()) {
                                    string = "Returning " + n3 + " bytes instead of " + n2;
                                    FontUtilities.getLogger().severe(string);
                                }
                            } else {
                                n3 = -1;
                            }
                            throw new IOException(string);
                        }
                        n3 += n4;
                    }
                    byteBuffer.flip();
                    if (n3 > n2) {
                        n3 = n2;
                    }
                }
            }
            catch (FontFormatException fontFormatException) {
                if (FontUtilities.isLogging()) {
                    FontUtilities.getLogger().severe("While reading " + this.platName, fontFormatException);
                }
                n3 = -1;
                this.deregisterFontAndClearStrikeCache();
            }
            catch (ClosedChannelException closedChannelException) {
                Thread.interrupted();
                this.close();
                return this.readBlock(byteBuffer, n, n2);
            }
            catch (IOException iOException) {
                if (FontUtilities.isLogging()) {
                    FontUtilities.getLogger().severe("While reading " + this.platName, iOException);
                }
                if (n3 != 0) break block21;
                n3 = -1;
                this.deregisterFontAndClearStrikeCache();
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ByteBuffer readBlock(int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        try {
            TrueTypeFont trueTypeFont = this;
            synchronized (trueTypeFont) {
                if (this.disposerRecord.channel == null) {
                    this.open();
                }
                if (n + n2 > this.fileSize) {
                    if (n > this.fileSize) {
                        return null;
                    }
                    byteBuffer = ByteBuffer.allocate(this.fileSize - n);
                }
                this.disposerRecord.channel.position(n);
                this.disposerRecord.channel.read(byteBuffer);
                byteBuffer.flip();
            }
        }
        catch (FontFormatException fontFormatException) {
            return null;
        }
        catch (ClosedChannelException closedChannelException) {
            Thread.interrupted();
            this.close();
            this.readBlock(byteBuffer, n, n2);
        }
        catch (IOException iOException) {
            return null;
        }
        return byteBuffer;
    }

    byte[] readBytes(int n, int n2) {
        ByteBuffer byteBuffer = this.readBlock(n, n2);
        if (byteBuffer.hasArray()) {
            return byteBuffer.array();
        }
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    private void verify() throws FontFormatException {
        this.open();
    }

    protected void init(int n) throws FontFormatException {
        ByteBuffer byteBuffer;
        int n2 = 0;
        ByteBuffer byteBuffer2 = this.readBlock(0, 12);
        try {
            switch (byteBuffer2.getInt()) {
                case 1953784678: {
                    byteBuffer2.getInt();
                    this.directoryCount = byteBuffer2.getInt();
                    if (n >= this.directoryCount) {
                        throw new FontFormatException("Bad collection index");
                    }
                    this.fontIndex = n;
                    byteBuffer2 = this.readBlock(12 + 4 * n, 4);
                    n2 = byteBuffer2.getInt();
                    break;
                }
                case 65536: 
                case 0x4F54544F: 
                case 1953658213: {
                    break;
                }
                default: {
                    throw new FontFormatException("Unsupported sfnt " + this.getPublicFileName());
                }
            }
            byteBuffer2 = this.readBlock(n2 + 4, 2);
            this.numTables = byteBuffer2.getShort();
            this.directoryOffset = n2 + 12;
            byteBuffer = this.readBlock(this.directoryOffset, this.numTables * 16);
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            this.tableDirectory = new DirectoryEntry[this.numTables];
            for (int i = 0; i < this.numTables; ++i) {
                DirectoryEntry directoryEntry;
                this.tableDirectory[i] = directoryEntry = new DirectoryEntry();
                directoryEntry.tag = intBuffer.get();
                intBuffer.get();
                directoryEntry.offset = intBuffer.get();
                directoryEntry.length = intBuffer.get();
                if (directoryEntry.offset + directoryEntry.length <= this.fileSize) continue;
                throw new FontFormatException("bad table, tag=" + directoryEntry.tag);
            }
            if (this.getDirectoryEntry(1751474532) == null) {
                throw new FontFormatException("missing head table");
            }
            if (this.getDirectoryEntry(1835104368) == null) {
                throw new FontFormatException("missing maxp table");
            }
            if (this.getDirectoryEntry(1752003704) != null && this.getDirectoryEntry(1751672161) == null) {
                throw new FontFormatException("missing hhea table");
            }
            this.initNames();
        }
        catch (Exception exception) {
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().severe(exception.toString());
            }
            if (exception instanceof FontFormatException) {
                throw (FontFormatException)exception;
            }
            throw new FontFormatException(exception.toString());
        }
        if (this.familyName == null || this.fullName == null) {
            throw new FontFormatException("Font name not found");
        }
        byteBuffer = this.getTableBuffer(1330851634);
        this.setStyle(byteBuffer);
        this.setCJKSupport(byteBuffer);
    }

    static String getCodePage() {
        if (defaultCodePage != null) {
            return defaultCodePage;
        }
        if (FontUtilities.isWindows) {
            defaultCodePage = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        } else {
            if (languages.length != codePages.length) {
                throw new InternalError("wrong code pages array length");
            }
            Locale locale = SunToolkit.getStartupLocale();
            String string = locale.getLanguage();
            if (string != null) {
                String string2;
                if (string.equals("zh") && (string2 = locale.getCountry()) != null) {
                    string = string + "_" + string2;
                }
                for (int i = 0; i < languages.length; ++i) {
                    for (int j = 0; j < languages[i].length; ++j) {
                        if (!string.equals(languages[i][j])) continue;
                        defaultCodePage = codePages[i];
                        return defaultCodePage;
                    }
                }
            }
        }
        if (defaultCodePage == null) {
            defaultCodePage = "";
        }
        return defaultCodePage;
    }

    @Override
    boolean supportsEncoding(String string) {
        if (string == null) {
            string = TrueTypeFont.getCodePage();
        }
        if ("".equals(string)) {
            return false;
        }
        if ((string = string.toLowerCase()).equals("gb18030")) {
            string = "gbk";
        } else if (string.equals("ms950_hkscs")) {
            string = "ms950";
        }
        ByteBuffer byteBuffer = this.getTableBuffer(1330851634);
        if (byteBuffer == null || byteBuffer.capacity() < 86) {
            return false;
        }
        int n = byteBuffer.getInt(78);
        int n2 = byteBuffer.getInt(82);
        for (int i = 0; i < encoding_mapping.length; ++i) {
            if (!encoding_mapping[i].equals(string) || (1 << i & n) == 0) continue;
            return true;
        }
        return false;
    }

    private void setCJKSupport(ByteBuffer byteBuffer) {
        if (byteBuffer == null || byteBuffer.capacity() < 50) {
            return;
        }
        int n = byteBuffer.getInt(46);
        this.supportsCJK = (n & 0x29BF0000) != 0;
        this.supportsJA = (n & 0x60000) != 0;
    }

    boolean supportsJA() {
        return this.supportsJA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getTableBuffer(int n) {
        int n2;
        DirectoryEntry directoryEntry = null;
        for (n2 = 0; n2 < this.numTables; ++n2) {
            if (this.tableDirectory[n2].tag != n) continue;
            directoryEntry = this.tableDirectory[n2];
            break;
        }
        if (directoryEntry == null || directoryEntry.length == 0 || directoryEntry.offset + directoryEntry.length > this.fileSize) {
            return null;
        }
        n2 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(directoryEntry.length);
        TrueTypeFont trueTypeFont = this;
        synchronized (trueTypeFont) {
            try {
                if (this.disposerRecord.channel == null) {
                    this.open();
                }
                this.disposerRecord.channel.position(directoryEntry.offset);
                n2 = this.disposerRecord.channel.read(byteBuffer);
                byteBuffer.flip();
            }
            catch (ClosedChannelException closedChannelException) {
                Thread.interrupted();
                this.close();
                return this.getTableBuffer(n);
            }
            catch (IOException iOException) {
                return null;
            }
            catch (FontFormatException fontFormatException) {
                return null;
            }
            if (n2 < directoryEntry.length) {
                return null;
            }
            return byteBuffer;
        }
    }

    long getLayoutTableCache() {
        try {
            return this.getScaler().getLayoutTableCache();
        }
        catch (FontScalerException fontScalerException) {
            return 0L;
        }
    }

    @Override
    byte[] getTableBytes(int n) {
        ByteBuffer byteBuffer = this.getTableBuffer(n);
        if (byteBuffer == null) {
            return null;
        }
        if (byteBuffer.hasArray()) {
            try {
                return byteBuffer.array();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] byArray = new byte[this.getTableSize(n)];
        byteBuffer.get(byArray);
        return byArray;
    }

    int getTableSize(int n) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != n) continue;
            return this.tableDirectory[i].length;
        }
        return 0;
    }

    int getTableOffset(int n) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != n) continue;
            return this.tableDirectory[i].offset;
        }
        return 0;
    }

    DirectoryEntry getDirectoryEntry(int n) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != n) continue;
            return this.tableDirectory[i];
        }
        return null;
    }

    boolean useEmbeddedBitmapsForSize(int n) {
        if (!this.supportsCJK) {
            return false;
        }
        if (this.getDirectoryEntry(1161972803) == null) {
            return false;
        }
        ByteBuffer byteBuffer = this.getTableBuffer(1161972803);
        int n2 = byteBuffer.getInt(4);
        for (int i = 0; i < n2; ++i) {
            int n3 = byteBuffer.get(8 + i * 48 + 45) & 0xFF;
            if (n3 != n) continue;
            return true;
        }
        return false;
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    protected void setStyle() {
        this.setStyle(this.getTableBuffer(1330851634));
    }

    private void setStyle(ByteBuffer byteBuffer) {
        if (byteBuffer == null || byteBuffer.capacity() < 64) {
            super.setStyle();
            return;
        }
        int n = byteBuffer.getChar(62) & 0xFFFF;
        int n2 = n & 1;
        int n3 = n & 0x20;
        int n4 = n & 0x40;
        if (n4 != 0 && (n2 | n3) != 0) {
            super.setStyle();
            return;
        }
        if ((n4 | n2 | n3) == 0) {
            super.setStyle();
            return;
        }
        switch (n3 | n2) {
            case 1: {
                this.style = 2;
                break;
            }
            case 32: {
                if (FontUtilities.isSolaris && this.platName.endsWith("HG-GothicB.ttf")) {
                    this.style = 0;
                    break;
                }
                this.style = 1;
                break;
            }
            case 33: {
                this.style = 3;
            }
        }
    }

    private void setStrikethroughMetrics(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null || byteBuffer.capacity() < 30 || n < 0) {
            this.stSize = 0.05f;
            this.stPos = -0.4f;
            return;
        }
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        this.stSize = (float)shortBuffer.get(13) / (float)n;
        this.stPos = (float)(-shortBuffer.get(14)) / (float)n;
    }

    private void setUnderlineMetrics(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null || byteBuffer.capacity() < 12 || n < 0) {
            this.ulSize = 0.05f;
            this.ulPos = 0.1f;
            return;
        }
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        this.ulSize = (float)shortBuffer.get(5) / (float)n;
        this.ulPos = (float)(-shortBuffer.get(4)) / (float)n;
    }

    @Override
    public void getStyleMetrics(float f, float[] fArray, int n) {
        if (this.ulSize == 0.0f && this.ulPos == 0.0f) {
            Buffer buffer;
            ByteBuffer byteBuffer = this.getTableBuffer(1751474532);
            int n2 = -1;
            if (byteBuffer != null && byteBuffer.capacity() >= 18 && ((n2 = ((ShortBuffer)(buffer = byteBuffer.asShortBuffer())).get(9) & 0xFFFF) < 16 || n2 > 16384)) {
                n2 = 2048;
            }
            buffer = this.getTableBuffer(1330851634);
            this.setStrikethroughMetrics((ByteBuffer)buffer, n2);
            ByteBuffer byteBuffer2 = this.getTableBuffer(1886352244);
            this.setUnderlineMetrics(byteBuffer2, n2);
        }
        fArray[n] = this.stPos * f;
        fArray[n + 1] = this.stSize * f;
        fArray[n + 2] = this.ulPos * f;
        fArray[n + 3] = this.ulSize * f;
    }

    private String makeString(byte[] byArray, int n, short s) {
        Object object;
        if (s >= 2 && s <= 6) {
            object = byArray;
            int n2 = n;
            byArray = new byte[n2];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                if (object[i] == false) continue;
                byArray[n++] = (byte)object[i];
            }
        }
        switch (s) {
            case 1: {
                object = "UTF-16";
                break;
            }
            case 0: {
                object = "UTF-16";
                break;
            }
            case 2: {
                object = "SJIS";
                break;
            }
            case 3: {
                object = "GBK";
                break;
            }
            case 4: {
                object = "MS950";
                break;
            }
            case 5: {
                object = "EUC_KR";
                break;
            }
            case 6: {
                object = "Johab";
                break;
            }
            default: {
                object = "UTF-16";
            }
        }
        try {
            return new String(byArray, 0, n, (String)object);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().warning(unsupportedEncodingException + " EncodingID=" + s);
            }
            return new String(byArray, 0, n);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void initNames() {
        byte[] byArray = new byte[256];
        ByteBuffer byteBuffer = this.getTableBuffer(1851878757);
        if (byteBuffer != null) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get();
            int n = shortBuffer.get();
            int n2 = shortBuffer.get() & 0xFFFF;
            this.nameLocale = SunToolkit.getStartupLocale();
            short s = TrueTypeFont.getLCIDFromLocale(this.nameLocale);
            block4: for (int i = 0; i < n; ++i) {
                short s2 = shortBuffer.get();
                if (s2 != 3) {
                    shortBuffer.position(shortBuffer.position() + 5);
                    continue;
                }
                short s3 = shortBuffer.get();
                short s4 = shortBuffer.get();
                short s5 = shortBuffer.get();
                int n3 = shortBuffer.get() & 0xFFFF;
                int n4 = (shortBuffer.get() & 0xFFFF) + n2;
                String string = null;
                switch (s5) {
                    case 1: {
                        if (this.familyName != null && s4 != 1033 && s4 != s) continue block4;
                        byteBuffer.position(n4);
                        byteBuffer.get(byArray, 0, n3);
                        string = this.makeString(byArray, n3, s3);
                        if (this.familyName == null || s4 == 1033) {
                            this.familyName = string;
                        }
                        if (s4 != s) continue block4;
                        this.localeFamilyName = string;
                        continue block4;
                    }
                    case 4: {
                        if (this.fullName != null && s4 != 1033 && s4 != s) continue block4;
                        byteBuffer.position(n4);
                        byteBuffer.get(byArray, 0, n3);
                        string = this.makeString(byArray, n3, s3);
                        if (this.fullName == null || s4 == 1033) {
                            this.fullName = string;
                        }
                        if (s4 != s) continue block4;
                        this.localeFullName = string;
                    }
                }
            }
            if (this.localeFamilyName == null) {
                this.localeFamilyName = this.familyName;
            }
            if (this.localeFullName == null) {
                this.localeFullName = this.fullName;
            }
        }
    }

    protected String lookupName(short s, int n) {
        String string = null;
        byte[] byArray = new byte[1024];
        ByteBuffer byteBuffer = this.getTableBuffer(1851878757);
        if (byteBuffer != null) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get();
            int n2 = shortBuffer.get();
            int n3 = shortBuffer.get() & 0xFFFF;
            for (int i = 0; i < n2; ++i) {
                short s2 = shortBuffer.get();
                if (s2 != 3) {
                    shortBuffer.position(shortBuffer.position() + 5);
                    continue;
                }
                short s3 = shortBuffer.get();
                short s4 = shortBuffer.get();
                short s5 = shortBuffer.get();
                int n4 = shortBuffer.get() & 0xFFFF;
                int n5 = (shortBuffer.get() & 0xFFFF) + n3;
                if (s5 != n || (string != null || s4 != 1033) && s4 != s) continue;
                byteBuffer.position(n5);
                byteBuffer.get(byArray, 0, n4);
                string = this.makeString(byArray, n4, s3);
                if (s4 != s) continue;
                return string;
            }
        }
        return string;
    }

    public int getFontCount() {
        return this.directoryCount;
    }

    @Override
    protected synchronized FontScaler getScaler() {
        if (this.scaler == null) {
            this.scaler = FontScaler.getScaler(this, this.fontIndex, this.supportsCJK, this.fileSize);
        }
        return this.scaler;
    }

    @Override
    public String getPostscriptName() {
        String string = this.lookupName((short)1033, 6);
        if (string == null) {
            return this.fullName;
        }
        return string;
    }

    @Override
    public String getFontName(Locale locale) {
        if (locale == null) {
            return this.fullName;
        }
        if (locale.equals(this.nameLocale) && this.localeFullName != null) {
            return this.localeFullName;
        }
        short s = TrueTypeFont.getLCIDFromLocale(locale);
        String string = this.lookupName(s, 4);
        if (string == null) {
            return this.fullName;
        }
        return string;
    }

    private static void addLCIDMapEntry(Map<String, Short> map, String string, short s) {
        map.put(string, s);
    }

    private static synchronized void createLCIDMap() {
        if (lcidMap != null) {
            return;
        }
        HashMap<String, Short> hashMap = new HashMap<String, Short>(200);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar", (short)1025);
        TrueTypeFont.addLCIDMapEntry(hashMap, "bg", (short)1026);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ca", (short)1027);
        TrueTypeFont.addLCIDMapEntry(hashMap, "zh", (short)1028);
        TrueTypeFont.addLCIDMapEntry(hashMap, "cs", (short)1029);
        TrueTypeFont.addLCIDMapEntry(hashMap, "da", (short)1030);
        TrueTypeFont.addLCIDMapEntry(hashMap, "de", (short)1031);
        TrueTypeFont.addLCIDMapEntry(hashMap, "el", (short)1032);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es", (short)1034);
        TrueTypeFont.addLCIDMapEntry(hashMap, "fi", (short)1035);
        TrueTypeFont.addLCIDMapEntry(hashMap, "fr", (short)1036);
        TrueTypeFont.addLCIDMapEntry(hashMap, "iw", (short)1037);
        TrueTypeFont.addLCIDMapEntry(hashMap, "hu", (short)1038);
        TrueTypeFont.addLCIDMapEntry(hashMap, "is", (short)1039);
        TrueTypeFont.addLCIDMapEntry(hashMap, "it", (short)1040);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ja", (short)1041);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ko", (short)1042);
        TrueTypeFont.addLCIDMapEntry(hashMap, "nl", (short)1043);
        TrueTypeFont.addLCIDMapEntry(hashMap, "no", (short)1044);
        TrueTypeFont.addLCIDMapEntry(hashMap, "pl", (short)1045);
        TrueTypeFont.addLCIDMapEntry(hashMap, "pt", (short)1046);
        TrueTypeFont.addLCIDMapEntry(hashMap, "rm", (short)1047);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ro", (short)1048);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ru", (short)1049);
        TrueTypeFont.addLCIDMapEntry(hashMap, "hr", (short)1050);
        TrueTypeFont.addLCIDMapEntry(hashMap, "sk", (short)1051);
        TrueTypeFont.addLCIDMapEntry(hashMap, "sq", (short)1052);
        TrueTypeFont.addLCIDMapEntry(hashMap, "sv", (short)1053);
        TrueTypeFont.addLCIDMapEntry(hashMap, "th", (short)1054);
        TrueTypeFont.addLCIDMapEntry(hashMap, "tr", (short)1055);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ur", (short)1056);
        TrueTypeFont.addLCIDMapEntry(hashMap, "in", (short)1057);
        TrueTypeFont.addLCIDMapEntry(hashMap, "uk", (short)1058);
        TrueTypeFont.addLCIDMapEntry(hashMap, "be", (short)1059);
        TrueTypeFont.addLCIDMapEntry(hashMap, "sl", (short)1060);
        TrueTypeFont.addLCIDMapEntry(hashMap, "et", (short)1061);
        TrueTypeFont.addLCIDMapEntry(hashMap, "lv", (short)1062);
        TrueTypeFont.addLCIDMapEntry(hashMap, "lt", (short)1063);
        TrueTypeFont.addLCIDMapEntry(hashMap, "fa", (short)1065);
        TrueTypeFont.addLCIDMapEntry(hashMap, "vi", (short)1066);
        TrueTypeFont.addLCIDMapEntry(hashMap, "hy", (short)1067);
        TrueTypeFont.addLCIDMapEntry(hashMap, "eu", (short)1069);
        TrueTypeFont.addLCIDMapEntry(hashMap, "mk", (short)1071);
        TrueTypeFont.addLCIDMapEntry(hashMap, "tn", (short)1074);
        TrueTypeFont.addLCIDMapEntry(hashMap, "xh", (short)1076);
        TrueTypeFont.addLCIDMapEntry(hashMap, "zu", (short)1077);
        TrueTypeFont.addLCIDMapEntry(hashMap, "af", (short)1078);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ka", (short)1079);
        TrueTypeFont.addLCIDMapEntry(hashMap, "fo", (short)1080);
        TrueTypeFont.addLCIDMapEntry(hashMap, "hi", (short)1081);
        TrueTypeFont.addLCIDMapEntry(hashMap, "mt", (short)1082);
        TrueTypeFont.addLCIDMapEntry(hashMap, "se", (short)1083);
        TrueTypeFont.addLCIDMapEntry(hashMap, "gd", (short)1084);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ms", (short)1086);
        TrueTypeFont.addLCIDMapEntry(hashMap, "kk", (short)1087);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ky", (short)1088);
        TrueTypeFont.addLCIDMapEntry(hashMap, "sw", (short)1089);
        TrueTypeFont.addLCIDMapEntry(hashMap, "tt", (short)1092);
        TrueTypeFont.addLCIDMapEntry(hashMap, "bn", (short)1093);
        TrueTypeFont.addLCIDMapEntry(hashMap, "pa", (short)1094);
        TrueTypeFont.addLCIDMapEntry(hashMap, "gu", (short)1095);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ta", (short)1097);
        TrueTypeFont.addLCIDMapEntry(hashMap, "te", (short)1098);
        TrueTypeFont.addLCIDMapEntry(hashMap, "kn", (short)1099);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ml", (short)1100);
        TrueTypeFont.addLCIDMapEntry(hashMap, "mr", (short)1102);
        TrueTypeFont.addLCIDMapEntry(hashMap, "sa", (short)1103);
        TrueTypeFont.addLCIDMapEntry(hashMap, "mn", (short)1104);
        TrueTypeFont.addLCIDMapEntry(hashMap, "cy", (short)1106);
        TrueTypeFont.addLCIDMapEntry(hashMap, "gl", (short)1110);
        TrueTypeFont.addLCIDMapEntry(hashMap, "dv", (short)1125);
        TrueTypeFont.addLCIDMapEntry(hashMap, "qu", (short)1131);
        TrueTypeFont.addLCIDMapEntry(hashMap, "mi", (short)1153);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_IQ", (short)2049);
        TrueTypeFont.addLCIDMapEntry(hashMap, "zh_CN", (short)2052);
        TrueTypeFont.addLCIDMapEntry(hashMap, "de_CH", (short)2055);
        TrueTypeFont.addLCIDMapEntry(hashMap, "en_GB", (short)2057);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_MX", (short)2058);
        TrueTypeFont.addLCIDMapEntry(hashMap, "fr_BE", (short)2060);
        TrueTypeFont.addLCIDMapEntry(hashMap, "it_CH", (short)2064);
        TrueTypeFont.addLCIDMapEntry(hashMap, "nl_BE", (short)2067);
        TrueTypeFont.addLCIDMapEntry(hashMap, "no_NO_NY", (short)2068);
        TrueTypeFont.addLCIDMapEntry(hashMap, "pt_PT", (short)2070);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ro_MD", (short)2072);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ru_MD", (short)2073);
        TrueTypeFont.addLCIDMapEntry(hashMap, "sr_CS", (short)2074);
        TrueTypeFont.addLCIDMapEntry(hashMap, "sv_FI", (short)2077);
        TrueTypeFont.addLCIDMapEntry(hashMap, "az_AZ", (short)2092);
        TrueTypeFont.addLCIDMapEntry(hashMap, "se_SE", (short)2107);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ga_IE", (short)2108);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ms_BN", (short)2110);
        TrueTypeFont.addLCIDMapEntry(hashMap, "uz_UZ", (short)2115);
        TrueTypeFont.addLCIDMapEntry(hashMap, "qu_EC", (short)2155);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_EG", (short)3073);
        TrueTypeFont.addLCIDMapEntry(hashMap, "zh_HK", (short)3076);
        TrueTypeFont.addLCIDMapEntry(hashMap, "de_AT", (short)3079);
        TrueTypeFont.addLCIDMapEntry(hashMap, "en_AU", (short)3081);
        TrueTypeFont.addLCIDMapEntry(hashMap, "fr_CA", (short)3084);
        TrueTypeFont.addLCIDMapEntry(hashMap, "sr_CS", (short)3098);
        TrueTypeFont.addLCIDMapEntry(hashMap, "se_FI", (short)3131);
        TrueTypeFont.addLCIDMapEntry(hashMap, "qu_PE", (short)3179);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_LY", (short)4097);
        TrueTypeFont.addLCIDMapEntry(hashMap, "zh_SG", (short)4100);
        TrueTypeFont.addLCIDMapEntry(hashMap, "de_LU", (short)4103);
        TrueTypeFont.addLCIDMapEntry(hashMap, "en_CA", (short)4105);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_GT", (short)4106);
        TrueTypeFont.addLCIDMapEntry(hashMap, "fr_CH", (short)4108);
        TrueTypeFont.addLCIDMapEntry(hashMap, "hr_BA", (short)4122);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_DZ", (short)5121);
        TrueTypeFont.addLCIDMapEntry(hashMap, "zh_MO", (short)5124);
        TrueTypeFont.addLCIDMapEntry(hashMap, "de_LI", (short)5127);
        TrueTypeFont.addLCIDMapEntry(hashMap, "en_NZ", (short)5129);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_CR", (short)5130);
        TrueTypeFont.addLCIDMapEntry(hashMap, "fr_LU", (short)5132);
        TrueTypeFont.addLCIDMapEntry(hashMap, "bs_BA", (short)5146);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_MA", (short)6145);
        TrueTypeFont.addLCIDMapEntry(hashMap, "en_IE", (short)6153);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_PA", (short)6154);
        TrueTypeFont.addLCIDMapEntry(hashMap, "fr_MC", (short)6156);
        TrueTypeFont.addLCIDMapEntry(hashMap, "sr_BA", (short)6170);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_TN", (short)7169);
        TrueTypeFont.addLCIDMapEntry(hashMap, "en_ZA", (short)7177);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_DO", (short)7178);
        TrueTypeFont.addLCIDMapEntry(hashMap, "sr_BA", (short)7194);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_OM", (short)8193);
        TrueTypeFont.addLCIDMapEntry(hashMap, "en_JM", (short)8201);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_VE", (short)8202);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_YE", (short)9217);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_CO", (short)9226);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_SY", (short)10241);
        TrueTypeFont.addLCIDMapEntry(hashMap, "en_BZ", (short)10249);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_PE", (short)10250);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_JO", (short)11265);
        TrueTypeFont.addLCIDMapEntry(hashMap, "en_TT", (short)11273);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_AR", (short)11274);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_LB", (short)12289);
        TrueTypeFont.addLCIDMapEntry(hashMap, "en_ZW", (short)12297);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_EC", (short)12298);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_KW", (short)13313);
        TrueTypeFont.addLCIDMapEntry(hashMap, "en_PH", (short)13321);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_CL", (short)13322);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_AE", (short)14337);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_UY", (short)14346);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_BH", (short)15361);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_PY", (short)15370);
        TrueTypeFont.addLCIDMapEntry(hashMap, "ar_QA", (short)16385);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_BO", (short)16394);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_SV", (short)17418);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_HN", (short)18442);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_NI", (short)19466);
        TrueTypeFont.addLCIDMapEntry(hashMap, "es_PR", (short)20490);
        lcidMap = hashMap;
    }

    private static short getLCIDFromLocale(Locale locale) {
        if (locale.equals(Locale.US)) {
            return 1033;
        }
        if (lcidMap == null) {
            TrueTypeFont.createLCIDMap();
        }
        String string = locale.toString();
        while (!"".equals(string)) {
            Short s = lcidMap.get(string);
            if (s != null) {
                return s;
            }
            int n = string.lastIndexOf(95);
            if (n < 1) {
                return 1033;
            }
            string = string.substring(0, n);
        }
        return 1033;
    }

    @Override
    public String getFamilyName(Locale locale) {
        if (locale == null) {
            return this.familyName;
        }
        if (locale.equals(this.nameLocale) && this.localeFamilyName != null) {
            return this.localeFamilyName;
        }
        short s = TrueTypeFont.getLCIDFromLocale(locale);
        String string = this.lookupName(s, 1);
        if (string == null) {
            return this.familyName;
        }
        return string;
    }

    @Override
    public CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new TrueTypeGlyphMapper(this);
        }
        return this.mapper;
    }

    protected void initAllNames(int n, HashSet hashSet) {
        byte[] byArray = new byte[256];
        ByteBuffer byteBuffer = this.getTableBuffer(1851878757);
        if (byteBuffer != null) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get();
            int n2 = shortBuffer.get();
            int n3 = shortBuffer.get() & 0xFFFF;
            for (int i = 0; i < n2; ++i) {
                short s = shortBuffer.get();
                if (s != 3) {
                    shortBuffer.position(shortBuffer.position() + 5);
                    continue;
                }
                short s2 = shortBuffer.get();
                short s3 = shortBuffer.get();
                short s4 = shortBuffer.get();
                int n4 = shortBuffer.get() & 0xFFFF;
                int n5 = (shortBuffer.get() & 0xFFFF) + n3;
                if (s4 != n) continue;
                byteBuffer.position(n5);
                byteBuffer.get(byArray, 0, n4);
                hashSet.add(this.makeString(byArray, n4, s2));
            }
        }
    }

    String[] getAllFamilyNames() {
        HashSet hashSet = new HashSet();
        try {
            this.initAllNames(1, hashSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashSet.toArray(new String[0]);
    }

    String[] getAllFullNames() {
        HashSet hashSet = new HashSet();
        try {
            this.initAllNames(4, hashSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashSet.toArray(new String[0]);
    }

    @Override
    Point2D.Float getGlyphPoint(long l, int n, int n2) {
        try {
            return this.getScaler().getGlyphPoint(l, n, n2);
        }
        catch (FontScalerException fontScalerException) {
            return null;
        }
    }

    private char[] getGaspTable() {
        if (this.gaspTable != null) {
            return this.gaspTable;
        }
        ByteBuffer byteBuffer = this.getTableBuffer(1734439792);
        if (byteBuffer == null) {
            this.gaspTable = new char[0];
            return this.gaspTable;
        }
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        char c = charBuffer.get();
        if (c > '\u0001') {
            this.gaspTable = new char[0];
            return this.gaspTable;
        }
        char c2 = charBuffer.get();
        if (4 + c2 * 4 > this.getTableSize(1734439792)) {
            this.gaspTable = new char[0];
            return this.gaspTable;
        }
        this.gaspTable = new char[2 * c2];
        charBuffer.get(this.gaspTable);
        return this.gaspTable;
    }

    @Override
    public boolean useAAForPtSize(int n) {
        char[] cArray = this.getGaspTable();
        if (cArray.length > 0) {
            for (int i = 0; i < cArray.length; i += 2) {
                if (n > cArray[i]) continue;
                return (cArray[i + 1] & 2) != 0;
            }
            return true;
        }
        if (this.style == 1) {
            return true;
        }
        return n <= 8 || n >= 18;
    }

    @Override
    public boolean hasSupplementaryChars() {
        return ((TrueTypeGlyphMapper)this.getMapper()).hasSupplementaryChars();
    }

    public String toString() {
        return "** TrueType Font: Family=" + this.familyName + " Name=" + this.fullName + " style=" + this.style + " fileName=" + this.getPublicFileName();
    }

    static {
        encoding_mapping = new String[]{"cp1252", "cp1250", "cp1251", "cp1253", "cp1254", "cp1255", "cp1256", "cp1257", "", "", "", "", "", "", "", "", "ms874", "ms932", "gbk", "ms949", "ms950", "ms1361", "", "", "", "", "", "", "", "", "", ""};
        languages = new String[][]{{"en", "ca", "da", "de", "es", "fi", "fr", "is", "it", "nl", "no", "pt", "sq", "sv"}, {"cs", "cz", "et", "hr", "hu", "nr", "pl", "ro", "sk", "sl", "sq", "sr"}, {"bg", "mk", "ru", "sh", "uk"}, {"el"}, {"tr"}, {"he"}, {"ar"}, {"et", "lt", "lv"}, {"th"}, {"ja"}, {"zh", "zh_CN"}, {"ko"}, {"zh_HK", "zh_TW"}, {"ko"}};
        codePages = new String[]{"cp1252", "cp1250", "cp1251", "cp1253", "cp1254", "cp1255", "cp1256", "cp1257", "ms874", "ms932", "gbk", "ms949", "ms950", "ms1361"};
        defaultCodePage = null;
    }

    private static class TTDisposerRecord
    implements DisposerRecord {
        FileChannel channel = null;

        private TTDisposerRecord() {
        }

        @Override
        public synchronized void dispose() {
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.channel = null;
            }
        }
    }

    static class DirectoryEntry {
        int tag;
        int offset;
        int length;

        DirectoryEntry() {
        }
    }
}

