/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.mrbean.BeanUtil;
import com.fasterxml.jackson.module.mrbean.POJOProperty;
import com.fasterxml.jackson.module.mrbean.asm.ClassWriter;
import com.fasterxml.jackson.module.mrbean.asm.FieldVisitor;
import com.fasterxml.jackson.module.mrbean.asm.MethodVisitor;
import com.fasterxml.jackson.module.mrbean.asm.Type;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class BeanBuilder {
    protected Map<String, POJOProperty> _beanProperties = new LinkedHashMap<String, POJOProperty>();
    protected LinkedHashMap<String, Method> _unsupportedMethods = new LinkedHashMap();
    protected final Class<?> _implementedType;
    protected final TypeFactory _typeFactory;

    public BeanBuilder(Class<?> clazz, TypeFactory typeFactory) {
        this._implementedType = clazz;
        this._typeFactory = typeFactory;
    }

    public BeanBuilder implement(boolean bl) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(this._implementedType);
        BeanUtil.findSuperTypes(this._implementedType, Object.class, arrayList);
        for (Class<?> clazz : arrayList) {
            for (Method method : clazz.getDeclaredMethods()) {
                String string = method.getName();
                int n = method.getParameterTypes().length;
                if (n == 0) {
                    if (string.startsWith("get") || string.startsWith("is") && BeanBuilder.returnsBoolean(method)) {
                        this.addGetter(method);
                        continue;
                    }
                } else if (n == 1 && string.startsWith("set")) {
                    this.addSetter(method);
                    continue;
                }
                if (BeanUtil.isConcrete(method) || this._unsupportedMethods.containsKey(string)) continue;
                if (bl) {
                    throw new IllegalArgumentException("Unrecognized abstract method '" + string + "' (not a getter or setter) -- to avoid exception, disable AbstractTypeMaterializer.Feature.FAIL_ON_UNMATERIALIZED_METHOD");
                }
                this._unsupportedMethods.put(string, method);
            }
        }
        return this;
    }

    public byte[] build(String string) {
        String string2;
        ClassWriter classWriter = new ClassWriter(1);
        String string3 = BeanBuilder.getInternalClassName(string);
        String string4 = BeanBuilder.getInternalClassName(this._implementedType.getName());
        if (this._implementedType.isInterface()) {
            string2 = "java/lang/Object";
            classWriter.visit(49, 33, string3, null, string2, new String[]{string4});
        } else {
            string2 = string4;
            classWriter.visit(49, 33, string3, null, string4, null);
        }
        classWriter.visitSource(string + ".java", null);
        BeanBuilder.generateDefaultConstructor(classWriter, string2);
        for (POJOProperty object : this._beanProperties.values()) {
            TypeDescription typeDescription = object.selectType(this._typeFactory);
            BeanBuilder.createField(classWriter, object, typeDescription);
            if (!object.hasConcreteGetter()) {
                BeanBuilder.createGetter(classWriter, string3, object, typeDescription);
            }
            if (object.hasConcreteSetter()) continue;
            BeanBuilder.createSetter(classWriter, string3, object, typeDescription);
        }
        for (Method method : this._unsupportedMethods.values()) {
            BeanBuilder.createUnimplementedMethod(classWriter, string3, method);
        }
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static String getPropertyName(String string) {
        int n = string.startsWith("is") ? 2 : 3;
        String string2 = string.substring(n);
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.setCharAt(0, Character.toLowerCase(string2.charAt(0)));
        return stringBuilder.toString();
    }

    private static String buildGetterName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        return stringBuilder.append("get").append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    private static String buildSetterName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        return stringBuilder.append("set").append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    private static String getInternalClassName(String string) {
        return string.replace(".", "/");
    }

    private void addGetter(Method method) {
        POJOProperty pOJOProperty = this.findProperty(BeanBuilder.getPropertyName(method.getName()));
        if (pOJOProperty.getGetter() == null) {
            pOJOProperty.setGetter(method);
        }
    }

    private void addSetter(Method method) {
        POJOProperty pOJOProperty = this.findProperty(BeanBuilder.getPropertyName(method.getName()));
        if (pOJOProperty.getSetter() == null) {
            pOJOProperty.setSetter(method);
        }
    }

    private POJOProperty findProperty(String string) {
        POJOProperty pOJOProperty = this._beanProperties.get(string);
        if (pOJOProperty == null) {
            pOJOProperty = new POJOProperty(string, this._implementedType);
            this._beanProperties.put(string, pOJOProperty);
        }
        return pOJOProperty;
    }

    private static final boolean returnsBoolean(Method method) {
        Class<?> clazz = method.getReturnType();
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }

    protected static void generateDefaultConstructor(ClassWriter classWriter, String string) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, string, "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void createField(ClassWriter classWriter, POJOProperty pOJOProperty, TypeDescription typeDescription) {
        String string = typeDescription.hasGenerics() ? typeDescription.genericSignature() : null;
        String string2 = typeDescription.erasedSignature();
        FieldVisitor fieldVisitor = classWriter.visitField(1, pOJOProperty.getFieldName(), string2, string, null);
        fieldVisitor.visitEnd();
    }

    private static void createSetter(ClassWriter classWriter, String string, POJOProperty pOJOProperty, TypeDescription typeDescription) {
        String string2;
        String string3;
        Method method = pOJOProperty.getSetter();
        if (method != null) {
            string3 = Type.getMethodDescriptor(method);
            string2 = method.getName();
        } else {
            string3 = "(" + typeDescription.erasedSignature() + ")V";
            string2 = BeanBuilder.buildSetterName(pOJOProperty.getName());
        }
        String string4 = typeDescription.hasGenerics() ? "(" + typeDescription.genericSignature() + ")V" : null;
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string2, string3, string4, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(typeDescription.getLoadOpcode(), 1);
        methodVisitor.visitFieldInsn(181, string, pOJOProperty.getFieldName(), typeDescription.erasedSignature());
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void createGetter(ClassWriter classWriter, String string, POJOProperty pOJOProperty, TypeDescription typeDescription) {
        String string2;
        String string3;
        Method method = pOJOProperty.getGetter();
        if (method != null) {
            string3 = Type.getMethodDescriptor(method);
            string2 = method.getName();
        } else {
            string3 = "()" + typeDescription.erasedSignature();
            string2 = BeanBuilder.buildGetterName(pOJOProperty.getName());
        }
        String string4 = typeDescription.hasGenerics() ? "()" + typeDescription.genericSignature() : null;
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string2, string3, string4, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, string, pOJOProperty.getFieldName(), typeDescription.erasedSignature());
        methodVisitor.visitInsn(typeDescription.getReturnOpcode());
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void createUnimplementedMethod(ClassWriter classWriter, String string, Method method) {
        String string2 = BeanBuilder.getInternalClassName(UnsupportedOperationException.class.getName());
        String string3 = Type.getMethodDescriptor(method);
        String string4 = method.getName();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string4, string3, null, null);
        methodVisitor.visitTypeInsn(187, string2);
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn("Unimplemented method '" + string4 + "' (not a setter/getter, could not materialize)");
        methodVisitor.visitMethodInsn(183, string2, "<init>", "(Ljava/lang/String;)V");
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    static class TypeDescription {
        private final Type _asmType;
        private JavaType _jacksonType;

        public TypeDescription(JavaType javaType) {
            this._jacksonType = javaType;
            this._asmType = Type.getType(javaType.getRawClass());
        }

        public Class<?> getRawClass() {
            return this._jacksonType.getRawClass();
        }

        public String erasedSignature() {
            return this._jacksonType.getErasedSignature();
        }

        public String genericSignature() {
            return this._jacksonType.getGenericSignature();
        }

        public boolean hasGenerics() {
            return this._jacksonType.hasGenericTypes();
        }

        public int getLoadOpcode() {
            return this._asmType.getOpcode(21);
        }

        public int getReturnOpcode() {
            return this._asmType.getOpcode(172);
        }

        public String toString() {
            return this._jacksonType.toString();
        }

        public static TypeDescription moreSpecificType(TypeDescription typeDescription, TypeDescription typeDescription2) {
            Class<?> clazz;
            Class<?> clazz2 = typeDescription.getRawClass();
            if (clazz2.isAssignableFrom(clazz = typeDescription2.getRawClass())) {
                return typeDescription2;
            }
            if (clazz.isAssignableFrom(clazz2)) {
                return typeDescription;
            }
            return null;
        }
    }
}

