/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.net.cookie.HttpCookie;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

abstract class CookieStore {
    protected transient TreeMap cookieJar = new TreeMap();

    CookieStore() {
    }

    public void recordCookie(HttpCookie httpCookie) {
        if (this.shouldRejectCookie(httpCookie)) {
            return;
        }
        this.loadCookieJar();
        String string = httpCookie.getDomain().toLowerCase();
        ArrayList arrayList = (ArrayList)this.cookieJar.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (this.addOrReplaceCookie(arrayList, httpCookie)) {
            this.cookieJar.put(string, arrayList);
            this.saveCookieJar();
        }
    }

    protected abstract void loadCookieJar();

    protected abstract void saveCookieJar();

    protected abstract String getName();

    protected boolean addOrReplaceCookie(ArrayList arrayList, HttpCookie httpCookie) {
        int n = arrayList.size();
        String string = httpCookie.getPath();
        String string2 = httpCookie.getName();
        HttpCookie httpCookie2 = null;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            String string3;
            HttpCookie httpCookie3 = (HttpCookie)arrayList.get(i);
            String string4 = httpCookie3.getPath();
            if (!string.equals(string4) || !string2.equals(string3 = httpCookie3.getName())) continue;
            httpCookie2 = httpCookie3;
            n2 = i;
            break;
        }
        if (httpCookie2 != null) {
            arrayList.set(n2, httpCookie);
        } else {
            arrayList.add(httpCookie);
        }
        return true;
    }

    protected boolean shouldRejectCookie(HttpCookie httpCookie) {
        return httpCookie.getDomain() == null || httpCookie.getPath() == null || httpCookie.getName() == null;
    }

    public String getRelevantCookies(URL uRL) {
        int n;
        this.loadCookieJar();
        String string = uRL.getHost();
        String string2 = this.getCookiesForHost(string, uRL);
        while ((n = string.indexOf(46, 1)) >= 0) {
            String string3 = this.getCookiesForHost(string = string.substring(n + 1), uRL);
            if (string3 == null) continue;
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            string2 = string2 + "; " + string3;
        }
        return string2;
    }

    private String getCookiesForHost(String string, URL uRL) {
        Object object;
        Comparable comparable;
        ArrayList arrayList = (ArrayList)this.cookieJar.get(string);
        if (arrayList == null) {
            return null;
        }
        String string2 = uRL.getFile();
        int n = string2.indexOf(63);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        Iterator iterator = arrayList.iterator();
        ArrayList<Comparable> arrayList2 = new ArrayList<Comparable>(10);
        while (iterator.hasNext()) {
            String string3;
            comparable = (HttpCookie)iterator.next();
            object = ((HttpCookie)comparable).getPath();
            if (!string2.startsWith((String)object) || ((HttpCookie)comparable).hasExpired() || !(string3 = uRL.getProtocol()).equals("https") && (!string3.equals("http") || ((HttpCookie)comparable).isSecure())) continue;
            arrayList2.add(comparable);
        }
        Collections.sort(arrayList2);
        iterator = arrayList2.iterator();
        comparable = null;
        while (iterator.hasNext()) {
            object = (HttpCookie)iterator.next();
            if (comparable == null) {
                comparable = new StringBuffer(((HttpCookie)object).getNameValue());
                continue;
            }
            ((StringBuffer)comparable).append("; ").append(((HttpCookie)object).getNameValue());
        }
        if (comparable == null) {
            return null;
        }
        return ((StringBuffer)comparable).toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append("\n[\n");
        for (List list : this.cookieJar.values()) {
            for (HttpCookie httpCookie : list) {
                stringBuffer.append("\t");
                stringBuffer.append(httpCookie.toString());
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

