/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.filters;

import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.LibrariesIndex;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;

public class InstalledLibraryPredicate
implements Predicate<ContributedLibrary> {
    private final LibrariesIndex index;

    public InstalledLibraryPredicate(LibrariesIndex index) {
        this.index = index;
    }

    public boolean apply(ContributedLibrary input) {
        if (input.isInstalled()) {
            return true;
        }
        Collection installed = Collections2.filter((Collection)this.index.find(input.getName()), (Predicate)new InstalledPredicate());
        return !installed.isEmpty();
    }

    public boolean equals(Object obj) {
        return obj instanceof InstalledLibraryPredicate;
    }
}

