/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource;

import jdk.management.resource.NotifyingMeter;
import jdk.management.resource.ResourceApprover;
import jdk.management.resource.ResourceId;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceType;

public class ThrottledMeter
extends NotifyingMeter {
    private volatile long ratePerSec;
    private final Object mutex;
    private long availableBytes;
    private long availableTimestamp;

    public static ThrottledMeter create(ResourceType resourceType, long l, ResourceApprover resourceApprover) {
        return new ThrottledMeter(resourceType, l, null, resourceApprover);
    }

    public static ThrottledMeter create(ResourceType resourceType, ResourceRequest resourceRequest, ResourceApprover resourceApprover) {
        return new ThrottledMeter(resourceType, Long.MAX_VALUE, resourceRequest, resourceApprover);
    }

    public static ThrottledMeter create(ResourceType resourceType, long l, ResourceRequest resourceRequest, ResourceApprover resourceApprover) {
        return new ThrottledMeter(resourceType, l, resourceRequest, resourceApprover);
    }

    ThrottledMeter(ResourceType resourceType, long l, ResourceRequest resourceRequest, ResourceApprover resourceApprover) {
        super(resourceType, resourceRequest, resourceApprover);
        if (l <= 0L) {
            throw new IllegalArgumentException("ratePerSec must be greater than zero");
        }
        this.ratePerSec = l;
        this.mutex = new Object();
        this.availableBytes = 0L;
        this.availableTimestamp = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long validate(long l, long l2, ResourceId resourceId) {
        long l3 = super.validate(l, l2, resourceId);
        if (l3 <= 0L) {
            return l3;
        }
        Object object = this.mutex;
        synchronized (object) {
            while (this.availableBytes - l2 < 0L) {
                long l4 = this.ratePerSec;
                long l5 = this.availableBytes;
                long l6 = System.currentTimeMillis();
                long l7 = Math.max(l6 - this.availableTimestamp, 0L);
                long l8 = l4 * l7 / 1000L;
                this.availableBytes = Math.min(this.availableBytes + l8, l4);
                this.availableTimestamp = l6;
                if (this.availableBytes - l2 >= 0L || l2 > l4 && l5 > 0L) break;
                long l9 = Math.min(l2 - this.availableBytes, l4);
                l7 = l9 * 1000L / l4;
                try {
                    this.mutex.wait(Math.max(l7, 10L));
                }
                catch (InterruptedException interruptedException) {
                    return 0L;
                }
            }
            this.availableBytes -= l2;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getCurrentRate() {
        Object object = this.mutex;
        synchronized (object) {
            long l = this.ratePerSec;
            long l2 = System.currentTimeMillis();
            long l3 = l2 - this.availableTimestamp;
            long l4 = l * l3 / 1000L;
            this.availableBytes = Math.min(this.availableBytes + l4, l);
            this.availableTimestamp = l2;
            long l5 = l - this.availableBytes;
            return l5;
        }
    }

    public final synchronized long getRatePerSec() {
        return this.ratePerSec;
    }

    public final synchronized long setRatePerSec(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("ratePerSec must be greater than zero");
        }
        long l2 = l;
        this.ratePerSec = l;
        return l2;
    }

    @Override
    public String toString() {
        return super.toString() + "; ratePerSec: " + Long.toString(this.ratePerSec) + "; currentRate: " + Long.toString(this.getCurrentRate());
    }
}

