/*
 * Decompiled with CFR 0.152.
 */
package processing.app.windows;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListComPortsParser {
    private final Pattern vidRegExp = Pattern.compile("VID_(\\w\\w\\w\\w)");
    private final Pattern pidRegExp = Pattern.compile("PID_(\\w\\w\\w\\w)");

    public String extractVIDAndPID(String output, String serial) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(output));
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith(serial.toUpperCase())) continue;
            Matcher vidMatcher = this.vidRegExp.matcher(line);
            Matcher pidMatcher = this.pidRegExp.matcher(line);
            if (!vidMatcher.find() || !pidMatcher.find()) continue;
            return ("0x" + vidMatcher.group(1) + "_0x" + pidMatcher.group(1)).toUpperCase();
        }
        return null;
    }
}

