/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayList;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.ir.CompileUnitHolder;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

abstract class ReplaceCompileUnits
extends NodeVisitor<LexicalContext> {
    ReplaceCompileUnits() {
        super(new LexicalContext());
    }

    abstract CompileUnit getReplacement(CompileUnit var1);

    CompileUnit getExistingReplacement(CompileUnitHolder node) {
        CompileUnit oldUnit = node.getCompileUnit();
        assert (oldUnit != null);
        CompileUnit newUnit = this.getReplacement(oldUnit);
        assert (newUnit != null);
        return newUnit;
    }

    @Override
    public Node leaveFunctionNode(FunctionNode node) {
        return node.setCompileUnit(this.lc, this.getExistingReplacement(node)).setState(this.lc, FunctionNode.CompilationState.COMPILE_UNITS_REUSED);
    }

    @Override
    public Node leaveLiteralNode(LiteralNode<?> node) {
        if (node instanceof LiteralNode.ArrayLiteralNode) {
            LiteralNode.ArrayLiteralNode aln = (LiteralNode.ArrayLiteralNode)node;
            if (aln.getUnits() == null) {
                return node;
            }
            ArrayList<LiteralNode.ArrayLiteralNode.ArrayUnit> newArrayUnits = new ArrayList<LiteralNode.ArrayLiteralNode.ArrayUnit>();
            for (LiteralNode.ArrayLiteralNode.ArrayUnit au : aln.getUnits()) {
                newArrayUnits.add(new LiteralNode.ArrayLiteralNode.ArrayUnit(this.getExistingReplacement(au), au.getLo(), au.getHi()));
            }
            return aln.setUnits(this.lc, newArrayUnits);
        }
        return node;
    }
}

