/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.services;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.cookie.CookieHandler;
import com.sun.deploy.net.cookie.IExplorerCookieHandler;
import com.sun.deploy.net.offline.OfflineHandler;
import com.sun.deploy.net.offline.WIExplorerOfflineHandler;
import com.sun.deploy.net.proxy.BrowserProxyConfig;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.SunAutoProxyHandler;
import com.sun.deploy.net.proxy.WDefaultBrowserProxyConfig;
import com.sun.deploy.net.proxy.WIExplorerAutoProxyHandler;
import com.sun.deploy.security.BrowserAuthenticator;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CredentialManager;
import com.sun.deploy.security.DeployKeyStore;
import com.sun.deploy.security.MSCredentialManager;
import com.sun.deploy.security.WIExplorerBrowserAuthenticator;
import com.sun.deploy.security.WIExplorerSSLRootCertStore;
import com.sun.deploy.security.WIExplorerSigningCertStore;
import com.sun.deploy.security.WIExplorerSigningRootCertStore;
import com.sun.deploy.security.WIExplorerUntrustedCertStore;
import com.sun.deploy.services.Service;
import com.sun.deploy.trace.Trace;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;

public class WPlatformService
implements Service {
    public CookieHandler getCookieHandler() {
        return new IExplorerCookieHandler();
    }

    public BrowserProxyConfig getProxyConfig() {
        return new WDefaultBrowserProxyConfig();
    }

    public ProxyHandler getAutoProxyHandler() {
        boolean bl = Config.isJavaVersionAtLeast16();
        if (bl) {
            return new SunAutoProxyHandler();
        }
        return new WIExplorerAutoProxyHandler();
    }

    public ProxyHandler getSystemProxyHandler() {
        return null;
    }

    public ProxyHandler getBrowserProxyHandler() {
        return null;
    }

    public CertStore getBrowserSigningRootCertStore() {
        return new WIExplorerSigningRootCertStore();
    }

    public CertStore getBrowserSSLRootCertStore() {
        return new WIExplorerSSLRootCertStore();
    }

    public CertStore getBrowserTrustedCertStore() {
        return new WIExplorerSigningCertStore();
    }

    public CertStore getBrowserUntrustedCertStore() {
        return new WIExplorerUntrustedCertStore();
    }

    public DeployKeyStore getBrowserClientAuthKeyStore() {
        DeployKeyStore deployKeyStore = AccessController.doPrivileged(new PrivilegedAction<DeployKeyStore>(){

            @Override
            public DeployKeyStore run() {
                try {
                    return new DeployKeyStore(new KeyStore[]{KeyStore.getInstance("Windows-MY", "SunMSCAPI"), KeyStore.getInstance("WIExplorerMy")});
                }
                catch (KeyStoreException keyStoreException) {
                    Trace.ignored(keyStoreException);
                    return null;
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    Trace.ignored(noSuchProviderException);
                    return null;
                }
            }
        });
        return deployKeyStore;
    }

    public CredentialManager getCredentialManager() {
        return MSCredentialManager.getInstance();
    }

    public BrowserAuthenticator getBrowserAuthenticator() {
        return new WIExplorerBrowserAuthenticator();
    }

    public SecureRandom getSecureRandom() {
        return new SecureRandom();
    }

    public boolean isIExplorer() {
        return true;
    }

    public boolean isNetscape() {
        return false;
    }

    public OfflineHandler getOfflineHandler() {
        return new WIExplorerOfflineHandler();
    }
}

