/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers.network;

import cc.arduino.packages.discoverers.network.NetworkTopologyListener;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.NetworkTopologyDiscovery;

public class NetworkChecker
extends TimerTask {
    private final NetworkTopologyListener topologyListener;
    private final NetworkTopologyDiscovery topology;
    private Set<InetAddress> knownAddresses;

    public NetworkChecker(NetworkTopologyListener topologyListener, NetworkTopologyDiscovery topology) {
        this.topologyListener = topologyListener;
        this.topology = topology;
        this.knownAddresses = Collections.synchronizedSet(new HashSet());
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 0L, 3000L);
    }

    @Override
    public void run() {
        try {
            InetAddress[] curentAddresses = this.topology.getInetAddresses();
            HashSet<InetAddress> current = new HashSet<InetAddress>(curentAddresses.length);
            for (InetAddress address : curentAddresses) {
                current.add(address);
                if (this.knownAddresses.contains(address)) continue;
                this.topologyListener.inetAddressAdded(address);
            }
            for (InetAddress address : this.knownAddresses) {
                if (current.contains(address)) continue;
                this.topologyListener.inetAddressRemoved(address);
            }
            this.knownAddresses = current;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

