/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.settings;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.jrockit.jfr.settings.EventDefault;
import oracle.jrockit.jfr.settings.EventSetting;
import oracle.jrockit.jfr.settings.JFCParser;
import oracle.jrockit.jfr.settings.PresetFile;

@Deprecated
public final class EventDefaultSet {
    private final List<EventDefault> defaults = new ArrayList<EventDefault>();

    public EventDefaultSet(Collection<EventDefault> collection) {
        this.defaults.addAll(collection);
    }

    public EventDefaultSet(EventDefault ... eventDefaultArray) {
        this(Arrays.asList(eventDefaultArray));
    }

    public EventSetting get(URI uRI) {
        return this.get(uRI.toString());
    }

    public EventSetting get(String string) {
        for (int i = this.defaults.size(); i > 0; --i) {
            EventDefault eventDefault = this.defaults.get(i - 1);
            if (!eventDefault.matches(string)) continue;
            return eventDefault.getSetting();
        }
        return null;
    }

    public List<EventDefault> getAll() {
        return Collections.unmodifiableList(this.defaults);
    }

    public static EventDefaultSet create(Reader reader) throws IOException, URISyntaxException, ParseException {
        return JFCParser.createEventDefaultSet(PresetFile.readContent(reader));
    }

    public static EventDefaultSet create(File file) throws IOException, ParseException, URISyntaxException {
        try (FileReader fileReader = new FileReader(file);){
            EventDefaultSet eventDefaultSet = JFCParser.createEventDefaultSet(PresetFile.readContent(fileReader));
            return eventDefaultSet;
        }
    }

    public static EventDefaultSet create(String string) throws IOException, URISyntaxException, ParseException {
        return PresetFile.createFromName(string).getSettings();
    }
}

