/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSerializableSchema;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;

@JacksonStdImpl
public class SerializableSerializer
extends StdSerializer<JsonSerializable> {
    public static final SerializableSerializer instance = new SerializableSerializer();
    private static final AtomicReference<ObjectMapper> _mapperReference = new AtomicReference();

    protected SerializableSerializer() {
        super(JsonSerializable.class);
    }

    @Override
    public void serialize(JsonSerializable jsonSerializable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonSerializable.serialize(jsonGenerator, serializerProvider);
    }

    @Override
    public final void serializeWithType(JsonSerializable jsonSerializable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        jsonSerializable.serializeWithType(jsonGenerator, serializerProvider, typeSerializer);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        Class<?> clazz;
        ObjectNode objectNode = this.createObjectNode();
        String string = "any";
        String string2 = null;
        String string3 = null;
        if (type != null && (clazz = TypeFactory.rawClass(type)).isAnnotationPresent(JsonSerializableSchema.class)) {
            JsonSerializableSchema jsonSerializableSchema = clazz.getAnnotation(JsonSerializableSchema.class);
            string = jsonSerializableSchema.schemaType();
            if (!"##irrelevant".equals(jsonSerializableSchema.schemaObjectPropertiesDefinition())) {
                string2 = jsonSerializableSchema.schemaObjectPropertiesDefinition();
            }
            if (!"##irrelevant".equals(jsonSerializableSchema.schemaItemDefinition())) {
                string3 = jsonSerializableSchema.schemaItemDefinition();
            }
        }
        objectNode.put("type", string);
        if (string2 != null) {
            try {
                objectNode.put("properties", SerializableSerializer._getObjectMapper().readTree(string2));
            }
            catch (IOException iOException) {
                throw new JsonMappingException("Failed to parse @JsonSerializableSchema.schemaObjectPropertiesDefinition value");
            }
        }
        if (string3 != null) {
            try {
                objectNode.put("items", SerializableSerializer._getObjectMapper().readTree(string3));
            }
            catch (IOException iOException) {
                throw new JsonMappingException("Failed to parse @JsonSerializableSchema.schemaItemDefinition value");
            }
        }
        return objectNode;
    }

    private static final synchronized ObjectMapper _getObjectMapper() {
        ObjectMapper objectMapper = _mapperReference.get();
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            _mapperReference.set(objectMapper);
        }
        return objectMapper;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        jsonFormatVisitorWrapper.expectAnyFormat(javaType);
    }
}

