/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers.network;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.discoverers.NetworkDiscovery;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import processing.app.helpers.NetUtils;

public class BoardReachabilityFilter
extends TimerTask {
    private final NetworkDiscovery networkDiscovery;

    public BoardReachabilityFilter(NetworkDiscovery networkDiscovery) {
        this.networkDiscovery = networkDiscovery;
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 0L, 3000L);
    }

    @Override
    public void run() {
        List<BoardPort> boardPorts = this.networkDiscovery.getBoardPortsDiscoveredWithJmDNS();
        Iterator<BoardPort> boardPortIterator = boardPorts.iterator();
        while (boardPortIterator.hasNext()) {
            try {
                boolean reachable;
                BoardPort board = boardPortIterator.next();
                InetAddress inetAddress = InetAddress.getByName(board.getAddress());
                int broadcastedPort = Integer.valueOf((String)board.getPrefs().get("port"));
                LinkedList<Integer> ports = new LinkedList<Integer>();
                ports.add(broadcastedPort);
                if (broadcastedPort == 80) {
                    ports.add(0, 22);
                }
                if (reachable = NetUtils.isReachable(inetAddress, ports)) continue;
                boardPortIterator.remove();
            }
            catch (UnknownHostException e) {
                boardPortIterator.remove();
            }
        }
        this.networkDiscovery.setReachableBoardPorts(boardPorts);
    }
}

