/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.LibrariesIndex;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.mrbean.MrBeanModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.helpers.FileUtils;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.packages.LegacyUserLibrary;
import processing.app.packages.LibraryList;
import processing.app.packages.UserLibrary;

public class LibrariesIndexer {
    private LibrariesIndex index;
    private final LibraryList installedLibraries = new LibraryList();
    private final LibraryList installedLibrariesWithDuplicates = new LibraryList();
    private List<File> librariesFolders;
    private final File indexFile;
    private final File stagingFolder;
    private File sketchbookLibrariesFolder;

    public LibrariesIndexer(File preferencesFolder) {
        this.indexFile = new File(preferencesFolder, "library_index.json");
        this.stagingFolder = new File(preferencesFolder, "staging" + File.separator + "libraries");
    }

    public void parseIndex() throws IOException {
        this.parseIndex(this.indexFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseIndex(File indexFile) throws IOException {
        FileInputStream indexIn = null;
        try {
            indexIn = new FileInputStream(indexFile);
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new MrBeanModule());
            mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            mapper.configure(DeserializationFeature.EAGER_DESERIALIZER_FETCH, true);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.index = (LibrariesIndex)mapper.readValue((InputStream)indexIn, LibrariesIndex.class);
            for (ContributedLibrary library : this.index.getLibraries()) {
                if (library.getCategory() != null && !"".equals(library.getCategory())) continue;
                library.setCategory("Uncategorized");
            }
        }
        finally {
            if (indexIn != null) {
                ((InputStream)indexIn).close();
            }
        }
    }

    public void setLibrariesFolders(List<File> _librariesFolders) {
        this.librariesFolders = _librariesFolders;
        this.rescanLibraries();
    }

    public void rescanLibraries() {
        this.installedLibraries.clear();
        this.installedLibrariesWithDuplicates.clear();
        for (ContributedLibrary lib : this.index.getLibraries()) {
            lib.setInstalled(false);
        }
        for (File folder : this.librariesFolders) {
            this.scanInstalledLibraries(folder, folder.equals(this.sketchbookLibrariesFolder));
        }
    }

    private void scanInstalledLibraries(File folder, boolean isSketchbook) {
        File[] list = folder.listFiles(OnlyDirs.ONLY_DIRS);
        if (list == null) {
            return;
        }
        for (File subfolder : list) {
            if (!BaseNoGui.isSanitaryName(subfolder.getName())) {
                String mess = I18n.format(I18n._("The library \"{0}\" cannot be used.\nLibrary names must contain only basic letters and numbers.\n(ASCII only and no spaces, and it cannot start with a number)"), subfolder.getName());
                BaseNoGui.showMessage(I18n._("Ignoring bad library name"), mess);
                continue;
            }
            try {
                this.scanLibrary(subfolder, isSketchbook);
            }
            catch (IOException e) {
                System.out.println(I18n.format(I18n._("Invalid library found in {0}: {1}"), subfolder, e.getMessage()));
            }
        }
    }

    private void scanLibrary(File folder, boolean isSketchbook) throws IOException {
        boolean readOnly = !FileUtils.isSubDirectory(this.sketchbookLibrariesFolder, folder);
        File check = new File(folder, "library.properties");
        if (!check.exists() || !check.isFile()) {
            LegacyUserLibrary lib = LegacyUserLibrary.create(folder);
            lib.setReadOnly(readOnly);
            this.installedLibraries.addOrReplace(lib);
            if (isSketchbook) {
                this.installedLibrariesWithDuplicates.add(lib);
            } else {
                this.installedLibrariesWithDuplicates.addOrReplace(lib);
            }
            return;
        }
        UserLibrary lib = UserLibrary.create(folder);
        lib.setReadOnly(readOnly);
        this.installedLibraries.addOrReplace(lib);
        if (isSketchbook) {
            this.installedLibrariesWithDuplicates.add(lib);
        } else {
            this.installedLibrariesWithDuplicates.addOrReplace(lib);
        }
        ContributedLibrary foundLib = this.index.find(lib.getName(), lib.getParsedVersion());
        if (foundLib != null) {
            foundLib.setInstalled(true);
            foundLib.setInstalledFolder(folder);
            foundLib.setReadOnly(readOnly);
            lib.setTypes(foundLib.getTypes());
        }
        if (lib.isReadOnly() && lib.getTypes() == null && !lib.getDeclaredTypes().isEmpty()) {
            lib.setTypes(lib.getDeclaredTypes());
        }
        if (lib.getTypes() == null) {
            lib.setTypes(Arrays.asList("Contributed"));
        }
    }

    public LibrariesIndex getIndex() {
        return this.index;
    }

    public LibraryList getInstalledLibraries() {
        return this.installedLibraries;
    }

    public LibraryList getInstalledLibrariesWithDuplicates() {
        return this.installedLibrariesWithDuplicates;
    }

    public File getStagingFolder() {
        return this.stagingFolder;
    }

    public void setSketchbookLibrariesFolder(File folder) {
        this.sketchbookLibrariesFolder = folder;
    }

    public File getSketchbookLibrariesFolder() {
        return this.sketchbookLibrariesFolder;
    }

    public File getIndexFile() {
        return this.indexFile;
    }
}

