/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.ui;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FilterJTextField
extends JTextField {
    private final String filterHint;
    private boolean showingHint;
    private String lastFilter = "";

    public FilterJTextField(String hint) {
        super(hint);
        this.filterHint = hint;
        this.showingHint = true;
        this.updateStyle();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (FilterJTextField.this.getText().isEmpty()) {
                    FilterJTextField.this.showingHint = true;
                }
                FilterJTextField.this.updateStyle();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (FilterJTextField.this.showingHint) {
                    FilterJTextField.this.showingHint = false;
                    FilterJTextField.this.setText("");
                }
                FilterJTextField.this.updateStyle();
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FilterJTextField.this.applyFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FilterJTextField.this.applyFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FilterJTextField.this.applyFilter();
            }
        });
    }

    private void applyFilter() {
        String filter = this.showingHint ? "" : this.getText();
        filter = filter.toLowerCase();
        if ((filter = filter.replaceAll("[^\\x30-\\x39^\\x61-\\x7a^\\x3a]", " ")).equals(this.lastFilter)) {
            return;
        }
        this.lastFilter = filter;
        this.onFilter(filter.split(" "));
    }

    protected void onFilter(String[] strings) {
    }

    public void updateStyle() {
        if (this.showingHint) {
            this.setText(this.filterHint);
            this.setForeground(Color.gray);
            this.setFont(this.getFont().deriveFont(2));
        } else {
            this.setForeground(UIManager.getColor("TextField.foreground"));
            this.setFont(this.getFont().deriveFont(0));
        }
    }
}

