/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.GPGDetachedSignatureVerifier;
import cc.arduino.contributions.packages.Constants;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.ContributionsIndexer;
import cc.arduino.contributions.packages.DownloadableContribution;
import cc.arduino.contributions.packages.DownloadableContributionsDownloader;
import cc.arduino.contributions.packages.PackageIndexFilenameFilter;
import cc.arduino.filters.FileExecutablePredicate;
import cc.arduino.utils.ArchiveExtractor;
import cc.arduino.utils.MultiStepProgress;
import cc.arduino.utils.Progress;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.helpers.FileUtils;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.tools.CollectStdOutStdErrExecutor;

public class ContributionInstaller {
    private final ContributionsIndexer indexer;
    private final DownloadableContributionsDownloader downloader;

    public ContributionInstaller(ContributionsIndexer contributionsIndexer) {
        File stagingFolder = contributionsIndexer.getStagingFolder();
        this.indexer = contributionsIndexer;
        this.downloader = new DownloadableContributionsDownloader(stagingFolder){

            @Override
            protected void onProgress(Progress progress) {
                ContributionInstaller.this.onProgress(progress);
            }
        };
    }

    public List<String> install(ContributedPlatform platform) throws Exception {
        LinkedList<String> errors = new LinkedList<String>();
        if (platform.isInstalled()) {
            throw new Exception("Platform is already installed!");
        }
        LinkedList<ContributedTool> tools = new LinkedList<ContributedTool>(platform.getResolvedTools());
        Iterator toolsIterator = tools.iterator();
        while (toolsIterator.hasNext()) {
            ContributedTool tool = (ContributedTool)toolsIterator.next();
            DownloadableContribution downloadable = tool.getDownloadableContribution();
            if (downloadable == null) {
                throw new Exception(I18n.format(I18n._("Tool {0} is not available for your operating system."), tool.getName()));
            }
            if (!downloadable.isInstalled()) continue;
            toolsIterator.remove();
        }
        MultiStepProgress progress = new MultiStepProgress((tools.size() + 1) * 2);
        try {
            this.downloader.download(platform, progress, I18n._("Downloading boards definitions."));
            progress.stepDone();
            int i = 1;
            for (ContributedTool tool : tools) {
                String msg = I18n.format(I18n._("Downloading tools ({0}/{1})."), i, tools.size());
                ++i;
                this.downloader.download(tool.getDownloadableContribution(), progress, msg);
                progress.stepDone();
            }
        }
        catch (InterruptedException e) {
            return errors;
        }
        ContributedPackage pack = platform.getParentPackage();
        File packageFolder = new File(this.indexer.getPackagesFolder(), pack.getName());
        File toolsFolder = new File(packageFolder, "tools");
        int i = 1;
        for (ContributedTool tool : tools) {
            progress.setStatus(I18n.format(I18n._("Installing tools ({0}/{1})..."), i, tools.size()));
            this.onProgress(progress);
            ++i;
            DownloadableContribution toolContrib = tool.getDownloadableContribution();
            File destFolder = new File(toolsFolder, tool.getName() + File.separator + tool.getVersion());
            destFolder.mkdirs();
            assert (toolContrib.getDownloadedFile() != null);
            new ArchiveExtractor(BaseNoGui.getPlatform()).extract(toolContrib.getDownloadedFile(), destFolder, 1);
            try {
                this.executePostInstallScriptIfAny(destFolder);
            }
            catch (IOException e) {
                errors.add(I18n._("Error running post install script"));
            }
            toolContrib.setInstalled(true);
            toolContrib.setInstalledFolder(destFolder);
            progress.stepDone();
        }
        progress.setStatus(I18n._("Installing boards..."));
        this.onProgress(progress);
        File platformFolder = new File(packageFolder, "hardware" + File.separator + platform.getArchitecture());
        File destFolder = new File(platformFolder, platform.getParsedVersion());
        destFolder.mkdirs();
        new ArchiveExtractor(BaseNoGui.getPlatform()).extract(platform.getDownloadedFile(), destFolder, 1);
        platform.setInstalled(true);
        platform.setInstalledFolder(destFolder);
        progress.stepDone();
        progress.setStatus(I18n._("Installation completed!"));
        this.onProgress(progress);
        return errors;
    }

    private void executePostInstallScriptIfAny(File folder) throws IOException {
        Collection postInstallScripts = Collections2.filter(BaseNoGui.getPlatform().postInstallScripts(folder), (Predicate)new FileExecutablePredicate());
        if (postInstallScripts.isEmpty()) {
            String[] subfolders = folder.list(new OnlyDirs());
            if (subfolders.length != 1) {
                return;
            }
            this.executePostInstallScriptIfAny(new File(folder, subfolders[0]));
            return;
        }
        File postInstallScript = (File)postInstallScripts.iterator().next();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        CollectStdOutStdErrExecutor executor = new CollectStdOutStdErrExecutor(stdout, stderr);
        executor.setWorkingDirectory(folder);
        executor.setExitValues(null);
        int exitValue = executor.execute(new CommandLine(postInstallScript));
        executor.setExitValues(new int[0]);
        System.out.write(stdout.toByteArray());
        System.err.write(stderr.toByteArray());
        if (executor.isFailure(exitValue)) {
            throw new IOException();
        }
    }

    public List<String> remove(ContributedPlatform platform) {
        if (platform == null || platform.isReadOnly()) {
            return new LinkedList<String>();
        }
        LinkedList<String> errors = new LinkedList<String>();
        FileUtils.recursiveDelete(platform.getInstalledFolder());
        platform.setInstalled(false);
        platform.setInstalledFolder(null);
        for (ContributedTool tool : platform.getResolvedTools()) {
            if (this.indexer.isContributedToolUsed(tool)) continue;
            DownloadableContribution toolContrib = tool.getDownloadableContribution();
            File destFolder = toolContrib.getInstalledFolder();
            FileUtils.recursiveDelete(destFolder);
            toolContrib.setInstalled(false);
            toolContrib.setInstalledFolder(null);
            try {
                destFolder.getParentFile().delete();
            }
            catch (SecurityException e) {}
        }
        return errors;
    }

    public List<String> updateIndex() throws Exception {
        MultiStepProgress progress = new MultiStepProgress(1);
        LinkedList<String> downloadedPackageIndexFilesAccumulator = new LinkedList<String>();
        this.downloadIndexAndSignature(progress, downloadedPackageIndexFilesAccumulator, Constants.PACKAGE_INDEX_URL);
        HashSet<String> packageIndexURLs = new HashSet<String>();
        String additionalURLs = PreferencesData.get("boardsmanager.additional.urls", "");
        if (!"".equals(additionalURLs)) {
            packageIndexURLs.addAll(Arrays.asList(additionalURLs.split(",")));
        }
        for (String packageIndexURL : packageIndexURLs) {
            this.downloadIndexAndSignature(progress, downloadedPackageIndexFilesAccumulator, packageIndexURL);
        }
        progress.stepDone();
        return downloadedPackageIndexFilesAccumulator;
    }

    private void downloadIndexAndSignature(MultiStepProgress progress, List<String> downloadedPackagedIndexFilesAccumulator, String packageIndexUrl) throws Exception {
        File packageIndex = this.download(progress, packageIndexUrl);
        downloadedPackagedIndexFilesAccumulator.add(packageIndex.getName());
        try {
            File packageIndexSignature = this.download(progress, packageIndexUrl + ".sig");
            boolean signatureVerified = new GPGDetachedSignatureVerifier().verify(packageIndex, packageIndexSignature, new File(BaseNoGui.getContentFile("lib"), "public.gpg.key"));
            if (signatureVerified) {
                downloadedPackagedIndexFilesAccumulator.add(packageIndexSignature.getName());
            } else {
                downloadedPackagedIndexFilesAccumulator.remove(packageIndex.getName());
                packageIndex.delete();
                packageIndexSignature.delete();
                System.err.println(I18n.format(I18n._("{0} file signature verification failed. File ignored."), packageIndexUrl));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private File download(MultiStepProgress progress, String packageIndexUrl) throws Exception {
        String statusText = I18n._("Downloading platforms index...");
        URL url = new URL(packageIndexUrl);
        String[] urlPathParts = url.getFile().split("/");
        File outputFile = this.indexer.getIndexFile(urlPathParts[urlPathParts.length - 1]);
        File tmpFile = new File(outputFile.getAbsolutePath() + ".tmp");
        this.downloader.download(url, tmpFile, progress, statusText);
        if (outputFile.exists() && !outputFile.delete()) {
            throw new Exception("An error occurred while updating platforms index! I can't delete file " + outputFile);
        }
        if (!tmpFile.renameTo(outputFile)) {
            throw new Exception("An error occurred while updating platforms index! I can't rename file " + tmpFile);
        }
        return outputFile;
    }

    protected void onProgress(Progress progress) {
    }

    public void deleteUnknownFiles(List<String> downloadedPackageIndexFiles) {
        File preferencesFolder = this.indexer.getIndexFile(".").getParentFile();
        File[] additionalPackageIndexFiles = preferencesFolder.listFiles(new PackageIndexFilenameFilter("package_index.json"));
        if (additionalPackageIndexFiles == null) {
            return;
        }
        for (File additionalPackageIndexFile : additionalPackageIndexFiles) {
            if (downloadedPackageIndexFiles.contains(additionalPackageIndexFile.getName())) continue;
            additionalPackageIndexFile.delete();
        }
    }
}

