/*
 * Decompiled with CFR 0.152.
 */
package processing.app.macosx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemProfilerParser {
    private static final String DEVICE_PATH = "device_path";
    private static final String VID = "vid";
    private static final String PID = "pid";
    private static final String SERIAL_NUMBER = "serial_number";
    private static final String DEV_TTY_USBSERIAL = "/dev/tty.usbserial-";
    private static final String DEV_CU_USBSERIAL = "/dev/cu.usbserial-";
    private static final String DEV_TTY_USBMODEM = "/dev/tty.usbmodem";
    private static final String DEV_CU_USBMODEM = "/dev/cu.usbmodem";
    private final Pattern vidRegex;
    private final Pattern serialNumberRegex = Pattern.compile("^Serial Number: (.+)$");
    private final Pattern locationRegex = Pattern.compile("^Location ID: (.+)$");
    private final Pattern pidRegex = Pattern.compile("^Product ID: (.+)$");

    public SystemProfilerParser() {
        this.vidRegex = Pattern.compile("^Vendor ID: (.+)$");
    }

    public String extractVIDAndPID(String output, String serial) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(output));
        String devicePrefix = serial.startsWith(DEV_TTY_USBSERIAL) ? DEV_TTY_USBSERIAL : (serial.startsWith(DEV_CU_USBSERIAL) ? DEV_CU_USBSERIAL : (serial.startsWith(DEV_TTY_USBMODEM) ? DEV_TTY_USBMODEM : DEV_CU_USBMODEM));
        HashMap<String, String> device = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            Matcher matcher = this.serialNumberRegex.matcher(line = line.replaceAll("\\s+", " "));
            if (matcher.matches()) {
                device.put(SERIAL_NUMBER, matcher.group(1));
                if (!serial.startsWith(DEV_TTY_USBSERIAL) && !serial.startsWith(DEV_CU_USBSERIAL)) continue;
                String devicePath = devicePrefix + matcher.group(1);
                device.put(DEVICE_PATH, devicePath);
                continue;
            }
            if ((serial.startsWith(DEV_TTY_USBMODEM) || serial.startsWith(DEV_CU_USBMODEM)) && (matcher = this.locationRegex.matcher(line)).matches()) {
                String suffix = matcher.group(1).substring(2, 6).replaceAll("0", "");
                String devicePath = devicePrefix + suffix + "1";
                device.put(DEVICE_PATH, devicePath);
                continue;
            }
            matcher = this.pidRegex.matcher(line);
            if (matcher.matches()) {
                String pid = matcher.group(1);
                if (pid.indexOf(" ") > 0) {
                    pid = pid.substring(0, pid.indexOf(" "));
                }
                device.put(PID, pid);
                continue;
            }
            matcher = this.vidRegex.matcher(line);
            if (matcher.matches()) {
                String vid = matcher.group(1);
                if (vid.indexOf(" ") > 0) {
                    vid = vid.substring(0, vid.indexOf(" "));
                }
                device.put(VID, vid);
                continue;
            }
            if (!line.equals("")) continue;
            if (device.containsKey(DEVICE_PATH) && ((String)device.get(DEVICE_PATH)).equals(serial)) {
                return ((String)device.get(VID) + "_" + (String)device.get(PID)).toUpperCase();
            }
            device = new HashMap();
        }
        return null;
    }
}

