/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class EncryptedKeyResolver
extends KeyResolverSpi {
    private static Logger log = Logger.getLogger(EncryptedKeyResolver.class.getName());
    private Key kek;
    private String algorithm;
    private List<KeyResolverSpi> internalKeyResolvers;

    public EncryptedKeyResolver(String string) {
        this.kek = null;
        this.algorithm = string;
    }

    public EncryptedKeyResolver(String string, Key key) {
        this.algorithm = string;
        this.kek = key;
    }

    public void registerInternalKeyResolver(KeyResolverSpi keyResolverSpi) {
        if (this.internalKeyResolvers == null) {
            this.internalKeyResolvers = new ArrayList<KeyResolverSpi>();
        }
        this.internalKeyResolvers.add(keyResolverSpi);
    }

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        SecretKey secretKey;
        block8: {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "EncryptedKeyResolver - Can I resolve " + element.getTagName());
            }
            if (element == null) {
                return null;
            }
            secretKey = null;
            boolean bl = XMLUtils.elementIsInEncryptionSpace(element, "EncryptedKey");
            if (bl) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Passed an Encrypted Key");
                }
                try {
                    XMLCipher xMLCipher = XMLCipher.getInstance();
                    xMLCipher.init(4, this.kek);
                    if (this.internalKeyResolvers != null) {
                        int n = this.internalKeyResolvers.size();
                        for (int i = 0; i < n; ++i) {
                            xMLCipher.registerInternalKeyResolver(this.internalKeyResolvers.get(i));
                        }
                    }
                    EncryptedKey encryptedKey = xMLCipher.loadEncryptedKey(element);
                    secretKey = (SecretKey)xMLCipher.decryptKey(encryptedKey, this.algorithm);
                }
                catch (XMLEncryptionException xMLEncryptionException) {
                    if (!log.isLoggable(Level.FINE)) break block8;
                    log.log(Level.FINE, xMLEncryptionException.getMessage(), xMLEncryptionException);
                }
            }
        }
        return secretKey;
    }
}

