/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignerOutputStream
extends ByteArrayOutputStream {
    private static Logger log = Logger.getLogger(SignerOutputStream.class.getName());
    final SignatureAlgorithm sa;

    public SignerOutputStream(SignatureAlgorithm signatureAlgorithm) {
        this.sa = signatureAlgorithm;
    }

    @Override
    public void write(byte[] byArray) {
        try {
            this.sa.update(byArray);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }

    @Override
    public void write(int n) {
        try {
            this.sa.update((byte)n);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Canonicalized SignedInfo:");
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i = n; i < n + n2; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
            log.log(Level.FINE, stringBuilder.toString());
        }
        try {
            this.sa.update(byArray, n, n2);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }
}

