/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.legacy.PApplet;

public class UpdateCheck
implements Runnable {
    Base base;
    String downloadURL = I18n._((String)"http://www.arduino.cc/latest.txt");
    static final long ONE_DAY = 86400000L;

    public UpdateCheck(Base base) {
        Thread thread = new Thread(this);
        this.base = base;
        thread.start();
    }

    @Override
    public void run() {
        Random r = new Random();
        long id = r.nextLong();
        String idString = PreferencesData.get((String)"update.id");
        if (idString != null) {
            id = Long.parseLong(idString);
        } else {
            PreferencesData.set((String)"update.id", (String)String.valueOf(id));
        }
        try {
            long when;
            String info = URLEncoder.encode(id + "\t" + PApplet.nf((int)10604, (int)4) + "\t" + System.getProperty("java.version") + "\t" + System.getProperty("java.vendor") + "\t" + System.getProperty("os.name") + "\t" + System.getProperty("os.version") + "\t" + System.getProperty("os.arch"), "UTF-8");
            int latest = this.readInt(this.downloadURL + "?" + info);
            String lastString = PreferencesData.get((String)"update.last");
            long now = System.currentTimeMillis();
            if (lastString != null && now - (when = Long.parseLong(lastString)) < 86400000L) {
                return;
            }
            PreferencesData.set((String)"update.last", (String)String.valueOf(now));
            String prompt = I18n._((String)"A new version of Arduino is available,\nwould you like to visit the Arduino download page?");
            if (this.base.activeEditor != null && latest > 10604) {
                Object[] options = new Object[]{I18n._((String)"Yes"), I18n._((String)"No")};
                int result = JOptionPane.showOptionDialog(this.base.activeEditor, prompt, I18n._((String)"Update"), 0, 3, null, options, options[0]);
                if (result == 0) {
                    Base.openURL(I18n._((String)"http://www.arduino.cc/en/Main/Software"));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readInt(String filename) throws IOException {
        URL url = new URL(filename);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            int n = Integer.parseInt(reader.readLine());
            return n;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

