/*
 * Decompiled with CFR 0.152.
 */
package processing.app.macosx;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import java.io.File;
import java.util.List;
import processing.app.Base;
import processing.app.Editor;

public class ThinkDifferent {
    private static final int MAX_WAIT_FOR_BASE = 10000;

    public static void init() {
        Application application = Application.getApplication();
        application.setAboutHandler(new AboutHandler(){

            public void handleAbout(AppEvent.AboutEvent aboutEvent) {
                if (ThinkDifferent.waitForBase()) {
                    Base.INSTANCE.handleAbout();
                }
            }
        });
        application.setPreferencesHandler(new PreferencesHandler(){

            public void handlePreferences(AppEvent.PreferencesEvent preferencesEvent) {
                if (ThinkDifferent.waitForBase()) {
                    Base.INSTANCE.handlePrefs();
                }
            }
        });
        application.setOpenFileHandler(new OpenFilesHandler(){

            public void openFiles(AppEvent.OpenFilesEvent openFilesEvent) {
                if (ThinkDifferent.waitForBase()) {
                    for (File file : openFilesEvent.getFiles()) {
                        try {
                            Base.INSTANCE.handleOpen(file);
                            List<Editor> editors = Base.INSTANCE.getEditors();
                            if (editors.size() != 2 || !editors.get(0).getSketch().isUntitled()) continue;
                            Base.INSTANCE.handleClose(editors.get(0));
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        });
        application.setQuitHandler(new QuitHandler(){

            public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, QuitResponse quitResponse) {
                if (ThinkDifferent.waitForBase()) {
                    if (Base.INSTANCE.handleClose(Base.INSTANCE.getActiveEditor())) {
                        quitResponse.performQuit();
                    } else {
                        quitResponse.cancelQuit();
                    }
                }
            }
        });
    }

    private static boolean waitForBase() {
        int slept = 0;
        while (Base.INSTANCE == null) {
            if (slept >= 10000) {
                return false;
            }
            ThinkDifferent.sleep(100);
            slept += 100;
        }
        return true;
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

