/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;
import processing.app.helpers.ProcessUtils;
import processing.app.helpers.StringUtils;

public abstract class Uploader
implements MessageConsumer {
    private static final List<String> STRINGS_TO_SUPPRESS = Arrays.asList("Connecting to programmer:", "Found programmer: Id = \"CATERIN\"; type = S", "Software Version = 1.0; No Hardware Version given.", "Programmer supports auto addr increment.", "Programmer supports buffered memory access with buffersize=128 bytes.", "Programmer supports the following devices:", "Device code: 0x44");
    private static final List<String> AVRDUDE_PROBLEMS = Arrays.asList("Programmer is not responding", "programmer is not responding", "protocol error", "avrdude: ser_open(): can't open device", "avrdude: ser_drain(): read error", "avrdude: ser_send(): write error", "avrdude: error: buffered memory access not supported.");
    protected final boolean verbose = PreferencesData.getBoolean("upload.verbose");
    private String error;
    protected boolean notFoundError;
    protected boolean noUploadPort;

    protected Uploader() {
        this.init(false);
    }

    protected Uploader(boolean nup) {
        this.init(nup);
    }

    private void init(boolean nup) {
        this.error = null;
        this.notFoundError = false;
        this.noUploadPort = nup;
    }

    public abstract boolean uploadUsingPreferences(File var1, String var2, String var3, boolean var4, List<String> var5) throws Exception;

    public abstract boolean burnBootloader() throws Exception;

    public boolean requiresAuthorization() {
        return false;
    }

    public String getAuthorizationKey() {
        return null;
    }

    protected boolean executeUploadCommand(Collection<String> command) throws Exception {
        return this.executeUploadCommand(command.toArray(new String[command.size()]));
    }

    protected boolean executeUploadCommand(String[] command) throws Exception {
        if (command == null || command.length == 0) {
            return true;
        }
        this.notFoundError = false;
        int result = -1;
        try {
            if (this.verbose) {
                for (String c : command) {
                    System.out.print(c + " ");
                }
                System.out.println();
            }
            Process process = ProcessUtils.exec(command);
            new MessageSiphon(process.getInputStream(), this, 100);
            new MessageSiphon(process.getErrorStream(), this, 100);
            result = process.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.error != null) {
            RunnerException exception = new RunnerException(this.error);
            exception.hideStackTrace();
            throw exception;
        }
        return result == 0;
    }

    @Override
    public void message(String s) {
        if (!this.verbose && StringUtils.stringContainsOneOf(s, STRINGS_TO_SUPPRESS)) {
            s = "";
        }
        System.err.print(s);
        if (s.contains("Error")) {
            this.notFoundError = true;
            return;
        }
        if (this.notFoundError) {
            this.error = I18n.format(I18n._("the selected serial port {0} does not exist or your board is not connected"), s);
            return;
        }
        if (s.contains("Device is not responding")) {
            this.error = I18n._("Device is not responding, check the right serial port is selected or RESET the board right before exporting");
            return;
        }
        if (StringUtils.stringContainsOneOf(s, AVRDUDE_PROBLEMS)) {
            this.error = I18n._("Problem uploading to board.  See http://www.arduino.cc/en/Guide/Troubleshooting#upload for suggestions.");
            return;
        }
        if (s.contains("Expected signature")) {
            this.error = I18n._("Wrong microcontroller found.  Did you select the right board from the Tools > Board menu?");
            return;
        }
    }
}

