/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.legacy.PApplet;
import processing.app.packages.UserLibrary;
import processing.app.syntax.CTokenMarker;
import processing.app.syntax.KeywordMap;

public class PdeKeywords
extends CTokenMarker {
    static KeywordMap keywordColoring;
    static Hashtable keywordToReference;

    public PdeKeywords() {
        super(false, PdeKeywords.getKeywords());
    }

    public static KeywordMap getKeywords() {
        if (keywordColoring == null) {
            try {
                keywordColoring = new KeywordMap(false);
                keywordToReference = new Hashtable();
                PdeKeywords.getKeywords(new File(BaseNoGui.getContentFile((String)"lib"), "keywords.txt"));
                for (UserLibrary lib : Base.getLibraries()) {
                    File keywords = new File(lib.getInstalledFolder(), "keywords.txt");
                    if (!keywords.exists()) continue;
                    PdeKeywords.getKeywords(keywords);
                }
            }
            catch (Exception e) {
                Base.showError("Problem loading keywords", "Could not load keywords.txt,\nplease re-install Arduino.", e);
                System.exit(1);
            }
        }
        return keywordColoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getKeywords(File input) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(input)));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String htmlFilename;
                String[] pieces = PApplet.split((String)line, (char)'\t');
                if (pieces.length < 2) continue;
                String keyword = pieces[0].trim();
                String coloring = pieces[1].trim();
                if (coloring.length() > 0 && Character.isDigit(coloring.charAt(coloring.length() - 1))) {
                    boolean isKey = coloring.charAt(0) == 'K';
                    int num = coloring.charAt(coloring.length() - 1) - 49;
                    byte id = (byte)((isKey ? 6 : 3) + num);
                    keywordColoring.add(keyword, id);
                }
                if (pieces.length < 3 || (htmlFilename = pieces[2].trim()).length() <= 0) continue;
                keywordToReference.put(keyword, htmlFilename);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static String getReference(String keyword) {
        return (String)keywordToReference.get(keyword);
    }
}

