/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.VersionHelper;
import com.github.zafarkhaja.semver.Version;
import java.io.File;

public abstract class DownloadableContribution {
    private boolean installed;
    private File installedFolder;
    private boolean downloaded;
    private File downloadedFile;
    private boolean readOnly;

    public abstract String getUrl();

    public abstract String getVersion();

    public abstract String getChecksum();

    public abstract long getSize();

    public abstract String getArchiveFileName();

    public boolean isDownloaded() {
        return this.downloaded;
    }

    public void setDownloaded(boolean downloaded) {
        this.downloaded = downloaded;
    }

    public File getDownloadedFile() {
        return this.downloadedFile;
    }

    public void setDownloadedFile(File downloadedFile) {
        this.downloadedFile = downloadedFile;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public File getInstalledFolder() {
        return this.installedFolder;
    }

    public void setInstalledFolder(File installedFolder) {
        this.installedFolder = installedFolder;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getParsedVersion() {
        Version version = VersionHelper.valueOf(this.getVersion());
        if (version == null) {
            return null;
        }
        return version.toString();
    }

    public String toString() {
        String res = "";
        if (this.installed) {
            res = res + "installed on " + this.installedFolder.getAbsolutePath() + " (" + this.getSize() + " bytes)";
        }
        return res;
    }
}

