/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.Environment;
import com.sun.deploy.ref.Helpers;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DeploymentHooks {
    static boolean usageTrackerFailed = false;
    Object usageTracker;
    Method runMethod;
    private static final String USAGE_TRACKER_APP_NAME_KEY = "UsageTracker-AppName";

    private boolean initialize() {
        if (usageTrackerFailed) {
            return false;
        }
        if (this.runMethod == null) {
            try {
                Class<?> clazz = Class.forName("sun.usagetracker.UsageTrackerClient", true, null);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                this.usageTracker = constructor.newInstance(new Object[0]);
                this.runMethod = clazz.getMethod("run", String.class, String.class);
            }
            catch (Throwable throwable) {
                usageTrackerFailed = true;
                return false;
            }
        }
        return true;
    }

    public synchronized void storeAppName(String string) {
        System.setProperty(USAGE_TRACKER_APP_NAME_KEY, string);
    }

    private synchronized String getAndClearAppName() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty(DeploymentHooks.USAGE_TRACKER_APP_NAME_KEY);
                System.clearProperty(DeploymentHooks.USAGE_TRACKER_APP_NAME_KEY);
                return string;
            }
        });
        return string;
    }

    public synchronized void trackUsage(AppInfo appInfo, DeploymentRuleSet deploymentRuleSet) {
        if (!this.initialize()) {
            return;
        }
        String string = this.getAndClearAppName();
        if (string == null) {
            return;
        }
        try {
            String string2;
            String string3 = null;
            if (Environment.isOldPlugin()) {
                string3 = "plugin";
            } else if (Environment.isJavaPlugin()) {
                string3 = Environment.isJavawsAppletLifecycle() ? "javaws applet" : "plugin2";
            } else if (Environment.isJavaWebStart()) {
                string3 = "javaws application";
            }
            if (deploymentRuleSet.isRuleBlock()) {
                string3 = string3 + " denied";
                if (deploymentRuleSet.getBlockString() != null) {
                    string3 = string3 + " [" + deploymentRuleSet.getBlockString() + "]";
                }
            } else if (deploymentRuleSet.isRuleRun()) {
                string2 = deploymentRuleSet.getVersionString();
                string3 = string2 == null || SecureStaticVersioning.satisfiesDRSVersion(string2) ? string3 + " permitted" : string3 + " denied [required version " + string2 + " not available]";
            }
            string2 = Helpers.storeAppModelToString(appInfo.getAppModel());
            string = string + " app_model=" + string2;
            Object[] objectArray = new Object[]{string3, string};
            this.runMethod.invoke(this.usageTracker, objectArray);
        }
        catch (Throwable throwable) {
            Trace.println("Error invoking UsageTracker:", TraceLevel.BASIC);
            Trace.ignored(throwable);
        }
    }
}

