/*
 * Decompiled with CFR 0.152.
 */
package processing.app.macosx;

import cc.arduino.packages.BoardPort;
import com.apple.eio.FileManager;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.StringUtils;
import processing.app.debug.TargetPackage;
import processing.app.legacy.PApplet;
import processing.app.legacy.PConstants;
import processing.app.macosx.SystemProfilerParser;
import processing.app.tools.CollectStdOutExecutor;

public class Platform
extends processing.app.Platform {
    private String osArch;
    static final int kDocumentsFolderType = 1685021555;
    static final int kDomainLibraryFolderType = 1684826466;
    static final short kUserDomain = -32763;

    @Override
    public void setLookAndFeel() throws Exception {
    }

    public Platform() {
        Toolkit.getDefaultToolkit();
    }

    @Override
    public void init() throws IOException {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.discoverRealOsArch();
    }

    private void discoverRealOsArch() throws IOException {
        CommandLine uname = CommandLine.parse((String)"uname -m");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CollectStdOutExecutor executor = new CollectStdOutExecutor(baos);
        executor.execute(uname);
        this.osArch = StringUtils.trim((String)new String(baos.toByteArray()));
    }

    @Override
    public File getSettingsFolder() throws Exception {
        return new File(this.getLibraryFolder(), "Arduino15");
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        return new File(this.getDocumentsFolder(), "Arduino");
    }

    @Override
    public void openURL(String url) throws Exception {
        if (PApplet.javaVersion < 1.6f) {
            if (url.startsWith("http")) {
                try {
                    Class<?> eieio = Class.forName("com.apple.eio.FileManager");
                    Method openMethod = eieio.getMethod("openURL", String.class);
                    openMethod.invoke(null, url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                PApplet.open(url);
            }
        } else {
            try {
                Class<?> desktopClass = Class.forName("java.awt.Desktop");
                Method getMethod = desktopClass.getMethod("getDesktop", new Class[0]);
                Object desktop = getMethod.invoke(null, new Object[0]);
                if (url.startsWith("http")) {
                    Method browseMethod = desktopClass.getMethod("browse", URI.class);
                    browseMethod.invoke(desktop, new URI(url));
                } else {
                    Method openMethod = desktopClass.getMethod("open", File.class);
                    openMethod.invoke(desktop, new File(url));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean openFolderAvailable() {
        return true;
    }

    @Override
    public void openFolder(File file) throws Exception {
        PApplet.open(file.getAbsolutePath());
    }

    protected String getLibraryFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1684826466);
    }

    protected String getDocumentsFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1685021555);
    }

    @Override
    public String getName() {
        return PConstants.platformNames[2];
    }

    @Override
    public Map<String, Object> resolveDeviceAttachedTo(String serial, Map<String, TargetPackage> packages, String devicesListOutput) {
        assert (packages != null);
        if (devicesListOutput == null) {
            return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
        }
        try {
            String vidPid = new SystemProfilerParser().extractVIDAndPID(devicesListOutput, serial);
            if (vidPid == null) {
                return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
            }
            return super.resolveDeviceByVendorIdProductId(packages, vidPid);
        }
        catch (IOException e) {
            return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
        }
    }

    @Override
    public String preListAllCandidateDevices() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CollectStdOutExecutor executor = new CollectStdOutExecutor(baos);
        try {
            CommandLine toDevicePath = CommandLine.parse((String)"/usr/sbin/system_profiler SPUSBDataType");
            executor.execute(toDevicePath);
            return new String(baos.toByteArray());
        }
        catch (Throwable e) {
            return super.preListAllCandidateDevices();
        }
    }

    @Override
    public List<BoardPort> filterPorts(List<BoardPort> ports, boolean showAll) {
        if (showAll) {
            return super.filterPorts(ports, true);
        }
        LinkedList<BoardPort> filteredPorts = new LinkedList<BoardPort>();
        for (BoardPort port : ports) {
            if (port.getAddress().startsWith("/dev/tty.")) continue;
            filteredPorts.add(port);
        }
        return filteredPorts;
    }

    @Override
    public String getOsArch() {
        return this.osArch;
    }
}

