/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.debug.LegacyTargetBoard;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.PreferencesMap;

public class LegacyTargetPlatform
implements TargetPlatform {
    private String id;
    private File folder;
    private TargetPackage containerPackage;
    protected PreferencesMap preferences = new PreferencesMap();
    private Map<String, TargetBoard> boards = new LinkedHashMap<String, TargetBoard>();
    private TargetBoard defaultBoard;
    private Map<String, PreferencesMap> programmers = new LinkedHashMap<String, PreferencesMap>();
    private PreferencesMap customMenus = new PreferencesMap();

    public LegacyTargetPlatform(String _name, File _folder, TargetPackage parent) throws TargetPlatformException {
        this.id = _name;
        this.folder = _folder;
        this.containerPackage = parent;
        File boardsFile = new File(this.folder, "boards.txt");
        if (!boardsFile.exists() || !boardsFile.canRead()) {
            throw new TargetPlatformException(I18n.format(I18n._("Could not find boards.txt in {0}. Is it pre-1.5?"), this.folder.getAbsolutePath()));
        }
        try {
            Map<String, PreferencesMap> boardsPreferences = new PreferencesMap(boardsFile).firstLevelMap();
            PreferencesMap menus = boardsPreferences.get("menu");
            if (menus != null) {
                this.customMenus = menus.topLevelMap();
            }
            boardsPreferences.remove("menu");
            Set<String> boardIds = boardsPreferences.keySet();
            for (String boardId : boardIds) {
                PreferencesMap preferences = boardsPreferences.get(boardId);
                LegacyTargetBoard board = new LegacyTargetBoard(boardId, preferences, this);
                this.boards.put(boardId, board);
                if (this.defaultBoard != null) continue;
                this.defaultBoard = board;
            }
        }
        catch (IOException e) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), boardsFile.getAbsolutePath()), e);
        }
        File platformsFile = new File(this.folder, "platform.txt");
        try {
            if (platformsFile.exists() && platformsFile.canRead()) {
                this.preferences.load(platformsFile);
            }
        }
        catch (IOException e) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), platformsFile.getAbsolutePath()), e);
        }
        File localPlatformsFile = new File(this.folder, "platform.local.txt");
        try {
            if (localPlatformsFile.exists() && localPlatformsFile.canRead()) {
                this.preferences.load(localPlatformsFile);
            }
        }
        catch (IOException e) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), localPlatformsFile.getAbsolutePath()), e);
        }
        if (!this.preferences.containsKey("rewriting") || !"disabled".equals(this.preferences.get("rewriting"))) {
            try {
                this.rewriteKeysOfOldPlatformsTxtAndWarnAboutIt();
            }
            catch (IOException e) {
                throw new TargetPlatformException(e);
            }
        }
        File progFile = new File(this.folder, "programmers.txt");
        try {
            if (progFile.exists() && progFile.canRead()) {
                PreferencesMap prefs = new PreferencesMap();
                prefs.load(progFile);
                this.programmers = prefs.firstLevelMap();
            }
        }
        catch (IOException e) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), progFile.getAbsolutePath()), e);
        }
    }

    private void rewriteKeysOfOldPlatformsTxtAndWarnAboutIt() throws IOException {
        File platformRewrite = new File(BaseNoGui.getHardwareFolder(), "platform.keys.rewrite.txt");
        PreferencesMap platformRewriteProps = new PreferencesMap(platformRewrite);
        PreferencesMap oldProps = platformRewriteProps.subTree("old");
        PreferencesMap newProps = platformRewriteProps.subTree("new");
        String platformName = (String)this.preferences.get("name");
        if (platformName == null) {
            platformName = this.folder.getAbsolutePath();
        }
        for (Map.Entry entry : oldProps.entrySet()) {
            String preferencesKey = ((String)entry.getKey()).substring(((String)entry.getKey()).indexOf(".") + 1);
            if (!this.preferences.containsKey(preferencesKey) || !((String)entry.getValue()).equals(this.preferences.get(preferencesKey))) continue;
            System.err.println(I18n.format(I18n._("Warning: platform.txt from core '{0}' contains deprecated {1}, automatically converted to {2}. Consider upgrading this core."), platformName, preferencesKey + "=" + (String)entry.getValue(), preferencesKey + "=" + (String)newProps.get(entry.getKey())));
            this.preferences.put(preferencesKey, newProps.get(entry.getKey()));
        }
        PreferencesMap addedProps = platformRewriteProps.subTree("added");
        for (Map.Entry entry : addedProps.entrySet()) {
            String keyToAdd = (String)entry.getKey();
            String[] keyToAddParts = keyToAdd.split("\\.");
            String keyToAddFirstLevel = keyToAddParts[0];
            String keyToAddSecondLevel = keyToAddParts[0] + "." + keyToAddParts[1];
            if (this.preferences.subTree(keyToAddFirstLevel).isEmpty() || this.preferences.subTree(keyToAddSecondLevel).isEmpty() || this.preferences.containsKey(keyToAdd)) continue;
            System.err.println(I18n.format(I18n._("Warning: platform.txt from core '{0}' misses property {1}, automatically set to {2}. Consider upgrading this core."), platformName, keyToAdd, entry.getValue()));
            this.preferences.put(keyToAdd, entry.getValue());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public File getFolder() {
        return this.folder;
    }

    @Override
    public Map<String, TargetBoard> getBoards() {
        return this.boards;
    }

    @Override
    public PreferencesMap getCustomMenus() {
        return this.customMenus;
    }

    @Override
    public Set<String> getCustomMenuIds() {
        return this.customMenus.keySet();
    }

    @Override
    public Map<String, PreferencesMap> getProgrammers() {
        return this.programmers;
    }

    @Override
    public PreferencesMap getProgrammer(String programmer) {
        return this.getProgrammers().get(programmer);
    }

    @Override
    public PreferencesMap getTool(String tool) {
        return this.getPreferences().subTree("tools").subTree(tool);
    }

    @Override
    public PreferencesMap getPreferences() {
        return this.preferences;
    }

    @Override
    public TargetBoard getBoard(String boardId) {
        if (this.boards.containsKey(boardId)) {
            return this.boards.get(boardId);
        }
        return this.defaultBoard;
    }

    @Override
    public TargetPackage getContainerPackage() {
        return this.containerPackage;
    }

    public String toString() {
        String res = "TargetPlatform: name=" + this.id + " boards={\n";
        for (String boardId : this.boards.keySet()) {
            res = res + "  " + boardId + " = " + this.boards.get(boardId) + "\n";
        }
        return res + "}";
    }
}

