/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.DownloadableContributionBuiltInAtTheBottomComparator;
import cc.arduino.contributions.GPGDetachedSignatureVerifier;
import cc.arduino.contributions.SignatureVerificationFailedException;
import cc.arduino.contributions.filters.BuiltInPredicate;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.packages.Constants;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributedTargetPackage;
import cc.arduino.contributions.packages.ContributedTargetPlatform;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.ContributionsIndex;
import cc.arduino.contributions.packages.DownloadableContribution;
import cc.arduino.contributions.packages.PackageIndexFilenameFilter;
import cc.arduino.contributions.packages.TestPackageIndexFilenameFilter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.mrbean.MrBeanModule;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import processing.app.BaseNoGui;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.filefilters.OnlyDirs;

public class ContributionsIndexer {
    private final File packagesFolder;
    private final File stagingFolder;
    private final File preferencesFolder;
    private ContributionsIndex index;

    public ContributionsIndexer(File preferencesFolder) {
        this.preferencesFolder = preferencesFolder;
        this.packagesFolder = new File(preferencesFolder, "packages");
        this.stagingFolder = new File(preferencesFolder, "staging" + File.separator + "packages");
    }

    public void parseIndex() throws Exception {
        File[] indexFiles;
        File defaultIndexFile = this.getIndexFile("package_index.json");
        if (!this.isSigned(defaultIndexFile)) {
            throw new SignatureVerificationFailedException("package_index.json");
        }
        this.index = this.parseIndex(defaultIndexFile);
        for (File indexFile : indexFiles = this.preferencesFolder.listFiles(new TestPackageIndexFilenameFilter(new PackageIndexFilenameFilter("package_index.json")))) {
            ContributionsIndex contributionsIndex = this.parseIndex(indexFile);
            this.mergeContributions(contributionsIndex, indexFile);
        }
        List<ContributedPackage> packages = this.index.getPackages();
        for (ContributedPackage pack : packages) {
            for (ContributedPlatform platform : pack.getPlatforms()) {
                platform.setParentPackage(pack);
                platform.resolveToolsDependencies(packages);
            }
        }
        this.index.fillCategories();
    }

    private void mergeContributions(ContributionsIndex contributionsIndex, File indexFile) {
        boolean signed = this.isSigned(indexFile);
        for (ContributedPackage contributedPackage : contributionsIndex.getPackages()) {
            ContributedPackage targetPackage;
            if (!signed) {
                for (ContributedPlatform contributedPlatform : contributedPackage.getPlatforms()) {
                    contributedPlatform.setCategory("Contributed");
                }
            }
            if ((targetPackage = this.index.getPackage(contributedPackage.getName())) == null) {
                this.index.getPackages().add(contributedPackage);
                continue;
            }
            if (!signed && this.isPackageNameProtected(contributedPackage)) continue;
            List<ContributedPlatform> platforms = contributedPackage.getPlatforms();
            if (platforms == null) {
                platforms = new LinkedList<ContributedPlatform>();
            }
            for (ContributedPlatform contributedPlatform : platforms) {
                ContributedPlatform platform = targetPackage.findPlatform(contributedPlatform.getArchitecture(), contributedPlatform.getVersion());
                if (platform != null) {
                    targetPackage.getPlatforms().remove(platform);
                }
                targetPackage.getPlatforms().add(contributedPlatform);
            }
            List<ContributedTool> tools = contributedPackage.getTools();
            if (tools == null) {
                tools = new LinkedList<ContributedTool>();
            }
            for (ContributedTool contributedTool : tools) {
                ContributedTool tool = targetPackage.findTool(contributedTool.getName(), contributedTool.getVersion());
                if (tool != null) {
                    targetPackage.getTools().remove(tool);
                }
                targetPackage.getTools().add(contributedTool);
            }
        }
    }

    private boolean isPackageNameProtected(ContributedPackage contributedPackage) {
        return Constants.PROTECTED_PACKAGE_NAMES.contains(contributedPackage.getName());
    }

    private boolean isSigned(File indexFile) {
        File signature = new File(indexFile.getParent(), indexFile.getName() + ".sig");
        if (!signature.exists()) {
            return false;
        }
        try {
            return new GPGDetachedSignatureVerifier().verify(indexFile, signature, new File(BaseNoGui.getContentFile("lib"), "public.gpg.key"));
        }
        catch (Exception e) {
            BaseNoGui.showWarning(e.getMessage(), e.getMessage(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContributionsIndex parseIndex(File indexFile) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(indexFile);
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new MrBeanModule());
            mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            mapper.configure(DeserializationFeature.EAGER_DESERIALIZER_FETCH, true);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ContributionsIndex contributionsIndex = (ContributionsIndex)mapper.readValue((InputStream)inputStream, ContributionsIndex.class);
            return contributionsIndex;
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
    }

    public void syncWithFilesystem(File hardwareFolder) throws IOException {
        this.syncBuiltInHardwareFolder(hardwareFolder);
        this.syncLocalPackagesFolder();
    }

    public void syncBuiltInHardwareFolder(File hardwareFolder) throws IOException {
        if (this.index == null) {
            return;
        }
        for (File folder : hardwareFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
            ContributedPackage pack = this.index.findPackage(folder.getName());
            if (pack == null) continue;
            this.syncBuiltInPackageWithFilesystem(pack, folder);
            File toolsFolder = new File(hardwareFolder, "tools");
            if (!toolsFolder.isDirectory()) continue;
            for (File toolFolder : toolsFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                File builtInToolsMetadata = new File(toolFolder, "builtin_tools_versions.txt");
                if (!builtInToolsMetadata.isFile()) continue;
                PreferencesMap toolsMetadata = new PreferencesMap(builtInToolsMetadata).subTree(pack.getName());
                for (Map.Entry toolMetadata : toolsMetadata.entrySet()) {
                    this.syncToolWithFilesystem(pack, toolFolder, (String)toolMetadata.getKey(), (String)toolMetadata.getValue());
                }
            }
        }
    }

    private void syncBuiltInPackageWithFilesystem(ContributedPackage pack, File hardwareFolder) throws IOException {
        for (File platformFolder : hardwareFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
            File platformTxt = new File(platformFolder, "platform.txt");
            String version = (String)new PreferencesMap(platformTxt).get("version");
            ContributedPlatform platform = this.syncHardwareWithFilesystem(pack, platformFolder, platformFolder.getName(), version);
            if (platform == null) continue;
            platform.setReadOnly(true);
        }
    }

    public void syncLocalPackagesFolder() {
        if (!this.packagesFolder.isDirectory()) {
            return;
        }
        if (this.index == null) {
            return;
        }
        for (File folder : this.packagesFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
            ContributedPackage pack = this.index.findPackage(folder.getName());
            if (pack == null) continue;
            this.syncPackageWithFilesystem(pack, folder);
        }
    }

    private void syncPackageWithFilesystem(ContributedPackage pack, File root) {
        File toolsFolder;
        File hardwareFolder = new File(root, "hardware");
        if (hardwareFolder.isDirectory()) {
            for (File platformFolder : hardwareFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                for (File versionFolder : platformFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                    this.syncHardwareWithFilesystem(pack, versionFolder, platformFolder.getName(), versionFolder.getName());
                }
            }
        }
        if ((toolsFolder = new File(root, "tools")).isDirectory()) {
            for (File toolFolder : toolsFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                for (File versionFolder : toolFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                    this.syncToolWithFilesystem(pack, versionFolder, toolFolder.getName(), versionFolder.getName());
                }
            }
        }
    }

    private void syncToolWithFilesystem(ContributedPackage pack, File installationFolder, String toolName, String version) {
        ContributedTool tool = pack.findTool(toolName, version);
        if (tool == null) {
            return;
        }
        DownloadableContribution contrib = tool.getDownloadableContribution();
        if (contrib == null) {
            System.err.println(tool + " seems to have no downloadable contributions for your operating system, but it is installed in\n" + installationFolder);
            return;
        }
        contrib.setInstalled(true);
        contrib.setInstalledFolder(installationFolder);
    }

    private ContributedPlatform syncHardwareWithFilesystem(ContributedPackage pack, File installationFolder, String architecture, String version) {
        ContributedPlatform platform = pack.findPlatform(architecture, version);
        if (platform != null) {
            platform.setInstalled(true);
            platform.setReadOnly(false);
            platform.setInstalledFolder(installationFolder);
        }
        return platform;
    }

    public String toString() {
        return this.index.toString();
    }

    public List<TargetPackage> createTargetPackages() throws TargetPlatformException {
        ArrayList<TargetPackage> packages = new ArrayList<TargetPackage>();
        if (this.index == null) {
            return packages;
        }
        for (ContributedPackage aPackage : this.index.getPackages()) {
            ContributedTargetPackage targetPackage = new ContributedTargetPackage(aPackage.getName());
            LinkedList platforms = new LinkedList(Collections2.filter(aPackage.getPlatforms(), (Predicate)new InstalledPredicate()));
            Collections.sort(platforms, new DownloadableContributionBuiltInAtTheBottomComparator());
            for (ContributedPlatform platform : platforms) {
                File folder;
                String arch = platform.getArchitecture();
                ContributedTargetPlatform targetPlatform = new ContributedTargetPlatform(arch, folder = platform.getInstalledFolder(), targetPackage, this.index);
                if (targetPackage.hasPlatform(targetPlatform)) continue;
                targetPackage.addPlatform(targetPlatform);
            }
            if (!targetPackage.hasPlatforms()) continue;
            packages.add(targetPackage);
        }
        return packages;
    }

    public boolean isContributedToolUsed(ContributedTool tool) {
        for (ContributedPackage pack : this.index.getPackages()) {
            for (ContributedPlatform platform : pack.getPlatforms()) {
                if (!platform.isInstalled()) continue;
                for (ContributedTool requiredTool : platform.getResolvedTools()) {
                    if (!requiredTool.equals(tool)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<ContributedTool> getInstalledTools() {
        HashSet<ContributedTool> tools = new HashSet<ContributedTool>();
        if (this.index == null) {
            return tools;
        }
        for (ContributedPackage pack : this.index.getPackages()) {
            Collection platforms = Collections2.filter(pack.getPlatforms(), (Predicate)new InstalledPredicate());
            ImmutableListMultimap platformsByName = Multimaps.index((Iterable)platforms, (Function)new Function<ContributedPlatform, String>(){

                public String apply(ContributedPlatform contributedPlatform) {
                    return contributedPlatform.getName();
                }
            });
            for (Map.Entry entry : platformsByName.asMap().entrySet()) {
                Collection platformsWithName = (Collection)entry.getValue();
                if (platformsWithName.size() > 1) {
                    platformsWithName = Collections2.filter((Collection)platformsWithName, (Predicate)Predicates.not((Predicate)new BuiltInPredicate()));
                }
                for (ContributedPlatform platform : platformsWithName) {
                    tools.addAll(platform.getResolvedTools());
                }
            }
        }
        return tools;
    }

    public ContributionsIndex getIndex() {
        return this.index;
    }

    public File getPackagesFolder() {
        return this.packagesFolder;
    }

    public File getStagingFolder() {
        return this.stagingFolder;
    }

    public File getIndexFile(String name) {
        return new File(this.preferencesFolder, name);
    }

    public List<ContributedPackage> getPackages() {
        if (this.index == null) {
            return new LinkedList<ContributedPackage>();
        }
        return this.index.getPackages();
    }

    public List<String> getCategories() {
        if (this.index == null) {
            return new LinkedList<String>();
        }
        return this.index.getCategories();
    }

    public ContributedPlatform getInstalled(String packageName, String platformArch) {
        if (this.index == null) {
            return null;
        }
        return this.index.getInstalled(packageName, platformArch);
    }
}

