/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.packages.ContributedBoard;
import cc.arduino.contributions.packages.ContributedHelp;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.ContributedToolReference;
import cc.arduino.contributions.packages.DownloadableContribution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class ContributedPlatform
extends DownloadableContribution {
    private List<ContributedTool> resolvedTools = null;
    private ContributedPackage parentPackage;

    public abstract String getName();

    public abstract String getCategory();

    public abstract void setCategory(String var1);

    public abstract String getArchitecture();

    @Override
    public abstract String getChecksum();

    public abstract List<ContributedToolReference> getToolsDependencies();

    public abstract List<ContributedBoard> getBoards();

    public abstract ContributedHelp getHelp();

    public List<ContributedTool> getResolvedTools() {
        if (this.resolvedTools == null) {
            return null;
        }
        return new LinkedList<ContributedTool>(this.resolvedTools);
    }

    public void resolveToolsDependencies(Collection<ContributedPackage> packages) {
        this.resolvedTools = new ArrayList<ContributedTool>();
        if (this.getToolsDependencies() == null) {
            return;
        }
        for (ContributedToolReference dep : this.getToolsDependencies()) {
            ContributedTool tool = dep.resolve(packages);
            if (tool == null) {
                System.err.println("Index error: could not find referenced tool " + dep);
            }
            this.resolvedTools.add(tool);
        }
    }

    public ContributedPackage getParentPackage() {
        return this.parentPackage;
    }

    public void setParentPackage(ContributedPackage parentPackage) {
        this.parentPackage = parentPackage;
    }

    @Override
    public String toString() {
        return this.getParsedVersion();
    }
}

