/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import sun.awt.AWTAccessor;
import sun.awt.AWTIcon32_security_icon_bw16_png;
import sun.awt.AWTIcon32_security_icon_bw24_png;
import sun.awt.AWTIcon32_security_icon_bw32_png;
import sun.awt.AWTIcon32_security_icon_bw48_png;
import sun.awt.AWTIcon32_security_icon_interim16_png;
import sun.awt.AWTIcon32_security_icon_interim24_png;
import sun.awt.AWTIcon32_security_icon_interim32_png;
import sun.awt.AWTIcon32_security_icon_interim48_png;
import sun.awt.AWTIcon32_security_icon_yellow16_png;
import sun.awt.AWTIcon32_security_icon_yellow24_png;
import sun.awt.AWTIcon32_security_icon_yellow32_png;
import sun.awt.AWTIcon32_security_icon_yellow48_png;
import sun.awt.IconInfo;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformEventNotifier;
import sun.lwawt.SecurityWarningWindow;
import sun.lwawt.macosx.CPlatformResponder;
import sun.lwawt.macosx.CPlatformView;
import sun.lwawt.macosx.CPlatformWindow;
import sun.lwawt.macosx.CWrapper;

public final class CWarningWindow
extends CPlatformWindow
implements SecurityWarningWindow,
PlatformEventNotifier {
    private final Lock lock = new Lock();
    private static final int SHOWING_DELAY = 300;
    private static final int HIDING_DELAY = 2000;
    private Rectangle bounds = new Rectangle();
    private final WeakReference<LWWindowPeer> ownerPeer;
    private final Window ownerWindow;
    private volatile int currentIcon = 0;
    private int currentSize = -1;
    private static IconInfo[][] icons;
    private final Runnable hidingTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CWarningWindow.this.lock;
            synchronized (object) {
                CWarningWindow.this.setVisible(false);
            }
            object = CWarningWindow.this.scheduler;
            synchronized (object) {
                CWarningWindow.this.hidingTaskHandle = null;
            }
        }
    };
    private final Runnable showingTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CWarningWindow.this.lock;
            synchronized (object) {
                if (!CWarningWindow.this.isVisible()) {
                    CWarningWindow.this.setVisible(true);
                }
                CWarningWindow.this.repaint();
            }
            object = CWarningWindow.this.scheduler;
            synchronized (object) {
                if (CWarningWindow.this.currentIcon > 0) {
                    CWarningWindow.this.currentIcon--;
                    CWarningWindow.this.showingTaskHandle = CWarningWindow.this.scheduler.schedule(CWarningWindow.this.showingTask, 300L, TimeUnit.MILLISECONDS);
                } else {
                    CWarningWindow.this.showingTaskHandle = null;
                }
            }
        }
    };
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture hidingTaskHandle;
    private ScheduledFuture showingTaskHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IconInfo getSecurityIconInfo(int n, int n2) {
        Class<CWarningWindow> clazz = CWarningWindow.class;
        synchronized (CWarningWindow.class) {
            if (icons == null) {
                icons = new IconInfo[4][3];
                CWarningWindow.icons[0][0] = new IconInfo(AWTIcon32_security_icon_bw16_png.security_icon_bw16_png);
                CWarningWindow.icons[0][1] = new IconInfo(AWTIcon32_security_icon_interim16_png.security_icon_interim16_png);
                CWarningWindow.icons[0][2] = new IconInfo(AWTIcon32_security_icon_yellow16_png.security_icon_yellow16_png);
                CWarningWindow.icons[1][0] = new IconInfo(AWTIcon32_security_icon_bw24_png.security_icon_bw24_png);
                CWarningWindow.icons[1][1] = new IconInfo(AWTIcon32_security_icon_interim24_png.security_icon_interim24_png);
                CWarningWindow.icons[1][2] = new IconInfo(AWTIcon32_security_icon_yellow24_png.security_icon_yellow24_png);
                CWarningWindow.icons[2][0] = new IconInfo(AWTIcon32_security_icon_bw32_png.security_icon_bw32_png);
                CWarningWindow.icons[2][1] = new IconInfo(AWTIcon32_security_icon_interim32_png.security_icon_interim32_png);
                CWarningWindow.icons[2][2] = new IconInfo(AWTIcon32_security_icon_yellow32_png.security_icon_yellow32_png);
                CWarningWindow.icons[3][0] = new IconInfo(AWTIcon32_security_icon_bw48_png.security_icon_bw48_png);
                CWarningWindow.icons[3][1] = new IconInfo(AWTIcon32_security_icon_interim48_png.security_icon_interim48_png);
                CWarningWindow.icons[3][2] = new IconInfo(AWTIcon32_security_icon_yellow48_png.security_icon_yellow48_png);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            int n3 = n % icons.length;
            return icons[n3][n2 % icons[n3].length];
        }
    }

    public CWarningWindow(Window window, LWWindowPeer lWWindowPeer) {
        this.ownerPeer = new WeakReference<LWWindowPeer>(lWWindowPeer);
        this.ownerWindow = window;
        this.initialize(null, null, lWWindowPeer.getPlatformWindow());
        this.setOpaque(false);
        String string = this.ownerWindow.getWarningString();
        if (string != null) {
            this.contentView.setToolTip(this.ownerWindow.getWarningString());
        }
        this.updateIconSize();
    }

    @Override
    public void reposition(int n, int n2, int n3, int n4) {
        Point2D point2D = AWTAccessor.getWindowAccessor().calculateSecurityWarningPosition(this.ownerWindow, n, n2, n3, n4);
        this.setBounds((int)point2D.getX(), (int)point2D.getY(), this.getWidth(), this.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean bl, boolean bl2) {
        ScheduledExecutorService scheduledExecutorService = this.scheduler;
        synchronized (scheduledExecutorService) {
            if (this.showingTaskHandle != null) {
                this.showingTaskHandle.cancel(false);
                this.showingTaskHandle = null;
            }
            if (this.hidingTaskHandle != null) {
                this.hidingTaskHandle.cancel(false);
                this.hidingTaskHandle = null;
            }
            if (bl) {
                this.currentIcon = this.isVisible() ? 0 : 2;
                this.showingTaskHandle = this.scheduler.schedule(this.showingTask, 50L, TimeUnit.MILLISECONDS);
            } else {
                if (!this.isVisible()) {
                    return;
                }
                this.hidingTaskHandle = bl2 ? this.scheduler.schedule(this.hidingTask, 2000L, TimeUnit.MILLISECONDS) : this.scheduler.schedule(this.hidingTask, 50L, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void notifyIconify(boolean bl) {
    }

    @Override
    public void notifyZoom(boolean bl) {
    }

    @Override
    public void notifyExpose(Rectangle rectangle) {
        this.repaint();
    }

    @Override
    public void notifyReshape(int n, int n2, int n3, int n4) {
    }

    @Override
    public void notifyUpdateCursor() {
    }

    @Override
    public void notifyActivation(boolean bl, LWWindowPeer lWWindowPeer) {
    }

    @Override
    public void notifyNCMouseDown() {
    }

    @Override
    public void notifyMouseEvent(int n, long l, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, byte[] byArray) {
        LWWindowPeer lWWindowPeer = (LWWindowPeer)this.ownerPeer.get();
        if (n == 505) {
            if (lWWindowPeer != null) {
                lWWindowPeer.updateSecurityWarningVisibility();
            }
        } else if (n == 504 && lWWindowPeer != null) {
            lWWindowPeer.updateSecurityWarningVisibility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        Lock lock = this.lock;
        synchronized (lock) {
            return this.bounds.getBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isVisible() {
        Lock lock = this.lock;
        synchronized (lock) {
            return this.visible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean bl) {
        Lock lock = this.lock;
        synchronized (lock) {
            long l = this.getNSWindowPtr();
            if (!bl && this.owner != null && this.owner.isVisible()) {
                CWrapper.NSWindow.removeChildWindow(this.owner.getNSWindowPtr(), l);
            }
            if (bl) {
                CWrapper.NSWindow.orderFront(l);
            } else {
                CWrapper.NSWindow.orderOut(l);
            }
            this.visible = bl;
            if (bl && this.owner != null && this.owner.isVisible()) {
                CWrapper.NSWindow.addChildWindow(this.owner.getNSWindowPtr(), l, 1);
                this.applyWindowLevel(this.ownerWindow);
            }
        }
    }

    @Override
    public void notifyMouseWheelEvent(long l, int n, int n2, int n3, int n4, int n5, int n6, double d, byte[] byArray) {
    }

    @Override
    public void notifyKeyEvent(int n, long l, int n2, int n3, char c, int n4) {
    }

    @Override
    protected int getInitialStyleBits() {
        int n = 0;
        CPlatformWindow.SET(n, 16, true);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deliverMoveResizeEvent(int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        Lock lock = this.lock;
        synchronized (lock) {
            bl2 = this.bounds.width != n3 || this.bounds.height != n4;
            this.bounds = new Rectangle(n, n2, n3, n4);
        }
        if (bl2) {
            this.replaceSurface();
        }
        super.deliverMoveResizeEvent(n, n2, n3, n4, bl);
    }

    @Override
    protected CPlatformResponder createPlatformResponder() {
        return new CPlatformResponder(this, false);
    }

    @Override
    protected CPlatformView createContentView() {
        return new CPlatformView(){

            @Override
            public GraphicsConfiguration getGraphicsConfiguration() {
                LWWindowPeer lWWindowPeer = (LWWindowPeer)CWarningWindow.this.ownerPeer.get();
                return lWWindowPeer.getGraphicsConfiguration();
            }

            @Override
            public Rectangle getBounds() {
                return CWarningWindow.this.getBounds();
            }

            @Override
            public CGLLayer createCGLayer() {
                return new CGLLayer(null){

                    @Override
                    public Rectangle getBounds() {
                        return CWarningWindow.this.getBounds();
                    }

                    @Override
                    public GraphicsConfiguration getGraphicsConfiguration() {
                        LWWindowPeer lWWindowPeer = (LWWindowPeer)CWarningWindow.this.ownerPeer.get();
                        return lWWindowPeer.getGraphicsConfiguration();
                    }

                    @Override
                    public boolean isOpaque() {
                        return false;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIconSize() {
        Object object;
        int n = -1;
        if (this.ownerWindow != null) {
            object = this.ownerWindow.getInsets();
            int n2 = Math.max(((Insets)object).top, Math.max(((Insets)object).bottom, Math.max(((Insets)object).left, ((Insets)object).right)));
            n = n2 < 24 ? 0 : (n2 < 32 ? 1 : (n2 < 48 ? 2 : 3));
        }
        if (n == -1) {
            n = 0;
        }
        object = this.lock;
        synchronized (object) {
            if (n != this.currentSize) {
                this.currentSize = n;
                IconInfo iconInfo = CWarningWindow.getSecurityIconInfo(this.currentSize, 0);
                AWTAccessor.getWindowAccessor().setSecurityWarningSize(this.ownerWindow, iconInfo.getWidth(), iconInfo.getHeight());
            }
        }
    }

    private final Graphics getGraphics() {
        SurfaceData surfaceData = this.contentView.getSurfaceData();
        if (this.ownerWindow == null || surfaceData == null) {
            return null;
        }
        return this.transformGraphics(new SunGraphics2D(surfaceData, SystemColor.windowText, SystemColor.window, this.ownerWindow.getFont()));
    }

    private void repaint() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                ((Graphics2D)graphics).setComposite(AlphaComposite.Src);
                graphics.drawImage(this.getSecurityIconInfo().getImage(), 0, 0, null);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    private void replaceSurface() {
        SurfaceData surfaceData = this.contentView.getSurfaceData();
        this.replaceSurfaceData();
        if (surfaceData != null && surfaceData != this.contentView.getSurfaceData()) {
            surfaceData.flush();
        }
    }

    private int getWidth() {
        return this.getSecurityIconInfo().getWidth();
    }

    private int getHeight() {
        return this.getSecurityIconInfo().getHeight();
    }

    private IconInfo getSecurityIconInfo() {
        return CWarningWindow.getSecurityIconInfo(this.currentSize, this.currentIcon);
    }

    private static class Lock {
        private Lock() {
        }
    }
}

