/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import com.sun.java.swing.SwingUtilities3;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.PaintEventDispatcher;
import sun.awt.RepaintArea;
import sun.awt.SunToolkit;
import sun.awt.event.IgnorePaintEvent;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.ToolkitImage;
import sun.java2d.SunGraphics2D;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.pipe.Region;
import sun.lwawt.LWContainerPeer;
import sun.lwawt.LWGraphicsConfig;
import sun.lwawt.LWKeyboardFocusManagerPeer;
import sun.lwawt.LWRepaintArea;
import sun.lwawt.LWToolkit;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformComponent;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CDropTarget;
import sun.util.logging.PlatformLogger;

public abstract class LWComponentPeer<T extends Component, D extends JComponent>
implements ComponentPeer,
DropTargetPeer {
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.lwawt.focus.LWComponentPeer");
    private final Object stateLock = new Object();
    private static final Object peerTreeLock = new Object();
    private final T target;
    private final LWContainerPeer<?, ?> containerPeer;
    private final LWWindowPeer windowPeer;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final Rectangle bounds = new Rectangle();
    private Region region;
    private boolean visible = false;
    private boolean enabled = true;
    private Color background;
    private Color foreground;
    private Font font;
    private final RepaintArea targetPaintArea;
    private volatile boolean isLayouting;
    private final D delegate;
    private Container delegateContainer;
    private Component delegateDropTarget;
    private final Object dropTargetLock = new Object();
    private int fNumDropTargets = 0;
    private CDropTarget fDropTarget = null;
    private final PlatformComponent platformComponent;
    static final char WIDE_CHAR = '0';
    private Image backBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LWComponentPeer(T t, PlatformComponent platformComponent) {
        this.targetPaintArea = new LWRepaintArea();
        this.target = t;
        this.platformComponent = platformComponent;
        Container container = SunToolkit.getNativeContainer(t);
        this.containerPeer = (LWContainerPeer)LWToolkit.targetToPeer(container);
        LWWindowPeer lWWindowPeer = this.windowPeer = this.containerPeer != null ? this.containerPeer.getWindowPeerOrSelf() : null;
        if (this.containerPeer != null) {
            this.containerPeer.addChildPeer(this);
        }
        AWTEventListener aWTEventListener = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        synchronized (toolkit) {
            try {
                aWTEventListener = this.getToolkitAWTEventListener();
                this.setToolkitAWTEventListener(null);
                Object object = this.getDelegateLock();
                synchronized (object) {
                    block13: {
                        this.delegate = this.createDelegate();
                        if (this.delegate != null) {
                            ((JComponent)this.delegate).setVisible(false);
                            this.delegateContainer = new DelegateContainer();
                            this.delegateContainer.add((Component)this.delegate);
                            this.delegateContainer.addNotify();
                            ((JComponent)this.delegate).addNotify();
                            LWComponentPeer.resetColorsAndFont(this.delegate);
                            ((JComponent)this.delegate).setOpaque(true);
                            break block13;
                        }
                        return;
                    }
                }
            }
            finally {
                this.setToolkitAWTEventListener(aWTEventListener);
            }
            SwingUtilities3.setDelegateRepaintManager(this.delegate, new RepaintManager(){

                @Override
                public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
                    LWComponentPeer.this.repaintPeer(SwingUtilities.convertRectangle(jComponent, new Rectangle(n, n2, n3, n4), LWComponentPeer.this.getDelegate()));
                }
            });
        }
    }

    protected final AWTEventListener getToolkitAWTEventListener() {
        return AccessController.doPrivileged(new PrivilegedAction<AWTEventListener>(){

            @Override
            public AWTEventListener run() {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                try {
                    Field field = Toolkit.class.getDeclaredField("eventListener");
                    field.setAccessible(true);
                    return (AWTEventListener)field.get(toolkit);
                }
                catch (Exception exception) {
                    throw new InternalError(exception.toString());
                }
            }
        });
    }

    protected final void setToolkitAWTEventListener(final AWTEventListener aWTEventListener) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                try {
                    Field field = Toolkit.class.getDeclaredField("eventListener");
                    field.setAccessible(true);
                    field.set(toolkit, aWTEventListener);
                }
                catch (Exception exception) {
                    throw new InternalError(exception.toString());
                }
                return null;
            }
        });
    }

    D createDelegate() {
        return null;
    }

    final D getDelegate() {
        return this.delegate;
    }

    Component getDelegateFocusOwner() {
        return this.getDelegate();
    }

    public final void initialize() {
        this.platformComponent.initialize(this.getPlatformWindow());
        this.initializeImpl();
        this.setVisible(((Component)this.target).isVisible());
    }

    void initializeImpl() {
        this.setBackground(((Component)this.target).getBackground());
        this.setForeground(((Component)this.target).getForeground());
        this.setFont(((Component)this.target).getFont());
        this.setBounds(((Component)this.target).getBounds());
        this.setEnabled(((Component)this.target).isEnabled());
    }

    private static void resetColorsAndFont(Container container) {
        container.setBackground(null);
        container.setForeground(null);
        container.setFont(null);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            LWComponentPeer.resetColorsAndFont((Container)container.getComponent(i));
        }
    }

    final Object getStateLock() {
        return this.stateLock;
    }

    final Object getDelegateLock() {
        return ((Component)this.getTarget()).getTreeLock();
    }

    protected static final Object getPeerTreeLock() {
        return peerTreeLock;
    }

    public final T getTarget() {
        return this.target;
    }

    protected final LWWindowPeer getWindowPeer() {
        return this.windowPeer;
    }

    protected LWWindowPeer getWindowPeerOrSelf() {
        return this.getWindowPeer();
    }

    protected final LWContainerPeer<?, ?> getContainerPeer() {
        return this.containerPeer;
    }

    public PlatformWindow getPlatformWindow() {
        LWWindowPeer lWWindowPeer = this.getWindowPeer();
        return lWWindowPeer.getPlatformWindow();
    }

    public LWToolkit getLWToolkit() {
        return LWToolkit.getLWToolkit();
    }

    @Override
    public final void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            this.disposeImpl();
        }
    }

    protected void disposeImpl() {
        this.destroyBuffers();
        LWContainerPeer<?, ?> lWContainerPeer = this.getContainerPeer();
        if (lWContainerPeer != null) {
            lWContainerPeer.removeChildPeer(this);
        }
        this.platformComponent.dispose();
        LWToolkit.targetDisposedPeer(this.getTarget(), this);
    }

    public final boolean isDisposed() {
        return this.disposed.get();
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.getWindowPeer().getGraphicsConfiguration();
    }

    public final LWGraphicsConfig getLWGC() {
        return (LWGraphicsConfig)((Object)this.getGraphicsConfiguration());
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration graphicsConfiguration) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Graphics getGraphics() {
        Graphics graphics = this.getOnscreenGraphics();
        if (graphics != null) {
            Object object = LWComponentPeer.getPeerTreeLock();
            synchronized (object) {
                this.applyConstrain(graphics);
            }
        }
        return graphics;
    }

    public final Graphics getOnscreenGraphics() {
        LWWindowPeer lWWindowPeer = this.getWindowPeerOrSelf();
        return lWWindowPeer.getOnscreenGraphics(this.getForeground(), this.getBackground(), this.getFont());
    }

    private void applyConstrain(Graphics graphics) {
        SunGraphics2D sunGraphics2D = (SunGraphics2D)graphics;
        Rectangle rectangle = this.localToWindow(this.getSize());
        sunGraphics2D.constrain(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.getVisibleRegion());
    }

    Region getVisibleRegion() {
        return LWComponentPeer.computeVisibleRect(this, this.getRegion());
    }

    static final Region computeVisibleRect(LWComponentPeer<?, ?> lWComponentPeer, Region region) {
        LWContainerPeer<?, ?> lWContainerPeer = lWComponentPeer.getContainerPeer();
        if (lWContainerPeer != null) {
            Rectangle rectangle = lWComponentPeer.getBounds();
            region = region.getTranslatedRegion(rectangle.x, rectangle.y);
            region = region.getIntersection(lWContainerPeer.getRegion());
            region = region.getIntersection(lWContainerPeer.getContentSize());
            region = lWContainerPeer.cutChildren(region, lWComponentPeer);
            region = LWComponentPeer.computeVisibleRect(lWContainerPeer, region);
            region = region.getTranslatedRegion(-rectangle.x, -rectangle.y);
        }
        return region;
    }

    @Override
    public ColorModel getColorModel() {
        return this.getGraphicsConfiguration().getColorModel();
    }

    public boolean isTranslucent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        this.getLWGC().assertOperationSupported(n, bufferCapabilities);
        Image image = this.getLWGC().createBackBuffer(this);
        Object object = this.getStateLock();
        synchronized (object) {
            this.backBuffer = image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Image getBackBuffer() {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.backBuffer != null) {
                return this.backBuffer;
            }
        }
        throw new IllegalStateException("Buffers have not been created");
    }

    @Override
    public final void flip(int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        this.getLWGC().flip(this, this.getBackBuffer(), n, n2, n3, n4, flipContents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroyBuffers() {
        Image image;
        Object object = this.getStateLock();
        synchronized (object) {
            image = this.backBuffer;
            this.backBuffer = null;
        }
        this.getLWGC().destroyBackBuffer(image);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 3);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        this.setBounds(n, n2, n3, n4, n5, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBounds(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        Object object;
        boolean bl3;
        Rectangle rectangle;
        Object object2 = this.getStateLock();
        synchronized (object2) {
            rectangle = new Rectangle(this.bounds);
            if ((n5 & 3) != 0) {
                this.bounds.x = n;
                this.bounds.y = n2;
            }
            if ((n5 & 3) != 0) {
                this.bounds.width = n3;
                this.bounds.height = n4;
            }
        }
        boolean bl4 = rectangle.x != n || rectangle.y != n2;
        boolean bl5 = bl3 = rectangle.width != n3 || rectangle.height != n4;
        if (!bl4 && !bl3) {
            return;
        }
        D d = this.getDelegate();
        if (d != null) {
            object = this.getDelegateLock();
            synchronized (object) {
                this.delegateContainer.setBounds(0, 0, n3, n4);
                ((Component)d).setBounds(this.delegateContainer.getBounds());
                ((Container)d).validate();
            }
        }
        object = this.localToWindow(0, 0);
        this.platformComponent.setBounds(((Point)object).x, ((Point)object).y, n3, n4);
        if (bl) {
            this.repaintOldNewBounds(rectangle);
            if (bl3) {
                this.handleResize(n3, n4, bl2);
            }
            if (bl4) {
                this.handleMove(n, n2, bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Rectangle getBounds() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.bounds.getBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Rectangle getSize() {
        Object object = this.getStateLock();
        synchronized (object) {
            return new Rectangle(this.bounds.width, this.bounds.height);
        }
    }

    @Override
    public Point getLocationOnScreen() {
        Point point = this.getWindowPeer().getLocationOnScreen();
        Point point2 = this.localToWindow(0, 0);
        return new Point(point.x + point2.x, point.y + point2.y);
    }

    Cursor getCursor(Point point) {
        return ((Component)this.getTarget()).getCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackground(Color color) {
        Color color2 = this.getBackground();
        if (color2 == color || color2 != null && color2.equals(color)) {
            return;
        }
        Object object = this.getStateLock();
        synchronized (object) {
            this.background = color;
        }
        object = this.getDelegate();
        if (object != null) {
            Object object2 = this.getDelegateLock();
            synchronized (object2) {
                ((JComponent)object).setBackground(color);
            }
        } else {
            this.repaintPeer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Color getBackground() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.background;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        if (color2 == color || color2 != null && color2.equals(color)) {
            return;
        }
        Object object = this.getStateLock();
        synchronized (object) {
            this.foreground = color;
        }
        object = this.getDelegate();
        if (object != null) {
            Object object2 = this.getDelegateLock();
            synchronized (object2) {
                ((JComponent)object).setForeground(color);
            }
        } else {
            this.repaintPeer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Color getForeground() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.foreground;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFont(Font font) {
        Font font2 = this.getFont();
        if (font2 == font || font2 != null && font2.equals(font)) {
            return;
        }
        Object object = this.getStateLock();
        synchronized (object) {
            this.font = font;
        }
        object = this.getDelegate();
        if (object != null) {
            Object object2 = this.getDelegateLock();
            synchronized (object2) {
                ((JComponent)object).setFont(font);
            }
        } else {
            this.repaintPeer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Font getFont() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.font;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FontMetrics getFontMetrics(Font font) {
        Graphics graphics = this.getOnscreenGraphics();
        if (graphics != null) {
            try {
                FontMetrics fontMetrics = graphics.getFontMetrics(font);
                return fontMetrics;
            }
            finally {
                graphics.dispose();
            }
        }
        Object object = this.getDelegateLock();
        synchronized (object) {
            return this.delegateContainer.getFontMetrics(font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = bl;
        LWContainerPeer<?, ?> lWContainerPeer = this.getContainerPeer();
        if (lWContainerPeer != null) {
            bl2 &= lWContainerPeer.isEnabled();
        }
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.enabled == bl2) {
                return;
            }
            this.enabled = bl2;
        }
        object = this.getDelegate();
        if (object != null) {
            Object object2 = this.getDelegateLock();
            synchronized (object2) {
                ((JComponent)object).setEnabled(bl2);
            }
        } else {
            this.repaintPeer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnabled() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean bl) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.visible == bl) {
                return;
            }
            this.visible = bl;
        }
        this.setVisibleImpl(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVisibleImpl(boolean bl) {
        D d = this.getDelegate();
        if (d != null) {
            Object object = this.getDelegateLock();
            synchronized (object) {
                ((JComponent)d).setVisible(bl);
            }
        }
        if (this.visible) {
            this.repaintPeer();
        } else {
            this.repaintParent(this.getBounds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isVisible() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.visible;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        ((Component)this.getTarget()).paint(graphics);
    }

    @Override
    public void print(Graphics graphics) {
        ((Component)this.getTarget()).print(graphics);
    }

    @Override
    public void reparent(ContainerPeer containerPeer) {
        throw new UnsupportedOperationException("ComponentPeer.reparent()");
    }

    @Override
    public boolean isReparentSupported() {
        return false;
    }

    @Override
    public void setZOrder(ComponentPeer componentPeer) {
        LWContainerPeer<?, ?> lWContainerPeer = this.getContainerPeer();
        lWContainerPeer.setChildPeerZOrder(this, (LWComponentPeer)componentPeer);
    }

    @Override
    public void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle;
        if (!(paintEvent instanceof IgnorePaintEvent) && (rectangle = paintEvent.getUpdateRect()) != null && !rectangle.isEmpty()) {
            this.targetPaintArea.add(rectangle, paintEvent.getID());
        }
    }

    @Override
    public void layout() {
    }

    @Override
    public boolean isObscured() {
        return false;
    }

    @Override
    public boolean canDetermineObscurity() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        Dimension dimension;
        Object object = this.getDelegateLock();
        synchronized (object) {
            dimension = ((JComponent)this.getDelegate()).getPreferredSize();
        }
        return this.validateSize(dimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize() {
        Dimension dimension;
        Object object = this.getDelegateLock();
        synchronized (object) {
            dimension = ((JComponent)this.getDelegate()).getMinimumSize();
        }
        return this.validateSize(dimension);
    }

    private Dimension validateSize(Dimension dimension) {
        if (dimension.width == 0 || dimension.height == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            dimension.width = fontMetrics.charWidth('0');
            dimension.height = fontMetrics.getHeight();
        }
        return dimension;
    }

    @Override
    public void updateCursorImmediately() {
        this.getLWToolkit().getCursorManager().updateCursor();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINEST)) {
            focusLog.finest("lightweightChild=" + component + ", temporary=" + bl + ", focusedWindowChangeAllowed=" + bl2 + ", time= " + l + ", cause=" + (Object)((Object)cause));
        }
        if (LWKeyboardFocusManagerPeer.processSynchronousLightweightTransfer(this.getTarget(), component, bl, bl2, l)) {
            return true;
        }
        int n = LWKeyboardFocusManagerPeer.shouldNativelyFocusHeavyweight(this.getTarget(), component, bl, bl2, l, cause);
        switch (n) {
            case 0: {
                return false;
            }
            case 2: {
                boolean bl3;
                Window window = SunToolkit.getContainingWindow(this.getTarget());
                if (window == null) {
                    focusLog.fine("request rejected, parentWindow is null");
                    LWKeyboardFocusManagerPeer.removeLastFocusRequest(this.getTarget());
                    return false;
                }
                LWWindowPeer lWWindowPeer = (LWWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window);
                if (lWWindowPeer == null) {
                    focusLog.fine("request rejected, parentPeer is null");
                    LWKeyboardFocusManagerPeer.removeLastFocusRequest(this.getTarget());
                    return false;
                }
                if (!bl2) {
                    LWWindowPeer lWWindowPeer2;
                    LWWindowPeer lWWindowPeer3 = lWWindowPeer2 = lWWindowPeer.isSimpleWindow() ? LWWindowPeer.getOwnerFrameDialog(lWWindowPeer) : lWWindowPeer;
                    if (lWWindowPeer2 == null || !lWWindowPeer2.getPlatformWindow().isActive()) {
                        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                            focusLog.fine("request rejected, focusedWindowChangeAllowed==false, decoratedPeer is inactive: " + lWWindowPeer2);
                        }
                        LWKeyboardFocusManagerPeer.removeLastFocusRequest(this.getTarget());
                        return false;
                    }
                }
                if (!(bl3 = lWWindowPeer.requestWindowFocus(cause)) || !window.isFocused()) {
                    if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                        focusLog.fine("request rejected, res= " + bl3 + ", parentWindow.isFocused()=" + window.isFocused());
                    }
                    LWKeyboardFocusManagerPeer.removeLastFocusRequest(this.getTarget());
                    return false;
                }
                LWKeyboardFocusManagerPeer lWKeyboardFocusManagerPeer = LWKeyboardFocusManagerPeer.getInstance();
                Component component2 = lWKeyboardFocusManagerPeer.getCurrentFocusOwner();
                return LWKeyboardFocusManagerPeer.deliverFocus(component, this.getTarget(), bl, bl2, l, cause, component2);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final Image createImage(ImageProducer imageProducer) {
        return new ToolkitImage(imageProducer);
    }

    @Override
    public final Image createImage(int n, int n2) {
        return this.getLWGC().createAcceleratedImage((Component)this.getTarget(), n, n2);
    }

    @Override
    public final VolatileImage createVolatileImage(int n, int n2) {
        return new SunVolatileImage((Component)this.getTarget(), n, n2);
    }

    @Override
    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return Toolkit.getDefaultToolkit().prepareImage(image, n, n2, imageObserver);
    }

    @Override
    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return Toolkit.getDefaultToolkit().checkImage(image, n, n2, imageObserver);
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void applyShape(Region region) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.region == region || this.region != null && this.region.equals(region)) {
                return;
            }
        }
        this.applyShapeImpl(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyShapeImpl(Region region) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.region = region != null ? Region.WHOLE_REGION.getIntersection(region) : null;
        }
        this.repaintParent(this.getBounds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Region getRegion() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.isShaped() ? this.region : Region.getInstance(this.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShaped() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.region != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDropTarget(DropTarget dropTarget) {
        LWWindowPeer lWWindowPeer = this.getWindowPeerOrSelf();
        if (lWWindowPeer != null && lWWindowPeer != this) {
            lWWindowPeer.addDropTarget(dropTarget);
        } else {
            Object object = this.dropTargetLock;
            synchronized (object) {
                if (++this.fNumDropTargets == 1) {
                    if (this.fDropTarget != null) {
                        System.err.println("CComponent.addDropTarget(): current drop target is non-null.");
                    }
                    this.fDropTarget = CDropTarget.createDropTarget(dropTarget, this.target, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDropTarget(DropTarget dropTarget) {
        LWWindowPeer lWWindowPeer = this.getWindowPeerOrSelf();
        if (lWWindowPeer != null && lWWindowPeer != this) {
            lWWindowPeer.removeDropTarget(dropTarget);
        } else {
            Object object = this.dropTargetLock;
            synchronized (object) {
                if (--this.fNumDropTargets == 0) {
                    if (this.fDropTarget != null) {
                        this.fDropTarget.dispose();
                        this.fDropTarget = null;
                    } else {
                        System.err.println("CComponent.removeDropTarget(): current drop target is null.");
                    }
                }
            }
        }
    }

    protected final void handleMove(int n, int n2, boolean bl) {
        if (bl) {
            AWTAccessor.getComponentAccessor().setLocation((Component)this.getTarget(), n, n2);
        }
        this.postEvent(new ComponentEvent((Component)this.getTarget(), 100));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleResize(int n, int n2, boolean bl) {
        Image image = null;
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.backBuffer != null) {
                image = this.backBuffer;
                this.backBuffer = this.getLWGC().createBackBuffer(this);
            }
        }
        this.getLWGC().destroyBackBuffer(image);
        if (bl) {
            AWTAccessor.getComponentAccessor().setSize((Component)this.getTarget(), n, n2);
        }
        this.postEvent(new ComponentEvent((Component)this.getTarget(), 101));
    }

    protected final void repaintOldNewBounds(Rectangle rectangle) {
        this.repaintParent(rectangle);
        this.repaintPeer(this.getSize());
    }

    protected final void repaintParent(Rectangle rectangle) {
        LWContainerPeer<?, ?> lWContainerPeer = this.getContainerPeer();
        if (lWContainerPeer != null) {
            lWContainerPeer.repaintPeer(lWContainerPeer.getContentSize().intersection(rectangle));
        }
    }

    public void postEvent(AWTEvent aWTEvent) {
        LWToolkit.postEvent(aWTEvent);
    }

    protected void postPaintEvent(int n, int n2, int n3, int n4) {
        if (AWTAccessor.getComponentAccessor().getIgnoreRepaint((Component)this.target)) {
            return;
        }
        PaintEvent paintEvent = PaintEventDispatcher.getPaintEventDispatcher().createPaintEvent((Component)this.getTarget(), n, n2, n3, n4);
        if (paintEvent != null) {
            this.postEvent(paintEvent);
        }
    }

    @Override
    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputEvent && ((InputEvent)aWTEvent).isConsumed()) {
            return;
        }
        switch (aWTEvent.getID()) {
            case 1004: 
            case 1005: {
                this.handleJavaFocusEvent((FocusEvent)aWTEvent);
                break;
            }
            case 800: 
            case 801: {
                this.handleJavaPaintEvent();
                break;
            }
            case 501: {
                this.handleJavaMouseEvent((MouseEvent)aWTEvent);
            }
        }
        this.sendEventToDelegate(aWTEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEventToDelegate(AWTEvent aWTEvent) {
        if (this.getDelegate() == null || !this.isShowing() || !this.isEnabled()) {
            return;
        }
        Object object = this.getDelegateLock();
        synchronized (object) {
            AWTEvent aWTEvent2 = this.createDelegateEvent(aWTEvent);
            if (aWTEvent2 != null) {
                AWTAccessor.getComponentAccessor().processEvent((Component)aWTEvent2.getSource(), aWTEvent2);
                if (aWTEvent2 instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)aWTEvent2;
                    SwingUtilities.processKeyBindings(keyEvent);
                }
            }
        }
    }

    private AWTEvent createDelegateEvent(AWTEvent aWTEvent) {
        ComponentEvent componentEvent = null;
        if (aWTEvent instanceof MouseWheelEvent) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
            componentEvent = new MouseWheelEvent((Component)this.delegate, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), mouseWheelEvent.getX(), mouseWheelEvent.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        } else if (aWTEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Component component = SwingUtilities.getDeepestComponentAt(this.delegate, mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.getID() == 506) {
                if (this.delegateDropTarget == null) {
                    this.delegateDropTarget = component;
                } else {
                    component = this.delegateDropTarget;
                }
            }
            if (mouseEvent.getID() == 502 && this.delegateDropTarget != null) {
                component = this.delegateDropTarget;
                this.delegateDropTarget = null;
            }
            if (component == null) {
                component = this.delegate;
            }
            componentEvent = SwingUtilities.convertMouseEvent(this.getTarget(), mouseEvent, component);
        } else if (aWTEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            componentEvent = new KeyEvent(this.getDelegateFocusOwner(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation());
            AWTAccessor.getKeyEventAccessor().setExtendedKeyCode((KeyEvent)componentEvent, keyEvent.getExtendedKeyCode());
        } else if (aWTEvent instanceof FocusEvent) {
            FocusEvent focusEvent = (FocusEvent)aWTEvent;
            componentEvent = new FocusEvent(this.getDelegateFocusOwner(), focusEvent.getID(), focusEvent.isTemporary());
        }
        return componentEvent;
    }

    protected void handleJavaMouseEvent(MouseEvent mouseEvent) {
        T t = this.getTarget();
        assert (mouseEvent.getSource() == t);
        if (!((Component)t).isFocusOwner() && LWKeyboardFocusManagerPeer.shouldFocusOnClick(t)) {
            LWKeyboardFocusManagerPeer.requestFocusFor(t, CausedFocusEvent.Cause.MOUSE_EVENT);
        }
    }

    void handleJavaFocusEvent(FocusEvent focusEvent) {
        LWKeyboardFocusManagerPeer lWKeyboardFocusManagerPeer = LWKeyboardFocusManagerPeer.getInstance();
        lWKeyboardFocusManagerPeer.setCurrentFocusOwner(focusEvent.getID() == 1004 ? (Component)this.getTarget() : null);
    }

    protected final boolean shouldClearRectBeforePaint() {
        return true;
    }

    private void handleJavaPaintEvent() {
        if (!this.isLayouting()) {
            this.targetPaintArea.paint(this.getTarget(), this.shouldClearRectBeforePaint());
        }
    }

    LWComponentPeer<?, ?> findPeerAt(int n, int n2) {
        Rectangle rectangle = this.getBounds();
        Region region = this.getRegion();
        boolean bl = this.isVisible() && region.contains(n - rectangle.x, n2 - rectangle.y);
        return bl ? this : null;
    }

    public Point windowToLocal(int n, int n2, LWWindowPeer lWWindowPeer) {
        return this.windowToLocal(new Point(n, n2), lWWindowPeer);
    }

    public Point windowToLocal(Point point, LWWindowPeer lWWindowPeer) {
        for (LWContainerPeer<?, ?> lWContainerPeer = this; lWContainerPeer != lWWindowPeer; lWContainerPeer = lWContainerPeer.getContainerPeer()) {
            Rectangle rectangle = lWContainerPeer.getBounds();
            point.x -= rectangle.x;
            point.y -= rectangle.y;
        }
        return new Point(point);
    }

    public Rectangle windowToLocal(Rectangle rectangle, LWWindowPeer lWWindowPeer) {
        Point point = this.windowToLocal(rectangle.getLocation(), lWWindowPeer);
        return new Rectangle(point, rectangle.getSize());
    }

    public Point localToWindow(int n, int n2) {
        return this.localToWindow(new Point(n, n2));
    }

    public Point localToWindow(Point point) {
        Rectangle rectangle = this.getBounds();
        for (LWContainerPeer<?, ?> lWContainerPeer = this.getContainerPeer(); lWContainerPeer != null; lWContainerPeer = lWContainerPeer.getContainerPeer()) {
            point.x += rectangle.x;
            point.y += rectangle.y;
            rectangle = lWContainerPeer.getBounds();
        }
        return new Point(point);
    }

    public Rectangle localToWindow(Rectangle rectangle) {
        Point point = this.localToWindow(rectangle.getLocation());
        return new Rectangle(point, rectangle.getSize());
    }

    public final void repaintPeer() {
        this.repaintPeer(this.getSize());
    }

    void repaintPeer(Rectangle rectangle) {
        Rectangle rectangle2 = this.getSize().intersection(rectangle);
        if (!this.isShowing() || rectangle2.isEmpty()) {
            return;
        }
        this.postPaintEvent(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isShowing() {
        Object object = LWComponentPeer.getPeerTreeLock();
        synchronized (object) {
            if (this.isVisible()) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                LWContainerPeer<?, ?> lWContainerPeer = this.getContainerPeer();
                return lWContainerPeer == null || lWContainerPeer.isShowing();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void paintPeer(Graphics graphics) {
        D d = this.getDelegate();
        if (d != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new InternalError("Painting must be done on EDT");
            }
            Object object = this.getDelegateLock();
            synchronized (object) {
                ((JComponent)this.getDelegate()).print(graphics);
            }
        }
    }

    protected static final void flushOnscreenGraphics() {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            oGLRenderQueue.flushNow();
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    protected final void setLayouting(boolean bl) {
        this.isLayouting = bl;
    }

    private final boolean isLayouting() {
        return this.isLayouting;
    }

    private final class DelegateContainer
    extends Container {
        DelegateContainer() {
            this.enableEvents(-1L);
        }

        @Override
        public boolean isLightweight() {
            return false;
        }

        @Override
        public Point getLocation() {
            return this.getLocationOnScreen();
        }

        @Override
        public Point getLocationOnScreen() {
            return LWComponentPeer.this.getLocationOnScreen();
        }

        @Override
        public int getX() {
            return this.getLocation().x;
        }

        @Override
        public int getY() {
            return this.getLocation().y;
        }
    }
}

