/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="sun.nio.ch.DatagramChannelImpl")
public final class DatagramChannelImplRMHooks {
    @InstrumentationMethod
    public SocketAddress getLocalAddress() throws IOException {
        return this.getLocalAddress();
    }

    @InstrumentationMethod
    public boolean isConnected() {
        return this.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public DatagramChannel bind(SocketAddress socketAddress) throws IOException {
        DatagramChannel datagramChannel;
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        long l = 0L;
        if (this.getLocalAddress() == null) {
            resourceIdImpl = ResourceIdImpl.of(socketAddress);
            resourceRequest = ApproverGroup.DATAGRAM_OPEN_GROUP.getApprover(this);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new IOException("Resource limited: too many open datagram channels");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                throw new IOException("Resource limited: too many open datagram channels", resourceRequestDeniedException);
            }
        }
        int n = 0;
        try {
            datagramChannel = this.bind(socketAddress);
            n = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n), resourceIdImpl);
            }
        }
        return datagramChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public DatagramChannel connect(SocketAddress socketAddress) throws IOException {
        DatagramChannel datagramChannel;
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        long l = 0L;
        if (this.getLocalAddress() == null) {
            resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
            resourceRequest = ApproverGroup.DATAGRAM_OPEN_GROUP.getApprover(this);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new IOException("Resource limited: too many open datagram channels");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                throw new IOException("Resource limited: too many open datagram channels", resourceRequestDeniedException);
            }
        }
        int n = 0;
        try {
            datagramChannel = this.connect(socketAddress);
            n = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n), resourceIdImpl);
            }
        }
        return datagramChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        ResourceRequest resourceRequest = ApproverGroup.DATAGRAM_RECEIVED_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(1L, resourceIdImpl), 0L);
            if (l < 1L) {
                throw new ResourceRequestDeniedException("Resource limited: too many received datagrams");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited: too many received datagrams", resourceRequestDeniedException);
        }
        resourceRequest.request(-(l - 1L), resourceIdImpl);
        int n = byteBuffer.remaining();
        ResourceRequest resourceRequest2 = ApproverGroup.DATAGRAM_READ_GROUP.getApprover(this);
        try {
            l = Math.max(resourceRequest2.request(n, resourceIdImpl), 0L);
            if (l < (long)n) {
                resourceRequest.request(-1L, resourceIdImpl);
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            resourceRequest.request(-1L, resourceIdImpl);
            throw new IOException("Resource limited: insufficient bytes approved", resourceRequestDeniedException);
        }
        int n2 = 0;
        SocketAddress socketAddress = null;
        try {
            int n3 = byteBuffer.position();
            socketAddress = this.receive(byteBuffer);
            n2 = byteBuffer.position() - n3;
        }
        finally {
            if (socketAddress == null) {
                resourceRequest.request(-1L, resourceIdImpl);
            }
            resourceRequest2.request(-(l - (long)n2), resourceIdImpl);
        }
        return socketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        int n;
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        long l = 0L;
        if (this.getLocalAddress() == null) {
            ResourceRequest resourceRequest = ApproverGroup.DATAGRAM_OPEN_GROUP.getApprover(this);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new ResourceRequestDeniedException("Resource limited: too many open datagram channels");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                throw new IOException("Resource limited: too many open datagram channels", resourceRequestDeniedException);
            }
            resourceRequest.request(-(l - 1L), resourceIdImpl);
        }
        if (this.isConnected()) {
            n = this.send(byteBuffer, socketAddress);
        } else {
            ResourceRequest resourceRequest = ApproverGroup.DATAGRAM_SENT_GROUP.getApprover(this);
            l = 0L;
            try {
                l = Math.max(resourceRequest.request(1L, resourceIdImpl), 0L);
                if (l < 1L) {
                    throw new ResourceRequestDeniedException("Resource limited: too many sent datagrams");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                throw new IOException("Resource limited: too many sent datagrams", resourceRequestDeniedException);
            }
            resourceRequest.request(-(l - 1L), resourceIdImpl);
            int n2 = byteBuffer.remaining();
            ResourceRequest resourceRequest2 = ApproverGroup.DATAGRAM_WRITE_GROUP.getApprover(this);
            try {
                l = Math.max(resourceRequest2.request(n2, resourceIdImpl), 0L);
                if (l < (long)n2) {
                    resourceRequest.request(-1L, resourceIdImpl);
                    throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                resourceRequest.request(-1L, resourceIdImpl);
                throw new IOException("Resource limited: insufficient bytes approved", resourceRequestDeniedException);
            }
            n = 0;
            try {
                n = this.send(byteBuffer, socketAddress);
            }
            finally {
                if (n == 0) {
                    resourceRequest.request(-1L, resourceIdImpl);
                }
                resourceRequest2.request(-(l - (long)n), resourceIdImpl);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read(ByteBuffer byteBuffer) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        ResourceRequest resourceRequest = ApproverGroup.DATAGRAM_RECEIVED_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(1L, resourceIdImpl), 0L);
            if (l < 1L) {
                throw new ResourceRequestDeniedException("Resource limited: too many received datagrams");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited: too many received datagrams", resourceRequestDeniedException);
        }
        resourceRequest.request(-(l - 1L), resourceIdImpl);
        ResourceRequest resourceRequest2 = ApproverGroup.DATAGRAM_READ_GROUP.getApprover(this);
        l = 0L;
        int n = byteBuffer.remaining();
        try {
            l = Math.max(resourceRequest2.request(n, resourceIdImpl), 0L);
            if (l < (long)n) {
                resourceRequest.request(-1L, resourceIdImpl);
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            resourceRequest.request(-1L, resourceIdImpl);
            throw new IOException("Resource limited: insufficient bytes approved", resourceRequestDeniedException);
        }
        int n2 = 0;
        int n3 = 0;
        try {
            n3 = this.read(byteBuffer);
            n2 = Math.max(n3, 0);
        }
        finally {
            resourceRequest2.request(-(l - (long)n2), resourceIdImpl);
            if (n2 == 0) {
                resourceRequest.request(-1L, resourceIdImpl);
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            return this.read(byteBufferArray, n, n2);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        ResourceRequest resourceRequest = ApproverGroup.DATAGRAM_RECEIVED_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(1L, resourceIdImpl), 0L);
            if (l < 1L) {
                throw new ResourceRequestDeniedException("Resource limited: too many received datagrams");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited: too many received datagrams", resourceRequestDeniedException);
        }
        resourceRequest.request(-(l - 1L), resourceIdImpl);
        ResourceRequest resourceRequest2 = ApproverGroup.DATAGRAM_READ_GROUP.getApprover(this);
        l = 0L;
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 += byteBufferArray[i].remaining();
        }
        try {
            l = Math.max(resourceRequest2.request(n3, resourceIdImpl), 0L);
            if (l < (long)n3) {
                resourceRequest.request(-1L, resourceIdImpl);
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            resourceRequest.request(-1L, resourceIdImpl);
            throw new IOException("Resource limited: insufficient bytes approved", resourceRequestDeniedException);
        }
        long l2 = 0L;
        long l3 = 0L;
        try {
            l3 = this.read(byteBufferArray, n, n2);
            l2 = Math.max(l3, 0L);
        }
        finally {
            resourceRequest2.request(-(l - l2), resourceIdImpl);
            if (l2 == 0L) {
                resourceRequest.request(-1L, resourceIdImpl);
            }
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int write(ByteBuffer byteBuffer) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        ResourceRequest resourceRequest = ApproverGroup.DATAGRAM_SENT_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(1L, resourceIdImpl), 0L);
            if (l < 1L) {
                throw new ResourceRequestDeniedException("Resource limited: too many sent datagrams");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited: too many sent datagrams", resourceRequestDeniedException);
        }
        resourceRequest.request(-(l - 1L), resourceIdImpl);
        ResourceRequest resourceRequest2 = ApproverGroup.DATAGRAM_WRITE_GROUP.getApprover(this);
        l = 0L;
        int n = byteBuffer.remaining();
        try {
            l = Math.max(resourceRequest2.request(n, resourceIdImpl), 0L);
            if (l < (long)n) {
                resourceRequest.request(-1L, resourceIdImpl);
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            resourceRequest.request(-1L, resourceIdImpl);
            throw new IOException("Resource limited: insufficient bytes approved", resourceRequestDeniedException);
        }
        int n2 = 0;
        try {
            n2 = this.write(byteBuffer);
        }
        finally {
            resourceRequest2.request(-(l - (long)n2), resourceIdImpl);
            if (n2 == 0) {
                resourceRequest.request(-1L, resourceIdImpl);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            return this.write(byteBufferArray, n, n2);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
        ResourceRequest resourceRequest = ApproverGroup.DATAGRAM_SENT_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(1L, resourceIdImpl), 0L);
            if (l < 1L) {
                throw new ResourceRequestDeniedException("Resource limited: too many sent datagrams");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited: too many sent datagrams", resourceRequestDeniedException);
        }
        resourceRequest.request(-(l - 1L), resourceIdImpl);
        ResourceRequest resourceRequest2 = ApproverGroup.DATAGRAM_WRITE_GROUP.getApprover(this);
        l = 0L;
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 += byteBufferArray[i].remaining();
        }
        try {
            l = Math.max(resourceRequest2.request(n3, resourceIdImpl), 0L);
            if (l < (long)n3) {
                resourceRequest.request(-1L, resourceIdImpl);
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            resourceRequest.request(-1L, resourceIdImpl);
            throw new IOException("Resource limited: insufficient bytes approved", resourceRequestDeniedException);
        }
        long l2 = 0L;
        try {
            l2 = this.write(byteBufferArray, n, n2);
        }
        finally {
            resourceRequest2.request(-(l - l2), resourceIdImpl);
            if (l2 == 0L) {
                resourceRequest.request(-1L, resourceIdImpl);
            }
        }
        return l2;
    }
}

