/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import processing.app.PreferencesData;
import processing.app.Theme;
import processing.app.helpers.OSUtils;
import processing.app.syntax.DefaultInputHandler;
import processing.app.syntax.InputHandler;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TextAreaDefaults;

public class PdeTextAreaDefaults
extends TextAreaDefaults {
    public PdeTextAreaDefaults() {
        this.inputHandler = new DefaultInputHandler();
        String mod = OSUtils.isMacOS() ? "A" : "C";
        this.inputHandler.addKeyBinding("BACK_SPACE", InputHandler.BACKSPACE);
        if (PreferencesData.getBoolean((String)"editor.keys.shift_backspace_is_delete")) {
            this.inputHandler.addKeyBinding("S+BACK_SPACE", InputHandler.DELETE);
        } else {
            this.inputHandler.addKeyBinding("S+BACK_SPACE", InputHandler.BACKSPACE);
        }
        this.inputHandler.addKeyBinding("DELETE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding("S+DELETE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding(mod + "+BACK_SPACE", InputHandler.BACKSPACE_WORD);
        this.inputHandler.addKeyBinding(mod + "+DELETE", InputHandler.DELETE_WORD);
        this.inputHandler.addKeyBinding("INSERT", InputHandler.OVERWRITE);
        if (PreferencesData.getBoolean((String)"editor.keys.alternative_cut_copy_paste")) {
            this.inputHandler.addKeyBinding("C+INSERT", InputHandler.CLIPBOARD_COPY);
            this.inputHandler.addKeyBinding("S+INSERT", InputHandler.CLIPBOARD_PASTE);
            this.inputHandler.addKeyBinding("S+DELETE", InputHandler.CLIPBOARD_CUT);
        }
        if (PreferencesData.getBoolean((String)"editor.keys.home_and_end_travel_far")) {
            this.inputHandler.addKeyBinding("HOME", InputHandler.DOCUMENT_HOME);
            this.inputHandler.addKeyBinding("END", InputHandler.DOCUMENT_END);
            this.inputHandler.addKeyBinding("S+HOME", InputHandler.SELECT_DOC_HOME);
            this.inputHandler.addKeyBinding("S+END", InputHandler.SELECT_DOC_END);
        } else {
            this.inputHandler.addKeyBinding("HOME", InputHandler.HOME);
            this.inputHandler.addKeyBinding("END", InputHandler.END);
            this.inputHandler.addKeyBinding("S+HOME", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("S+END", InputHandler.SELECT_END);
            this.inputHandler.addKeyBinding("C+HOME", InputHandler.DOCUMENT_HOME);
            this.inputHandler.addKeyBinding("C+END", InputHandler.DOCUMENT_END);
            this.inputHandler.addKeyBinding("CS+HOME", InputHandler.SELECT_DOC_HOME);
            this.inputHandler.addKeyBinding("CS+END", InputHandler.SELECT_DOC_END);
        }
        if (OSUtils.isMacOS()) {
            this.inputHandler.addKeyBinding("M+LEFT", InputHandler.HOME);
            this.inputHandler.addKeyBinding("M+RIGHT", InputHandler.END);
            this.inputHandler.addKeyBinding("MS+LEFT", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("MS+RIGHT", InputHandler.SELECT_END);
        } else {
            this.inputHandler.addKeyBinding("C+LEFT", InputHandler.HOME);
            this.inputHandler.addKeyBinding("C+RIGHT", InputHandler.END);
            this.inputHandler.addKeyBinding("CS+HOME", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("CS+END", InputHandler.SELECT_END);
        }
        this.inputHandler.addKeyBinding("PAGE_UP", InputHandler.PREV_PAGE);
        this.inputHandler.addKeyBinding("PAGE_DOWN", InputHandler.NEXT_PAGE);
        this.inputHandler.addKeyBinding("S+PAGE_UP", InputHandler.SELECT_PREV_PAGE);
        this.inputHandler.addKeyBinding("S+PAGE_DOWN", InputHandler.SELECT_NEXT_PAGE);
        this.inputHandler.addKeyBinding("LEFT", InputHandler.PREV_CHAR);
        this.inputHandler.addKeyBinding("S+LEFT", InputHandler.SELECT_PREV_CHAR);
        this.inputHandler.addKeyBinding(mod + "+LEFT", InputHandler.PREV_WORD);
        this.inputHandler.addKeyBinding(mod + "S+LEFT", InputHandler.SELECT_PREV_WORD);
        this.inputHandler.addKeyBinding("RIGHT", InputHandler.NEXT_CHAR);
        this.inputHandler.addKeyBinding("S+RIGHT", InputHandler.SELECT_NEXT_CHAR);
        this.inputHandler.addKeyBinding(mod + "+RIGHT", InputHandler.NEXT_WORD);
        this.inputHandler.addKeyBinding(mod + "S+RIGHT", InputHandler.SELECT_NEXT_WORD);
        this.inputHandler.addKeyBinding("UP", InputHandler.PREV_LINE);
        this.inputHandler.addKeyBinding(mod + "+UP", InputHandler.PREV_LINE);
        this.inputHandler.addKeyBinding("S+UP", InputHandler.SELECT_PREV_LINE);
        this.inputHandler.addKeyBinding("DOWN", InputHandler.NEXT_LINE);
        this.inputHandler.addKeyBinding(mod + "+DOWN", InputHandler.NEXT_LINE);
        this.inputHandler.addKeyBinding("S+DOWN", InputHandler.SELECT_NEXT_LINE);
        this.inputHandler.addKeyBinding("MS+UP", InputHandler.SELECT_DOC_HOME);
        this.inputHandler.addKeyBinding("CS+UP", InputHandler.SELECT_DOC_HOME);
        this.inputHandler.addKeyBinding("MS+DOWN", InputHandler.SELECT_DOC_END);
        this.inputHandler.addKeyBinding("CS+DOWN", InputHandler.SELECT_DOC_END);
        this.inputHandler.addKeyBinding(mod + "+ENTER", InputHandler.REPEAT);
        this.document = new SyntaxDocument();
        this.editable = true;
        this.electricScroll = 3;
        this.cols = 80;
        this.rows = 15;
        this.styles = new SyntaxStyle[12];
        this.styles[1] = Theme.getStyle("comment1");
        this.styles[2] = Theme.getStyle("comment2");
        this.styles[6] = Theme.getStyle("keyword1");
        this.styles[7] = Theme.getStyle("keyword2");
        this.styles[8] = Theme.getStyle("keyword3");
        this.styles[3] = Theme.getStyle("literal1");
        this.styles[4] = Theme.getStyle("literal2");
        this.styles[5] = Theme.getStyle("label");
        this.styles[10] = Theme.getStyle("url");
        this.styles[9] = Theme.getStyle("operator");
        this.styles[11] = Theme.getStyle("invalid");
        this.font = PreferencesData.getFont((String)"editor.font");
        this.fgcolor = Theme.getColor("editor.fgcolor");
        this.bgcolor = Theme.getColor("editor.bgcolor");
        this.caretVisible = true;
        this.caretBlinks = PreferencesData.getBoolean((String)"editor.caret.blink");
        this.caretColor = Theme.getColor("editor.caret.color");
        this.selectionColor = Theme.getColor("editor.selection.color");
        this.lineHighlight = Theme.getBoolean("editor.linehighlight");
        this.lineHighlightColor = Theme.getColor("editor.linehighlight.color");
        this.bracketHighlight = Theme.getBoolean("editor.brackethighlight");
        this.bracketHighlightColor = Theme.getColor("editor.brackethighlight.color");
        this.eolMarkers = Theme.getBoolean("editor.eolmarkers");
        this.eolMarkerColor = Theme.getColor("editor.eolmarkers.color");
        this.paintInvalid = Theme.getBoolean("editor.invalid");
    }
}

