/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.File;
import java.util.Map;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.helpers.PreferencesHelper;
import processing.app.helpers.PreferencesMap;
import processing.app.syntax.SyntaxStyle;

public class Theme {
    static PreferencesMap defaults;
    static PreferencesMap table;

    protected static void init() {
        try {
            table.load(new File(BaseNoGui.getContentFile((String)"lib"), "theme/theme.txt"));
        }
        catch (Exception te) {
            Base.showError(null, I18n._((String)"Could not read color theme settings.\nYou'll need to reinstall Arduino."), te);
        }
        Theme.setColor("run.window.bgcolor", SystemColor.control);
        defaults = new PreferencesMap((Map)table);
    }

    public static String get(String attribute) {
        return (String)table.get((Object)attribute);
    }

    public static String getDefault(String attribute) {
        return (String)defaults.get((Object)attribute);
    }

    public static void set(String attribute, String value) {
        table.put((Object)attribute, (Object)value);
    }

    public static boolean getBoolean(String attribute) {
        return table.getBoolean(attribute);
    }

    public static void setBoolean(String attribute, boolean value) {
        table.putBoolean(attribute, value);
    }

    public static int getInteger(String attribute) {
        return Integer.parseInt(Theme.get(attribute));
    }

    public static void setInteger(String key, int value) {
        Theme.set(key, String.valueOf(value));
    }

    public static Color getColor(String name) {
        return PreferencesHelper.parseColor((String)Theme.get(name));
    }

    public static void setColor(String attr, Color color) {
        PreferencesHelper.putColor((PreferencesMap)table, (String)attr, (Color)color);
    }

    public static Font getFont(String attr) {
        Font font = PreferencesHelper.getFont((PreferencesMap)table, (String)attr);
        if (font == null) {
            String value = Theme.getDefault(attr);
            Theme.set(attr, value);
            font = PreferencesHelper.getFont((PreferencesMap)table, (String)attr);
        }
        return font;
    }

    public static SyntaxStyle getStyle(String what) {
        String[] split = Theme.get("editor." + what + ".style").split(",");
        Color color = PreferencesHelper.parseColor((String)split[0]);
        String style = split[1];
        boolean bold = style.contains("bold");
        boolean italic = style.contains("italic");
        boolean underlined = style.contains("underlined");
        return new SyntaxStyle(color, italic, bold, underlined);
    }

    static {
        table = new PreferencesMap();
    }
}

