/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.files.DeleteFilesOnShutdown;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import processing.app.Base;
import processing.app.EditorConsole;
import processing.app.I18n;
import processing.app.PreferencesData;

class EditorConsoleStream
extends OutputStream {
    static File tempFolder;
    static File outFile;
    static File errFile;
    static EditorConsole currentConsole;
    static OutputStream stderrFile;
    static OutputStream stdoutFile;
    static PrintStream consoleErr;
    static PrintStream consoleOut;
    public static PrintStream systemErr;
    public static PrintStream systemOut;
    final boolean err;
    PrintStream system;
    OutputStream file;

    public static void init() {
        if (systemOut == null) {
            systemOut = System.out;
            systemErr = System.err;
            tempFolder = Base.createTempFolder("console");
            DeleteFilesOnShutdown.add((File)tempFolder);
            try {
                String errFileName;
                String outFileName = PreferencesData.get((String)"console.output.file");
                if (outFileName != null) {
                    outFile = new File(tempFolder, outFileName);
                    DeleteFilesOnShutdown.add((File)outFile);
                    stdoutFile = new FileOutputStream(outFile);
                }
                if ((errFileName = PreferencesData.get((String)"console.error.file")) != null) {
                    errFile = new File(tempFolder, errFileName);
                    DeleteFilesOnShutdown.add((File)errFile);
                    stderrFile = new FileOutputStream(errFile);
                }
            }
            catch (IOException e) {
                Base.showWarning(I18n._((String)"Console Error"), I18n._((String)"A problem occurred while trying to open the\nfiles used to store the console output."), e);
            }
            consoleOut = new PrintStream(new EditorConsoleStream(false));
            consoleErr = new PrintStream(new EditorConsoleStream(true));
            if (PreferencesData.getBoolean((String)"console")) {
                try {
                    System.setOut(consoleOut);
                    System.setErr(consoleErr);
                }
                catch (Exception e) {
                    e.printStackTrace(systemOut);
                }
            }
        }
    }

    public static void quit() {
        System.setOut(systemOut);
        System.setErr(systemErr);
        consoleOut.close();
        consoleErr.close();
        try {
            stdoutFile.close();
            stderrFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        outFile.delete();
        errFile.delete();
        tempFolder.delete();
    }

    public EditorConsoleStream(boolean _err) {
        this.err = _err;
        if (this.err) {
            this.system = systemErr;
            this.file = stderrFile;
        } else {
            this.system = systemOut;
            this.file = stdoutFile;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(int b) {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        if (currentConsole != null) {
            currentConsole.appendText(new String(b, offset, length), this.err);
        }
        this.system.write(b, offset, length);
        if (this.file != null) {
            try {
                this.file.write(b, offset, length);
                this.file.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.file = null;
            }
        }
    }

    public static void setCurrent(EditorConsole console) {
        currentConsole = console;
    }
}

