/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.contributions.BuiltInCoreIsNewerCheck;
import cc.arduino.contributions.DownloadableContributionVersionComparator;
import cc.arduino.contributions.VersionHelper;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.LibrariesIndexer;
import cc.arduino.contributions.libraries.LibraryInstaller;
import cc.arduino.contributions.libraries.ui.LibraryManagerUI;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributionInstaller;
import cc.arduino.contributions.packages.ContributionsIndexer;
import cc.arduino.contributions.packages.ui.ContributionManagerUI;
import cc.arduino.files.DeleteFilesOnShutdown;
import cc.arduino.packages.DiscoveryManager;
import cc.arduino.utils.Progress;
import cc.arduino.view.Event;
import cc.arduino.view.SplashScreenHelper;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.EditorConsoleStream;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.PreferencesData;
import processing.app.Theme;
import processing.app.UpdateCheck;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.CommandlineParser;
import processing.app.helpers.FileUtils;
import processing.app.helpers.GUIUserNotifier;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.helpers.filefilters.OnlyFilesWithExtension;
import processing.app.javax.swing.filechooser.FileNameExtensionFilter;
import processing.app.legacy.PApplet;
import processing.app.macosx.ThinkDifferent;
import processing.app.packages.LibraryList;
import processing.app.packages.UserLibrary;
import processing.app.tools.MenuScroller;
import processing.app.tools.ZipDeflater;

public class Base {
    public static final Predicate<UserLibrary> CONTRIBUTED = new Predicate<UserLibrary>(){

        public boolean apply(UserLibrary library) {
            return library.getTypes() == null || library.getTypes().isEmpty() || library.getTypes().contains("Contributed");
        }
    };
    private static boolean commandLine;
    public static volatile Base INSTANCE;
    public static SplashScreenHelper splashScreenHelper;
    Preferences preferencesFrame;
    boolean builtOnce;
    public static String librariesClassPath;
    static File untitledFolder;
    List<Editor> editors = Collections.synchronizedList(new ArrayList());
    Editor activeEditor;
    private List<JMenu> boardsCustomMenus;
    private volatile Action openBoardsManager;
    boolean breakTime = false;
    String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

    public static void main(String[] args) throws Exception {
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        splashScreenHelper.splashText(I18n._((String)"Loading configuration..."));
        if (OSUtils.isMacOS()) {
            ThinkDifferent.init();
        }
        try {
            Base.guardedMain(args);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(255);
        }
    }

    public static void guardedMain(String[] args) throws Exception {
        block2: {
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)DeleteFilesOnShutdown.INSTANCE));
            BaseNoGui.initLogger();
            BaseNoGui.notifier = new GUIUserNotifier();
            Base.initPlatform();
            BaseNoGui.initPortableFolder();
            BaseNoGui.initParameters((String[])args);
            System.setProperty("swing.aatext", PreferencesData.get((String)"editor.antialias", (String)"true"));
            BaseNoGui.initVersion();
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            Theme.init();
            try {
                Base.getPlatform().setLookAndFeel();
            }
            catch (Exception e) {
                String mess = e.getMessage();
                if (mess.indexOf("ch.randelshofer.quaqua.QuaquaLookAndFeel") != -1) break block2;
                System.err.println(I18n._((String)"Non-fatal error while setting the Look & Feel."));
                System.err.println(I18n._((String)"The error message follows, however Arduino should run fine."));
                System.err.println(mess);
            }
        }
        untitledFolder = Base.createTempFolder("untitled");
        DeleteFilesOnShutdown.add((File)untitledFolder);
        INSTANCE = new Base(args);
    }

    protected static void setCommandLine() {
        commandLine = true;
    }

    protected static boolean isCommandLine() {
        return commandLine;
    }

    protected static void initPlatform() {
        BaseNoGui.initPlatform();
    }

    protected static void initRequirements() {
        try {
            Class.forName("com.sun.jdi.VirtualMachine");
        }
        catch (ClassNotFoundException cnfe) {
            Base.showError(I18n._((String)"Please install JDK 1.5 or later"), I18n._((String)"Arduino requires a full JDK (not just a JRE)\nto run. Please install JDK 1.5 or later.\nMore information can be found in the reference."), cnfe);
        }
    }

    public static File absoluteFile(String path) {
        return BaseNoGui.absoluteFile((String)path);
    }

    public Base(String[] args) throws Exception {
        Object installer;
        ContributionsIndexer indexer;
        Base.getPlatform().init();
        String sketchbookPath = BaseNoGui.getSketchbookPath();
        if (sketchbookPath == null) {
            File defaultFolder = this.getDefaultSketchbookFolderOrPromptForIt();
            if (BaseNoGui.getPortableFolder() != null) {
                PreferencesData.set((String)"sketchbook.path", (String)BaseNoGui.getPortableSketchbookFolder());
            } else {
                PreferencesData.set((String)"sketchbook.path", (String)defaultFolder.getAbsolutePath());
            }
            if (!defaultFolder.exists()) {
                defaultFolder.mkdirs();
            }
        }
        splashScreenHelper.splashText(I18n._((String)"Initializing packages..."));
        BaseNoGui.initPackages();
        splashScreenHelper.splashText(I18n._((String)"Preparing boards..."));
        this.rebuildBoardsMenu();
        this.onBoardOrPortChange();
        CommandlineParser parser = CommandlineParser.newCommandlineParser((String[])args);
        for (String path : parser.getFilenames()) {
            File file = Base.absoluteFile(path);
            if (OSUtils.isWindows()) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            boolean showEditor = parser.isGuiMode();
            if (!parser.isForceSavePrefs()) {
                PreferencesData.setDoSave((boolean)showEditor);
            }
            if (this.handleOpen(file, this.nextEditorLocation(), showEditor) != null) continue;
            String mess = I18n.format((String)I18n._((String)"Failed to open sketch: \"{0}\""), (Object[])new Object[]{path});
            if (parser.isVerifyOrUploadMode()) {
                Base.showError(null, mess, 2);
                continue;
            }
            Base.showWarning(null, mess, null);
        }
        PreferencesData.save();
        if (parser.isInstallBoard()) {
            indexer = new ContributionsIndexer(BaseNoGui.getSettingsFolder());
            installer = new ContributionInstaller(indexer){
                private String lastStatus;
                {
                    this.lastStatus = "";
                }

                protected void onProgress(Progress progress) {
                    if (!this.lastStatus.equals(progress.getStatus())) {
                        System.out.println(progress.getStatus());
                    }
                    this.lastStatus = progress.getStatus();
                }
            };
            List downloadedPackageIndexFiles = installer.updateIndex();
            installer.deleteUnknownFiles(downloadedPackageIndexFiles);
            indexer.parseIndex();
            indexer.syncWithFilesystem(Base.getHardwareFolder());
            String[] boardToInstallParts = parser.getBoardToInstall().split(":");
            ContributedPlatform selected = null;
            if (boardToInstallParts.length == 3) {
                selected = indexer.getIndex().findPlatform(boardToInstallParts[0], boardToInstallParts[1], VersionHelper.valueOf((String)boardToInstallParts[2]).toString());
            } else if (boardToInstallParts.length == 2) {
                List platformsByName = indexer.getIndex().findPlatforms(boardToInstallParts[0], boardToInstallParts[1]);
                Collections.sort(platformsByName, new DownloadableContributionVersionComparator());
                if (!platformsByName.isEmpty()) {
                    selected = (ContributedPlatform)platformsByName.get(platformsByName.size() - 1);
                }
            }
            if (selected == null) {
                System.out.println(I18n._((String)"Selected board is not available"));
                System.exit(1);
            }
            ContributedPlatform installed = indexer.getInstalled(boardToInstallParts[0], boardToInstallParts[1]);
            if (!selected.isReadOnly()) {
                installer.install(selected);
            }
            if (installed != null && !installed.isReadOnly()) {
                installer.remove(installed);
            }
            System.exit(0);
        } else if (parser.isInstallLibrary()) {
            indexer = new LibrariesIndexer(BaseNoGui.getSettingsFolder());
            installer = new LibraryInstaller((LibrariesIndexer)indexer){
                private String lastStatus;
                {
                    this.lastStatus = "";
                }

                protected void onProgress(Progress progress) {
                    if (!this.lastStatus.equals(progress.getStatus())) {
                        System.out.println(progress.getStatus());
                    }
                    this.lastStatus = progress.getStatus();
                }
            };
            indexer.parseIndex();
            BaseNoGui.onBoardOrPortChange();
            indexer.setSketchbookLibrariesFolder(BaseNoGui.getSketchbookLibrariesFolder());
            indexer.setLibrariesFolders(BaseNoGui.getLibrariesPath());
            installer.updateIndex();
            for (String library : parser.getLibraryToInstall().split(",")) {
                String[] libraryToInstallParts = library.split(":");
                ContributedLibrary selected = null;
                if (libraryToInstallParts.length == 2) {
                    selected = indexer.getIndex().find(libraryToInstallParts[0], VersionHelper.valueOf((String)libraryToInstallParts[1]).toString());
                } else if (libraryToInstallParts.length == 1) {
                    List librariesByName = indexer.getIndex().find(libraryToInstallParts[0]);
                    Collections.sort(librariesByName, new DownloadableContributionVersionComparator());
                    if (!librariesByName.isEmpty()) {
                        selected = (ContributedLibrary)librariesByName.get(librariesByName.size() - 1);
                    }
                }
                if (selected == null) {
                    System.out.println(I18n._((String)"Selected library is not available"));
                    System.exit(1);
                }
                ContributedLibrary installed = indexer.getIndex().getInstalled(libraryToInstallParts[0]);
                if (selected.isReadOnly()) {
                    installer.remove(installed);
                    continue;
                }
                installer.install(selected, installed);
            }
            System.exit(0);
        } else if (parser.isVerifyOrUploadMode()) {
            splashScreenHelper.close();
            PreferencesData.set((String)"build.verbose", (String)("" + parser.isDoVerboseBuild()));
            PreferencesData.set((String)"upload.verbose", (String)("" + parser.isDoVerboseUpload()));
            PreferencesData.set((String)"runtime.preserve.temp.files", (String)Boolean.toString(parser.isPreserveTempFiles()));
            PreferencesData.setDoSave((boolean)false);
            Editor editor = this.editors.get(0);
            if (parser.isUploadMode()) {
                splashScreenHelper.splashText(I18n._((String)"Verifying and uploading..."));
                editor.exportHandler.run();
            } else {
                splashScreenHelper.splashText(I18n._((String)"Verifying..."));
                editor.runHandler.run();
            }
            int res = editor.status.mode;
            if (res == 1) {
                System.exit(1);
            }
            System.exit(0);
        } else if (parser.isGuiMode()) {
            splashScreenHelper.splashText(I18n._((String)"Starting..."));
            this.restoreSketches();
            if (this.editors.isEmpty()) {
                this.handleNew();
            }
            if (PreferencesData.getBoolean((String)"update.check")) {
                new UpdateCheck(this);
            }
            new Thread(new BuiltInCoreIsNewerCheck(this)).start();
        } else if (parser.isNoOpMode()) {
            System.exit(0);
        } else if (parser.isGetPrefMode()) {
            String value = PreferencesData.get((String)parser.getGetPref(), null);
            if (value != null) {
                System.out.println(value);
                System.exit(0);
            } else {
                System.exit(4);
            }
        }
    }

    protected boolean restoreSketches() throws Exception {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        boolean windowPositionValid = true;
        if (PreferencesData.get((String)"last.screen.height") != null) {
            int screenW = PreferencesData.getInteger((String)"last.screen.width");
            int screenH = PreferencesData.getInteger((String)"last.screen.height");
            if (screen.width != screenW || screen.height != screenH) {
                windowPositionValid = false;
            }
        } else {
            windowPositionValid = false;
        }
        int count = PreferencesData.getInteger((String)"last.sketch.count");
        int opened = 0;
        for (int i = 0; i < count; ++i) {
            int[] location;
            String path = PreferencesData.get((String)("last.sketch" + i + ".path"));
            if (BaseNoGui.getPortableFolder() != null) {
                File absolute = new File(BaseNoGui.getPortableFolder(), path);
                try {
                    path = absolute.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (windowPositionValid) {
                String locationStr = PreferencesData.get((String)("last.sketch" + i + ".location"));
                location = PApplet.parseInt((String[])PApplet.split((String)locationStr, (char)','));
            } else {
                location = this.nextEditorLocation();
            }
            if (this.handleOpen(new File(path), location, true) == null) continue;
            ++opened;
        }
        return opened > 0;
    }

    protected void storeSketches() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        PreferencesData.setInteger((String)"last.screen.width", (int)screen.width);
        PreferencesData.setInteger((String)"last.screen.height", (int)screen.height);
        String untitledPath = untitledFolder.getAbsolutePath();
        int index = 0;
        for (Editor editor : this.editors) {
            String path = editor.getSketch().getMainFilePath();
            if (path.startsWith(untitledPath) && !editor.getSketch().isModified() || BaseNoGui.getPortableFolder() != null && (path = FileUtils.relativePath((String)BaseNoGui.getPortableFolder().toString(), (String)path)) == null) continue;
            PreferencesData.set((String)("last.sketch" + index + ".path"), (String)path);
            int[] location = editor.getPlacement();
            String locationStr = PApplet.join((String[])PApplet.str((int[])location), (String)",");
            PreferencesData.set((String)("last.sketch" + index + ".location"), (String)locationStr);
            ++index;
        }
        PreferencesData.setInteger((String)"last.sketch.count", (int)index);
    }

    protected void storeSketchPath(Editor editor, int index) {
        String untitledPath;
        String path = editor.getSketch().getMainFilePath();
        if (path.startsWith(untitledPath = untitledFolder.getAbsolutePath())) {
            path = "";
        } else if (BaseNoGui.getPortableFolder() != null && (path = FileUtils.relativePath((String)BaseNoGui.getPortableFolder().toString(), (String)path)) == null) {
            path = "";
        }
        PreferencesData.set((String)("last.sketch" + index + ".path"), (String)path);
    }

    protected void handleActivated(Editor whichEditor) {
        this.activeEditor = whichEditor;
        EditorConsoleStream.setCurrent(this.activeEditor.console);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] nextEditorLocation() {
        int defaultWidth = PreferencesData.getInteger((String)"editor.window.width.default");
        int defaultHeight = PreferencesData.getInteger((String)"editor.window.height.default");
        if (this.activeEditor == null) {
            Rectangle screen = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            return new int[]{(screen.width - defaultWidth) / 2, (screen.height - defaultHeight) / 2, defaultWidth, defaultHeight, 0};
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        List<Editor> list = this.editors;
        synchronized (list) {
            int OVER = 50;
            Editor lastOpened = this.activeEditor;
            int[] location = lastOpened.getPlacement();
            location[0] = location[0] + 50;
            location[1] = location[1] + 50;
            if (location[0] == 50 || location[2] == 50 || location[0] + location[2] > screen.width || location[1] + location[3] > screen.height) {
                return new int[]{(int)(Math.random() * (double)(screen.width - defaultWidth)), (int)(Math.random() * (double)(screen.height - defaultHeight)), defaultWidth, defaultHeight, 0};
            }
            return location;
        }
    }

    protected File createNewUntitled() throws IOException {
        File newbieDir = null;
        String newbieName = null;
        File sketchbookDir = Base.getSketchbookFolder();
        File newbieParentDir = untitledFolder;
        int index = 0;
        Calendar cal = Calendar.getInstance();
        int day = cal.get(5);
        int month = cal.get(2);
        String purty = this.months[month] + PApplet.nf((int)day, (int)2);
        do {
            if (index == 26) {
                if (!this.breakTime) {
                    Base.showWarning(I18n._((String)"Time for a Break"), I18n._((String)"You've reached the limit for auto naming of new sketches\nfor the day. How about going for a walk instead?"), null);
                    this.breakTime = true;
                } else {
                    Base.showWarning(I18n._((String)"Sunshine"), I18n._((String)"No really, time for some fresh air for you."), null);
                }
                return null;
            }
            newbieName = "sketch_" + purty + (char)(97 + index);
            newbieDir = new File(newbieParentDir, newbieName);
            ++index;
        } while (newbieDir.exists() || new File(sketchbookDir, newbieName).exists());
        newbieDir.mkdirs();
        File newbieFile = new File(newbieDir, newbieName + ".ino");
        if (!newbieFile.createNewFile()) {
            throw new IOException();
        }
        FileUtils.copyFile((File)new File(Base.getContentFile("examples"), "01.Basics" + File.separator + "BareMinimum" + File.separator + "BareMinimum.ino"), (File)newbieFile);
        return newbieFile;
    }

    public void handleNew() throws Exception {
        block3: {
            try {
                File file = this.createNewUntitled();
                if (file != null) {
                    Editor editor = this.handleOpen(file);
                    editor.untitled = true;
                }
            }
            catch (IOException e) {
                if (this.activeEditor == null) break block3;
                this.activeEditor.statusError(e);
            }
        }
    }

    public void handleNewReplace() {
        if (!this.activeEditor.checkModified()) {
            return;
        }
        this.activeEditor.internalCloseRunner();
        this.handleNewReplaceImpl();
    }

    protected void handleNewReplaceImpl() {
        try {
            File file = this.createNewUntitled();
            if (file != null) {
                this.activeEditor.handleOpenInternal(file);
                this.activeEditor.untitled = true;
            }
        }
        catch (IOException e) {
            this.activeEditor.statusError(e);
        }
    }

    public void handleOpenReplace(File file) {
        if (!this.activeEditor.checkModified()) {
            return;
        }
        this.activeEditor.internalCloseRunner();
        boolean loaded = this.activeEditor.handleOpenInternal(file);
        if (!loaded) {
            this.handleNewReplaceImpl();
        }
    }

    public void handleOpenPrompt() throws Exception {
        FileDialog fd = new FileDialog((Frame)this.activeEditor, I18n._((String)"Open an Arduino sketch..."), 0);
        File lastFolder = new File(PreferencesData.get((String)"last.folder", (String)Base.getSketchbookFolder().getAbsolutePath()));
        if (lastFolder.exists() && lastFolder.isFile()) {
            lastFolder = lastFolder.getParentFile();
        }
        fd.setDirectory(lastFolder.getAbsolutePath());
        fd.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ino") || name.toLowerCase().endsWith(".pde");
            }
        });
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return;
        }
        File inputFile = new File(directory, filename);
        PreferencesData.set((String)"last.folder", (String)inputFile.getAbsolutePath());
        this.handleOpen(inputFile);
    }

    public Editor handleOpen(File file) throws Exception {
        return this.handleOpen(file, this.nextEditorLocation(), true);
    }

    protected Editor handleOpen(File file, int[] location, boolean showEditor) throws Exception {
        if (!file.exists()) {
            return null;
        }
        String path = file.getAbsolutePath();
        for (Editor editor : this.editors) {
            if (!editor.getSketch().getMainFilePath().equals(path)) continue;
            editor.toFront();
            return editor;
        }
        Editor editor = new Editor(this, file, location);
        if (editor.getSketch() == null) {
            return null;
        }
        this.editors.add(editor);
        if (showEditor) {
            editor.setVisible(true);
        }
        return editor;
    }

    public boolean handleClose(Editor editor) {
        if (!editor.checkModified()) {
            return false;
        }
        editor.internalCloseRunner();
        if (this.editors.size() == 1) {
            if (OSUtils.isMacOS()) {
                Object[] options = new Object[]{"OK", "Cancel"};
                String prompt = I18n._((String)"<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Are you sure you want to Quit?</b><p>Closing the last open sketch will quit Arduino.");
                int result = JOptionPane.showOptionDialog(editor, prompt, I18n._((String)"Quit"), 0, 3, null, options, options[0]);
                if (result == 1 || result == -1) {
                    return false;
                }
            }
            this.editors.remove(editor);
            try {
                Editor.serialMonitor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.storeSketches();
            PreferencesData.save();
            System.exit(0);
        } else {
            editor.setVisible(false);
            editor.dispose();
            this.editors.remove(editor);
        }
        return true;
    }

    public boolean handleQuit() {
        this.storeSketches();
        try {
            Editor.serialMonitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.handleQuitEach()) {
            for (Editor editor : this.editors) {
                editor.internalCloseRunner();
            }
            PreferencesData.save();
            if (!OSUtils.isMacOS()) {
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    protected boolean handleQuitEach() {
        int index = 0;
        for (Editor editor : this.editors) {
            if (editor.checkModified()) {
                this.storeSketchPath(editor, index);
                ++index;
                continue;
            }
            return false;
        }
        return true;
    }

    protected void rebuildSketchbookMenus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Base.this.rebuildSketchbookMenu(Editor.sketchbookMenu);
                Base.this.rebuildToolbarMenu(Editor.toolbarMenu);
            }
        });
    }

    protected void rebuildToolbarMenu(JMenu menu) {
        menu.removeAll();
        JMenuItem item = Editor.newJMenuItem(I18n._((String)"Open..."), 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Base.this.handleOpenPrompt();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        menu.add(item);
        menu.addSeparator();
        try {
            boolean sketches = this.addSketches(menu, Base.getSketchbookFolder(), true);
            if (sketches) {
                menu.addSeparator();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            boolean found = this.addSketches(menu, BaseNoGui.getExamplesFolder(), true);
            if (found) {
                menu.addSeparator();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void rebuildSketchbookMenu(JMenu menu) {
        try {
            menu.removeAll();
            this.addSketches(menu, Base.getSketchbookFolder(), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LibraryList getIDELibs() {
        LibraryList installedLibraries = new LibraryList(BaseNoGui.librariesIndexer.getInstalledLibraries());
        LinkedList libs = new LinkedList(Collections2.filter(new LinkedList(installedLibraries), (Predicate)Predicates.not(CONTRIBUTED)));
        return new LibraryList(libs);
    }

    public LibraryList getUserLibs() {
        LibraryList installedLibraries = new LibraryList(BaseNoGui.librariesIndexer.getInstalledLibraries());
        LinkedList libs = new LinkedList(Collections2.filter(new LinkedList(installedLibraries), CONTRIBUTED));
        return new LibraryList(libs);
    }

    public void rebuildImportMenu(JMenu importMenu) {
        if (importMenu == null) {
            return;
        }
        importMenu.removeAll();
        JMenuItem menu = new JMenuItem(I18n._((String)"Manage Libraries..."));
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.this.openManageLibrariesDialog();
            }
        });
        importMenu.add(menu);
        importMenu.addSeparator();
        JMenuItem addLibraryMenuItem = new JMenuItem(I18n._((String)"Add .ZIP Library..."));
        addLibraryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.this.handleAddLibrary();
                Base.this.onBoardOrPortChange();
                Base.this.rebuildImportMenu(Editor.importMenu);
                Base.this.rebuildExamplesMenu(Editor.examplesMenu);
            }
        });
        importMenu.add(addLibraryMenuItem);
        importMenu.addSeparator();
        TargetPlatform targetPlatform = Base.getTargetPlatform();
        if (targetPlatform != null) {
            LibraryList ideLibs = this.getIDELibs();
            LibraryList userLibs = this.getUserLibs();
            try {
                String platformNameLabel = StringUtils.capitalize((String)targetPlatform.getContainerPackage().getId()) + "/" + StringUtils.capitalize((String)targetPlatform.getId());
                platformNameLabel = I18n.format((String)I18n._((String)"{0} libraries"), (Object[])new Object[]{platformNameLabel});
                JMenuItem platformItem = new JMenuItem(I18n._((String)platformNameLabel));
                platformItem.setEnabled(false);
                importMenu.add(platformItem);
                if (ideLibs.size() > 0) {
                    this.addLibraries(importMenu, ideLibs);
                }
                if (userLibs.size() > 0) {
                    if (ideLibs.size() > 0) {
                        importMenu.addSeparator();
                    }
                    JMenuItem contributedLibraryItem = new JMenuItem(I18n._((String)"Contributed libraries"));
                    contributedLibraryItem.setEnabled(false);
                    importMenu.add(contributedLibraryItem);
                    this.addLibraries(importMenu, userLibs);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void rebuildExamplesMenu(JMenu menu) {
        if (menu == null) {
            return;
        }
        try {
            menu.removeAll();
            boolean found = this.addSketches(menu, BaseNoGui.getExamplesFolder(), false);
            if (found) {
                menu.addSeparator();
            }
            LibraryList ideLibs = this.getIDELibs();
            ideLibs.sort();
            for (UserLibrary lib : ideLibs) {
                this.addSketchesSubmenu(menu, lib, false);
            }
            LibraryList userLibs = this.getUserLibs();
            if (userLibs.size() > 0) {
                menu.addSeparator();
                userLibs.sort();
                for (UserLibrary lib : userLibs) {
                    this.addSketchesSubmenu(menu, lib, false);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onBoardOrPortChange() {
        BaseNoGui.onBoardOrPortChange();
        for (Editor editor : this.editors) {
            editor.onBoardOrPortChange();
        }
    }

    private void openManageLibrariesDialog() {
        LibraryManagerUI managerUI = new LibraryManagerUI(this.activeEditor){

            @Override
            protected void onIndexesUpdated() throws Exception {
                BaseNoGui.initPackages();
                Base.this.rebuildBoardsMenu();
                Base.this.onBoardOrPortChange();
                this.setIndexer(BaseNoGui.librariesIndexer);
            }
        };
        managerUI.setLocationRelativeTo(this.activeEditor);
        managerUI.setIndexer(BaseNoGui.librariesIndexer);
        managerUI.setVisible(true);
        this.onBoardOrPortChange();
        this.rebuildImportMenu(Editor.importMenu);
        this.rebuildExamplesMenu(Editor.examplesMenu);
    }

    private void openInstallBoardDialog(final String filterText) throws Exception {
        ContributionManagerUI managerUI = new ContributionManagerUI(this.activeEditor){

            @Override
            protected void onIndexesUpdated() throws Exception {
                BaseNoGui.initPackages();
                Base.this.rebuildBoardsMenu();
                this.setIndexer(BaseNoGui.indexer);
                if (StringUtils.isNotEmpty((CharSequence)filterText)) {
                    this.setFilterText(filterText);
                }
            }
        };
        managerUI.setLocationRelativeTo(this.activeEditor);
        managerUI.setIndexer(BaseNoGui.indexer);
        managerUI.setVisible(true);
        BaseNoGui.initPackages();
        this.rebuildBoardsMenu();
        this.onBoardOrPortChange();
    }

    public void rebuildBoardsMenu() throws Exception {
        this.boardsCustomMenus = new LinkedList<JMenu>();
        JMenu boardMenu = new JMenu(I18n._((String)"Board"));
        boardMenu.putClientProperty("removeOnWindowDeactivation", true);
        MenuScroller.setScrollerFor(boardMenu);
        this.openBoardsManager = new AbstractAction(I18n._((String)"Boards Manager...")){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                String filterText = "";
                if (actionevent instanceof Event) {
                    filterText = ((Event)actionevent).getPayload().get("filterText").toString();
                }
                try {
                    Base.this.openInstallBoardDialog(filterText);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        boardMenu.add(new JMenuItem(this.openBoardsManager));
        this.boardsCustomMenus.add(boardMenu);
        if (BaseNoGui.packages.size() == 0) {
            return;
        }
        boardMenu.add(new JSeparator());
        HashSet customMenusTitles = new HashSet();
        for (TargetPackage targetPackage : BaseNoGui.packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.platforms()) {
                customMenusTitles.addAll(targetPlatform.getCustomMenus().values());
            }
        }
        for (String customMenuTitle : customMenusTitles) {
            JMenu customMenu = new JMenu(I18n._((String)customMenuTitle));
            customMenu.putClientProperty("removeOnWindowDeactivation", true);
            this.boardsCustomMenus.add(customMenu);
        }
        LinkedList<JMenuItem> menuItemsToClickAfterStartup = new LinkedList<JMenuItem>();
        ButtonGroup boardsButtonGroup = new ButtonGroup();
        HashMap<String, ButtonGroup> buttonGroupsMap = new HashMap<String, ButtonGroup>();
        boolean first = true;
        for (TargetPackage targetPackage : BaseNoGui.packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.platforms()) {
                if (!first) {
                    boardMenu.add(new JSeparator());
                }
                first = false;
                String platformLabel = (String)targetPlatform.getPreferences().get((Object)"name");
                if (platformLabel != null && !targetPlatform.getBoards().isEmpty()) {
                    JMenuItem menuLabel = new JMenuItem(I18n._((String)platformLabel));
                    menuLabel.setEnabled(false);
                    boardMenu.add(menuLabel);
                }
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    JRadioButtonMenuItem item = this.createBoardMenusAndCustomMenus(this.boardsCustomMenus, menuItemsToClickAfterStartup, buttonGroupsMap, board, targetPlatform, targetPackage);
                    boardMenu.add(item);
                    boardsButtonGroup.add(item);
                }
            }
        }
        if (menuItemsToClickAfterStartup.isEmpty()) {
            menuItemsToClickAfterStartup.add(Base.selectFirstEnabledMenuItem(boardMenu));
        }
        for (JMenuItem menuItemToClick : menuItemsToClickAfterStartup) {
            menuItemToClick.setSelected(true);
            menuItemToClick.getAction().actionPerformed(new ActionEvent(this, -1, ""));
        }
    }

    private JRadioButtonMenuItem createBoardMenusAndCustomMenus(final List<JMenu> boardsCustomMenus, List<JMenuItem> menuItemsToClickAfterStartup, Map<String, ButtonGroup> buttonGroupsMap, TargetBoard board, TargetPlatform targetPlatform, TargetPackage targetPackage) throws Exception {
        String selPackage = PreferencesData.get((String)"target_package");
        String selPlatform = PreferencesData.get((String)"target_platform");
        String selBoard = PreferencesData.get((String)"board");
        String boardId = board.getId();
        String packageName = targetPackage.getId();
        String platformName = targetPlatform.getId();
        AbstractAction action = new AbstractAction(board.getName()){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                Base.this.selectBoard((TargetBoard)this.getValue("b"));
                Base.this.filterVisibilityOfSubsequentBoardMenus(boardsCustomMenus, (TargetBoard)this.getValue("b"), 1);
                Base.this.onBoardOrPortChange();
                Base.this.rebuildImportMenu(Editor.importMenu);
                Base.this.rebuildExamplesMenu(Editor.examplesMenu);
            }
        };
        action.putValue("b", board);
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
        if (selBoard.equals(boardId) && selPackage.equals(packageName) && selPlatform.equals(platformName)) {
            menuItemsToClickAfterStartup.add(item);
        }
        PreferencesMap customMenus = targetPlatform.getCustomMenus();
        for (final String menuId : customMenus.keySet()) {
            String title = (String)customMenus.get((Object)menuId);
            JMenu menu = this.getBoardCustomMenu(I18n._((String)title));
            if (!board.hasMenu(menuId)) continue;
            PreferencesMap boardCustomMenu = board.getMenuLabels(menuId);
            for (String customMenuOption : boardCustomMenu.keySet()) {
                AbstractAction subAction = new AbstractAction(I18n._((String)((String)boardCustomMenu.get((Object)customMenuOption)))){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PreferencesData.set((String)("custom_" + menuId), (String)(((TargetBoard)this.getValue("board")).getId() + "_" + this.getValue("custom_menu_option")));
                        Base.this.onBoardOrPortChange();
                    }
                };
                subAction.putValue("board", board);
                subAction.putValue("custom_menu_option", customMenuOption);
                if (!buttonGroupsMap.containsKey(menuId)) {
                    buttonGroupsMap.put(menuId, new ButtonGroup());
                }
                JRadioButtonMenuItem subItem = new JRadioButtonMenuItem(subAction);
                menu.add(subItem);
                buttonGroupsMap.get(menuId).add(subItem);
                String selectedCustomMenuEntry = PreferencesData.get((String)("custom_" + menuId));
                if (!selBoard.equals(boardId) || !(boardId + "_" + customMenuOption).equals(selectedCustomMenuEntry)) continue;
                menuItemsToClickAfterStartup.add(subItem);
            }
        }
        return item;
    }

    private void filterVisibilityOfSubsequentBoardMenus(List<JMenu> boardsCustomMenus, TargetBoard board, int fromIndex) {
        for (int i = fromIndex; i < boardsCustomMenus.size(); ++i) {
            JMenuItem visibleSelectedOrFirstMenuItem;
            JMenu menu = boardsCustomMenus.get(i);
            for (int m = 0; m < menu.getItemCount(); ++m) {
                JMenuItem menuItem = menu.getItem(m);
                menuItem.setVisible(menuItem.getAction().getValue("board").equals(board));
            }
            menu.setVisible(Base.ifThereAreVisibleItemsOn(menu));
            if (!menu.isVisible() || (visibleSelectedOrFirstMenuItem = Base.selectVisibleSelectedOrFirstMenuItem(menu)).isSelected()) continue;
            visibleSelectedOrFirstMenuItem.setSelected(true);
            visibleSelectedOrFirstMenuItem.getAction().actionPerformed(null);
        }
    }

    private static boolean ifThereAreVisibleItemsOn(JMenu menu) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (!menu.getItem(i).isVisible()) continue;
            return true;
        }
        return false;
    }

    private JMenu getBoardCustomMenu(String label) throws Exception {
        for (JMenu menu : this.boardsCustomMenus) {
            if (!label.equals(menu.getText())) continue;
            return menu;
        }
        throw new Exception("Custom menu not found!");
    }

    private static JMenuItem selectVisibleSelectedOrFirstMenuItem(JMenu menu) {
        JMenuItem firstVisible = null;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null || !item.isVisible()) continue;
            if (item.isSelected()) {
                return item;
            }
            if (firstVisible != null) continue;
            firstVisible = item;
        }
        if (firstVisible != null) {
            return firstVisible;
        }
        throw new IllegalStateException("Menu has no enabled items");
    }

    private static JMenuItem selectFirstEnabledMenuItem(JMenu menu) {
        for (int i = 1; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null || !item.isEnabled()) continue;
            return item;
        }
        throw new IllegalStateException("Menu has no enabled items");
    }

    private void selectBoard(TargetBoard targetBoard) {
        BaseNoGui.selectBoard((TargetBoard)targetBoard);
    }

    public static void selectSerialPort(String port) {
        BaseNoGui.selectSerialPort((String)port);
    }

    public void rebuildProgrammerMenu(JMenu menu) {
        menu.removeAll();
        ButtonGroup group = new ButtonGroup();
        for (TargetPackage targetPackage : BaseNoGui.packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.platforms()) {
                for (String programmer : targetPlatform.getProgrammers().keySet()) {
                    String id = targetPackage.getId() + ":" + programmer;
                    AbstractAction action = new AbstractAction((String)targetPlatform.getProgrammer(programmer).get((Object)"name")){

                        @Override
                        public void actionPerformed(ActionEvent actionevent) {
                            PreferencesData.set((String)"programmer", (String)("" + this.getValue("id")));
                        }
                    };
                    action.putValue("id", id);
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
                    if (PreferencesData.get((String)"programmer").equals(id)) {
                        item.setSelected(true);
                    }
                    group.add(item);
                    menu.add(item);
                }
            }
        }
    }

    protected boolean addSketches(JMenu menu, File folder, boolean replaceExisting) throws IOException {
        if (folder == null) {
            return false;
        }
        if (!folder.isDirectory()) {
            return false;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return false;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareToIgnoreCase(file2.getName());
            }
        });
        boolean ifound = false;
        for (File subfolder : files) {
            if (FileUtils.isSCCSOrHiddenFile((File)subfolder) || !subfolder.isDirectory() || !this.addSketchesSubmenu(menu, subfolder.getName(), subfolder, replaceExisting)) continue;
            ifound = true;
        }
        return ifound;
    }

    private boolean addSketchesSubmenu(JMenu menu, UserLibrary lib, boolean replaceExisting) throws IOException {
        return this.addSketchesSubmenu(menu, lib.getName(), lib.getInstalledFolder(), replaceExisting);
    }

    private boolean addSketchesSubmenu(JMenu menu, String name, File folder, final boolean replaceExisting) throws IOException {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = e.getActionCommand();
                File file = new File(path);
                if (file.exists()) {
                    boolean replace = replaceExisting;
                    if ((e.getModifiers() & 1) != 0) {
                        boolean bl = replace = !replace;
                    }
                    if (replace) {
                        Base.this.handleOpenReplace(file);
                    } else {
                        try {
                            Base.this.handleOpen(file);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    Base.showWarning(I18n._((String)"Sketch Does Not Exist"), I18n._((String)"The selected sketch no longer exists.\nYou may need to restart Arduino to update\nthe sketchbook menu."), null);
                }
            }
        };
        File entry = new File(folder, name + ".ino");
        if (!entry.exists() && new File(folder, name + ".pde").exists()) {
            entry = new File(folder, name + ".pde");
        }
        if (entry.exists()) {
            if (!BaseNoGui.isSanitaryName((String)name)) {
                if (!this.builtOnce) {
                    String complaining = I18n.format((String)I18n._((String)"The sketch \"{0}\" cannot be used.\nSketch names must contain only basic letters and numbers\n(ASCII-only with no spaces, and it cannot start with a number).\nTo get rid of this message, remove the sketch from\n{1}"), (Object[])new Object[]{name, entry.getAbsolutePath()});
                    Base.showMessage(I18n._((String)"Ignoring sketch with bad name"), complaining);
                }
                return false;
            }
            JMenuItem item = new JMenuItem(name);
            item.addActionListener(listener);
            item.setActionCommand(entry.getAbsolutePath());
            menu.add(item);
            return true;
        }
        if (folder.getName().equals("examples")) {
            return this.addSketches(menu, folder, replaceExisting);
        }
        JMenu submenu = new JMenu(name);
        boolean found = this.addSketches(submenu, folder, replaceExisting);
        if (found) {
            menu.add(submenu);
            MenuScroller.setScrollerFor(submenu);
        }
        return found;
    }

    protected void addLibraries(JMenu menu, LibraryList libs) throws IOException {
        LibraryList list = new LibraryList(libs);
        list.sort();
        for (UserLibrary lib : list) {
            AbstractAction action = new AbstractAction(lib.getName()){

                @Override
                public void actionPerformed(ActionEvent event) {
                    UserLibrary l = (UserLibrary)this.getValue("library");
                    try {
                        Base.this.activeEditor.getSketch().importLibrary(l);
                    }
                    catch (IOException e) {
                        Base.showWarning(I18n._((String)"Error"), I18n.format((String)"Unable to list header files in {0}", (Object[])new Object[]{l.getSrcFolder()}), e);
                    }
                }
            };
            action.putValue("library", lib);
            JMenuItem item = new JMenuItem(action);
            item.putClientProperty("library", lib);
            menu.add(item);
        }
    }

    public static String[] headerListFromIncludePath(File path) throws IOException {
        String[] list = path.list((FilenameFilter)new OnlyFilesWithExtension(new String[]{".h"}));
        if (list == null) {
            throw new IOException();
        }
        return list;
    }

    protected void loadHardware(File folder) {
        BaseNoGui.loadHardware((File)folder);
    }

    public void handleAbout() {
        final Image image = Base.getLibImage("about.png", this.activeEditor);
        final Window window = new Window(this.activeEditor){

            @Override
            public void paint(Graphics g) {
                g.drawImage(image, 0, 0, null);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                g.setFont(new Font("SansSerif", 0, 11));
                g.setColor(Color.white);
                g.drawString(BaseNoGui.VERSION_NAME, 33, 20);
            }
        };
        window.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                window.dispose();
            }
        });
        int w = image.getWidth(this.activeEditor);
        int h = image.getHeight(this.activeEditor);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        window.setBounds((screen.width - w) / 2, (screen.height - h) / 2, w, h);
        window.setLocationRelativeTo(this.activeEditor);
        window.setVisible(true);
    }

    public void handlePrefs() {
        if (this.preferencesFrame == null) {
            this.preferencesFrame = new Preferences();
        }
        this.preferencesFrame.showFrame(this.activeEditor);
    }

    public static Platform getPlatform() {
        return BaseNoGui.getPlatform();
    }

    public static String getPlatformName() {
        String osname = System.getProperty("os.name");
        if (osname.indexOf("Mac") != -1) {
            return "macosx";
        }
        if (osname.indexOf("Windows") != -1) {
            return "windows";
        }
        if (osname.equals("Linux")) {
            return "linux";
        }
        return "other";
    }

    public static File getSettingsFolder() {
        return BaseNoGui.getSettingsFolder();
    }

    public static File getSettingsFile(String filename) {
        return BaseNoGui.getSettingsFile((String)filename);
    }

    public static File getBuildFolder() {
        return BaseNoGui.getBuildFolder();
    }

    public static File createTempFolder(String name) {
        return BaseNoGui.createTempFolder((String)name);
    }

    public static LibraryList getLibraries() {
        return BaseNoGui.librariesIndexer.getInstalledLibraries();
    }

    public static String getExamplesPath() {
        return BaseNoGui.getExamplesPath();
    }

    public static List<File> getLibrariesPath() {
        return BaseNoGui.getLibrariesPath();
    }

    public static File getToolsFolder() {
        return BaseNoGui.getToolsFolder();
    }

    public static String getToolsPath() {
        return BaseNoGui.getToolsPath();
    }

    public static File getHardwareFolder() {
        return BaseNoGui.getHardwareFolder();
    }

    public static File getCoreLibraries(String path) {
        return Base.getContentFile(path);
    }

    public static String getHardwarePath() {
        return BaseNoGui.getHardwarePath();
    }

    public static String getAvrBasePath() {
        return BaseNoGui.getAvrBasePath();
    }

    public static TargetPackage getTargetPackage(String packageName) {
        return BaseNoGui.getTargetPackage((String)packageName);
    }

    public static TargetPlatform getTargetPlatform() {
        return BaseNoGui.getTargetPlatform();
    }

    public static TargetPlatform getTargetPlatform(String packageName, String platformName) {
        return BaseNoGui.getTargetPlatform((String)packageName, (String)platformName);
    }

    public static TargetPlatform getCurrentTargetPlatformFromPackage(String pack) {
        return BaseNoGui.getCurrentTargetPlatformFromPackage((String)pack);
    }

    public static PreferencesMap getBoardPreferences() {
        return BaseNoGui.getBoardPreferences();
    }

    public List<JMenu> getBoardsCustomMenus() {
        return this.boardsCustomMenus;
    }

    public static File getPortableFolder() {
        return BaseNoGui.getPortableFolder();
    }

    public static String getPortableSketchbookFolder() {
        return BaseNoGui.getPortableSketchbookFolder();
    }

    public static File getSketchbookFolder() {
        return BaseNoGui.getSketchbookFolder();
    }

    public static File getSketchbookLibrariesFolder() {
        return BaseNoGui.getSketchbookLibrariesFolder();
    }

    public static String getSketchbookLibrariesPath() {
        return Base.getSketchbookLibrariesFolder().getAbsolutePath();
    }

    public static File getSketchbookHardwareFolder() {
        return BaseNoGui.getSketchbookHardwareFolder();
    }

    protected File getDefaultSketchbookFolderOrPromptForIt() {
        File sketchbookFolder = BaseNoGui.getDefaultSketchbookFolder();
        if (sketchbookFolder == null) {
            sketchbookFolder = Base.promptSketchbookLocation();
        }
        boolean result = true;
        if (!sketchbookFolder.exists()) {
            result = sketchbookFolder.mkdirs();
        }
        if (!result) {
            Base.showError(I18n._((String)"You forgot your sketchbook"), I18n._((String)"Arduino cannot run because it could not\ncreate a folder to store your sketchbook."), null);
        }
        return sketchbookFolder;
    }

    protected static File promptSketchbookLocation() {
        File folder = null;
        folder = new File(System.getProperty("user.home"), "sketchbook");
        if (!folder.exists()) {
            folder.mkdirs();
            return folder;
        }
        String prompt = I18n._((String)"Select (or create new) folder for sketches...");
        folder = Base.selectFolder(prompt, null, null);
        if (folder == null) {
            System.exit(0);
        }
        return folder;
    }

    public static void openURL(String url) {
        try {
            Base.getPlatform().openURL(url);
        }
        catch (Exception e) {
            Base.showWarning(I18n._((String)"Problem Opening URL"), I18n.format((String)I18n._((String)"Could not open the URL\n{0}"), (Object[])new Object[]{url}), e);
        }
    }

    protected static boolean openFolderAvailable() {
        return BaseNoGui.getPlatform().openFolderAvailable();
    }

    public static void openFolder(File file) {
        try {
            BaseNoGui.getPlatform().openFolder(file);
        }
        catch (Exception e) {
            Base.showWarning(I18n._((String)"Problem Opening Folder"), I18n.format((String)I18n._((String)"Could not open the folder\n{0}"), (Object[])new Object[]{file.getAbsolutePath()}), e);
        }
    }

    public static File selectFolder(String prompt, File folder, Frame frame) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(prompt);
        if (folder != null) {
            fc.setSelectedFile(folder);
        }
        fc.setFileSelectionMode(1);
        int returned = fc.showOpenDialog(new JDialog());
        if (returned == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static void setIcon(Frame frame) {
        if (OSUtils.isMacOS()) {
            return;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(PApplet.ICON_IMAGE);
        frame.setIconImage(image);
    }

    public static void registerWindowCloseKeys(JRootPane root, ActionListener disposer) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        root.registerKeyboardAction(disposer, stroke, 2);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        stroke = KeyStroke.getKeyStroke(87, modifiers);
        root.registerKeyboardAction(disposer, stroke, 2);
    }

    public static void showReference(String filename) {
        Base.showReference("reference/arduino.cc/en", filename);
    }

    public static void showReference(String prefix, String filename) {
        File referenceFolder = Base.getContentFile(prefix);
        File referenceFile = new File(referenceFolder, filename);
        if (!referenceFile.exists()) {
            referenceFile = new File(referenceFolder, filename + ".html");
        }
        Base.openURL(referenceFile.getAbsolutePath());
    }

    public static void showEdisonGettingStarted() {
        Base.showReference("reference/Edison_help_files", "ArduinoIDE_guide_edison");
    }

    public static void showArduinoGettingStarted() {
        if (OSUtils.isMacOS()) {
            Base.showReference("Guide/MacOSX");
        } else if (OSUtils.isWindows()) {
            Base.showReference("Guide/Windows");
        } else {
            Base.openURL("http://www.arduino.cc/playground/Learning/Linux");
        }
    }

    public static void showReference() {
        Base.showReference("Reference/HomePage");
    }

    public static void showEnvironment() {
        Base.showReference("Guide/Environment");
    }

    public static void showTroubleshooting() {
        Base.showReference("Guide/Troubleshooting");
    }

    public static void showFAQ() {
        Base.showReference("Main/FAQ");
    }

    public static void showMessage(String title, String message) {
        BaseNoGui.showMessage((String)title, (String)message);
    }

    public static void showWarning(String title, String message, Exception e) {
        BaseNoGui.showWarning((String)title, (String)message, (Exception)e);
    }

    public static void showError(String title, String message, Throwable e) {
        Base.showError(title, message, e, 1);
    }

    public static void showError(String title, String message, int exit_code) {
        Base.showError(title, message, null, exit_code);
    }

    public static void showError(String title, String message, Throwable e, int exit_code) {
        BaseNoGui.showError((String)title, (String)message, (Throwable)e, (int)exit_code);
    }

    public static int showYesNoCancelQuestion(Editor editor, String title, String primary, String secondary) {
        if (!OSUtils.isMacOS()) {
            int result = JOptionPane.showConfirmDialog(null, primary + "\n" + secondary, title, 1, 3);
            return result;
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost.", 3);
        Object[] options = new String[]{"Save", "Cancel", "Don't Save"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return 0;
        }
        if (result == options[1]) {
            return 2;
        }
        if (result == options[2]) {
            return 1;
        }
        return -1;
    }

    public static int showYesNoQuestion(Frame editor, String title, String primary, String secondary) {
        if (!OSUtils.isMacOS()) {
            return JOptionPane.showConfirmDialog(editor, "<html><body><b>" + primary + "</b>" + "<br>" + secondary, title, 0, 3);
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>" + primary + "</b>" + "<p>" + secondary + "</p>", 3);
        Object[] options = new String[]{"Yes", "No"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return 0;
        }
        if (result == options[1]) {
            return 1;
        }
        return -1;
    }

    public static File getContentFile(String name) {
        return BaseNoGui.getContentFile((String)name);
    }

    public static Image getThemeImage(String name, Component who) {
        return Base.getLibImage("theme/" + name, who);
    }

    public static Image getLibImage(String name, Component who) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        File imageLocation = new File(Base.getContentFile("lib"), name);
        Image image = tk.getImage(imageLocation.getAbsolutePath());
        MediaTracker tracker = new MediaTracker(who);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    public static int countLines(String what) {
        return BaseNoGui.countLines((String)what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytesRaw(File file) throws IOException {
        int size = (int)file.length();
        FileInputStream input = null;
        try {
            int bytesRead;
            input = new FileInputStream(file);
            byte[] buffer = new byte[size];
            int offset = 0;
            while ((bytesRead = input.read(buffer, offset, size - offset)) != -1) {
                offset += bytesRead;
                if (bytesRead != 0) continue;
            }
            byte[] byArray = buffer;
            return byArray;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public static HashMap<String, String> readSettings(File inputFile) {
        HashMap<String, String> outgoing = new HashMap<String, String>();
        if (!inputFile.exists()) {
            return outgoing;
        }
        String[] lines = PApplet.loadStrings((File)inputFile);
        for (int i = 0; i < lines.length; ++i) {
            String line;
            int hash = lines[i].indexOf(35);
            String string = line = hash == -1 ? lines[i].trim() : lines[i].substring(0, hash).trim();
            if (line.length() == 0) continue;
            int equals = line.indexOf(61);
            if (equals == -1) {
                System.err.println("ignoring illegal line in " + inputFile);
                System.err.println("  " + line);
                continue;
            }
            String attr = line.substring(0, equals).trim();
            String valu = line.substring(equals + 1).trim();
            outgoing.put(attr, valu);
        }
        return outgoing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        InputStream from = null;
        OutputStream to = null;
        try {
            int bytesRead;
            from = new BufferedInputStream(new FileInputStream(sourceFile));
            to = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] buffer = new byte[16384];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
            to.flush();
        }
        finally {
            if (from != null) {
                from.close();
            }
            if (to != null) {
                to.close();
            }
        }
        targetFile.setLastModified(sourceFile.lastModified());
    }

    public static String loadFile(File file) throws IOException {
        return BaseNoGui.loadFile((File)file);
    }

    public static void saveFile(String str, File file) throws IOException {
        BaseNoGui.saveFile((String)str, (File)file);
    }

    public static void copyDir(File sourceDir, File targetDir) throws IOException {
        targetDir.mkdirs();
        String[] files = sourceDir.list();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].charAt(0) == '.') continue;
            File source = new File(sourceDir, files[i]);
            File target = new File(targetDir, files[i]);
            if (source.isDirectory()) {
                Base.copyDir(source, target);
                target.setLastModified(source.lastModified());
                continue;
            }
            Base.copyFile(source, target);
        }
    }

    public static void removeDir(File dir) {
        BaseNoGui.removeDir((File)dir);
    }

    public static void removeDescendants(File dir) {
        BaseNoGui.removeDescendants((File)dir);
    }

    public static int calcFolderSize(File folder) {
        int size = 0;
        String[] files = folder.list();
        if (files == null) {
            return -1;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(".") || files[i].equals("..") || files[i].equals(".DS_Store")) continue;
            File fella = new File(folder, files[i]);
            if (fella.isDirectory()) {
                size += Base.calcFolderSize(fella);
                continue;
            }
            size += (int)fella.length();
        }
        return size;
    }

    public static String[] listFiles(String path, boolean relative) {
        return Base.listFiles(new File(path), relative);
    }

    public static String[] listFiles(File folder, boolean relative) {
        String path = folder.getAbsolutePath();
        Vector<String> vector = new Vector<String>();
        Base.listFiles(relative ? path + File.separator : "", path, vector);
        Object[] outgoing = new String[vector.size()];
        vector.copyInto(outgoing);
        return outgoing;
    }

    protected static void listFiles(String basePath, String path, Vector<String> vector) {
        File folder = new File(path);
        String[] list = folder.list();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].charAt(0) == '.') continue;
            File file = new File(path, list[i]);
            String newPath = file.getAbsolutePath();
            if (newPath.startsWith(basePath)) {
                newPath = newPath.substring(basePath.length());
            }
            vector.add(newPath);
            if (!file.isDirectory()) continue;
            Base.listFiles(basePath, newPath, vector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAddLibrary() {
        File destinationFolder;
        File tmpFolder;
        File sourceFile;
        block14: {
            block13: {
                block12: {
                    JFileChooser fileChooser = new JFileChooser(System.getProperty("user.home"));
                    fileChooser.setDialogTitle(I18n._((String)"Select a zip file or a folder containing the library you'd like to add"));
                    fileChooser.setFileSelectionMode(2);
                    fileChooser.setFileFilter(new FileNameExtensionFilter(I18n._((String)"ZIP files or folders"), "zip"));
                    Dimension preferredSize = fileChooser.getPreferredSize();
                    fileChooser.setPreferredSize(new Dimension(preferredSize.width + 200, preferredSize.height + 200));
                    int returnVal = fileChooser.showOpenDialog(this.activeEditor);
                    if (returnVal != 0) {
                        return;
                    }
                    sourceFile = fileChooser.getSelectedFile();
                    tmpFolder = null;
                    try {
                        if (sourceFile.isDirectory()) break block12;
                        try {
                            tmpFolder = FileUtils.createTempFolder();
                            ZipDeflater zipDeflater = new ZipDeflater(sourceFile, tmpFolder);
                            zipDeflater.deflate();
                            File[] foldersInTmpFolder = tmpFolder.listFiles((FilenameFilter)new OnlyDirs());
                            if (foldersInTmpFolder.length != 1) {
                                throw new IOException(I18n._((String)"Zip doesn't contain a library"));
                            }
                            sourceFile = foldersInTmpFolder[0];
                        }
                        catch (IOException e) {
                            this.activeEditor.statusError(e);
                            FileUtils.recursiveDelete((File)tmpFolder);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.recursiveDelete(tmpFolder);
                        throw throwable;
                    }
                }
                File libFolder = sourceFile;
                String libName = libFolder.getName();
                if (BaseNoGui.isSanitaryName((String)libName)) break block13;
                String mess = I18n.format((String)I18n._((String)"The library \"{0}\" cannot be used.\nLibrary names must contain only basic letters and numbers.\n(ASCII only and no spaces, and it cannot start with a number)"), (Object[])new Object[]{libName});
                this.activeEditor.statusError(mess);
                FileUtils.recursiveDelete((File)tmpFolder);
                return;
            }
            destinationFolder = new File(Base.getSketchbookLibrariesFolder(), sourceFile.getName());
            if (destinationFolder.mkdir()) break block14;
            this.activeEditor.statusError(I18n.format((String)I18n._((String)"A library named {0} already exists"), (Object[])new Object[]{sourceFile.getName()}));
            FileUtils.recursiveDelete((File)tmpFolder);
            return;
        }
        try {
            FileUtils.copy((File)sourceFile, (File)destinationFolder);
        }
        catch (IOException e) {
            this.activeEditor.statusError(e);
            FileUtils.recursiveDelete((File)tmpFolder);
            return;
        }
        this.activeEditor.statusNotice(I18n._((String)"Library added to your libraries. Check \"Include library\" menu"));
        FileUtils.recursiveDelete((File)tmpFolder);
    }

    public static DiscoveryManager getDiscoveryManager() {
        return BaseNoGui.getDiscoveryManager();
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    public boolean hasActiveEditor() {
        return this.activeEditor != null;
    }

    public List<Editor> getEditors() {
        return new LinkedList<Editor>(this.editors);
    }

    public Action getOpenBoardsManager() {
        return this.openBoardsManager;
    }

    static {
        splashScreenHelper = new SplashScreenHelper(SplashScreen.getSplashScreen());
    }
}

