/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.im.InputMethodRequests;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import processing.app.Base;
import processing.app.EditorLineStatus;
import processing.app.EditorListener;
import processing.app.syntax.InputHandler;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.SyntaxUtilities;
import processing.app.syntax.TextAreaDefaults;
import processing.app.syntax.TextAreaLineNumbers;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.TextUtilities;
import processing.app.syntax.Token;
import processing.app.syntax.TokenMarker;
import processing.app.syntax.im.InputMethodSupport;

public class JEditTextArea
extends JComponent {
    public static String LEFT_OF_SCROLLBAR = "los";
    private InputMethodSupport inputMethodSupport = null;
    public EditorListener editorListener;
    public EditorLineStatus editorLineStatus;
    protected static String LEFT = "left";
    protected static String CENTER = "center";
    protected static String RIGHT = "right";
    protected static String BOTTOM = "bottom";
    protected static JEditTextArea focusedComponent;
    protected static Timer caretTimer;
    protected TextAreaPainter painter;
    protected TextAreaLineNumbers editorLineNumbers;
    protected JPopupMenu popup;
    protected EventListenerList eventListenerList;
    protected MutableCaretEvent caretEvent;
    protected boolean caretBlinks;
    protected boolean caretVisible;
    protected boolean blink;
    protected boolean editable;
    protected int firstLine;
    protected int visibleLines;
    protected int electricScroll;
    protected int horizontalOffset;
    protected JScrollBar vertical;
    protected JScrollBar horizontal;
    protected boolean scrollBarsInitialized;
    protected InputHandler inputHandler;
    protected SyntaxDocument document;
    protected DocumentHandler documentHandler;
    protected Segment lineSegment;
    protected int selectionStart;
    protected int selectionStartLine;
    protected int selectionEnd;
    protected int selectionEndLine;
    protected boolean biasLeft;
    protected int newSelectionStart;
    protected int newSelectionEnd;
    protected boolean selectWord;
    protected boolean selectLine;
    protected int selectionAncorStart;
    protected int selectionAncorEnd;
    protected int bracketPosition;
    protected int bracketLine;
    protected int magicCaret;
    protected boolean overwrite;
    protected boolean rectSelect;

    public JEditTextArea(TextAreaDefaults defaults) {
        this.enableEvents(8L);
        this.painter = new TextAreaPainter(this, defaults);
        this.editorLineNumbers = new TextAreaLineNumbers(this, defaults);
        this.documentHandler = new DocumentHandler();
        this.eventListenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.lineSegment = new Segment();
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.blink = true;
        this.setLayout(new ScrollLayout());
        this.add(LEFT, this.editorLineNumbers);
        this.add(CENTER, this.painter);
        this.vertical = new JScrollBar(1);
        this.add(RIGHT, this.vertical);
        this.horizontal = new JScrollBar(0);
        this.add(BOTTOM, this.horizontal);
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.painter.addComponentListener(new ComponentHandler());
        this.painter.addMouseListener(new MouseHandler());
        this.painter.addMouseMotionListener(new DragHandler());
        this.addFocusListener(new FocusHandler());
        this.setFocusTraversalKeysEnabled(false);
        this.setInputHandler(defaults.inputHandler);
        this.setDocument(defaults.document);
        this.editable = defaults.editable;
        this.caretVisible = defaults.caretVisible;
        this.caretBlinks = defaults.caretBlinks;
        this.electricScroll = defaults.electricScroll;
        focusedComponent = this;
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (!JEditTextArea.this.scrollBarsInitialized) {
                    return;
                }
                int amt = e.getWheelRotation();
                JEditTextArea.this.vertical.setValue(JEditTextArea.this.vertical.getValue() + amt * 3);
            }
        });
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.inputMethodSupport == null) {
            this.inputMethodSupport = new InputMethodSupport(this);
        }
        return this.inputMethodSupport;
    }

    public int getScrollPosition() {
        return this.vertical.getValue();
    }

    public void setScrollPosition(int what) {
        this.vertical.setValue(what);
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean caretBlinks) {
        this.caretBlinks = caretBlinks;
        if (!caretBlinks) {
            this.blink = false;
        }
        this.painter.invalidateSelectedLines();
    }

    public final boolean isCaretVisible() {
        return (!this.caretBlinks || this.blink) && this.caretVisible;
    }

    public void setCaretVisible(boolean caretVisible) {
        this.caretVisible = caretVisible;
        this.blink = true;
        this.painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.painter.invalidateSelectedLines();
        } else {
            this.blink = true;
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int electricScroll) {
        this.electricScroll = electricScroll;
    }

    public void updateScrollBars() {
        if (this.vertical != null && this.visibleLines != 0) {
            this.vertical.setValues(this.firstLine, this.visibleLines, 0, this.getLineCount());
            this.vertical.setUnitIncrement(2);
            this.vertical.setBlockIncrement(this.visibleLines);
        }
        if (this.horizontal != null && this.painter.getWidth() != 0) {
            int lineCount = this.getLineCount();
            int maxLineLength = 0;
            for (int i = 0; i < lineCount; ++i) {
                int lineLength = this.getLineLength(i);
                if (lineLength <= maxLineLength) continue;
                maxLineLength = lineLength;
            }
            int charWidth = this.painter.getFontMetrics().charWidth('w');
            int width = maxLineLength * charWidth;
            int painterWidth = this.painter.getWidth();
            this.horizontal.setValues(-this.horizontalOffset, painterWidth, 0, width);
            this.horizontal.setUnitIncrement(charWidth);
            this.horizontal.setBlockIncrement(width / 2);
        }
        this.updateLineNumbers();
    }

    private void updateLineNumbers() {
        if (this.editorLineNumbers != null) {
            this.editorLineNumbers.updateLineNumbers(this.getFirstLine() + 1, Math.min(this.getFirstLine() + this.getVisibleLines() + 1, this.getLineCount()));
            this.editorLineNumbers.updateWidthForNumDigits(String.valueOf(this.getLineCount()).length());
        }
    }

    public final int getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(int firstLine) {
        if (firstLine == this.firstLine) {
            return;
        }
        this.firstLine = firstLine;
        if (firstLine != this.vertical.getValue()) {
            this.updateScrollBars();
        }
        this.repaintEditor();
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int height = this.painter.getHeight();
        int lineHeight = this.painter.getFontMetrics().getHeight();
        this.visibleLines = height / lineHeight;
        this.updateScrollBars();
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int horizontalOffset) {
        if (horizontalOffset == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = horizontalOffset;
        if (horizontalOffset != this.horizontal.getValue()) {
            this.updateScrollBars();
        }
        this.repaintEditor();
    }

    public boolean setOrigin(int firstLine, int horizontalOffset) {
        boolean changed = false;
        if (horizontalOffset != this.horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
            changed = true;
        }
        if (firstLine != this.firstLine) {
            this.firstLine = firstLine;
            changed = true;
        }
        if (changed) {
            this.updateScrollBars();
            this.repaintEditor();
        }
        return changed;
    }

    private void repaintEditor() {
        this.painter.repaint();
        this.updateLineNumbers();
    }

    public boolean scrollToCaret() {
        int line = this.getCaretLine();
        int lineStart = this.getLineStartOffset(line);
        int offset = Math.max(0, Math.min(this.getLineLength(line) - 1, this.getCaretPosition() - lineStart));
        return this.scrollTo(line, offset);
    }

    public boolean scrollTo(int line, int offset) {
        if (this.visibleLines == 0) {
            this.setFirstLine(Math.max(0, line - this.electricScroll));
            return true;
        }
        int newFirstLine = this.firstLine;
        int newHorizontalOffset = this.horizontalOffset;
        if (line < this.firstLine + this.electricScroll) {
            newFirstLine = Math.max(0, line - this.electricScroll);
        } else if (line + this.electricScroll >= this.firstLine + this.visibleLines) {
            newFirstLine = line - this.visibleLines + this.electricScroll + 1;
            if (newFirstLine + this.visibleLines >= this.getLineCount()) {
                newFirstLine = this.getLineCount() - this.visibleLines;
            }
            if (newFirstLine < 0) {
                newFirstLine = 0;
            }
        }
        int x = this._offsetToX(line, offset);
        int width = this.painter.getFontMetrics().charWidth('w');
        if (x < 0) {
            newHorizontalOffset = Math.min(0, this.horizontalOffset - x + width + 5);
        } else if (x + width >= this.painter.getWidth()) {
            newHorizontalOffset = this.horizontalOffset + (this.painter.getWidth() - x) - width - 5;
        }
        return this.setOrigin(newFirstLine, newHorizontalOffset);
    }

    public int lineToY(int line) {
        FontMetrics fm = this.painter.getFontMetrics();
        return (line - this.firstLine) * fm.getHeight() - (fm.getLeading() + fm.getMaxDescent());
    }

    public int yToLine(int y) {
        FontMetrics fm = this.painter.getFontMetrics();
        int height = fm.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, y / height + this.firstLine));
    }

    public final int offsetToX(int line, int offset) {
        this.painter.currentLineTokens = null;
        return this._offsetToX(line, offset);
    }

    public int _offsetToX(int line, int offset) {
        Token tokens;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fm = this.painter.getFontMetrics();
        this.getLineText(line, this.lineSegment);
        int segmentOffset = this.lineSegment.offset;
        int x = this.horizontalOffset;
        if (tokenMarker == null) {
            this.lineSegment.count = offset;
            return x + Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
        }
        if (this.painter.currentLineIndex == line && this.painter.currentLineTokens != null) {
            tokens = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = line;
            tokens = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, line);
        }
        Font defaultFont = this.painter.getFont();
        SyntaxStyle[] styles = this.painter.getStyles();
        byte id;
        while ((id = tokens.id) != 127) {
            fm = id == 0 ? this.painter.getFontMetrics() : styles[id].getFontMetrics(defaultFont, this);
            int length = tokens.length;
            if (offset + segmentOffset < this.lineSegment.offset + length) {
                this.lineSegment.count = offset - (this.lineSegment.offset - segmentOffset);
                return x + Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
            }
            this.lineSegment.count = length;
            x += Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
            this.lineSegment.offset += length;
            tokens = tokens.next;
        }
        return x;
    }

    public int xToOffset(int line, int x) {
        Token tokens;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fm = this.painter.getFontMetrics();
        this.getLineText(line, this.lineSegment);
        char[] segmentArray = this.lineSegment.array;
        int segmentOffset = this.lineSegment.offset;
        int segmentCount = this.lineSegment.count;
        int width = this.horizontalOffset;
        if (tokenMarker == null) {
            for (int i = 0; i < segmentCount; ++i) {
                char c = segmentArray[i + segmentOffset];
                int charWidth = c == '\t' ? (int)this.painter.nextTabStop(width, i) - width : fm.charWidth(c);
                if (this.painter.isBlockCaretEnabled() ? x - charWidth <= width : x - charWidth / 2 <= width) {
                    return i;
                }
                width += charWidth;
            }
            return segmentCount;
        }
        if (this.painter.currentLineIndex == line && this.painter.currentLineTokens != null) {
            tokens = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = line;
            tokens = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, line);
        }
        int offset = 0;
        Font defaultFont = this.painter.getFont();
        SyntaxStyle[] styles = this.painter.getStyles();
        byte id;
        while ((id = tokens.id) != 127) {
            fm = id == 0 ? this.painter.getFontMetrics() : styles[id].getFontMetrics(defaultFont, this);
            int length = tokens.length;
            for (int i = 0; i < length; ++i) {
                char c = segmentArray[segmentOffset + offset + i];
                int charWidth = c == '\t' ? (int)this.painter.nextTabStop(width, offset + i) - width : fm.charWidth(c);
                if (this.painter.isBlockCaretEnabled() ? x - charWidth <= width : x - charWidth / 2 <= width) {
                    return offset + i;
                }
                width += charWidth;
            }
            offset += length;
            tokens = tokens.next;
        }
        return offset;
    }

    public int xyToOffset(int x, int y) {
        int line = this.yToLine(y);
        int start = this.getLineStartOffset(line);
        return start + this.xToOffset(line, x);
    }

    public final SyntaxDocument getDocument() {
        return this.document;
    }

    public void setDocument(SyntaxDocument document) {
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = document;
        document.addDocumentListener(this.documentHandler);
        this.select(0, 0);
        this.updateScrollBars();
        this.repaintEditor();
    }

    public void setDocument(SyntaxDocument document, int start, int stop, int scroll) {
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = document;
        document.addDocumentListener(this.documentHandler);
        this.select(start, stop);
        this.updateScrollBars();
        this.setScrollPosition(scroll);
        this.repaintEditor();
    }

    public final TokenMarker getTokenMarker() {
        return this.document.getTokenMarker();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        this.document.setTokenMarker(tokenMarker);
    }

    public final int getDocumentLength() {
        return this.document.getLength();
    }

    public final int getLineCount() {
        if (this.document != null) {
            return this.document.getDefaultRootElement().getElementCount();
        }
        return 0;
    }

    public final int getLineOfOffset(int offset) {
        return this.document.getDefaultRootElement().getElementIndex(offset);
    }

    public int getLineStartOffset(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getStartOffset();
    }

    public int getLineStopOffset(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getEndOffset();
    }

    public int getSafeLineStopOffset(int line) {
        return Math.min(this.getLineStopOffset(line), this.getDocumentLength());
    }

    public int getLineLength(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getEndOffset() - lineElement.getStartOffset() - 1;
    }

    public String getText() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            return null;
        }
    }

    public void setText(String text) {
        try {
            this.document.beginCompoundEdit();
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, text, null);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        finally {
            this.document.endCompoundEdit();
        }
    }

    public final String getText(int start, int len) {
        try {
            return this.document.getText(start, len);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            return null;
        }
    }

    public final void getText(int start, int len, Segment segment) {
        try {
            this.document.getText(start, len, segment);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            segment.count = 0;
            segment.offset = 0;
        }
    }

    public final String getLineText(int lineIndex) {
        int start = this.getLineStartOffset(lineIndex);
        return this.getText(start, this.getLineStopOffset(lineIndex) - start - 1);
    }

    public final void getLineText(int lineIndex, Segment segment) {
        int start = this.getLineStartOffset(lineIndex);
        this.getText(start, this.getLineStopOffset(lineIndex) - start - 1, segment);
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionStart(int line) {
        if (line == this.selectionStartLine) {
            return this.selectionStart;
        }
        if (this.rectSelect) {
            Element map = this.document.getDefaultRootElement();
            int start = this.selectionStart - map.getElement(this.selectionStartLine).getStartOffset();
            Element lineElement = map.getElement(line);
            int lineStart = lineElement.getStartOffset();
            int lineEnd = lineElement.getEndOffset() - 1;
            return Math.min(lineEnd, lineStart + start);
        }
        return this.getLineStartOffset(line);
    }

    public final int getSelectionStartLine() {
        return this.selectionStartLine;
    }

    public final void setSelectionStart(int selectionStart) {
        this.select(selectionStart, this.selectionEnd);
    }

    public final int getSelectionStop() {
        return this.selectionEnd;
    }

    public int getSelectionStop(int line) {
        if (line == this.selectionEndLine) {
            return this.selectionEnd;
        }
        if (this.rectSelect) {
            Element map = this.document.getDefaultRootElement();
            int end2 = this.selectionEnd - map.getElement(this.selectionEndLine).getStartOffset();
            Element lineElement = map.getElement(line);
            int lineStart = lineElement.getStartOffset();
            int lineEnd = lineElement.getEndOffset() - 1;
            return Math.min(lineEnd, lineStart + end2);
        }
        return this.getLineStopOffset(line) - 1;
    }

    public final int getSelectionStopLine() {
        return this.selectionEndLine;
    }

    public final void setSelectionEnd(int selectionEnd) {
        this.select(this.selectionStart, selectionEnd);
    }

    public final boolean isSelectionActive() {
        return this.selectionStart != this.selectionEnd;
    }

    public final int getCaretPosition() {
        return this.biasLeft ? this.selectionStart : this.selectionEnd;
    }

    public final int getCaretLine() {
        return this.biasLeft ? this.selectionStartLine : this.selectionEndLine;
    }

    public final int getMarkPosition() {
        return this.biasLeft ? this.selectionEnd : this.selectionStart;
    }

    public final int getMarkLine() {
        return this.biasLeft ? this.selectionEndLine : this.selectionStartLine;
    }

    public final void setCaretPosition(int caret) {
        this.select(caret, caret);
    }

    public final void selectAll() {
        this.select(0, this.getDocumentLength());
    }

    public final void selectNone() {
        this.select(this.getCaretPosition(), this.getCaretPosition());
    }

    public void select(int start, int end2) {
        boolean newBias;
        int newEnd;
        int newStart;
        if (start <= end2) {
            newStart = start;
            newEnd = end2;
            newBias = false;
        } else {
            newStart = end2;
            newEnd = start;
            newBias = true;
        }
        if (newEnd > this.getDocumentLength()) {
            newEnd = this.getDocumentLength();
        }
        if (newStart < 0) {
            throw new IllegalArgumentException("Bounds out of range: " + newStart + "," + newEnd + " [" + this.getDocumentLength() + "]");
        }
        if (newStart != this.selectionStart || newEnd != this.selectionEnd || newBias != this.biasLeft) {
            String selection;
            Clipboard unixclipboard;
            int newStartLine = this.getLineOfOffset(newStart);
            int newEndLine = this.getLineOfOffset(newEnd);
            if (this.painter.isBracketHighlightEnabled()) {
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
                this.updateBracketHighlight(end2);
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
            }
            this.painter.invalidateLineRange(this.selectionStartLine, this.selectionEndLine);
            this.painter.invalidateLineRange(newStartLine, newEndLine);
            this.document.addUndoableEdit(new CaretUndo(this.selectionStart, this.selectionEnd));
            this.selectionStart = newStart;
            this.selectionEnd = newEnd;
            this.selectionStartLine = newStartLine;
            this.selectionEndLine = newEndLine;
            this.biasLeft = newBias;
            if (newStart != newEnd && (unixclipboard = this.getToolkit().getSystemSelection()) != null && (selection = this.getSelectedText()) != null) {
                unixclipboard.setContents(new StringSelection(selection), null);
            }
            this.fireCaretEvent();
        }
        this.blink = true;
        caretTimer.restart();
        if (this.selectionStart == this.selectionEnd) {
            this.rectSelect = false;
        }
        this.magicCaret = -1;
        this.scrollToCaret();
        if (this.editorLineStatus != null) {
            this.editorLineStatus.set(this.selectionStartLine, this.selectionEndLine);
        }
    }

    private boolean isWordCharacter(char ch, String noWordSep) {
        return Character.isLetterOrDigit(ch) || ch == '_' || noWordSep.indexOf(ch) != -1;
    }

    protected void setNewSelectionWord(int line, int offset) {
        int i;
        if (this.getLineLength(line) == 0) {
            this.newSelectionEnd = this.newSelectionStart = this.getLineStartOffset(line);
            return;
        }
        String noWordSep = (String)this.document.getProperty("noWordSep");
        if (noWordSep == null) {
            noWordSep = "";
        }
        String lineText = this.getLineText(line);
        int wordStart = 0;
        int wordEnd = lineText.length();
        char ch = lineText.charAt(Math.max(0, offset - 1));
        boolean selectNoLetter = !this.isWordCharacter(ch, noWordSep);
        for (i = offset - 1; i >= 0; --i) {
            ch = lineText.charAt(i);
            if (!(selectNoLetter ^ !this.isWordCharacter(ch, noWordSep))) continue;
            wordStart = i + 1;
            break;
        }
        for (i = offset; i < lineText.length(); ++i) {
            ch = lineText.charAt(i);
            if (!(selectNoLetter ^ !this.isWordCharacter(ch, noWordSep))) continue;
            wordEnd = i;
            break;
        }
        int lineStart = this.getLineStartOffset(line);
        this.newSelectionStart = lineStart + wordStart;
        this.newSelectionEnd = lineStart + wordEnd;
    }

    public final String getSelectedText() {
        if (this.selectionStart == this.selectionEnd) {
            return null;
        }
        if (this.rectSelect) {
            Element map = this.document.getDefaultRootElement();
            int start = this.selectionStart - map.getElement(this.selectionStartLine).getStartOffset();
            int end2 = this.selectionEnd - map.getElement(this.selectionEndLine).getStartOffset();
            if (end2 < start) {
                int tmp = end2;
                end2 = start;
                start = tmp;
            }
            StringBuffer buf = new StringBuffer();
            Segment seg = new Segment();
            for (int i = this.selectionStartLine; i <= this.selectionEndLine; ++i) {
                Element lineElement = map.getElement(i);
                int lineStart = lineElement.getStartOffset();
                int lineEnd = lineElement.getEndOffset() - 1;
                int lineLen = lineEnd - lineStart;
                lineStart = Math.min(lineStart + start, lineEnd);
                lineLen = Math.min(end2 - start, lineEnd - lineStart);
                this.getText(lineStart, lineLen, seg);
                buf.append(seg.array, seg.offset, seg.count);
                if (i == this.selectionEndLine) continue;
                buf.append('\n');
            }
            return buf.toString();
        }
        return this.getText(this.selectionStart, this.selectionEnd - this.selectionStart);
    }

    public void setSelectedText(String selectedText) {
        if (!this.editable) {
            throw new InternalError("Text component read only");
        }
        this.document.beginCompoundEdit();
        try {
            if (this.rectSelect) {
                Element map = this.document.getDefaultRootElement();
                int start = this.selectionStart - map.getElement(this.selectionStartLine).getStartOffset();
                int end2 = this.selectionEnd - map.getElement(this.selectionEndLine).getStartOffset();
                if (end2 < start) {
                    int tmp = end2;
                    end2 = start;
                    start = tmp;
                }
                int lastNewline = 0;
                int currNewline = 0;
                for (int i = this.selectionStartLine; i <= this.selectionEndLine; ++i) {
                    Element lineElement = map.getElement(i);
                    int lineStart = lineElement.getStartOffset();
                    int lineEnd = lineElement.getEndOffset() - 1;
                    int rectStart = Math.min(lineEnd, lineStart + start);
                    this.document.remove(rectStart, Math.min(lineEnd - rectStart, end2 - start));
                    if (selectedText == null) continue;
                    currNewline = selectedText.indexOf(10, lastNewline);
                    if (currNewline == -1) {
                        currNewline = selectedText.length();
                    }
                    this.document.insertString(rectStart, selectedText.substring(lastNewline, currNewline), null);
                    lastNewline = Math.min(selectedText.length(), currNewline + 1);
                }
                if (selectedText != null && currNewline != selectedText.length()) {
                    int offset = map.getElement(this.selectionEndLine).getEndOffset() - 1;
                    this.document.insertString(offset, "\n", null);
                    this.document.insertString(offset + 1, selectedText.substring(currNewline + 1), null);
                }
            } else {
                this.document.remove(this.selectionStart, this.selectionEnd - this.selectionStart);
                if (selectedText != null) {
                    this.document.insertString(this.selectionStart, selectedText, null);
                }
            }
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            throw new InternalError("Cannot replace selection");
        }
        finally {
            this.document.endCompoundEdit();
        }
        this.setCaretPosition(this.selectionEnd);
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean editable) {
        this.editable = editable;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public final int getMagicCaretPosition() {
        return this.magicCaret;
    }

    public final void setMagicCaretPosition(int magicCaret) {
        this.magicCaret = magicCaret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteSetSelectedText(String str) {
        if (!this.overwrite || this.selectionStart != this.selectionEnd) {
            this.setSelectedText(str);
            return;
        }
        int caret = this.getCaretPosition();
        int caretLineEnd = this.getLineStopOffset(this.getCaretLine());
        if (caretLineEnd - caret <= str.length()) {
            this.setSelectedText(str);
            return;
        }
        this.document.beginCompoundEdit();
        try {
            this.document.remove(caret, str.length());
            this.document.insertString(caret, str, null);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        finally {
            this.document.endCompoundEdit();
        }
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean overwrite2) {
        this.overwrite = overwrite2;
        this.painter.invalidateSelectedLines();
    }

    public final boolean isSelectionRectangular() {
        return this.rectSelect;
    }

    public final void setSelectionRectangular(boolean rectSelect) {
        this.rectSelect = rectSelect;
        this.painter.invalidateSelectedLines();
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public final void addCaretListener(CaretListener listener) {
        this.eventListenerList.add(CaretListener.class, listener);
    }

    public final void removeCaretListener(CaretListener listener) {
        this.eventListenerList.remove(CaretListener.class, listener);
    }

    public void cut() {
        if (this.editable) {
            this.copy();
            this.setSelectedText("");
        }
    }

    public void copy() {
        if (this.selectionStart != this.selectionEnd) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            String selection = this.getSelectedText();
            int repeatCount = this.inputHandler.getRepeatCount();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < repeatCount; ++i) {
                buf.append(selection);
            }
            StringSelection t = new StringSelection(buf.toString());
            clipboard.setContents(t, null);
            Clipboard unixclipboard = this.getToolkit().getSystemSelection();
            if (unixclipboard != null) {
                unixclipboard.setContents(t, null);
            }
        }
    }

    public void paste() {
        if (this.editable) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            try {
                String selection = ((String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor)).replace('\r', '\n');
                selection = selection.replace('\u00a0', ' ');
                int repeatCount = this.inputHandler.getRepeatCount();
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < repeatCount; ++i) {
                    buf.append(selection);
                }
                selection = buf.toString();
                this.setSelectedText(selection);
            }
            catch (Exception e) {
                this.getToolkit().beep();
                System.err.println("Clipboard does not contain a string");
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (focusedComponent == this) {
            focusedComponent = null;
        }
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        super.processKeyEvent(evt);
        if (this.inputHandler == null) {
            return;
        }
        switch (evt.getID()) {
            case 400: {
                if (this.editorListener != null && this.editorListener.keyTyped(evt)) break;
                this.inputHandler.keyTyped(evt);
                break;
            }
            case 401: {
                if (this.editorListener != null && this.editorListener.keyPressed(evt)) break;
                this.inputHandler.keyPressed(evt);
                break;
            }
            case 402: {
                this.inputHandler.keyReleased(evt);
            }
        }
    }

    protected void fireCaretEvent() {
        Object[] listeners = this.eventListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != CaretListener.class) continue;
            ((CaretListener)listeners[i + 1]).caretUpdate(this.caretEvent);
        }
    }

    protected void updateBracketHighlight(int newCaretPosition) {
        if (newCaretPosition == 0) {
            this.bracketLine = -1;
            this.bracketPosition = -1;
            return;
        }
        try {
            int offset = TextUtilities.findMatchingBracket(this.document, newCaretPosition - 1);
            if (offset != -1) {
                this.bracketLine = this.getLineOfOffset(offset);
                this.bracketPosition = offset - this.getLineStartOffset(this.bracketLine);
                return;
            }
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent evt) {
        DocumentEvent.ElementChange ch = evt.getChange(this.document.getDefaultRootElement());
        int count = ch == null ? 0 : ch.getChildrenAdded().length - ch.getChildrenRemoved().length;
        int line = this.getLineOfOffset(evt.getOffset());
        if (count == 0) {
            this.painter.invalidateLine(line);
        } else if (line < this.firstLine) {
            this.setFirstLine(this.firstLine + count);
        } else {
            this.painter.invalidateLineRange(line, this.firstLine + this.visibleLines);
            this.updateScrollBars();
        }
    }

    public String checkClickedURL(String line, int offset) {
        String[] parse = SyntaxUtilities.parseCommentUrls(line);
        if (parse == null) {
            return null;
        }
        int start = parse[0].length();
        int stop = start + parse[1].length();
        if (offset < start || offset > stop) {
            return null;
        }
        return parse[1];
    }

    public void setDisplayLineNumbers(boolean displayLineNumbers) {
        this.editorLineNumbers.setDisplayLineNumbers(displayLineNumbers);
    }

    static {
        caretTimer = new Timer(500, new CaretBlinker());
        caretTimer.setInitialDelay(500);
        caretTimer.start();
    }

    class CaretUndo
    extends AbstractUndoableEdit {
        private int start;
        private int end;

        CaretUndo(int start, int end2) {
            this.start = start;
            this.end = end2;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public String getPresentationName() {
            return "caret move";
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            JEditTextArea.this.select(this.start, this.end);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            JEditTextArea.this.select(this.start, this.end);
        }

        @Override
        public boolean addEdit(UndoableEdit edit) {
            if (edit instanceof CaretUndo) {
                CaretUndo cedit = (CaretUndo)edit;
                this.start = cedit.start;
                this.end = cedit.end;
                cedit.die();
                return true;
            }
            return false;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            Clipboard unixclipboard;
            boolean trigger;
            JEditTextArea.this.requestFocus();
            JEditTextArea.this.setCaretVisible(true);
            focusedComponent = JEditTextArea.this;
            boolean bl = trigger = (evt.getModifiers() & 4) != 0;
            if (!trigger && evt.isPopupTrigger()) {
                trigger = true;
            }
            if (trigger && JEditTextArea.this.popup != null) {
                JEditTextArea.this.popup.show(JEditTextArea.this.painter, evt.getX(), evt.getY());
                return;
            }
            if ((evt.getModifiers() & 8) != 0 && (unixclipboard = JEditTextArea.this.getToolkit().getSystemSelection()) != null) {
                Transferable t = unixclipboard.getContents(null);
                if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                        s = s.replace('\u00a0', ' ');
                        if (JEditTextArea.this.editable) {
                            JEditTextArea.this.setSelectedText(s);
                        }
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        e.printStackTrace();
                    }
                }
                return;
            }
            int line = JEditTextArea.this.yToLine(evt.getY());
            int offset = JEditTextArea.this.xToOffset(line, evt.getX());
            int dot = JEditTextArea.this.getLineStartOffset(line) + offset;
            JEditTextArea.this.selectLine = false;
            JEditTextArea.this.selectWord = false;
            switch (evt.getClickCount()) {
                case 1: {
                    this.doSingleClick(evt, line, offset, dot);
                    break;
                }
                case 2: {
                    try {
                        this.doDoubleClick(evt, line, offset, dot);
                    }
                    catch (BadLocationException bl2) {
                        bl2.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    this.doTripleClick(evt, line, offset, dot);
                }
            }
        }

        private void doSingleClick(MouseEvent evt, int line, int offset, int dot) {
            String clickedURL = JEditTextArea.this.checkClickedURL(JEditTextArea.this.getLineText(line), offset);
            if (clickedURL != null) {
                Base.openURL(clickedURL);
                return;
            }
            if ((evt.getModifiers() & 1) != 0) {
                JEditTextArea.this.rectSelect = (evt.getModifiers() & 2) != 0;
                JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), dot);
            } else {
                JEditTextArea.this.setCaretPosition(dot);
            }
        }

        private void doDoubleClick(MouseEvent evt, int line, int offset, int dot) throws BadLocationException {
            if (JEditTextArea.this.getLineLength(line) == 0) {
                return;
            }
            try {
                int bracket = TextUtilities.findMatchingBracket(JEditTextArea.this.document, Math.max(0, dot - 1));
                if (bracket != -1) {
                    int mark = JEditTextArea.this.getMarkPosition();
                    if (bracket > mark) {
                        ++bracket;
                        --mark;
                    }
                    JEditTextArea.this.select(mark, bracket);
                    return;
                }
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
            JEditTextArea.this.setNewSelectionWord(line, offset);
            JEditTextArea.this.select(JEditTextArea.this.newSelectionStart, JEditTextArea.this.newSelectionEnd);
            JEditTextArea.this.selectWord = true;
            JEditTextArea.this.selectionAncorStart = JEditTextArea.this.selectionStart;
            JEditTextArea.this.selectionAncorEnd = JEditTextArea.this.selectionEnd;
        }

        private void doTripleClick(MouseEvent evt, int line, int offset, int dot) {
            JEditTextArea.this.selectLine = true;
            JEditTextArea.this.select(JEditTextArea.this.getLineStartOffset(line), JEditTextArea.this.getSafeLineStopOffset(line));
            JEditTextArea.this.selectionAncorStart = JEditTextArea.this.selectionStart;
            JEditTextArea.this.selectionAncorEnd = JEditTextArea.this.selectionEnd;
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            JEditTextArea.this.setCaretVisible(true);
            focusedComponent = JEditTextArea.this;
        }

        @Override
        public void focusLost(FocusEvent evt) {
            JEditTextArea.this.setCaretVisible(false);
            focusedComponent = null;
        }
    }

    class DragHandler
    implements MouseMotionListener {
        final Cursor normalCursor = new Cursor(0);
        final Cursor handCursor = new Cursor(12);

        DragHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (JEditTextArea.this.popup != null && JEditTextArea.this.popup.isVisible()) {
                return;
            }
            if (!JEditTextArea.this.selectWord && !JEditTextArea.this.selectLine) {
                JEditTextArea.this.setSelectionRectangular((evt.getModifiers() & 2) != 0);
                JEditTextArea.this.select(JEditTextArea.this.getMarkPosition(), JEditTextArea.this.xyToOffset(evt.getX(), evt.getY()));
            } else {
                int line = JEditTextArea.this.yToLine(evt.getY());
                if (JEditTextArea.this.selectWord) {
                    JEditTextArea.this.setNewSelectionWord(line, JEditTextArea.this.xToOffset(line, evt.getX()));
                } else {
                    JEditTextArea.this.newSelectionStart = JEditTextArea.this.getLineStartOffset(line);
                    JEditTextArea.this.newSelectionEnd = JEditTextArea.this.getSafeLineStopOffset(line);
                }
                if (JEditTextArea.this.newSelectionStart < JEditTextArea.this.selectionAncorStart) {
                    JEditTextArea.this.select(JEditTextArea.this.newSelectionStart, JEditTextArea.this.selectionAncorEnd);
                } else if (JEditTextArea.this.newSelectionEnd > JEditTextArea.this.selectionAncorEnd) {
                    JEditTextArea.this.select(JEditTextArea.this.selectionAncorStart, JEditTextArea.this.newSelectionEnd);
                } else {
                    JEditTextArea.this.select(JEditTextArea.this.newSelectionStart, JEditTextArea.this.newSelectionEnd);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            int line = JEditTextArea.this.yToLine(evt.getY());
            int offset = JEditTextArea.this.xToOffset(line, evt.getX());
            boolean wantHandCursor = JEditTextArea.this.checkClickedURL(JEditTextArea.this.getLineText(line), offset) != null;
            JComponent src = (JComponent)evt.getSource();
            if (wantHandCursor) {
                src.setCursor(this.handCursor);
            } else {
                src.setCursor(this.normalCursor);
            }
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            JEditTextArea.this.documentChanged(evt);
            int offset = evt.getOffset();
            int length = evt.getLength();
            int newStart = JEditTextArea.this.selectionStart > offset || JEditTextArea.this.selectionStart == JEditTextArea.this.selectionEnd && JEditTextArea.this.selectionStart == offset ? JEditTextArea.this.selectionStart + length : JEditTextArea.this.selectionStart;
            int newEnd = JEditTextArea.this.selectionEnd >= offset ? JEditTextArea.this.selectionEnd + length : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(newStart, newEnd);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            JEditTextArea.this.documentChanged(evt);
            int offset = evt.getOffset();
            int length = evt.getLength();
            int newStart = JEditTextArea.this.selectionStart > offset ? (JEditTextArea.this.selectionStart > offset + length ? JEditTextArea.this.selectionStart - length : offset) : JEditTextArea.this.selectionStart;
            int newEnd = JEditTextArea.this.selectionEnd > offset ? (JEditTextArea.this.selectionEnd > offset + length ? JEditTextArea.this.selectionEnd - length : offset) : JEditTextArea.this.selectionEnd;
            JEditTextArea.this.select(newStart, newEnd);
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }
    }

    class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            JEditTextArea.this.recalculateVisibleLines();
            JEditTextArea.this.scrollBarsInitialized = true;
        }
    }

    class AdjustHandler
    implements AdjustmentListener {
        AdjustHandler() {
        }

        @Override
        public void adjustmentValueChanged(final AdjustmentEvent evt) {
            if (!JEditTextArea.this.scrollBarsInitialized) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (evt.getAdjustable() == JEditTextArea.this.vertical) {
                        JEditTextArea.this.setFirstLine(JEditTextArea.this.vertical.getValue());
                    } else {
                        JEditTextArea.this.setHorizontalOffset(-JEditTextArea.this.horizontal.getValue());
                    }
                }
            });
        }
    }

    class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(JEditTextArea.this);
        }

        @Override
        public int getDot() {
            return JEditTextArea.this.getCaretPosition();
        }

        @Override
        public int getMark() {
            return JEditTextArea.this.getMarkPosition();
        }
    }

    static class CaretBlinker
    implements ActionListener {
        CaretBlinker() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (focusedComponent != null && focusedComponent.hasFocus()) {
                        focusedComponent.blinkCaret();
                    }
                }
            });
        }
    }

    class ScrollLayout
    implements LayoutManager {
        private Component left;
        private Component center;
        private Component right;
        private Component bottom;
        private Vector leftOfScrollBar = new Vector();

        ScrollLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name.equals(LEFT)) {
                this.left = comp;
            } else if (name.equals(CENTER)) {
                this.center = comp;
            } else if (name.equals(RIGHT)) {
                this.right = comp;
            } else if (name.equals(BOTTOM)) {
                this.bottom = comp;
            } else if (name.equals(LEFT_OF_SCROLLBAR)) {
                this.leftOfScrollBar.addElement(comp);
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (this.left == comp) {
                this.left = null;
            }
            if (this.center == comp) {
                this.center = null;
            }
            if (this.right == comp) {
                this.right = null;
            }
            if (this.bottom == comp) {
                this.bottom = null;
            } else {
                this.leftOfScrollBar.removeElement(comp);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension centerPref = this.center.getPreferredSize();
            dim.width += centerPref.width;
            dim.height += centerPref.height;
            Dimension leftPref = this.left.getPreferredSize();
            dim.width += leftPref.width;
            Dimension rightPref = this.right.getPreferredSize();
            dim.width += rightPref.width;
            Dimension bottomPref = this.bottom.getPreferredSize();
            dim.height += bottomPref.height;
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Insets insets = JEditTextArea.this.getInsets();
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension centerPref = this.center.getMinimumSize();
            dim.width += centerPref.width;
            dim.height += centerPref.height;
            Dimension leftPref = this.left.getMinimumSize();
            dim.width += leftPref.width;
            Dimension rightPref = this.right.getMinimumSize();
            dim.width += rightPref.width;
            Dimension bottomPref = this.bottom.getMinimumSize();
            dim.height += bottomPref.height;
            dim.height += 5;
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Insets insets = parent.getInsets();
            int itop = insets.top;
            int ileft = insets.left;
            int ibottom = insets.bottom;
            int iright = insets.right;
            int leftWidth = this.left.getSize().width;
            int rightWidth = this.right.getPreferredSize().width;
            int bottomHeight = this.bottom.getPreferredSize().height;
            int centerWidth = size.width - leftWidth - rightWidth - ileft - iright;
            int centerHeight = size.height - bottomHeight - itop - ibottom;
            this.left.setBounds(ileft, itop, leftWidth, centerHeight);
            this.center.setBounds(ileft += leftWidth, itop, centerWidth, centerHeight);
            this.right.setBounds(ileft + centerWidth, itop, rightWidth, centerHeight);
            Enumeration status = this.leftOfScrollBar.elements();
            while (status.hasMoreElements()) {
                Component comp = (Component)status.nextElement();
                Dimension dim = comp.getPreferredSize();
                comp.setBounds(ileft, itop + centerHeight, dim.width, bottomHeight);
                ileft += dim.width;
            }
            this.bottom.setBounds(ileft, itop + centerHeight, size.width - rightWidth - ileft - iright, bottomHeight);
        }
    }
}

