/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;

class BufferedStyledDocument
extends DefaultStyledDocument {
    private List<DefaultStyledDocument.ElementSpec> elements = new ArrayList<DefaultStyledDocument.ElementSpec>();
    private int maxLineLength;
    private int maxLineCount;
    private int currentLineLength = 0;
    private boolean changed = false;

    public BufferedStyledDocument(int _maxLineLength, int _maxLineCount) {
        this.maxLineLength = _maxLineLength;
        this.maxLineCount = _maxLineCount;
    }

    public synchronized void appendString(String text, AttributeSet a) {
        this.changed = true;
        char[] chars = text.toCharArray();
        int start = 0;
        int stop = 0;
        while (stop < chars.length) {
            char c = chars[stop];
            ++stop;
            ++this.currentLineLength;
            if (c != '\n' && c != '\r' && this.currentLineLength <= this.maxLineLength) continue;
            this.elements.add(new DefaultStyledDocument.ElementSpec(a, 3, chars, start, stop - start));
            this.elements.add(new DefaultStyledDocument.ElementSpec(a, 2));
            this.elements.add(new DefaultStyledDocument.ElementSpec(a, 1));
            this.currentLineLength = 0;
            start = stop;
        }
        this.elements.add(new DefaultStyledDocument.ElementSpec(a, 3, chars, start, stop - start));
    }

    public synchronized void insertAll() {
        try {
            DefaultStyledDocument.ElementSpec[] elementArray = this.elements.toArray(new DefaultStyledDocument.ElementSpec[0]);
            this.insert(this.getLength(), elementArray);
            Element root = this.getDefaultRootElement();
            int lineCount = root.getElementCount();
            int overage = lineCount - this.maxLineCount;
            if (overage > 0) {
                Element lineElement = root.getElement(overage);
                if (lineElement == null) {
                    return;
                }
                int endOffset = lineElement.getEndOffset();
                this.remove(0, endOffset);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.elements.clear();
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }
}

