/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Theme;
import processing.app.debug.TextAreaFIFO;
import processing.app.legacy.PApplet;

public abstract class AbstractMonitor
extends JFrame
implements ActionListener {
    protected final JLabel noLineEndingAlert;
    protected TextAreaFIFO textArea;
    protected JScrollPane scrollPane;
    protected JTextField textField;
    protected JButton sendButton;
    protected JCheckBox autoscrollBox;
    protected JComboBox lineEndings;
    protected JComboBox serialRates;
    private Timer updateTimer;
    private StringBuffer updateBuffer;

    public AbstractMonitor(String title) {
        super(title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                try {
                    AbstractMonitor.this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        KeyStroke wc = Editor.WINDOW_CLOSE_KEYSTROKE;
        this.getRootPane().getInputMap(1).put(wc, "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    AbstractMonitor.this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AbstractMonitor.this.setVisible(false);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        Font consoleFont = Theme.getFont("console.font");
        Font editorFont = PreferencesData.getFont((String)"editor.font");
        Font font = new Font(consoleFont.getName(), consoleFont.getStyle(), editorFont.getSize());
        this.textArea = new TextAreaFIFO(8000000);
        this.textArea.setRows(16);
        this.textArea.setColumns(40);
        this.textArea.setEditable(false);
        this.textArea.setFont(font);
        ((DefaultCaret)this.textArea.getCaret()).setUpdatePolicy(1);
        this.scrollPane = new JScrollPane(this.textArea);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        JPanel upperPane = new JPanel();
        upperPane.setLayout(new BoxLayout(upperPane, 0));
        upperPane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.textField = new JTextField(40);
        this.sendButton = new JButton(I18n._((String)"Send"));
        upperPane.add(this.textField);
        upperPane.add(Box.createRigidArea(new Dimension(4, 0)));
        upperPane.add(this.sendButton);
        this.getContentPane().add((Component)upperPane, "North");
        final JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.autoscrollBox = new JCheckBox(I18n._((String)"Autoscroll"), true);
        this.noLineEndingAlert = new JLabel(I18n.format((String)I18n._((String)"You've pressed {0} but nothing was sent. Should you select a line ending?"), (Object[])new Object[]{I18n._((String)"Send")}));
        this.noLineEndingAlert.setToolTipText(this.noLineEndingAlert.getText());
        this.noLineEndingAlert.setForeground(pane.getBackground());
        Dimension minimumSize = new Dimension(this.noLineEndingAlert.getMinimumSize());
        minimumSize.setSize(minimumSize.getWidth() / 3.0, minimumSize.getHeight());
        this.noLineEndingAlert.setMinimumSize(minimumSize);
        this.lineEndings = new JComboBox<String>(new String[]{I18n._((String)"No line ending"), I18n._((String)"Newline"), I18n._((String)"Carriage return"), I18n._((String)"Both NL & CR")});
        this.lineEndings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PreferencesData.setInteger((String)"serial.line_ending", (int)AbstractMonitor.this.lineEndings.getSelectedIndex());
                AbstractMonitor.this.noLineEndingAlert.setForeground(pane.getBackground());
            }
        });
        if (PreferencesData.get((String)"serial.line_ending") != null) {
            this.lineEndings.setSelectedIndex(PreferencesData.getInteger((String)"serial.line_ending"));
        }
        this.lineEndings.setMaximumSize(this.lineEndings.getMinimumSize());
        String[] serialRateStrings = new String[]{"300", "1200", "2400", "4800", "9600", "19200", "38400", "57600", "115200"};
        this.serialRates = new JComboBox();
        for (String rate : serialRateStrings) {
            this.serialRates.addItem(rate + " " + I18n._((String)"baud"));
        }
        this.serialRates.setMaximumSize(this.serialRates.getMinimumSize());
        pane.add(this.autoscrollBox);
        pane.add(Box.createHorizontalGlue());
        pane.add(this.noLineEndingAlert);
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.lineEndings);
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.serialRates);
        this.setMinimumSize(new Dimension(pane.getMinimumSize().width, this.getPreferredSize().height));
        this.getContentPane().add((Component)pane, "South");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (PreferencesData.get((String)"last.screen.height") != null) {
            String locationStr;
            int screenW = PreferencesData.getInteger((String)"last.screen.width");
            int screenH = PreferencesData.getInteger((String)"last.screen.height");
            if (screen.width == screenW && screen.height == screenH && (locationStr = PreferencesData.get((String)"last.serial.location")) != null) {
                int[] location = PApplet.parseInt((String[])PApplet.split((String)locationStr, (char)','));
                this.setPlacement(location);
            }
        }
        this.updateBuffer = new StringBuffer(0x100000);
        this.updateTimer = new Timer(33, this);
        this.updateTimer.start();
    }

    public void onSerialRateChange(ActionListener listener) {
        this.serialRates.addActionListener(listener);
    }

    public void onSendCommand(ActionListener listener) {
        this.textField.addActionListener(listener);
        this.sendButton.addActionListener(listener);
    }

    protected void setPlacement(int[] location) {
        this.setBounds(location[0], location[1], location[2], location[3]);
    }

    protected int[] getPlacement() {
        int[] location = new int[4];
        Rectangle bounds = this.getBounds();
        location[0] = bounds.x;
        location[1] = bounds.y;
        location[2] = bounds.width;
        location[3] = bounds.height;
        return location;
    }

    public void message(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractMonitor.this.textArea.append(s);
                if (AbstractMonitor.this.autoscrollBox.isSelected()) {
                    AbstractMonitor.this.textArea.setCaretPosition(AbstractMonitor.this.textArea.getDocument().getLength());
                }
            }
        });
    }

    public boolean requiresAuthorization() {
        return false;
    }

    public String getAuthorizationKey() {
        return null;
    }

    public abstract void open() throws Exception;

    public abstract void close() throws Exception;

    public synchronized void addToUpdateBuffer(char[] buff, int n) {
        this.updateBuffer.append(buff, 0, n);
    }

    private synchronized String consumeUpdateBuffer() {
        String s = this.updateBuffer.toString();
        this.updateBuffer.setLength(0);
        return s;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = this.consumeUpdateBuffer();
        if (s.length() > 0) {
            if (this.autoscrollBox.isSelected()) {
                this.textArea.appendTrim(s);
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            } else {
                this.textArea.appendNoTrim(s);
            }
        }
    }
}

