/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.coretext;

import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.coretext.CGAffineTransform;
import com.sun.javafx.font.coretext.CGRect;
import com.sun.javafx.font.coretext.CTFontStrike;
import com.sun.javafx.font.coretext.OS;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;

class CTFontFile
extends PrismFontFile {
    private static final CGAffineTransform tx = new CGAffineTransform();

    CTFontFile(String string, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        super(string, string2, n, bl, bl2, bl3, bl4);
    }

    public static boolean registerFont(String string) {
        if (string == null) {
            return false;
        }
        long l = OS.kCFAllocatorDefault();
        boolean bl = false;
        long l2 = OS.CFStringCreate(string);
        if (l2 != 0L) {
            int n = 0;
            long l3 = OS.CFURLCreateWithFileSystemPath(l, l2, n, false);
            if (l3 != 0L) {
                int n2 = 1;
                bl = OS.CTFontManagerRegisterFontsForURL(l3, n2, 0L);
                OS.CFRelease(l3);
            }
            OS.CFRelease(l2);
        }
        return bl;
    }

    CGRect getBBox(int n, float f) {
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f, BaseTransform.IDENTITY_TRANSFORM);
        long l = cTFontStrike.getFontRef();
        if (l == 0L) {
            return null;
        }
        long l2 = OS.CTFontCreatePathForGlyph(l, (short)n, tx);
        if (l2 == 0L) {
            return null;
        }
        CGRect cGRect = OS.CGPathGetPathBoundingBox(l2);
        OS.CGPathRelease(l2);
        return cGRect;
    }

    Path2D getGlyphOutline(int n, float f) {
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f, BaseTransform.IDENTITY_TRANSFORM);
        long l = cTFontStrike.getFontRef();
        if (l == 0L) {
            return null;
        }
        long l2 = OS.CTFontCreatePathForGlyph(l, (short)n, tx);
        if (l2 == 0L) {
            return null;
        }
        Path2D path2D = OS.CGPathApply(l2);
        OS.CGPathRelease(l2);
        return path2D;
    }

    @Override
    protected int[] createGlyphBoundingBox(int n) {
        short s;
        float f = 12.0f;
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f, BaseTransform.IDENTITY_TRANSFORM);
        long l = cTFontStrike.getFontRef();
        if (l == 0L) {
            return null;
        }
        int[] nArray = new int[4];
        if (!this.isCFF() && OS.CTFontGetBoundingRectForGlyphUsingTables(l, (short)n, s = this.getIndexToLocFormat(), nArray)) {
            return nArray;
        }
        long l2 = OS.CTFontCreatePathForGlyph(l, (short)n, null);
        if (l2 == 0L) {
            return null;
        }
        CGRect cGRect = OS.CGPathGetPathBoundingBox(l2);
        OS.CGPathRelease(l2);
        float f2 = (float)this.getUnitsPerEm() / f;
        nArray[0] = (int)Math.round(cGRect.origin.x * (double)f2);
        nArray[1] = (int)Math.round(cGRect.origin.y * (double)f2);
        nArray[2] = (int)Math.round((cGRect.origin.x + cGRect.size.width) * (double)f2);
        nArray[3] = (int)Math.round((cGRect.origin.y + cGRect.size.height) * (double)f2);
        return nArray;
    }

    @Override
    protected PrismFontStrike<CTFontFile> createStrike(float f, BaseTransform baseTransform, int n, FontStrikeDesc fontStrikeDesc) {
        return new CTFontStrike(this, f, baseTransform, n, fontStrikeDesc);
    }

    static {
        CTFontFile.tx.a = 1.0;
        CTFontFile.tx.d = -1.0;
    }
}

