/*
 * Decompiled with CFR 0.152.
 */
package processing.app.packages;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import processing.app.helpers.FileUtils;
import processing.app.packages.UserLibrary;

public class LibraryList
extends LinkedList<UserLibrary> {
    public LibraryList(LibraryList libs) {
        super(libs);
    }

    public LibraryList() {
    }

    public LibraryList(List<UserLibrary> ideLibs) {
        super(ideLibs);
    }

    public UserLibrary getByName(String name) {
        for (UserLibrary l : this) {
            if (!l.getName().equals(name)) continue;
            return l;
        }
        return null;
    }

    public void addOrReplace(UserLibrary lib) {
        this.remove(lib);
        this.add(lib);
    }

    public void remove(UserLibrary lib) {
        UserLibrary l = this.getByName(lib.getName());
        if (l != null) {
            super.remove(l);
        }
    }

    public void sort() {
        Collections.sort(this, UserLibrary.CASE_INSENSITIVE_ORDER);
    }

    public LibraryList filterLibrariesInSubfolder(File subFolder) {
        LibraryList res = new LibraryList();
        for (UserLibrary lib : this) {
            if (!FileUtils.isSubDirectory(subFolder, lib.getInstalledFolder())) continue;
            res.add(lib);
        }
        return res;
    }

    public boolean hasLibrary(UserLibrary lib) {
        for (UserLibrary l : this) {
            if (l != lib) continue;
            return true;
        }
        return false;
    }
}

